/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util.condition;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import de.odysseus.el.context.WFElContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.el.ELContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.el.UelExpressionCondition;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.engine.impl.log.pojo.InsertConditionParseLogParam;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableScopeImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFConditionParseException;
import kd.bos.workflow.nocode.NoCodeFlowUtil;

public class ConditionUtil {
    private static Log logger = LogFactory.getLog((String)ConditionUtil.class.getName());
    public static final String SYMBOL_DOLLAR = "$";
    public static final String SYMBOL_SHARP = "#";
    public static final String PARTICIPANTCONDITION = "participant";
    public static final String PARTICIPANT_CONDITION_AUTO_CIRCULATE = "participantAutoCirculate";
    public static final String PARTICIPANT_CONDITION_AUTO_COORDINATOR = "participantAutoCoordinator";
    public static final String COMPLETIONCONDITION = "completion";
    public static final String MSGCONDITION = "msg";
    public static final String STARTCONDITION = "addressProcess";
    public static final String SCHEMECONDITION = "addressScheme";
    public static final String TASKAUTORULECONDITION = "taskAutoRule";
    public static final String SKIPCONDITION = "skip";
    public static final String AUTOAUDITCONDITION = "autoAudit";
    public static final String AUDITPOINTCONDITION = "auditPoint";
    public static final String TASKSUBJECTCONDITION = "taskSubject";
    public static final String BILLSUBJECTCONDITION_PC = "billSubjectPc";
    public static final String BILLSUBJECTCONDITION_MOBIL = "billSubjectMobil";
    public static final String DELEGATESETTING = "delegateSetting";
    private static final String FORMATSTRING = "%s_[%s]";

    public static boolean hasTrueCondition(SequenceFlow sequenceFlow, DelegateExecution execution) {
        String key = sequenceFlow.getNumber();
        ConditionType.logSeqName(sequenceFlow);
        ConditionType.logOpDesc(sequenceFlow.getConditionalRule());
        boolean dynamic = sequenceFlow.isDynamic();
        return ConditionUtil.hasTrueCondition(sequenceFlow.getConditionalRule(), (VariableScope)execution, key + "_[" + dynamic + "]");
    }

    public static boolean hasTrueCondition(SequenceFlow sequenceFlow, TaskEntity task) {
        String key = sequenceFlow.getNumber();
        ConditionType.logSeqName(sequenceFlow);
        ConditionType.logOpDesc(sequenceFlow.getConditionalRule());
        boolean dynamic = sequenceFlow.isDynamic();
        return ConditionUtil.hasTrueCondition(sequenceFlow.getConditionalRule(), (VariableScope)task, key + "_[" + dynamic + "]");
    }

    public static boolean hasTrueCondition(ConditionalRuleEntity conditionalRule, VariableScope variableScope, String key) {
        ConditionType.logOpDesc(conditionalRule);
        boolean result = true;
        boolean plugin = false;
        if (conditionalRule != null) {
            String conditionExpression = null;
            try {
                if (WfUtils.isNotEmpty(conditionalRule.getExpression())) {
                    conditionExpression = conditionalRule.getExpression();
                    result = ConditionUtil.hasTrueCondition(conditionExpression, variableScope, key);
                } else if (WfUtils.isNotEmpty(conditionalRule.getPlugin())) {
                    plugin = true;
                    result = false;
                    ExecutionEntity execution = null;
                    if (variableScope instanceof ExecutionEntityImpl) {
                        execution = (ExecutionEntityImpl)variableScope;
                    } else if (variableScope instanceof PreComputatorExecutionEntityImpl) {
                        execution = (PreComputatorExecutionEntityImpl)variableScope;
                    } else if (variableScope instanceof TaskEntityImpl) {
                        execution = ((TaskEntityImpl)variableScope).getExecution();
                    }
                    conditionExpression = conditionalRule.getPlugin();
                    Object ret = ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.CONDITIONALRULE, conditionExpression, execution);
                    if (ret instanceof Boolean) {
                        result = (Boolean)ret;
                    }
                    ConditionUtil.recordConditionInst(conditionExpression, variableScope, key, result, true, null);
                }
            }
            catch (Exception e) {
                ConditionUtil.recordConditionInst(conditionExpression, variableScope, key, result, plugin, e);
                if (e instanceof WFConditionParseException) {
                    throw e;
                }
                throw ExceptionUtil.createWFConditionParseException(conditionExpression, variableScope, e);
            }
        }
        return result;
    }

    private static void recordConditionInst(String conditionalRule, VariableScope variableScope, String markKey, boolean ret, boolean plugin, Exception e) {
        block20: {
            try {
                boolean insertDB = WfUtils.isNotEmpty(markKey);
                if (!insertDB) {
                    markKey = String.format("%s-%s", "only", "log");
                }
                ExecutionEntity execution = null;
                String businessKey = null;
                if (variableScope instanceof ExecutionEntityImpl) {
                    execution = (ExecutionEntityImpl)variableScope;
                    businessKey = execution.getBusinessKey();
                    markKey = String.format(FORMATSTRING, markKey, execution.getCurrentActInstId());
                } else if (variableScope instanceof PreComputatorExecutionEntityImpl) {
                    execution = (PreComputatorExecutionEntityImpl)variableScope;
                    businessKey = execution.getBusinessKey();
                    markKey = String.format(FORMATSTRING, markKey, execution.getCurrentActInstId());
                } else if (variableScope instanceof TaskEntityImpl) {
                    execution = ((TaskEntityImpl)variableScope).getExecution();
                    businessKey = execution.getBusinessKey();
                    markKey = String.format(FORMATSTRING, markKey, execution.getCurrentActInstId());
                } else if (variableScope instanceof BusinessModelVariableScope && (ret || e != null)) {
                    execution = ConditionUtil.calExecutionParam(variableScope);
                    businessKey = execution.getBusinessKey();
                    markKey = String.format(FORMATSTRING, markKey, businessKey);
                }
                if (variableScope instanceof BusinessModelVariableScope && !ret && e == null) {
                    insertDB = false;
                }
                InsertConditionParseLogParam param = InsertConditionParseLogParam.get().setExecutionEntity(execution).setConditionalRule(conditionalRule).setMarkKey(markKey).setBusinessKey(businessKey);
                ConditionType conditionType = ConditionType.valueOf(markKey, true);
                String expressResult = "";
                if (!(variableScope instanceof VariableScopeImpl)) {
                    return;
                }
                VariableScopeImpl variableScopeImpl = (VariableScopeImpl)variableScope;
                ELContext eContext = variableScopeImpl.getCachedElContext();
                if (plugin) {
                    expressResult = "(" + conditionalRule + ")=[" + ret + "]";
                    param.setExpressResult(expressResult);
                    Context.getCommandContext().getConditionParseLogManager().insert(param);
                } else if (eContext instanceof WFElContext) {
                    List msgs = ((WFElContext)eContext).getLogMsg();
                    expressResult = Joiner.on((char)';').join((Iterable)msgs);
                    param.setExpressResult(expressResult);
                    if (e != null) {
                        String currentProp = ((WFElContext)eContext).getCurrentProp();
                        logger.debug(String.format("\u201c%1$s\u201d\u8ba1\u7b97\u9519\u8bef\uff0c\u539f\u56e0\uff1a%2$s\uff0c\u5806\u6808\u4fe1\u606f\uff1a%3$s\u3002", currentProp, e.getMessage(), WfUtils.getExceptionStacktrace(e)));
                    }
                    if (insertDB) {
                        insertDB = false;
                        Context.getCommandContext().getConditionParseLogManager().insert(param);
                    }
                } else if (insertDB) {
                    expressResult = "(" + conditionalRule + ")=[" + ret + "]";
                    param.setExpressResult(expressResult);
                    Context.getCommandContext().getConditionParseLogManager().insert(param);
                }
                if (conditionType.logRuntime()) {
                    RunTimeLog.get().appendLog(expressResult);
                }
            }
            catch (Exception ee) {
                logger.warn(String.format("recordConditionInst error:%s", WfUtils.getExceptionStacktrace(ee)));
                if (e == null) break block20;
                logger.warn(String.format("hasTrueCondition error: %s", WfUtils.getExceptionStacktrace(e)));
            }
        }
    }

    private static ExecutionEntity calExecutionParam(VariableScope variableScope) {
        BusinessModelVariableScope businessModelVariableScope = (BusinessModelVariableScope)variableScope;
        Object env = businessModelVariableScope.getVariable("env");
        if (env instanceof Boolean) {
            return ConditionUtil.calEvnExecution(businessModelVariableScope);
        }
        ExecutionEntityImpl execution = new ExecutionEntityImpl();
        Long processDefinitionId = (Long)businessModelVariableScope.getVariable("processDefinitionId");
        execution.setProcessDefinitionId(processDefinitionId);
        String billNo = ConditionUtil.getBillno(businessModelVariableScope);
        String entityNumber = businessModelVariableScope.getEntityNumber();
        String businessKey = businessModelVariableScope.getBusinessKey();
        execution.setBillNo(billNo);
        execution.setBusinessKey(businessKey);
        execution.setEntityNumber(entityNumber);
        String schemeName = (String)businessModelVariableScope.getVariable("schemeName");
        String name = "";
        if (schemeName != null && processDefinitionId != null) {
            ProcessDefinitionEntity byId = (ProcessDefinitionEntity)Context.getCommandContext().getProcessDefinitionEntityManager().findById(processDefinitionId);
            if (byId != null) {
                name = billNo + '/' + byId.getKey() + '/' + byId.getVersion() + '/' + schemeName;
            }
        } else {
            name = (String)businessModelVariableScope.getVariable("processName");
        }
        execution.setName((ILocaleString)new LocaleString(name));
        return execution;
    }

    private static ExecutionEntity calEvnExecution(BusinessModelVariableScope businessModelVariableScope) {
        ExecutionEntityImpl executionEntity = new ExecutionEntityImpl();
        String entityNumber = businessModelVariableScope.getEntityNumber();
        String businessKey = businessModelVariableScope.getBusinessKey();
        Long processDefinitionId = (Long)businessModelVariableScope.getVariable("processDefinitionId");
        DynamicObject businessObject = WfUtils.findBusinessObject(businessKey, entityNumber);
        businessModelVariableScope.setModel(businessObject);
        String billNo = ConditionUtil.getBillno(businessModelVariableScope);
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)Context.getCommandContext().getProcessDefinitionEntityManager().findById(processDefinitionId);
        executionEntity.setProcessDefinitionId(processDefinitionId);
        executionEntity.setEntityNumber(entityNumber);
        executionEntity.setBusinessKey(businessKey);
        executionEntity.setBillNo(billNo);
        Optional<ProcessDefinitionEntity> optional = Optional.ofNullable(processDefinition);
        String name = billNo + '/' + optional.map(ProcessDefinitionEntity::getKey).orElse("") + '/' + optional.map(ProcessDefinitionEntity::getVersion).orElse("");
        executionEntity.setName((ILocaleString)new LocaleString(name));
        return executionEntity;
    }

    private static String getBillno(BusinessModelVariableScope variableScope) {
        try {
            if (variableScope == null) {
                return "";
            }
            DynamicObject model = variableScope.getModel();
            if (model == null) {
                return "";
            }
            IDataEntityType dataEntityType = model.getDataEntityType();
            if (dataEntityType instanceof MainEntityType) {
                MainEntityType type = (MainEntityType)dataEntityType;
                return TaskBehaviorUtil.getTaskBillNo(type, model);
            }
        }
        catch (Throwable error) {
            logger.info("\u5355\u636e\u7f16\u53f7\u83b7\u53d6\u5931\u8d25" + error);
        }
        return "";
    }

    public static boolean hasTrueCondition(String conditionExpression, VariableScope variableScope, String key) {
        boolean ret = false;
        boolean plugin = false;
        try {
            if (ExternalInterfaceUtil.isValidValue(conditionExpression)) {
                plugin = true;
                Object result = Boolean.FALSE;
                result = variableScope instanceof TaskEntity ? ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.CONDITIONALRULE, conditionExpression, ((TaskEntity)variableScope).getExecution()) : ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.CONDITIONALRULE, conditionExpression, variableScope);
                ret = result instanceof Boolean && (Boolean)result != false;
            } else if (conditionExpression != null && conditionExpression.startsWith("#NOCODE#")) {
                ret = NoCodeFlowUtil.parseNoCodeConditionExpression(conditionExpression, variableScope, false);
            } else {
                Expression expression;
                UelExpressionCondition condition;
                if (WfUtils.isNotEmpty(conditionExpression) && (conditionExpression.startsWith("entryUnion(") || conditionExpression.startsWith("entryAnyOne(")) && conditionExpression.contains(",")) {
                    int index = conditionExpression.indexOf(44);
                    String unionRule = "entryUnion";
                    if (conditionExpression.startsWith("entryAnyOne(")) {
                        unionRule = "entryAnyOne";
                    }
                    String entryKey = conditionExpression.substring(unionRule.length() + 1, index);
                    logger.debug("\u6267\u884c\u8054\u5408\u8fd0\u7b97\uff0cconditionExpression:" + conditionExpression + ",unionRule:" + unionRule + ",entryKey" + entryKey);
                    conditionExpression = conditionExpression.substring(index + 1, conditionExpression.length() - 1);
                    variableScope.setTransientVariable("conditionRule_keyEntry", entryKey);
                    variableScope.setTransientVariable("conditionRule_unionrule", unionRule);
                }
                if ((condition = new UelExpressionCondition(expression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(conditionExpression))).evaluate(variableScope)) {
                    ret = true;
                }
            }
            ConditionUtil.recordConditionInst(conditionExpression, variableScope, key, ret, plugin, null);
        }
        catch (Exception e) {
            ConditionUtil.recordConditionInst(conditionExpression, variableScope, key, ret, plugin, e);
            throw ExceptionUtil.createWFConditionParseException(conditionExpression, variableScope, e);
        }
        finally {
            if (variableScope != null && variableScope.getTransientVariable("getnextnode_variable") != null) {
                variableScope.removeTransientVariable("getnextnode_variable");
            }
            if (variableScope != null) {
                variableScope.removeTransientVariable("conditionRule_keyEntry");
                variableScope.removeTransientVariable("conditionRule_unionrule");
            }
        }
        return ret;
    }

    protected static String getActiveValue(String originalValue, String propertyName, ObjectNode elementProperties) {
        JsonNode overrideValueNode;
        String activeValue = originalValue;
        if (elementProperties != null && (overrideValueNode = elementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : overrideValueNode.asText();
        }
        return activeValue;
    }

    public static String handleMacro(String conditionExpression, String nodeId) {
        if (conditionExpression.contains("proc.lastAssignee")) {
            conditionExpression = conditionExpression.replace("proc.lastAssignee", "\"" + RequestContext.get().getUserId() + "\"");
        } else if (nodeId != null && conditionExpression.contains("proc." + nodeId + "Assignee")) {
            conditionExpression = conditionExpression.replace("proc." + nodeId + "Assignee", "\"" + RequestContext.get().getUserId() + "\"");
        }
        return conditionExpression;
    }

    public static String handleMacroForCalculateNextNode(String conditionExpression, Map<String, String> nodeIdMapItAuditNumber, Map<String, String> nodeIdMapItAssigneeId, String lastAssign, Map<String, String> nodeIdMapExecutionType, VariableScope variableScope) {
        HashMap<String, String> transientVariable = new HashMap<String, String>();
        if (conditionExpression.contains("proc.lastAssignee") && WfUtils.isNotEmpty(lastAssign)) {
            transientVariable.put("lastAssignee", lastAssign);
        }
        Iterator<Map.Entry<String, String>> nodeIdEntry = nodeIdMapItAuditNumber.entrySet().iterator();
        Process process = null;
        if (variableScope instanceof ExecutionEntity) {
            process = ProcessDefinitionUtil.getProcessByProcInstId(((ExecutionEntity)variableScope).getProcessInstanceId());
        } else if (variableScope instanceof TaskEntity) {
            process = ProcessDefinitionUtil.getProcessByProcInstId(((TaskEntity)variableScope).getProcessInstanceId());
        }
        block0: while (nodeIdEntry.hasNext()) {
            Map.Entry<String, String> entry = nodeIdEntry.next();
            String string = (String)entry.getKey();
            String auditNumber = (String)entry.getValue();
            String nodeAuditNumber = String.format("%s.%s", "proc", string + "AuditNumber");
            if (auditNumber == null || !conditionExpression.contains(nodeAuditNumber)) continue;
            String absEnumAN = String.format("absenum(%s)", nodeAuditNumber);
            if (conditionExpression.contains(absEnumAN)) {
                if (process == null) continue;
                UserTask ut = (UserTask)process.getFlowElement(string);
                for (DecisionOption op : ut.getDecisionOptions()) {
                    if (!op.getNumber().equals(auditNumber)) continue;
                    conditionExpression = conditionExpression.replaceAll(String.format("absenum\\(%s\\)", nodeAuditNumber), "\"" + op.getName() + "\"");
                    continue block0;
                }
                continue;
            }
            conditionExpression = conditionExpression.replaceAll(nodeAuditNumber, "\"" + auditNumber + "\"");
        }
        for (Map.Entry entry : nodeIdMapItAssigneeId.entrySet()) {
            String nodeId = (String)entry.getKey();
            if (nodeIdMapItAssigneeId.get(nodeId) == null || !conditionExpression.contains("proc." + nodeId + "Assignee")) continue;
            transientVariable.put(nodeId + "Assignee", nodeIdMapItAssigneeId.get(nodeId));
        }
        LinkedHashMap<String, String> types = new LinkedHashMap<String, String>();
        types.put("byHand", ResManager.loadKDString((String)"\u4eba\u5de5", (String)"ExpressionPropUtils_15", (String)"bos-wf-engine", (Object[])new Object[0]));
        types.put("byAuto", ResManager.loadKDString((String)"\u81ea\u52a8", (String)"ExpressionPropUtils_16", (String)"bos-wf-engine", (Object[])new Object[0]));
        types.put(SKIPCONDITION, ResManager.loadKDString((String)"\u8df3\u8fc7", (String)"ExpressionPropUtils_17", (String)"bos-wf-engine", (Object[])new Object[0]));
        types.put("jump", ResManager.loadKDString((String)"\u8df3\u8f6c", (String)"ExpressionPropUtils_18", (String)"bos-wf-engine", (Object[])new Object[0]));
        for (Map.Entry<String, String> entry : nodeIdMapExecutionType.entrySet()) {
            String nodeId = entry.getKey();
            String executionType = entry.getValue();
            String nodeExeType = "proc." + nodeId + "ExecutionType";
            if (nodeIdMapExecutionType.get(nodeId) == null || !conditionExpression.contains(nodeExeType)) continue;
            String absEnumNodeET = String.format("absenum(%s)", nodeExeType);
            if (conditionExpression.contains(absEnumNodeET)) {
                conditionExpression = conditionExpression.replaceAll(String.format("absenum\\(%s\\)", nodeExeType), "\"" + (String)types.get(executionType) + "\"");
                continue;
            }
            conditionExpression = conditionExpression.replaceAll(nodeExeType, "\"" + executionType + "\"");
        }
        if (!transientVariable.isEmpty()) {
            variableScope.setTransientVariable("getnextnode_variable", transientVariable);
        }
        return conditionExpression;
    }

    public static boolean isConditionAvailable(ConditionalRuleEntity condition) {
        return condition != null && (WfUtils.isNotEmpty(condition.getExpression()) || WfUtils.isNotEmpty(condition.getPlugin()));
    }

    public static String getConInstKey(String nodeNumber, String identify) {
        String conditionKey = ConditionType.getConditionKey();
        if (StringUtils.isNotEmpty((CharSequence)conditionKey)) {
            identify = conditionKey;
        }
        return String.format("[%s]_[%s]", identify, nodeNumber);
    }

    public static String getStartConInstKey(String entityNumber, String operation, String number) {
        return String.format("[%s]_[%s]_[%s]_[%s]", STARTCONDITION, entityNumber, operation, number);
    }

    public static String getSchmeConInstKey(String prodefNum, String number) {
        return String.format("[%s]_[%s]_[%s]", SCHEMECONDITION, prodefNum, number);
    }
}

