/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util.condition;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.util.JSONUtils;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.EventSupportTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Gateway;
import kd.bos.workflow.bpmn.model.NotifyTask;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.WFException;

public class ConditionalRuleHelper {
    private static final String VALUE = "value";

    private ConditionalRuleHelper() {
    }

    public static String getConditionExpression(List<Map<String, Object>> itemsValue) {
        if (!itemsValue.isEmpty()) {
            StringBuilder expressionSB = new StringBuilder("${");
            String leftbracket = "";
            String expression = "";
            String comparetype = "";
            String valuetype = "";
            String value = "";
            String rightbracket = "";
            String logaic = "";
            boolean hasquotes = true;
            int i = 0;
            for (Map<String, Object> itemValue : itemsValue) {
                ++i;
                Object expressionObj = itemValue.get("expression");
                if (expressionObj == null) continue;
                if (expressionObj instanceof String) {
                    expression = expressionObj.toString();
                    if (WfUtils.isEmpty(expression)) continue;
                    Pattern pattern = Pattern.compile("value=([\\w\\.]+)");
                    Matcher matcher = pattern.matcher(expression);
                    if (matcher.find()) {
                        expression = matcher.group(1);
                    }
                } else if (expressionObj instanceof Map) {
                    Map expressionMap = (Map)expressionObj;
                    if (expressionMap.isEmpty()) continue;
                    expression = (String)expressionMap.get(VALUE);
                }
                leftbracket = ConditionalRuleHelper.getString(itemValue.get("leftbracket"));
                comparetype = ConditionalRuleHelper.getString(itemValue.get("comparetype"));
                valuetype = ConditionalRuleHelper.getString(itemValue.get("valuetype"));
                hasquotes = itemValue.get("hasquotes") == null ? true : (Boolean)itemValue.get("hasquotes");
                value = ConditionalRuleHelper.getExpressionValue(valuetype, itemValue);
                rightbracket = ConditionalRuleHelper.getString(itemValue.get("rightbracket"));
                logaic = i == itemsValue.size() ? "" : ConditionalRuleHelper.getString(itemValue.get("logaic"));
                if ("empty".equals(comparetype) || "notempty".equals(comparetype)) {
                    expressionSB.append(' ').append("".equals(leftbracket) ? "" : leftbracket + ' ').append(comparetype).append(' ').append(expression).append(' ').append("".equals(rightbracket) ? "" : rightbracket + ' ').append(logaic);
                    continue;
                }
                expressionSB.append(' ').append("".equals(leftbracket) ? "" : leftbracket + ' ').append(expression).append(' ').append(comparetype).append(' ');
                if (ConditionalRuleHelper.isDesignatedCompareType(comparetype)) {
                    hasquotes = true;
                }
                if (hasquotes && !valuetype.equals("fieldVal")) {
                    expressionSB.append('\"').append(value).append('\"').append(' ').append("".equals(rightbracket) ? "" : rightbracket + ' ').append(logaic);
                    continue;
                }
                expressionSB.append(value).append(' ').append("".equals(rightbracket) ? "" : rightbracket + ' ').append(logaic);
            }
            return expressionSB.append('}').toString();
        }
        return "";
    }

    private static boolean isDesignatedCompareType(String comparetype) {
        return "LK".equals(comparetype) || "NL".equals(comparetype) || "BL".equals(comparetype) || "NB".equals(comparetype) || "NC".equals(comparetype) || "IN".equals(comparetype) || "CL".equals(comparetype) || "NI".equals(comparetype) || "CAL".equals(comparetype) || "CAY".equals(comparetype) || "NOTC".equals(comparetype) || "ANI".equals(comparetype);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getExpressionValue(String valuetype, Map<String, Object> itemValue) {
        String value = "";
        Object valueObj = itemValue.get(VALUE);
        if (valueObj == null) {
            return value;
        }
        if ("fieldVal".equals(valuetype)) {
            if (valueObj instanceof String) {
                value = valueObj.toString();
                if (WfUtils.isEmpty(value)) {
                    return value;
                }
                Pattern pattern = Pattern.compile("value=([\\w\\.]+)");
                Matcher matcher = pattern.matcher(value);
                if (!matcher.find()) return value;
                return matcher.group(1);
            }
            if (!(valueObj instanceof Map)) return value;
            Map expressionMap = (Map)valueObj;
            if (!expressionMap.isEmpty()) return (String)expressionMap.get(VALUE);
            return value;
        }
        if (valueObj instanceof List) {
            List list = (List)valueObj;
            if (list.isEmpty()) return value;
            Object typeObj = list.get(0);
            StringBuilder sb = new StringBuilder();
            if (typeObj instanceof Map) {
                for (Map m : list) {
                    if (m.get(VALUE) == null || !WfUtils.isNotEmpty(m.get(VALUE).toString())) continue;
                    sb.append(m.get(VALUE).toString()).append(',');
                }
            } else {
                for (Object o : list) {
                    if (o == null || !WfUtils.isNotEmpty(o.toString())) continue;
                    sb.append(o.toString()).append(',');
                }
            }
            if (sb.length() <= 1) return value;
            if (!sb.toString().endsWith(",")) return value;
            return sb.substring(0, sb.length() - 1);
        }
        if (!(valueObj instanceof String)) return value;
        return (String)valueObj;
    }

    public static List<Map<String, Object>> getConditionItems(List<Map<String, Object>> conditionals) {
        ArrayList<Map<String, Object>> conditionItems = new ArrayList<Map<String, Object>>(conditionals.size());
        for (Map<String, Object> conditional : conditionals) {
            HashMap<String, Object> item = new HashMap<String, Object>(9);
            item.put("leftbracket", conditional.get("leftbracket"));
            Object compareTypeObj = conditional.get("operation");
            if (WfUtils.isNotEmptyString(compareTypeObj)) {
                String expression;
                String compareType = compareTypeObj.toString();
                if ("!empty".equals(compareType)) {
                    item.put("comparetype", "notempty");
                    item.put("expression", conditional.get("paramnumber"));
                } else if ("BR".equals(compareType)) {
                    if (WfUtils.isNotEmptyString(conditional.get("paramnumber"))) {
                        expression = conditional.get("paramnumber").toString();
                        expression = expression.endsWith(".id") ? expression.replace(".id", ".mc_wfRole") : expression + ".mc_wfRole";
                        item.put("expression", expression);
                        item.put("comparetype", "CL");
                    }
                } else if ("BO".equals(compareType)) {
                    if (WfUtils.isNotEmptyString(conditional.get("paramnumber"))) {
                        expression = conditional.get("paramnumber").toString();
                        expression = expression.endsWith(".id") ? expression.replace(".id", ".mc_org") : expression + ".mc_org";
                        item.put("expression", expression);
                        item.put("comparetype", "CL");
                    }
                } else if ("BS".equals(compareType)) {
                    if (WfUtils.isNotEmptyString(conditional.get("paramnumber"))) {
                        expression = conditional.get("paramnumber").toString();
                        expression = expression.endsWith(".id") ? expression.replace(".id", ".mc_bsOrg") : expression + ".mc_bsOrg";
                        item.put("expression", expression);
                        item.put("comparetype", "CL");
                    }
                } else if ("CS".equals(compareType)) {
                    if (WfUtils.isNotEmptyString(conditional.get("paramnumber"))) {
                        expression = conditional.get("paramnumber").toString();
                        expression = expression.endsWith(".id") ? expression.replace(".id", ".mc_csOrg") : expression + ".mc_csOrg";
                        item.put("expression", expression);
                        item.put("comparetype", "CL");
                    }
                } else {
                    item.put("expression", conditional.get("paramnumber"));
                    item.put("comparetype", conditional.get("operation"));
                }
            } else {
                item.put("expression", conditional.get("paramnumber"));
                item.put("comparetype", conditional.get("operation"));
            }
            item.put("logaic", conditional.get("logic"));
            if (conditional.get("id") != null) {
                item.put("id", conditional.get("id"));
            }
            item.put("rightbracket", conditional.get("rightbracket"));
            item.put("valuetype", conditional.get("valuetype"));
            item.put("isHideExp", conditional.get("isHideExp"));
            Object value = conditional.get(VALUE);
            if (value != null) {
                String strVal = value.toString();
                if (strVal.startsWith("[")) {
                    item.put(VALUE, SerializationUtils.fromJsonString((String)value.toString(), List.class));
                } else if (strVal.startsWith("{")) {
                    item.put(VALUE, SerializationUtils.fromJsonString((String)value.toString(), Map.class));
                } else {
                    item.put(VALUE, strVal);
                }
            }
            conditionItems.add(item);
        }
        return conditionItems;
    }

    public static String validateExpression(String expression, List<Map<String, Object>> conditionals) {
        if (WfUtils.isEmptyString(expression) || conditionals.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6761\u4ef6\u8868\u8fbe\u5f0f\u3002", (String)"ConditionalRuleHelper_1", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        String tip = ConditionalRuleHelper.validateConditionItems(conditionals);
        return tip == null ? ConditionalRuleHelper.validateConsistency(expression) : tip;
    }

    public static String validateConditionItems(List<Map<String, Object>> conditionals) {
        String tip = null;
        LinkedHashMap<String, String> validateFields = new LinkedHashMap<String, String>();
        validateFields.put("comparetype", ResManager.loadKDString((String)"\u64cd\u4f5c\u7b26", (String)"ConditionalRuleHelper_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        validateFields.put(VALUE, ResManager.loadKDString((String)"\u503c", (String)"ConditionalRuleHelper_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        validateFields.put("logaic", ResManager.loadKDString((String)"\u903b\u8f91\u7b26", (String)"ConditionalRuleHelper_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        ArrayDeque<String> bracket = new ArrayDeque<String>();
        Object lbkt = null;
        Object rbkt = null;
        String left = null;
        String right = null;
        Object value = null;
        String bracketTip = ResManager.loadKDString((String)"\u6761\u4ef6\u8868\u8fbe\u5f0f\u5de6\u62ec\u53f7\u548c\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\u3002", (String)"ConditionalRuleHelper_5", (String)"bos-wf-engine", (Object[])new Object[0]);
        int size = conditionals.size();
        Map<String, Object> cond = null;
        for (int i = 0; i < size; ++i) {
            cond = conditionals.get(i);
            for (Map.Entry entry : validateFields.entrySet()) {
                String key = (String)entry.getKey();
                value = cond.get(key);
                if (VALUE.equals(key)) {
                    if ("empty".equals(cond.get("comparetype")) || "notempty".equals(cond.get("comparetype"))) continue;
                    value = ConditionalRuleHelper.getConditionItemValue(value);
                }
                if (value != null && (!(value instanceof String) || !WfUtils.isEmpty(value.toString())) || "logaic".equals(key) && i == size - 1) continue;
                int j = i + 1;
                tip = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ConditionalRuleHelper_6", (String)"bos-wf-engine", (Object[])new Object[0]), j, validateFields.get(key));
                return tip;
            }
            lbkt = cond.get("leftbracket");
            rbkt = cond.get("rightbracket");
            if (lbkt != null && WfUtils.isNotEmpty(left = lbkt.toString().replace("!", ""))) {
                for (int j = 0; j < left.length(); ++j) {
                    bracket.push("(");
                }
            }
            if (rbkt == null || !WfUtils.isNotEmpty(right = rbkt.toString())) continue;
            for (int k = 0; k < right.length(); ++k) {
                if (bracket.isEmpty()) {
                    return bracketTip;
                }
                bracket.pop();
            }
        }
        if (!bracket.isEmpty()) {
            tip = bracketTip;
        }
        return tip;
    }

    public static String getConditionItemValue(Object itemValue) {
        String strVal = null;
        if (itemValue instanceof String && WfUtils.isNotEmpty(strVal = itemValue.toString())) {
            if (strVal.startsWith("[")) {
                itemValue = SerializationUtils.fromJsonString((String)itemValue.toString(), List.class);
            } else {
                return strVal;
            }
        }
        if (itemValue instanceof List) {
            List vals = (List)itemValue;
            StringBuilder sb = new StringBuilder();
            Map map = null;
            for (int i = 0; i < vals.size(); ++i) {
                map = (Map)vals.get(i);
                sb.append(map.get(VALUE));
                if (i >= vals.size() - 1) continue;
                sb.append(',');
            }
            return sb.toString();
        }
        if (itemValue instanceof Map) {
            Map val = (Map)itemValue;
            return (String)val.get(VALUE);
        }
        return "";
    }

    private static String getString(Object value) {
        if (value == null) {
            return "";
        }
        String ret = value.toString().trim();
        if (ret.length() <= 0) {
            return "";
        }
        return ret;
    }

    public static String getConditionExpression(ArrayNode conditions) {
        try {
            List<Map<String, Object>> items = ConditionalRuleHelper.getConditionItems((List)JSONUtils.cast((String)conditions.toString(), List.class));
            int size = items.size();
            Map<String, Object> item = null;
            for (int i = 0; i < size; ++i) {
                item = items.get(i);
                Object value = item.get(VALUE);
                if (value != null) {
                    boolean noQuotes = value instanceof Number || value instanceof Boolean || value.toString().matches("\\d+(\\.\\d+)?");
                    item.put("hasquotes", !noQuotes);
                }
                Object logic = item.get("logaic");
                if (i >= size - 1 || logic != null && !WfUtils.isEmpty(logic.toString())) continue;
                item.put("logaic", "&&");
                ((ObjectNode)conditions.get(i)).put("logic", "&&");
            }
            return ConditionalRuleHelper.getConditionExpression(items);
        }
        catch (IOException e) {
            throw new WFException(String.format(ResManager.loadKDString((String)"\u91cd\u65b0\u751f\u6210\u6761\u4ef6\u89c4\u5219\u8868\u8fbe\u5f0f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u8bbe\u7f6e\u3002\u539f\u56e0\uff1a%s", (String)"ConditionalRuleHelper_9", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public static String validateConsistency(String expression) {
        String tip = null;
        ArrayDeque<Character> bracket = new ArrayDeque<Character>();
        String bracketTip = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u7ed3\u679c\u4e0e\u6761\u4ef6\u8bbe\u7f6e\u4e0d\u4e00\u81f4\u3002", (String)"ConditionalRuleHelper_10", (String)"bos-wf-engine", (Object[])new Object[0]);
        for (char c : expression.toCharArray()) {
            if (c == '(') {
                bracket.push(Character.valueOf('('));
                continue;
            }
            if (c != ')') continue;
            if (bracket.isEmpty()) {
                return bracketTip;
            }
            bracket.pop();
        }
        if (!bracket.isEmpty()) {
            tip = bracketTip;
        }
        return tip;
    }

    public static String getEntryBillNumber(Process process, String nodeId, Object needSourceElement) {
        if (WfUtils.isNotEmpty(nodeId)) {
            String entityId;
            FlowElement element = process.getFlowElement(nodeId = nodeId.replaceFirst("\\s*(\\w+)\\s+.+", "$1").trim());
            if (element instanceof SequenceFlow) {
                SequenceFlow seqFlow = (SequenceFlow)element;
                element = process.getFlowElement(seqFlow.getSourceRef());
            }
            if (element instanceof BillTask) {
                if (needSourceElement != null && ((Boolean)needSourceElement).booleanValue()) {
                    return ((BillTask)element).getSourceEntityNumber();
                }
                return ((BillTask)element).getEntityNumber();
            }
            if (element instanceof UserTask) {
                return ((UserTask)element).getEntityNumber();
            }
            if (element instanceof EventSupportTask) {
                entityId = ((EventSupportTask)element).getEntityId();
                return MetadataDao.getNumberById((String)entityId);
            }
            if (element instanceof AutoTask) {
                entityId = ((AutoTask)element).getEntityId();
                return MetadataDao.getNumberById((String)entityId);
            }
            if (element instanceof CallActivity) {
                return ((CallActivity)element).getEntityNumber();
            }
            if (element instanceof Gateway) {
                return ((Gateway)element).getEntityNumber() == null ? process.getEntraBill() : ((Gateway)element).getEntityNumber();
            }
            if (element instanceof NotifyTask) {
                return ((NotifyTask)element).getEntityNumber() == null ? process.getEntraBill() : ((NotifyTask)element).getEntityNumber();
            }
        }
        return process.getEntraBill();
    }
}

