/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util.taskrule;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterNavigationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterOperationMetaEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.task.center.operation.IOperation;
import kd.bos.workflow.engine.task.center.operation.OperationsRegister;
import kd.bos.workflow.engine.task.center.operation.SetTaskLevelOperation;

public class VerifyConditionUtils {
    private static Log logger = LogFactory.getLog(VerifyConditionUtils.class);
    public static final String ACTIVITSTATEENABLE = "enable";
    public static final String SCENE_FOLDER = "folder";
    public static final String SCENE_RULE = "rule";

    private VerifyConditionUtils() {
    }

    public static void verifyConditionsAndExecute(Long taskId, Long userId) {
        if (WfUtils.isEmpty(userId)) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        if (WfUtils.isEmpty(userId) || WfUtils.isEmpty(taskId)) {
            return;
        }
        TaskEntity task = null;
        List<TaskCenterRuleEntity> centerRules = commandContext.getTaskCenterRuleEntityManager().getTaskCenterRulesByUserId(userId);
        if (centerRules != null && centerRules.size() > 0) {
            TaskCenterRuleEntity ruleEntity = null;
            TaskCenterOperationMetaEntity transferOperation = null;
            for (TaskCenterRuleEntity i : centerRules) {
                String activitState = i.getActivitstate();
                if (!ACTIVITSTATEENABLE.equals(activitState)) continue;
                List<TaskCenterOperationMetaEntity> operationList = i.getOperationMetas();
                for (TaskCenterOperationMetaEntity o : operationList) {
                    if (!"Transfer".equals(o.getOperationkey())) continue;
                    transferOperation = o;
                    break;
                }
                if (transferOperation == null) continue;
                ruleEntity = i;
                break;
            }
            boolean passVerifyConditions = false;
            if (ruleEntity != null && transferOperation != null && (task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId)) != null) {
                String key = ConditionUtil.getConInstKey(taskId + "_" + userId, "taskAutoRule");
                try {
                    passVerifyConditions = ConditionUtil.hasTrueCondition(ruleEntity.getExpression(), (VariableScope)task, key);
                }
                catch (Exception e) {
                    logger.warn(String.format("error occur for rule[%s][%s],exception is [%s]", ruleEntity.getExpression(), ruleEntity.getId(), e.getMessage()));
                }
                if (passVerifyConditions) {
                    IOperation operation = OperationsRegister.getInstance().getOperation("Transfer");
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("params", transferOperation.getOperateparams());
                    params.put("taskId", taskId);
                    params.put("userId", userId);
                    params.put("taskRuleId", ruleEntity.getId());
                    params.put("taskEntity", task);
                    operation.execute(null, params);
                }
            }
            if (!passVerifyConditions) {
                boolean isUrgency = VerifyConditionUtils.isUrgency(taskId, task, centerRules);
                if (isUrgency) {
                    Iterator<TaskCenterRuleEntity> ruleIterator = centerRules.iterator();
                    while (ruleIterator.hasNext()) {
                        List<TaskCenterOperationMetaEntity> operationList;
                        TaskCenterRuleEntity centerRule = ruleIterator.next();
                        if (!ACTIVITSTATEENABLE.equals(centerRule.getActivitstate()) || !(operationList = VerifyConditionUtils.removeImportant(centerRule, isUrgency)).isEmpty()) continue;
                        ruleIterator.remove();
                    }
                }
                for (TaskCenterRuleEntity centerRule : centerRules) {
                    if (!ACTIVITSTATEENABLE.equals(centerRule.getActivitstate())) continue;
                    VerifyConditionUtils.verifyOneRuleAndExecute(userId, taskId, commandContext, centerRule, task);
                }
            }
        }
    }

    public static void verifyOneRuleAndExecute(Long ruleownerId, Long taskId, CommandContext commandContext, TaskCenterRuleEntity centerRule, TaskEntity task) {
        String expression = centerRule.getExpression();
        if (WfUtils.isEmpty(expression)) {
            return;
        }
        boolean passVerifyConditions = false;
        if (task == null) {
            task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        }
        if (task != null) {
            String type = centerRule.getType();
            if (SCENE_FOLDER.equals(type)) {
                if (!task.isDisplay() || "mobile".equals(task.getEndType())) {
                    return;
                }
                List<IdentityLinkEntity> identityLinks = task.getIdentityLinks();
                if (identityLinks == null) {
                    return;
                }
                IdentityLinkEntity ruleOwnerIdentityLink = null;
                for (IdentityLinkEntity identityLinkEntity : identityLinks) {
                    if (!identityLinkEntity.getUserId().equals(centerRule.getUserid())) continue;
                    ruleOwnerIdentityLink = identityLinkEntity;
                    break;
                }
                if (ruleOwnerIdentityLink == null || !ruleOwnerIdentityLink.isDisplay().booleanValue() || ruleOwnerIdentityLink.getCompositeTaskId() > 0L) {
                    return;
                }
            }
            String key = ConditionUtil.getConInstKey(taskId + "_" + centerRule.getUserid(), "taskAutoRule");
            try {
                passVerifyConditions = ConditionUtil.hasTrueCondition(expression, (VariableScope)task, key);
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
                passVerifyConditions = false;
            }
            if (passVerifyConditions) {
                List<TaskCenterOperationMetaEntity> operateMetas = centerRule.getOperationMetas();
                Collections.sort(operateMetas, new Comparator<TaskCenterOperationMetaEntity>(){

                    @Override
                    public int compare(TaskCenterOperationMetaEntity o1, TaskCenterOperationMetaEntity o2) {
                        return (int)(Long.parseLong(o1.getId()) - Long.parseLong(o2.getId()));
                    }
                });
                VerifyConditionUtils.executeOperations(operateMetas, task, ruleownerId, centerRule.getId());
            }
        }
    }

    private static void executeOperations(List<TaskCenterOperationMetaEntity> operateMetas, TaskEntity taskEntity, Long ruleOwnerId, Long taskRuleId) {
        if (operateMetas == null || operateMetas.size() < 1) {
            return;
        }
        for (TaskCenterOperationMetaEntity operateMeta : operateMetas) {
            String fieldName = operateMeta.getOperationkey();
            IOperation operation = OperationsRegister.getInstance().getOperation(fieldName);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("params", operateMeta.getOperateparams());
            params.put("taskId", taskEntity.getId());
            params.put("userId", ruleOwnerId);
            params.put("taskRuleId", taskRuleId);
            params.put("taskEntity", taskEntity);
            operation.execute(null, params);
        }
    }

    @Deprecated
    public static void executeOperations(List<TaskCenterOperationMetaEntity> operateMetas, Long taskId, Long ruleOwnerId, Long taskRuleId) {
        TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(taskId);
        VerifyConditionUtils.executeOperations(operateMetas, task, ruleOwnerId, taskRuleId);
    }

    public static void executeTaskRuleCalculate(Long userId, Long ruleId, String sence) {
        if (WfUtils.isEmpty(userId) || WfUtils.isEmpty(ruleId) || WfUtils.isEmpty(sence)) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        QFilter filter = new QFilter("userid", "=", (Object)userId);
        QFilter notNullFilter = new QFilter("taskid", "is not null", (Object)0);
        QFilter typeFilter = new QFilter("type", "=", (Object)"participant");
        QFilter[] filters = new QFilter[]{filter, notNullFilter, typeFilter};
        List identityLinkEntitys = commandContext.getIdentityLinkEntityManager().findByQueryFilters(filters, "id,taskId", null);
        if (SCENE_FOLDER.equals(sence)) {
            ruleId = ((TaskCenterNavigationEntity)commandContext.getTaskCenterNavigationEntityManager().findById(ruleId)).getTaskcenterruleid();
        }
        TaskCenterRuleEntity centerRule = null;
        List<TaskCenterRuleEntity> centerRules = commandContext.getTaskCenterRuleEntityManager().getTaskCenterRulesByUserId(userId);
        for (TaskCenterRuleEntity taskCenterRuleEntity : centerRules) {
            if (!ruleId.equals(taskCenterRuleEntity.getId())) continue;
            centerRule = taskCenterRuleEntity;
            break;
        }
        if (centerRule != null) {
            HashSet<Long> taskIds = new HashSet<Long>();
            for (IdentityLinkEntity identityLinkEntity : identityLinkEntitys) {
                Long taskid = identityLinkEntity.getTaskId();
                if (!WfUtils.isNotEmpty(taskid)) continue;
                taskIds.add(taskid);
            }
            QFilter qFilter = new QFilter("id", "in", taskIds);
            List tasks = commandContext.getTaskEntityManager().findByQueryFilters(new QFilter[]{qFilter});
            for (TaskEntity t : tasks) {
                try {
                    List<TaskCenterOperationMetaEntity> operationList = VerifyConditionUtils.removeImportant(centerRule, VerifyConditionUtils.isUrgency(t.getId(), t, centerRules));
                    if (operationList.isEmpty()) continue;
                    VerifyConditionUtils.verifyOneRuleAndExecute(userId, t.getId(), commandContext, centerRule, t);
                }
                catch (Exception e) {
                    logger.error("\u81ea\u52a8\u6761\u4ef6\u89c4\u5219\u5e94\u7528\u9519\u8bef\uff1ataskId:" + t.getId() + ",rule:" + (centerRule == null ? "null" : centerRule.getId()) + "\uff0cuser:" + userId);
                }
            }
        }
    }

    public static boolean isUrgency(Long taskId, TaskEntity task, List<TaskCenterRuleEntity> centerRules) {
        CommandContext commandContext;
        if (task == null && (task = (TaskEntity)(commandContext = Context.getCommandContext()).getTaskEntityManager().findById(taskId)) == null) {
            return Boolean.FALSE;
        }
        for (TaskCenterRuleEntity rule : centerRules) {
            String activitState = rule.getActivitstate();
            String expression = rule.getExpression();
            if (WfUtils.isEmpty(expression) || !ACTIVITSTATEENABLE.equals(activitState)) continue;
            boolean passVerifyConditions = false;
            String key = ConditionUtil.getConInstKey(task.getId() + "_" + rule.getUserid(), "taskAutoRule");
            try {
                passVerifyConditions = ConditionUtil.hasTrueCondition(expression, (VariableScope)task, key);
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
                passVerifyConditions = false;
            }
            if (!passVerifyConditions) continue;
            List<TaskCenterOperationMetaEntity> operationList = rule.getOperationMetas();
            for (TaskCenterOperationMetaEntity o : operationList) {
                if (!"setTaskLevel".equals(o.getOperationkey())) continue;
                String param = o.getOperateparams().replace("'", "\"");
                Map paramsMap = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
                String markId = (String)paramsMap.get("levelId");
                if (SetTaskLevelOperation.URGENCY != Long.parseLong(markId)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static List<TaskCenterOperationMetaEntity> removeImportant(TaskCenterRuleEntity centerRule, boolean isUrgency) {
        List<TaskCenterOperationMetaEntity> operationList = centerRule.getOperationMetas();
        if (!isUrgency) {
            return operationList;
        }
        Iterator<TaskCenterOperationMetaEntity> iterator = operationList.iterator();
        while (iterator.hasNext()) {
            TaskCenterOperationMetaEntity o = iterator.next();
            if (!"setTaskLevel".equals(o.getOperationkey())) continue;
            String param = o.getOperateparams().replace("'", "\"");
            Map paramsMap = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
            String markId = (String)paramsMap.get("levelId");
            if (SetTaskLevelOperation.IMPORTANT != Long.parseLong(markId)) continue;
            iterator.remove();
        }
        return operationList;
    }
}

