/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.variable;

import java.math.BigDecimal;
import kd.bos.workflow.engine.impl.variable.ValueFields;
import kd.bos.workflow.engine.impl.variable.VariableType;

public class DoubleType
implements VariableType {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTypeName() {
        return "double";
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        return valueFields.getDoubleValue();
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        if (value instanceof BigDecimal) {
            value = ((BigDecimal)value).doubleValue();
        }
        valueFields.setDoubleValue((Double)value);
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Double.class.isAssignableFrom(value.getClass()) || BigDecimal.class.isAssignableFrom(value.getClass());
    }
}

