/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.variable;

import kd.bos.workflow.engine.impl.variable.ValueFields;
import kd.bos.workflow.engine.impl.variable.VariableType;

public class IntegerType
implements VariableType {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTypeName() {
        return "integer";
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        if (valueFields.getLongValue() != null) {
            return valueFields.getLongValue().intValue();
        }
        return null;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            valueFields.setLongValue(((Integer)value).longValue());
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setLongValue(null);
            valueFields.setTextValue(null);
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Integer.class.isAssignableFrom(value.getClass()) || Integer.TYPE.isAssignableFrom(value.getClass());
    }
}

