/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.variable;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.variable.ValueFields;
import kd.bos.workflow.engine.impl.variable.VariableType;

public class JsonType
implements VariableType {
    protected static Log logger = LogFactory.getLog(JsonType.class);
    protected final int maxLength;
    protected ObjectMapper objectMapper;

    public JsonType(int maxLength, ObjectMapper objectMapper) {
        this.maxLength = maxLength;
        this.objectMapper = objectMapper;
    }

    @Override
    public String getTypeName() {
        return "json";
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        JsonNode jsonValue = null;
        if (valueFields.getTextValue() != null && valueFields.getTextValue().length() > 0) {
            try {
                jsonValue = this.objectMapper.readTree(valueFields.getTextValue());
            }
            catch (Exception e) {
                logger.error("Error reading json variable " + valueFields.getName(), (Throwable)e);
            }
        }
        if (jsonValue instanceof ArrayNode) {
            return SerializationUtils.fromJsonStringToList((String)valueFields.getTextValue(), Object.class);
        }
        if (jsonValue instanceof ObjectNode) {
            return SerializationUtils.fromJsonString((String)valueFields.getTextValue(), Map.class);
        }
        return jsonValue;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        if (value instanceof List || value instanceof Map) {
            valueFields.setTextValue(SerializationUtils.toJsonString((Object)value));
        } else {
            valueFields.setTextValue(value != null ? value.toString() : null);
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof JsonNode || value instanceof List || value instanceof Map) {
            return Boolean.TRUE;
        }
        return false;
    }
}

