/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.variable;

import java.util.UUID;
import kd.bos.workflow.engine.impl.variable.ValueFields;
import kd.bos.workflow.engine.impl.variable.VariableType;

public class UUIDType
implements VariableType {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTypeName() {
        return "uuid";
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        String textValue = valueFields.getTextValue();
        if (textValue == null) {
            return null;
        }
        return UUID.fromString(textValue);
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setTextValue(null);
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return UUID.class.isAssignableFrom(value.getClass());
    }
}

