/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.listener;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventListener;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEntityEventImpl;
import kd.bos.workflow.engine.impl.asyncexecutor.RepeatJobModel;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.validation.validator.util.BpmnNodeValidateUtil;

public class JobFinishExecuteTestingPlanListener
implements ActivitiEventListener {
    private WorkflowService wfService = null;
    private static Log log = LogFactory.getLog(JobFinishExecuteTestingPlanListener.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onEvent(ActivitiEvent event) {
        ActivitiEntityEventImpl activitiEvent;
        if (!(event instanceof ActivitiEntityEventImpl) || !WfUtils.isNotEmpty((activitiEvent = (ActivitiEntityEventImpl)event).getExecutionId()) || !(activitiEvent.getEntity() instanceof JobEntity)) return;
        JobEntity job = (JobEntity)activitiEvent.getEntity();
        if (JobStateEnum.ERRORED.getNumber().equals(job.getState())) {
            this.markTestingPlanfailed(job);
            return;
        }
        String jobType = job.getJobHandlerType();
        if (RuntimeUtil.isRunningJob(jobType)) {
            Long executionId = activitiEvent.getExecutionId();
            Long procInstId = activitiEvent.getProcessInstanceId();
            RepeatJobModel repeatJob = job.getRepeatJobModel();
            if (repeatJob != null && WfUtils.isNotEmpty(repeatJob.getLockKey())) {
                try (DLock tlock = DLock.create((String)String.format("wf/autotest/%s", repeatJob.getLockKey()), (String)String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u6d4b\u8bd5\u9501\u5b9a[%s]", (String)"JobFinishExecuteTestingPlanListener_2", (String)"bos-wf-engine", (Object[])new Object[0]), repeatJob.getLockKey())).fastMode();){
                    if (RepeatJobModel.JobLockedStrategy.DISCARD == repeatJob.getRepeatJobStrategy()) {
                        boolean lockSuccess = tlock.tryLock(60000L);
                        if (!lockSuccess) return;
                        this.handleTask(job, executionId, procInstId);
                        return;
                    }
                    tlock.lock();
                    this.handleTask(job, executionId, procInstId);
                    return;
                }
            } else {
                this.handleTask(job, executionId, procInstId);
            }
            return;
        } else if ("async-taskRuleAnalysis".equals(jobType)) {
            log.info(jobType);
            return;
        } else {
            if (!"async-todo".equals(jobType)) return;
            log.info(jobType);
        }
    }

    private void markTestingPlanfailed(JobEntity job) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)job.getProcessInstanceId())};
        DynamicObject hisProcInst = QueryServiceHelper.queryOne((String)"wf_hiprocinst", (String)"testingPlanId", (QFilter[])filters);
        BpmnNodeValidateUtil.removeValidateDatas(job.getProcessInstanceId());
        BpmnNodeValidateUtil.recordValidateFailed(hisProcInst.getLong("testingPlanId"), String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u8fd0\u884c\u5f02\u5e38\uff0c%s", (String)"JobFinishExecuteTestingPlanListener_1", (String)"bos-wf-engine", (Object[])new Object[0]), job.getExceptionMessage()));
    }

    private void handleTask(JobEntity job, Long executionId, Long procInstId) {
        String cfg = job.getJobHandlerConfiguration();
        Map map = (Map)SerializationUtils.fromJsonString((String)cfg, Map.class);
        if (map.get("joinFlag") != null) {
            QFilter pf = new QFilter("processInstanceId", "=", (Object)procInstId);
            QFilter nf = new QFilter("taskDefinitionKey", "=", (Object)job.getElementId());
            List<TaskEntity> list = this.wfService.getTaskService().findTasksByFilter(new QFilter[]{pf, nf});
            if (list == null || list.isEmpty()) {
                return;
            }
            TaskEntity task = list.get(0);
            if (task != null) {
                this.wfService.getRuntimeService().validate(procInstId, task.getExecutionId(), task.getId());
            }
        } else {
            ExecutionEntity currentExecution = (ExecutionEntity)this.getWfService().getRepositoryService().findEntityById(executionId, "wf_execution");
            if (currentExecution != null) {
                TaskEntity task = (TaskEntity)this.wfService.getRepositoryService().findEntityById(currentExecution.getCurrentTaskId(), "wf_task");
                if (task != null) {
                    this.wfService.getRuntimeService().validate(procInstId, currentExecution.getId(), task.getId());
                } else if ("async-continuation".equals(job.getJobHandlerType()) && !"completed".equals(job.getState())) {
                    this.wfService.getRuntimeService().validate(procInstId, currentExecution.getId(), 0L);
                }
            } else {
                this.wfService.getRuntimeService().validate(procInstId, null, 0L);
            }
        }
    }

    public WorkflowService getWfService() {
        if (this.wfService == null) {
            this.wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        }
        return this.wfService;
    }

    @Override
    public boolean isFailOnException() {
        return false;
    }
}

