/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.management.batchsetting;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.IModelModifyLog;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogImpl;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingProperty;
import kd.bos.workflow.engine.management.batchsetting.IBatchSettingProperties;
import kd.bos.workflow.engine.management.batchsetting.IPropertiesBatchSetter;

public abstract class AbstractPropertiesBatchSetter<T>
implements IPropertiesBatchSetter {
    protected Log log = LogFactory.getLog(this.getClass());

    protected void updateNodeProperties(JSONObject model, T node, ProcessInfoEntity info, String type, IBatchSettingProperties batchSetting) {
        boolean isMatched = batchSetting.isMatched(node, info);
        if (!isMatched) {
            return;
        }
        List<BatchSettingProperty> settings = batchSetting.getBatchSettingProperties(type);
        if (settings == null || settings.isEmpty()) {
            this.log.debug(String.format("%s no batchSettingProperties", type));
            return;
        }
        this.updateNodeProperties(model, node, settings);
    }

    protected void updatePropertySetting(List<BatchSettingProperty> settings, JSONObject properties) {
        for (BatchSettingProperty setting : settings) {
            String prop = setting.getProperty();
            if (WfUtils.isNotEmpty(setting.getGroup())) {
                prop = String.format("%s.%s", setting.getGroup(), setting.getProperty());
            }
            this.updateProperty(properties, prop, this.getClonedValue(setting.getProperty(), setting.getValue()));
        }
    }

    protected Object getClonedValue(String property, Object value) {
        if (value instanceof Map) {
            JSONObject map = JSON.parseObject((String)JSONObject.toJSONString((Object)value, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            return BpmnDiffUtil.regenerateListPropertyId(map);
        }
        if (value instanceof List) {
            JSONObject map = new JSONObject();
            JSONArray array = JSON.parseArray((String)JSONObject.toJSONString((Object)value, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            map.put(property, (Object)array);
            return BpmnDiffUtil.regenerateListPropertyId(map).get((Object)property);
        }
        return value;
    }

    protected void updateProperty(JSONObject properties, String prop, Object value) {
        BpmnModelUtil.setProperty((Map<String, Object>)properties, prop, value);
    }

    @Override
    public void recordBatchSettingLogs(CommandContext commandContext, ProcessInfoEntity info, String before, String after) {
        ModelModifyLogEntityManager manager = commandContext.getModifyLogEntityManager();
        ModelModifyLogImpl modifyLog = new ModelModifyLogImpl(info.getProcdefId(), info.getSchemeId(), info.getResourceId());
        List<ModelModifyLogEntity> entities = this.getModelModifyLogEntities(commandContext, modifyLog, before, after);
        for (ModelModifyLogEntity entity : entities) {
            entity.setType("batchSetting");
            manager.insert(entity);
        }
        commandContext.getModelDataChangeLogEntityManager().recordChangeLog(info.getProcdefId(), info.getSchemeId(), info.getResourceId(), before);
    }

    protected abstract List<ModelModifyLogEntity> getModelModifyLogEntities(CommandContext var1, IModelModifyLog var2, String var3, String var4);

    protected abstract void updateNodeProperties(JSONObject var1, T var2, List<BatchSettingProperty> var3);
}

