/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.management.batchsetting;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.cmd.management.CreateProcessInfoEntityCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingJobInfo;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingProperty;
import kd.bos.workflow.engine.management.batchsetting.CustomSchemePropertiesBatchSetter;
import kd.bos.workflow.engine.management.batchsetting.DefaultSchemePropertiesBatchSetter;
import kd.bos.workflow.engine.management.batchsetting.IPropertiesBatchSetter;
import kd.bos.workflow.engine.management.batchsetting.MutexResult;

public class BatchSettingUtil {
    private static Log log = LogFactory.getLog(BatchSettingUtil.class);
    private static Set<String> conditionTypes = new HashSet<String>(16);
    private static Map<String, IPropertiesBatchSetter> settersMap = new HashMap<String, IPropertiesBatchSetter>();
    private static Pattern pattern = Pattern.compile("\\{\\s*([\\w\\._]+?)\\s*\\}");

    private BatchSettingUtil() {
    }

    public static IPropertiesBatchSetter getPropertiesBatchSetter(String schemeType) {
        return settersMap.get(schemeType);
    }

    public static Set<String> getStencilTypesFormString(String typesStr) {
        if (WfUtils.isEmpty(typesStr)) {
            return new HashSet<String>();
        }
        String[] types = typesStr.split(",");
        HashSet<String> stencilTypes = new HashSet<String>(types.length);
        for (String type : types) {
            stencilTypes.add(type);
        }
        return stencilTypes;
    }

    public static void createProcessInfo(CommandContext commandContext, DynamicConfigSchemeEntity entity, String data) {
        ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().create();
        resource.setId(entity.getJsonResourceId());
        resource.setData(data);
        new CreateProcessInfoEntityCmd(resource, entity).execute(commandContext);
    }

    public static void dispatchJobFormInfo(IFormView view, AbstractFormPlugin plugin, BatchSettingJobInfo info) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("wf");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setName(info.getName());
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(info.getTaskClassname());
        jobInfo.setParams(info.getParams());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, "taskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(info.getCaption());
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setClickClassName(info.getClickClassName());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)view);
    }

    public static boolean batchSettingTaskCloseCallBack(IFormView view, ClosedCallBackEvent e) {
        BatchSettingUtil.releaseBatchSettingMutexLock("batch_setting_properties");
        Object returnData = e.getReturnData();
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            String taskInfoStr = (String)data.get("taskinfo");
            if (WfUtils.isEmpty(taskInfoStr)) {
                log.debug("taskinfo is empty!");
                return false;
            }
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            if (taskInfo.isTaskEnd()) {
                Map result = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
                if (Boolean.TRUE.equals(result.get("success"))) {
                    return true;
                }
                String errormsg = (String)result.get("errormsg");
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u201c%s\u201d\u3002", (String)"BatchSettingUtil_1", (String)"bos-wf-engine", (Object[])new Object[0]), errormsg));
                return false;
            }
        } else {
            log.debug("returnData is null!");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MutexResult requireBatchSettingMutexLock(String dataObjId) {
        MutexResult result = new MutexResult();
        String entityId = "wf_processinfo";
        String opKey = "batchsetting";
        String mutexGroupId = MutexHelper.getMutexGroupId((String)entityId, (String)opKey);
        if (WfUtils.isEmpty(mutexGroupId)) {
            result.setSuccess(true);
            return result;
        }
        String userId = RequestContext.get().getUserId();
        try (DataMutex dataMutex = DataMutex.create();){
            Map batchSetLock;
            if ("save_dynamic_scheme".equals(dataObjId)) {
                batchSetLock = dataMutex.getLockInfo("batch_setting_properties", mutexGroupId, entityId);
                if (batchSetLock != null) {
                    log.debug(String.format("\u5f53\u524d\u5df2\u6709\u6279\u91cf\u8bbe\u7f6e\u7684\u9501\uff0c%s \u7533\u8bf7\u4fdd\u5b58\u914d\u7f6e\u65b9\u6848\u7684\u9501\u5931\u8d25\u3002 ", userId));
                    BatchSettingUtil.setFailedMutexResult(result, batchSetLock);
                    MutexResult mutexResult = result;
                    return mutexResult;
                }
                result.setSuccess(true);
                dataMutex.require(dataObjId, mutexGroupId, entityId, opKey, true);
                return result;
            }
            batchSetLock = dataMutex.getLockInfo("batch_setting_properties", mutexGroupId, entityId);
            if (batchSetLock != null) {
                log.debug(String.format("\u5f53\u524d\u5df2\u6709\u6279\u91cf\u8bbe\u7f6e\u7684\u9501\uff0c%s \u7533\u8bf7\u6279\u91cf\u8bbe\u7f6e\u7684\u9501\u5931\u8d25\u3002 ", userId));
                BatchSettingUtil.setFailedMutexResult(result, batchSetLock);
                MutexResult mutexResult = result;
                return mutexResult;
            }
            Map schemeModifyLock = dataMutex.getLockInfo("save_dynamic_scheme", mutexGroupId, entityId);
            if (schemeModifyLock != null) {
                log.debug(String.format("\u5f53\u524d\u5df2\u6709\u914d\u7f6e\u65b9\u6848\u4fdd\u5b58\u7684\u9501\uff0c%s \u7533\u8bf7\u6279\u91cf\u8bbe\u7f6e\u7684\u9501\u5931\u8d25\u3002 ", userId));
                BatchSettingUtil.setFailedMutexResult(result, schemeModifyLock);
                MutexResult mutexResult = result;
                return mutexResult;
            }
            boolean isSuccess = dataMutex.require(dataObjId, mutexGroupId, entityId, opKey, true);
            result.setSuccess(isSuccess);
            if (isSuccess) return result;
            BatchSettingUtil.setFailedMutexResult(result, dataMutex.getLockInfo());
            return result;
        }
        catch (IOException e) {
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"BatchSettingUtil_2", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
    }

    private static void setFailedMutexResult(MutexResult result, Map<String, String> lockInfo) {
        result.setSuccess(false);
        if (lockInfo == null) {
            return;
        }
        String userIdStr = lockInfo.get("userid");
        if (WfUtils.isNotEmpty(userIdStr)) {
            result.setUserId(Long.parseLong(userIdStr));
        }
    }

    public static void releaseBatchSettingMutexLock(String dataObjId) {
        MutexHelper.release((String)"wf_processinfo", (String)"batchsetting", (String)dataObjId);
    }

    public static void showRequireFailedTip(IFormView view, MutexResult result) {
        view.showMessage(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u6d41\u7a0b\u5c5e\u6027\u6279\u91cf\u8bbe\u7f6e\u6216\u65b9\u6848\u8bbe\u7f6e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BatchSettingUtil_3", (String)"bos-wf-engine", (Object[])new Object[0]), result.getUserName()));
    }

    public static Object getPropertyValue(Map<String, Object> cellProperties, BatchSettingProperty batchSettingProperty) {
        String property;
        String group = batchSettingProperty.getGroup();
        String path = property = batchSettingProperty.getProperty();
        if (WfUtils.isNotEmpty(group)) {
            path = String.format("%s.%s", group, property);
        }
        return BpmnModelUtil.getProperty(cellProperties, path);
    }

    public static boolean isStandardDecisionOption(String number) {
        return "Consent".equals(number) || "Reject".equals(number);
    }

    public static boolean isExpressionHasNotCommonExpression(String expression, List<String> expressions) {
        if (WfUtils.isEmpty(expression)) {
            return false;
        }
        Matcher matcher = pattern.matcher(expression);
        while (matcher.find()) {
            String number = matcher.group(1);
            boolean matched = BatchSettingUtil.isExpressionMatched(number, expressions);
            if (matched) continue;
            return true;
        }
        return false;
    }

    public static boolean isConditionHasNotCommonExpression(Map<String, Object> condition, List<String> expressions) {
        if (condition == null) {
            return false;
        }
        List items = (List)condition.get("entryentity");
        if (items == null || items.isEmpty()) {
            return false;
        }
        for (Map item : items) {
            String paramnumber = (String)item.get("paramnumber");
            boolean matched = BatchSettingUtil.isExpressionMatched(paramnumber, expressions);
            if (matched) continue;
            return true;
        }
        return false;
    }

    private static boolean isExpressionMatched(String number, List<String> expressions) {
        for (String expression : expressions) {
            if (number == null || !number.startsWith(expression)) continue;
            return true;
        }
        return false;
    }

    public static boolean isParticipantReferNotCommonExpression(String type, String referencePerson) {
        if (!"relation".equals(type) || WfUtils.isEmpty(referencePerson)) {
            return false;
        }
        if (referencePerson.startsWith("ENTI_") || referencePerson.startsWith("ENTRY_")) {
            return false;
        }
        String expression = referencePerson.replace("PROC_", "");
        return !"initiator".equals(expression) && !"lastAssignee".equals(expression);
    }

    public static boolean isConditionProperty(Object value) {
        if (!(value instanceof Map)) {
            return false;
        }
        Map map = (Map)value;
        Object type = map.get("type");
        if (type instanceof String) {
            return conditionTypes.contains(type.toString());
        }
        return false;
    }

    public static boolean isProcessInfoCanBeDeleted(CommandContext commandContext, Long procDefId, String state) {
        String field = String.format("%s,%s", "versionstate", "enable");
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procDefId, field);
        if ("newest".equals(processDefinition.getVersionState())) {
            log.debug(String.format("%s is the newest.", procDefId));
            return false;
        }
        if (state != null && !state.equals(processDefinition.getEnable())) {
            log.debug(String.format("%s state is %s, expected: %s", procDefId, processDefinition.getEnable(), state));
            return false;
        }
        long count = commandContext.getExecutionEntityManager().countExecutionsByProcDefId(procDefId);
        if (count > 0L) {
            log.debug(String.format("%s has running executions.", procDefId));
            return false;
        }
        return true;
    }

    public static boolean hasAdvancedSettingPermission() {
        return PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_processinfo", (String)"1CWJCD1V3PLN");
    }

    public static String getGeneralBatchSetBtnName() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539", (String)"BatchSettingUtil_4", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    public static MultiLangEnumBridge getGeneralBatchSetBtnBridgeName() {
        return new MultiLangEnumBridge("\u6279\u91cf\u4fee\u6539", "BatchSettingUtil_4", "bos-wf-engine");
    }

    public static String getAdvancedBatchSetBtnName() {
        return ResManager.loadKDString((String)"\u5c5e\u6027\u6279\u91cf\u8bbe\u7f6e", (String)"BatchSettingUtil_5", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    public static MultiLangEnumBridge getAdvancedBatchSetBtnBridgeName() {
        return new MultiLangEnumBridge("\u5c5e\u6027\u6279\u91cf\u8bbe\u7f6e", "BatchSettingUtil_5", "bos-wf-engine");
    }

    public static String getInCondition(Collection<Long> values) {
        int index = 0;
        int size = values.size();
        StringBuilder sb = new StringBuilder("(");
        for (Long value : values) {
            sb.append(value);
            if (index < size - 1) {
                sb.append(',');
            }
            ++index;
        }
        sb.append(')');
        return sb.toString();
    }

    static {
        settersMap.put("default", new DefaultSchemePropertiesBatchSetter());
        settersMap.put("custom", new CustomSchemePropertiesBatchSetter());
        conditionTypes.addAll(ConditionalRuleType.getTypes());
    }
}

