/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.management.batchsetting;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.management.scheme.CompareVersionDifferenceCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoDetailEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoDetailEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.IModelModifyLog;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntity;
import kd.bos.workflow.engine.management.batchsetting.AbstractPropertiesBatchSetter;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingProperty;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingUtil;
import kd.bos.workflow.engine.management.batchsetting.IBatchSettingProperties;

public class CustomSchemePropertiesBatchSetter
extends AbstractPropertiesBatchSetter<ProcessInfoDetailEntity> {
    @Override
    public JSONObject getModelDataJSON(String data) {
        JSONObject model = null;
        model = WfUtils.isNotEmpty(data) ? JSON.parseObject((String)data) : new JSONObject();
        return model;
    }

    @Override
    public void updateProcessProperties(CommandContext commandContext, JSONObject model, ProcessInfoEntity info, IBatchSettingProperties batchSetting) {
        ProcessInfoDetailEntityImpl activity = new ProcessInfoDetailEntityImpl();
        activity.setActivityId("node_1");
        activity.setActivityType("Diagram");
        this.updateNodeProperties(model, activity, info, activity.getActivityType(), batchSetting);
    }

    @Override
    public void updateChildrenProperties(JSONObject model, ProcessInfoEntity info, IBatchSettingProperties batchSetting) {
        List<ProcessInfoDetailEntity> activities = info.getActivities();
        for (ProcessInfoDetailEntity activity : activities) {
            this.updateNodeProperties(model, activity, info, activity.getActivityType(), batchSetting);
        }
    }

    @Override
    protected void updateNodeProperties(JSONObject model, ProcessInfoDetailEntity node, List<BatchSettingProperty> settings) {
        JSONObject properties = null;
        if ("Diagram".equals(node.getActivityType())) {
            properties = model.getJSONObject("properties");
            if (properties == null) {
                properties = new JSONObject();
                model.put("properties", (Object)properties);
            }
        } else {
            properties = this.getNodeProperties(model, node);
        }
        this.updatePropertySetting(settings, properties);
    }

    @Override
    protected void updateProperty(JSONObject properties, String prop, Object value) {
        if (BatchSettingUtil.isConditionProperty(value)) {
            this.updateConditionRule(properties, prop, value);
        } else if (value instanceof Map) {
            this.updateMapProperty(properties, prop, value);
        } else if (value instanceof List) {
            this.updateListProperty(properties, prop, value);
        } else {
            super.updateProperty(properties, prop, value);
        }
    }

    private void updateConditionRule(JSONObject properties, String prop, Object value) {
        HashMap<String, Object> condition = new HashMap<String, Object>((Map)value);
        BpmnDiffUtil.markAsIndependent(condition);
        super.updateProperty(properties, prop, condition);
    }

    private void updateMapProperty(JSONObject properties, String prop, Object value) {
        Map map = (Map)value;
        if (map.isEmpty()) {
            return;
        }
        map.put("_action_", "clear-add");
        super.updateProperty(properties, prop, map);
    }

    private void updateListProperty(JSONObject properties, String prop, Object value) {
        List items = (List)value;
        if (items.isEmpty()) {
            return;
        }
        for (Object item : items) {
            if (!(item instanceof Map)) continue;
            Map map = (Map)item;
            map.put("_action_", "clear-add");
        }
        super.updateProperty(properties, prop, items);
    }

    private JSONObject getNodeProperties(JSONObject model, ProcessInfoDetailEntity node) {
        JSONArray childShapes = model.getJSONArray("childShapes");
        if (childShapes == null) {
            childShapes = new JSONArray();
            model.put("childShapes", (Object)childShapes);
            return this.createAndAddChild(childShapes, node.getActivityId());
        }
        JSONObject child = null;
        int size = childShapes.size();
        for (int i = 0; i < size; ++i) {
            child = childShapes.getJSONObject(i);
            String resourceId = child.getString("resourceId");
            if (!resourceId.equals(node.getActivityId())) continue;
            return child.getJSONObject("properties");
        }
        return this.createAndAddChild(childShapes, node.getActivityId());
    }

    private JSONObject createAndAddChild(JSONArray childShapes, String resourceId) {
        JSONObject child = new JSONObject();
        child.put("_inherit_", (Object)true);
        child.put("resourceId", (Object)resourceId);
        JSONObject properties = new JSONObject();
        child.put("properties", (Object)properties);
        childShapes.add((Object)child);
        return properties;
    }

    @Override
    protected List<ModelModifyLogEntity> getModelModifyLogEntities(CommandContext commandContext, IModelModifyLog modifyLog, String before, String after) {
        Long resId = commandContext.getDynamicConfigSchemeEntityManager().getParentSchemeResourceId(modifyLog.getSchemeId());
        ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(resId, "data");
        String data = resource.getData();
        String beforeData = WfUtils.isNotEmpty(before) ? String.valueOf(BpmnDiffUtil.applyPatch(data, before)) : data;
        String afterData = String.valueOf(BpmnDiffUtil.applyPatch(data, after));
        return new CompareVersionDifferenceCmd(afterData, beforeData, modifyLog, new HashSet<String>()).execute(commandContext);
    }
}

