/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.management.batchsetting;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.workflow.engine.impl.cmd.management.scheme.CompareVersionDifferenceCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.IModelModifyLog;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntity;
import kd.bos.workflow.engine.management.batchsetting.AbstractPropertiesBatchSetter;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingProperty;
import kd.bos.workflow.engine.management.batchsetting.IBatchSettingProperties;

public class DefaultSchemePropertiesBatchSetter
extends AbstractPropertiesBatchSetter<JSONObject> {
    @Override
    public JSONObject getModelDataJSON(String data) {
        return JSON.parseObject((String)data);
    }

    @Override
    public void updateProcessProperties(CommandContext commandContext, JSONObject model, ProcessInfoEntity info, IBatchSettingProperties batchSetting) {
        this.updateNodeProperties(model, model, info, "Diagram", batchSetting);
        this.handleSpecialProperties(commandContext, info, batchSetting.getBatchSettingProperties("Diagram"));
    }

    private void handleSpecialProperties(CommandContext commandContext, ProcessInfoEntity info, List<BatchSettingProperty> batchSettingProperties) {
        if (batchSettingProperties == null || batchSettingProperties.isEmpty()) {
            return;
        }
        for (BatchSettingProperty property : batchSettingProperties) {
            if (!"orgUnitId".equals(property.getProperty())) continue;
            this.handleOrgUnitIdProperty(commandContext, info, property.getValue());
            break;
        }
    }

    private void handleOrgUnitIdProperty(CommandContext commandContext, ProcessInfoEntity info, Object value) {
        Long newOrgId = Long.valueOf(value.toString());
        ProcessDefinitionEntityManager procDefManager = commandContext.getProcessDefinitionEntityManager();
        ProcessInfoEntityManager processInfoManager = commandContext.getProcessInfoEntityManager();
        ProcessDefinitionEntity procDef = (ProcessDefinitionEntity)procDefManager.findById(info.getProcdefId());
        procDef.setOrgUnitId(newOrgId);
        procDefManager.update(procDef);
        ProcessInfoEntity processInfo = (ProcessInfoEntity)processInfoManager.findById(info.getId());
        processInfo.setOrgId(newOrgId);
        processInfoManager.update(processInfo);
    }

    @Override
    public void updateChildrenProperties(JSONObject model, ProcessInfoEntity info, IBatchSettingProperties batchSetting) {
        JSONArray children = model.getJSONArray("childShapes");
        int size = children.size();
        JSONObject child = null;
        JSONObject stencil = null;
        for (int i = 0; i < size; ++i) {
            child = children.getJSONObject(i);
            stencil = child.getJSONObject("stencil");
            String type = stencil.getString("id");
            this.updateNodeProperties(model, child, info, type, batchSetting);
        }
    }

    @Override
    protected void updateNodeProperties(JSONObject model, JSONObject node, List<BatchSettingProperty> settings) {
        JSONObject properties = node.getJSONObject("properties");
        this.updatePropertySetting(settings, properties);
    }

    @Override
    protected List<ModelModifyLogEntity> getModelModifyLogEntities(CommandContext commandContext, IModelModifyLog modifyLog, String before, String after) {
        return new CompareVersionDifferenceCmd(after, before, modifyLog, new HashSet<String>()).execute(commandContext);
    }
}

