/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.management.batchsetting.cmd;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.deployer.VersionUtils;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnJsonStringCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnModelCmd;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoDetailEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.DynamicSchemeUtil;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingUtil;
import kd.bos.workflow.engine.management.batchsetting.IBatchSettingProperties;
import kd.bos.workflow.engine.management.batchsetting.IPropertiesBatchSetter;
import kd.bos.workflow.engine.management.batchsetting.task.AbstractBatchSettingTask;

public abstract class AbstractBatchSettingPropertiesCmd
implements IBatchSettingProperties,
Command<Void> {
    protected Log log = LogFactory.getLog(this.getClass());
    protected AbstractBatchSettingTask task;

    public AbstractBatchSettingPropertiesCmd(AbstractBatchSettingTask task) {
        this.task = task;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        List<ProcessInfoEntity> infos = this.getProcessInfoEntities(commandContext);
        int size = infos.size();
        HashSet<Long> defaultSchemeIds = new HashSet<Long>(size);
        HashSet<Long> customSchemeIds = new HashSet<Long>(size);
        ArrayList<Long> customSchemeInfoIds = new ArrayList<Long>(size);
        ArrayList<Long> resIds = new ArrayList<Long>(size);
        for (ProcessInfoEntity info : infos) {
            resIds.add(info.getResourceId());
            if ("custom".equals(info.getSchemeType())) {
                customSchemeInfoIds.add(info.getId());
                customSchemeIds.add(info.getSchemeId());
                continue;
            }
            defaultSchemeIds.add(info.getSchemeId());
        }
        Map<Long, List<ProcessInfoDetailEntity>> activitiesMap = this.findCustomSchemeActivities(commandContext, customSchemeInfoIds);
        Map<Long, ResourceEntity> resMap = this.findResources(commandContext, resIds);
        int count = 0;
        int progress = 0;
        for (ProcessInfoEntity info : infos) {
            this.updateProperties(commandContext, info, resMap, activitiesMap);
            progress = 100 * ++count / size;
            String description = String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u6d41\u7a0b\u5c5e\u6027 %1$s / %2$s", (String)"AbstractBatchSettingPropertiesCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), count, size);
            this.task.updateProgress(progress, description);
        }
        this.clearSchemeCache(commandContext, defaultSchemeIds, customSchemeIds);
        this.task.feedbackResult();
        return null;
    }

    private Map<Long, List<ProcessInfoDetailEntity>> findCustomSchemeActivities(CommandContext commandContext, List<Long> customSchemeInfoIds) {
        if (customSchemeInfoIds.isEmpty()) {
            return new HashMap<Long, List<ProcessInfoDetailEntity>>();
        }
        return commandContext.getProcessInfoEntityManager().findCustomSchemeActivities(customSchemeInfoIds);
    }

    private void clearSchemeCache(CommandContext commandContext, Set<Long> defaultSchemeIds, Set<Long> customSchemeIds) {
        QFilter[] filters;
        DynamicConfigSchemeEntityManager schemeEntityManager = commandContext.getDynamicConfigSchemeEntityManager();
        List entities = schemeEntityManager.findByQueryFilters(filters = new QFilter[]{new QFilter("parentschemeid", "in", defaultSchemeIds)}, "id", null);
        if (entities != null && !entities.isEmpty()) {
            for (DynamicConfigSchemeEntity entity : entities) {
                customSchemeIds.add(entity.getId());
            }
        }
        ArrayList<Long> schemeIds = new ArrayList<Long>(defaultSchemeIds.size() + customSchemeIds.size());
        schemeIds.addAll(defaultSchemeIds);
        schemeIds.addAll(customSchemeIds);
        String fields = String.format("%s,%s,%s,%s", "id", "number", "isdefault", "processdefinitionid");
        List<DynamicConfigSchemeEntity> schemes = schemeEntityManager.findSchemesByIds(fields, schemeIds);
        int count = 0;
        int progress = 0;
        int size = schemeIds.size();
        BpmnModel model = null;
        for (DynamicConfigSchemeEntity scheme : schemes) {
            DynamicSchemeUtil.disposeCache(commandContext, scheme);
            model = new GetConfigSchemeBpmnModelCmd(scheme.getId()).execute(commandContext);
            DynamicSchemeUtil.disposeOperationCache(commandContext, scheme, model);
            String description = String.format(ResManager.loadKDString((String)"\u6e05\u9664\u65b9\u6848\u7f13\u5b58 %1$s / %2$s", (String)"AbstractBatchSettingPropertiesCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), ++count, size);
            progress = 100 * count / size;
            this.task.updateProgress(progress, description);
        }
    }

    private Map<Long, ResourceEntity> findResources(CommandContext commandContext, List<Long> resIds) {
        HashMap<Long, ResourceEntity> resMap = new HashMap<Long, ResourceEntity>(resIds.size());
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        EntityQueryBuilder resQueryBuilder = resourceManager.createQueryBuilder();
        resQueryBuilder.addFilter("id", "in", resIds);
        List resources = resourceManager.findByQueryBuilder(resQueryBuilder);
        for (ResourceEntity resource : resources) {
            resMap.put(resource.getId(), resource);
        }
        return resMap;
    }

    private void updateProperties(CommandContext commandContext, ProcessInfoEntity info, Map<Long, ResourceEntity> resMap, Map<Long, List<ProcessInfoDetailEntity>> activitiesMap) {
        ResourceEntity resource = resMap.get(info.getResourceId());
        String data = resource.getData();
        IPropertiesBatchSetter batchSetter = BatchSettingUtil.getPropertiesBatchSetter(info.getSchemeType());
        JSONObject model = batchSetter.getModelDataJSON(data);
        List<ProcessInfoDetailEntity> customSchemeActivities = activitiesMap.get(info.getId());
        if (customSchemeActivities != null && !customSchemeActivities.isEmpty()) {
            info.getActivities().addAll(customSchemeActivities);
        }
        this.batchSettingModelProperties(commandContext, batchSetter, info, model);
        this.updateResource(commandContext, resource, model, info.getProcdefId());
        this.recordBaseDataRef(commandContext, info, data);
        this.recordLogs(commandContext, batchSetter, info, resource, data);
    }

    private void recordBaseDataRef(CommandContext commandContext, ProcessInfoEntity info, String data) {
        String modelJson = data;
        if ("custom".equals(info.getSchemeType())) {
            modelJson = new GetConfigSchemeBpmnJsonStringCmd(info.getSchemeId(), null).execute(commandContext);
        }
        BpmnModelUtil.recordBaseDataRef(modelJson, info.getProcdefId(), info.getSchemeId());
    }

    private void updateResource(CommandContext commandContext, ResourceEntity resource, JSONObject model, Long procDefId) {
        resource.setData(JSONObject.toJSONString((Object)model, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        ILocaleString content = resource.getContent();
        if (content == null) {
            commandContext.getResourceEntityManager().update(resource);
            return;
        }
        String procName = null;
        String procNumber = null;
        Object multiData = null;
        ProcessDefinitionEntity procdefEntity = null;
        JSONObject properties = model.getJSONObject("properties");
        if (this.isPropertiesHasRequiredProps(properties)) {
            procName = properties.getString("name");
            procNumber = properties.getString("process_id");
        } else {
            procdefEntity = this.getProcessDefinitionEntity(commandContext, procDefId);
            procName = procdefEntity.getName().getLocaleValue();
            procNumber = procdefEntity.getKey();
        }
        String lang = RequestContext.get().getLang().toString();
        String dataStr = (String)content.get((Object)lang);
        if (WfUtils.isNotEmpty(dataStr)) {
            multiData = JSON.parseObject((String)dataStr);
        } else {
            procdefEntity = procdefEntity != null ? procdefEntity : this.getProcessDefinitionEntity(commandContext, procDefId);
            String version = VersionUtils.getNextVersion(procdefEntity.getVersion());
            multiData = ExtractMultiLanguageWordsUtil.getMultiLangResourceTemplate(resource.getId(), procName, procdefEntity.getModelId(), version, lang);
        }
        Map<String, Object> terms = ExtractMultiLanguageWordsUtil.getExtractedMultiLangTerms(model, procNumber);
        multiData.put("data", terms);
        content.put((Object)lang, (Object)JSONObject.toJSONString((Object)multiData));
        commandContext.getResourceEntityManager().update(resource);
    }

    private boolean isPropertiesHasRequiredProps(JSONObject properties) {
        return properties != null && properties.getString("name") != null && properties.getString("process_id") != null;
    }

    private ProcessDefinitionEntity getProcessDefinitionEntity(CommandContext commandContext, Long id) {
        return (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(id, "modelid,version,name,key");
    }

    protected void batchSettingModelProperties(CommandContext commandContext, IPropertiesBatchSetter batchSetter, ProcessInfoEntity info, JSONObject model) {
        this.updateProcessProperties(commandContext, batchSetter, model, info);
        this.updateChildrenProperties(batchSetter, model, info);
    }

    protected void updateProcessProperties(CommandContext commandContext, IPropertiesBatchSetter batchSetter, JSONObject model, ProcessInfoEntity info) {
        batchSetter.updateProcessProperties(commandContext, model, info, this);
    }

    protected void updateChildrenProperties(IPropertiesBatchSetter batchSetter, JSONObject model, ProcessInfoEntity info) {
        batchSetter.updateChildrenProperties(model, info, this);
    }

    private void recordLogs(CommandContext commandContext, IPropertiesBatchSetter batchSetter, ProcessInfoEntity info, ResourceEntity resource, String data) {
        batchSetter.recordBatchSettingLogs(commandContext, info, data, resource.getData());
        WfUtils.addOpLog("wf_processinfo", "batchModify", this.getOperationNameBridge(), new MultiLangEnumBridge("\u6d41\u7a0bID\uff1a%1$s\uff0c\u65b9\u6848ID\uff1a%2$s", "AbstractBatchSettingPropertiesCmd_3", "bos-wf-engine"), info.getProcdefId(), info.getSchemeId());
    }

    protected abstract String getOperationName();

    protected abstract MultiLangEnumBridge getOperationNameBridge();

    protected abstract List<ProcessInfoEntity> getProcessInfoEntities(CommandContext var1);
}

