/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.management.batchsetting.cmd;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoDetailEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntityManager;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingProperty;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingUtil;
import kd.bos.workflow.engine.management.batchsetting.IPropertiesBatchSetter;
import kd.bos.workflow.engine.management.batchsetting.cmd.AbstractBatchSettingPropertiesCmd;
import kd.bos.workflow.engine.management.batchsetting.task.AbstractBatchSettingTask;

public class BatchSettingAdvancedPropertiesCmd
extends AbstractBatchSettingPropertiesCmd {
    private String stencilType;
    private Map<Long, List<Long>> idsMap;
    private List<BatchSettingProperty> properties;

    public BatchSettingAdvancedPropertiesCmd(String stencilType, Map<Long, List<Long>> idsMap, List<BatchSettingProperty> properties, AbstractBatchSettingTask task) {
        super(task);
        this.idsMap = idsMap;
        this.properties = properties;
        this.stencilType = stencilType;
    }

    @Override
    protected List<ProcessInfoEntity> getProcessInfoEntities(CommandContext commandContext) {
        ProcessInfoEntityManager manager = commandContext.getProcessInfoEntityManager();
        Set<Long> keys = this.idsMap.keySet();
        ArrayList<Long> ids = new ArrayList<Long>(keys);
        List<ProcessInfoEntity> infos = manager.findProcessInfoEntities(ids);
        int size = infos.size() * 2;
        ArrayList<Long> detailIds = new ArrayList<Long>(size);
        for (Map.Entry<Long, List<Long>> entry : this.idsMap.entrySet()) {
            List<Long> values = entry.getValue();
            for (Long detailId : values) {
                detailIds.add(detailId);
            }
        }
        HashMap<Long, ProcessInfoEntity> infoMap = new HashMap<Long, ProcessInfoEntity>(infos.size());
        for (ProcessInfoEntity info : infos) {
            infoMap.put(info.getId(), info);
        }
        List<ProcessInfoDetailEntity> list = manager.findFilteredProcessInfoDetailEntities(detailIds);
        for (ProcessInfoDetailEntity detail : list) {
            ((ProcessInfoEntity)infoMap.get(detail.getProcessInfoId())).getFilteredActivityIds().add(detail.getActivityId());
        }
        return infos;
    }

    @Override
    public List<BatchSettingProperty> getBatchSettingProperties(String type) {
        return this.properties;
    }

    @Override
    protected void batchSettingModelProperties(CommandContext commandContext, IPropertiesBatchSetter batchSetter, ProcessInfoEntity info, JSONObject model) {
        if ("Diagram".equals(this.stencilType)) {
            super.updateProcessProperties(commandContext, batchSetter, model, info);
        } else {
            super.updateChildrenProperties(batchSetter, model, info);
            this.updateProcessInfoDetails(commandContext, info);
        }
    }

    private void updateProcessInfoDetails(CommandContext commandContext, ProcessInfoEntity info) {
        for (BatchSettingProperty property : this.properties) {
            if (!"name".equals(property.getProperty())) continue;
            List<String> filtered = info.getFilteredActivityIds();
            info = commandContext.getProcessInfoEntityManager().findProcessInfoWithDetailsBySchemeId(info.getSchemeId());
            List<ProcessInfoDetailEntity> detailList = info.getDetails();
            for (ProcessInfoDetailEntity detail : detailList) {
                if (!filtered.contains(detail.getActivityId())) continue;
                ILocaleString activityName = detail.getActivityName();
                activityName.setLocaleValue(property.getValue().toString());
            }
            commandContext.getProcessInfoEntityManager().update(info);
            break;
        }
    }

    @Override
    public boolean isMatched(Object node, ProcessInfoEntity info) {
        String resourceId = "";
        if (node instanceof JSONObject) {
            resourceId = ((JSONObject)node).getString("resourceId");
        } else if (node instanceof ProcessInfoDetailEntity) {
            resourceId = ((ProcessInfoDetailEntity)node).getActivityId();
        }
        if ("node_1".equals(resourceId)) {
            return true;
        }
        return info.getFilteredActivityIds().contains(resourceId);
    }

    @Override
    protected String getOperationName() {
        return BatchSettingUtil.getAdvancedBatchSetBtnName();
    }

    @Override
    protected MultiLangEnumBridge getOperationNameBridge() {
        return BatchSettingUtil.getAdvancedBatchSetBtnBridgeName();
    }
}

