/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.management.batchsetting.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntity;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingProperty;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingUtil;
import kd.bos.workflow.engine.management.batchsetting.cmd.AbstractBatchSettingPropertiesCmd;
import kd.bos.workflow.engine.management.batchsetting.task.AbstractBatchSettingTask;

public class BatchSettingGeneralPropertiesCmd
extends AbstractBatchSettingPropertiesCmd {
    private List<Long> ids;
    private List<BatchSettingProperty> properties;
    private Map<String, List<BatchSettingProperty>> classifiedMap = new HashMap<String, List<BatchSettingProperty>>();

    public BatchSettingGeneralPropertiesCmd(List<Long> ids, List<BatchSettingProperty> properties, AbstractBatchSettingTask task) {
        super(task);
        this.ids = ids;
        this.properties = properties;
        this.initClassfiedMap();
    }

    private void initClassfiedMap() {
        List<BatchSettingProperty> settings = null;
        for (BatchSettingProperty property : this.properties) {
            Set<String> stencilTypes = property.getStencilTypes();
            for (String stencilType : stencilTypes) {
                settings = this.classifiedMap.get(stencilType);
                if (settings == null) {
                    settings = new ArrayList<BatchSettingProperty>();
                    this.classifiedMap.put(stencilType, settings);
                }
                settings.add(property);
            }
        }
    }

    @Override
    protected List<ProcessInfoEntity> getProcessInfoEntities(CommandContext commandContext) {
        return commandContext.getProcessInfoEntityManager().findProcessInfoEntities(this.ids);
    }

    @Override
    public List<BatchSettingProperty> getBatchSettingProperties(String type) {
        return this.classifiedMap.get(type);
    }

    @Override
    public boolean isMatched(Object child, ProcessInfoEntity info) {
        return true;
    }

    @Override
    protected String getOperationName() {
        return BatchSettingUtil.getGeneralBatchSetBtnName();
    }

    @Override
    protected MultiLangEnumBridge getOperationNameBridge() {
        return BatchSettingUtil.getGeneralBatchSetBtnBridgeName();
    }
}

