/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.management.batchsetting.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ProcessInfoInitializeTask
extends AbstractTask {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void execute(RequestContext ctx, Map<String, Object> params) throws KDException {
        boolean includeOngoing = Boolean.TRUE.equals(params.get("ongoing"));
        String language = String.valueOf(params.get("language"));
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        RepositoryService repositoryService = wfService.getRepositoryService();
        List<Long> procDefIds = wfService.getManagementService().findToBeInitializedProcDefIds(includeOngoing);
        if (procDefIds.isEmpty()) {
            return;
        }
        int progress = 0;
        int failedCount = 0;
        int successCount = 0;
        StringBuilder failedMsg = new StringBuilder();
        int size = procDefIds.size();
        for (int i = 0; i < size; ++i) {
            Long procDefId = procDefIds.get(i);
            LocaleString descLocalStrinfg = ResManager.getLocaleString((String)"\u521d\u59cb\u5316\u6279\u91cf\u8bbe\u7f6e\u6d41\u7a0b\u6570\u636e  %1$s / %2$s", (String)"ProcessInfoInitializeTask_1", (String)"bos-wf-engine");
            String desc = String.format((String)descLocalStrinfg.get((Object)language), i + 1, size);
            progress = 100 * i / size;
            this.feedbackProgress(progress, desc, null);
            if (this.isStop()) {
                this.stop();
            }
            try {
                this.initProcessInfo(wfService, procDefId, language);
                ++successCount;
                continue;
            }
            catch (Exception e) {
                ++failedCount;
                ProcessDefinitionEntity entity = (ProcessDefinitionEntity)repositoryService.findEntityById(procDefId, "wf_processdefinition", "name,key");
                LocaleString failedMsgLocalStrinfg = ResManager.getLocaleString((String)"\u521d\u59cb\u5316\u6d41\u7a0b\u5931\u8d25\uff0c\u6d41\u7a0b\u540d\u79f0\uff1a%1$s\uff0c\u6d41\u7a0b\u7f16\u7801\uff1a%2$s\uff0c\u539f\u56e0\uff1a%3$s\u3002", (String)"ProcessInfoInitializeTask_2", (String)"bos-wf-engine");
                failedMsg.append("  ").append(String.format((String)failedMsgLocalStrinfg.get((Object)language), entity.getName(), entity.getKey(), e.getMessage()));
                this.log.error(String.format("%s %s", procDefId, WfUtils.getExceptionStacktrace(e)));
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("failed", failedCount);
        result.put("successed", successCount);
        result.put("failedMessage", failedMsg.toString());
        this.feedbackCustomdata(result);
    }

    private void initProcessInfo(WorkflowService wfService, Long procDefId, String language) {
        wfService.getManagementService().initProcessInfoByProcDefId(procDefId, language);
    }
}

