/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.management.util;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityImpl;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ConditionalRuleConvertUtil {
    private static final String WF_CONDITIONALRULE = "wf_conditionalrule";
    private static final String ID = "id";
    private static final String SHOWTEXT = "showtext";
    private static final String TYPE = "type";
    private static final String DESCRIPTION = "description";
    private static final String ELEMENTID = "elementid";
    private static final String VERSION = "version";
    private static final String ENTRY = "entryentity";
    private static final String LEFTBRACKET = "leftbracket";
    private static final String PARAMTYPE = "paramtype";
    private static final String PARAM = "param";
    private static final String PARAMNUMBER = "paramnumber";
    private static final String PARAMDATATYPE = "paramdatatype";
    private static final String OPERATION = "operation";
    private static final String VALUE = "value";
    private static final String RIGHTBRACKET = "rightbracket";
    private static final String LOGIC = "logic";
    private static final String VALUETYPE = "valueType";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String EXPRESSION = "expression";
    private static final String PLUGIN = "plugin";

    public static String conditionalRuleToJson(ConditionalRuleEntity conditionalRuleModel) {
        DynamicObject dynamicObject = conditionalRuleModel.getDynamicObject();
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dynamicObject.getDynamicObjectType());
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        jser.setSerializeComplexProperty(true);
        binder.setOnlyDbProperty(false);
        String json = jser.serializeToString((Object)dynamicObject, null);
        return json;
    }

    public static ConditionalRuleEntity jsonToConditionalRuleModel(String json) {
        DynamicObject dataEntity = ConditionalRuleConvertUtil.getDynamicObject(json);
        ConditionalRuleEntity condRuleModel = ConditionalRuleConvertUtil.getCondRuleModel(dataEntity);
        return condRuleModel;
    }

    public static ConditionalRuleEntity jsonConditionalRuleModelWithQuery(String json) {
        DynamicObject dataEntity = ConditionalRuleConvertUtil.getDynamicObject(json);
        ConditionalRuleEntity condRuleModel = ConditionalRuleConvertUtil.getCondRuleModelWithQuery(dataEntity);
        condRuleModel.getDynamicObject();
        return condRuleModel;
    }

    public static ConditionalRuleEntity getCondRuleModel(DynamicObject dynamicObject) {
        ConditionalRuleEntityImpl condRule = new ConditionalRuleEntityImpl();
        ConditionalRuleConvertUtil.packageConfig(dynamicObject, condRule);
        return condRule;
    }

    private static ConditionalRuleEntity getCondRuleModelWithQuery(DynamicObject dynamicObject) {
        ConditionalRuleEntity condRule = WfUtils.isNotEmpty(dynamicObject.getLong(ID)) ? (ConditionalRuleEntity)ConditionalRuleConvertUtil.getRepositoryService().findEntityById(dynamicObject.getLong(ID), WF_CONDITIONALRULE) : new ConditionalRuleEntityImpl();
        ConditionalRuleConvertUtil.packageConfig(dynamicObject, condRule);
        return condRule;
    }

    private static void packageConfig(DynamicObject dynamicObject, ConditionalRuleEntity condRule) {
        if (dynamicObject.get(SHOWTEXT) != null) {
            condRule.setShowtext((ILocaleString)dynamicObject.get(SHOWTEXT));
        }
        if (dynamicObject.get(TYPE) != null) {
            condRule.setType(dynamicObject.get(TYPE).toString());
        }
        if (dynamicObject.get(DESCRIPTION) != null) {
            condRule.setDescription((ILocaleString)dynamicObject.get(DESCRIPTION));
        }
        if (dynamicObject.get(ELEMENTID) != null) {
            condRule.setElementid(dynamicObject.get(ELEMENTID).toString());
        }
        if (dynamicObject.get(VERSION) != null) {
            condRule.setVersion(dynamicObject.get(VERSION).toString());
        }
        condRule.setId(dynamicObject.getLong(ID));
        condRule.setProcdefid(dynamicObject.getLong("procdefid"));
        condRule.setValidtime(dynamicObject.getDate("validtime"));
        String expression = null;
        if (dynamicObject.get(EXPRESSION) == null || !WfUtils.isNotEmpty(expression = dynamicObject.get(EXPRESSION).toString())) {
            if (dynamicObject.get(PLUGIN) != null) {
                condRule.setPlugin(dynamicObject.get(PLUGIN).toString());
            }
            return;
        }
        condRule.setExpression(expression);
        if (dynamicObject.get("property") != null) {
            condRule.setProperty(dynamicObject.get("property").toString());
        }
        ArrayList<ConditionalEntity> conditionals = new ArrayList<ConditionalEntity>();
        DynamicObjectCollection entity = dynamicObject.getDynamicObjectCollection(ENTRY);
        if (!entity.isEmpty()) {
            String id = null;
            String value = null;
            for (DynamicObject dynObj : entity) {
                id = dynObj.getString(ID);
                value = dynObj.getString(VALUE);
                if (id != null && WfUtils.isNotEmpty(id)) {
                    conditionals.add(new ConditionalEntityImpl(id, condRule.getId(), dynObj.getString(LEFTBRACKET), dynObj.getString(PARAMNUMBER), dynObj.getString(OPERATION), value, dynObj.getString(RIGHTBRACKET), dynObj.getString(LOGIC), dynObj.getString(VALUETYPE), dynObj.getString(ENTITYNUMBER), dynObj.getInt("seq")));
                    continue;
                }
                conditionals.add(new ConditionalEntityImpl(condRule.getId(), dynObj.getString(LEFTBRACKET), dynObj.getString(PARAMNUMBER), dynObj.getString(OPERATION), value, dynObj.getString(RIGHTBRACKET), dynObj.getString(LOGIC), dynObj.getString(VALUETYPE), dynObj.getString(ENTITYNUMBER), dynObj.getInt("seq")));
            }
        }
        condRule.setEntryentity(conditionals);
    }

    private static DynamicObject getDynamicObject(String json) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)WF_CONDITIONALRULE);
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)mainEntityType);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        DynamicObject dataEntity = (DynamicObject)jser.deserializeFromString(json, null);
        return dataEntity;
    }

    private static RepositoryService getRepositoryService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRepositoryService();
    }
}

