/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.ReflectUtil;
import kd.bos.workflow.engine.msg.AbstractMessageServiceHandler;
import kd.bos.workflow.engine.msg.MessageService;
import kd.bos.workflow.engine.msg.MessageServiceConfig;
import kd.bos.workflow.engine.msg.MessageTemplateCalculate;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.cmd.CoordinateRecordToDoCmd;
import kd.bos.workflow.engine.msg.cmd.CreateToDoCmd;
import kd.bos.workflow.engine.msg.cmd.DealMessageCmd;
import kd.bos.workflow.engine.msg.cmd.DealToDoCmd;
import kd.bos.workflow.engine.msg.cmd.DeleteDealToDoAndCreateToDoCmd;
import kd.bos.workflow.engine.msg.cmd.DeleteToDoCmd;
import kd.bos.workflow.engine.msg.cmd.NoCodeSendTextMessageForNodeCmd;
import kd.bos.workflow.engine.msg.cmd.SendMessageCmd;
import kd.bos.workflow.engine.msg.cmd.SendTextMessageForNodeCmd;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.task.TaskInfo;

public class MessageServiceImpl
implements MessageService {
    private static Log logger = LogFactory.getLog(MessageServiceImpl.class);
    public static final String SYSTEMPUBACC = "systempubacc";
    public static final String PUBACCNUMBER = "pubaccnumber";
    private final Map<String, AbstractMessageServiceHandler> services = new HashMap<String, AbstractMessageServiceHandler>();
    private final boolean DEFAULT_ASYNC = true;
    private String accountId;
    private List<MessageServiceConfig> messageServiceConfigs;
    private ProcessEngineConfigurationImpl processEngineConfiguration = null;
    private String hashTag;
    private Map<String, String> cacheConfigValue = new HashMap<String, String>();

    public MessageServiceImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public MessageServiceImpl(ProcessEngineConfigurationImpl processEngineConfigurationImpl, String accountId) {
        this.accountId = accountId;
        this.processEngineConfiguration = processEngineConfigurationImpl;
    }

    public void initMessageServiceConfig() {
        if (this.messageServiceConfigs == null) {
            this.messageServiceConfigs = new ArrayList<MessageServiceConfig>();
        }
        try {
            DynamicObject[] objs;
            this.messageServiceConfigs.clear();
            for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)"msg_channel", (String)"id,enable,number,name,serviceclass,mobileappconfig,createDate,modifyDate", null)) {
                boolean avaliable = obj.getBoolean("enable");
                if (!avaliable || "sysnotice".equals(obj.get("number"))) continue;
                MessageServiceConfig config = new MessageServiceConfig();
                config.setAvaliable(avaliable);
                config.setId(obj.get("id").toString());
                config.setMessageServiceName(obj.getLocaleString("name"));
                config.setServiceKey(obj.getString("number"));
                config.setServiceClass(obj.getString("serviceclass"));
                config.setMobileappconfig(obj.getString("mobileappconfig"));
                this.messageServiceConfigs.add(config);
            }
            this.hashTag = WfCacheHelper.getMsgConfig();
            WfCacheHelper.removeDefaultNotifyType("message");
            WfCacheHelper.removeDefaultNotifyType("task");
            WfCacheHelper.removeDefaultNotifyType("alarm");
            WfCacheHelper.removeDefaultNotifyType("warning");
            this.cacheConfigValue.clear();
        }
        catch (Exception e) {
            logger.error(String.format("\u83b7\u53d6\u6d88\u606f\u670d\u52a1\u914d\u7f6e\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a%s", e.getMessage()));
        }
    }

    @Override
    public void init() {
        this.initMessageServiceConfig();
        for (MessageServiceConfig config : this.messageServiceConfigs) {
            this.register(config);
        }
    }

    @Override
    public List<MessageServiceConfig> getMessageServiceConfigs() {
        return this.messageServiceConfigs;
    }

    private void register(MessageServiceConfig config) {
        if (!config.isAvaliable()) {
            logger.warn(String.format("\u6d88\u606f\u670d\u52a1\u914d\u7f6e\u4e3a\u4e0d\u53ef\u7528\uff0c\u65e0\u9700\u6ce8\u518c\u8be5\u670d\u52a1\u3002\u5177\u4f53\u914d\u7f6e\u4fe1\u606f\u5982\u4e0b\uff1a%s", config));
            return;
        }
        String serviceKey = config.getServiceKey();
        String serviceClass = config.getServiceClass();
        if (WfUtils.isEmpty(serviceKey) || WfUtils.isEmpty(serviceClass)) {
            logger.warn(String.format("\u6d88\u606f\u670d\u52a1\u6ce8\u518c\u5931\u8d25\uff0cserviceKey\u6216serviceClass\u672a\u627e\u5230\uff0c\u5177\u4f53\u914d\u7f6e\u4fe1\u606f\u5982\u4e0b\uff1a%s", config));
            return;
        }
        try {
            AbstractMessageServiceHandler serviceHandler = (AbstractMessageServiceHandler)ReflectUtil.instantiate(serviceClass);
            serviceHandler.setConfig(config);
            this.services.put(serviceKey, serviceHandler);
        }
        catch (Exception e) {
            logger.warn(String.format("\u6d88\u606f\u670d\u52a1\u6ce8\u518c\u5931\u8d25\uff0c\u5b9e\u4f8b\u5316\u6d88\u606f\u670d\u52a1\u5904\u7406\u5668\u53d1\u751f\u5f02\u5e38\uff0c\u5177\u4f53\u914d\u7f6e\u4fe1\u606f\u5982\u4e0b\uff1a%1$s \n\u5177\u4f53\u7684\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a%2$s", config, e.getMessage()));
        }
    }

    @Override
    public void createToDo(Long taskId) {
        if (WfUtils.isTesting()) {
            return;
        }
        new CreateToDoCmd(taskId, null, true).execute(Context.getCommandContext());
    }

    @Override
    public void createToDo(Long taskId, List<Long> userIds) {
        if (WfUtils.isTesting()) {
            return;
        }
        new CreateToDoCmd(taskId, null, true, null, userIds).execute(Context.getCommandContext());
    }

    @Override
    public void createTransferToDo(Long taskId) {
        if (WfUtils.isTesting()) {
            return;
        }
        new CreateToDoCmd(taskId, null, true, MessageTypeEnum.TRANSFER.getNumber()).execute(Context.getCommandContext());
    }

    @Override
    public void createTransferToDo(Long taskId, List<Long> userIds) {
        if (WfUtils.isTesting()) {
            return;
        }
        new CreateToDoCmd(taskId, null, true, MessageTypeEnum.TRANSFER.getNumber(), userIds).execute(Context.getCommandContext());
    }

    @Override
    public void createWithdrawTransferToDo(Long taskId, List<Long> userIds) {
        if (WfUtils.isTesting()) {
            return;
        }
        new CreateToDoCmd(taskId, null, true, "withdrawTansferTask", userIds).execute(Context.getCommandContext());
    }

    @Override
    public void createCoordinateToDo(Long taskId, List<Long> userIds) {
        if (WfUtils.isTesting()) {
            return;
        }
        new CreateToDoCmd(taskId, null, true, MessageTypeEnum.COORDINATE.getNumber(), userIds).execute(Context.getCommandContext());
    }

    @Override
    public void createToDo(TaskEntity task) {
        if (WfUtils.isTesting()) {
            return;
        }
        new CreateToDoCmd(null, task, true).execute(Context.getCommandContext());
    }

    @Override
    public void dealCoordinateRecordToDo(Long taskId, List<Long> userIds) {
        if (WfUtils.isTesting()) {
            return;
        }
        new CoordinateRecordToDoCmd(taskId, userIds, true, true).execute(Context.getCommandContext());
    }

    @Override
    public void deleteToDo(Long taskId, List<Long> userIds) {
        if (WfUtils.isTesting()) {
            return;
        }
        new DeleteToDoCmd(taskId, userIds, true, true).execute(Context.getCommandContext());
    }

    @Override
    public void deleteToDo(Long taskId, List<Long> userIds, boolean async, boolean check) {
        if (WfUtils.isTesting()) {
            return;
        }
        new DeleteToDoCmd(taskId, userIds, async, check).execute(Context.getCommandContext());
    }

    @Override
    public void deleteToDo(Long taskId, List<Long> userIds, boolean check) {
        if (WfUtils.isTesting()) {
            return;
        }
        new DeleteToDoCmd(taskId, userIds, true, check).execute(Context.getCommandContext());
    }

    @Override
    public void dealToDo(TaskInfo task, Long userId, boolean async, boolean check) {
        if (WfUtils.isTesting()) {
            return;
        }
        new DealToDoCmd(task, userId, async, check).execute(Context.getCommandContext());
    }

    @Override
    public void dealToDo(TaskInfo task, Long userId, boolean async, boolean check, boolean onlySync) {
        if (WfUtils.isTesting()) {
            return;
        }
        new DealToDoCmd(task, userId, async, check, onlySync).execute(Context.getCommandContext());
    }

    @Override
    public void dealToDo(TaskInfo task, Long userId, boolean async) {
        if (WfUtils.isTesting()) {
            return;
        }
        new DealToDoCmd(task, userId, async, true).execute(Context.getCommandContext());
    }

    @Override
    public void batchDealToDo(List<TaskEntity> tasks, Long userId, boolean async) {
        if (WfUtils.isTesting()) {
            return;
        }
        new DealToDoCmd(tasks, userId, async, true).execute(Context.getCommandContext());
    }

    @Override
    public void deleteDealToDoAndCreateToDo(Long taskId) {
        if (WfUtils.isTesting()) {
            return;
        }
        this.processEngineConfiguration.getCommandExecutor().execute(new DeleteDealToDoAndCreateToDoCmd(taskId, true));
    }

    @Override
    public void sendMessage(MessageContext ctx, MessageInfo msg) {
        if (WfUtils.isTesting()) {
            return;
        }
        new SendMessageCmd(ctx, msg, true).execute(Context.getCommandContext());
    }

    public Map<String, AbstractMessageServiceHandler> getServcies() {
        return this.services;
    }

    public AbstractMessageServiceHandler getService(String key) {
        return this.services.get(key);
    }

    @Override
    public void sendMessageForNode(DelegateExecution execution, String activityId, List<MessageSendModel> ret, String sentevtOut) {
        if (WfUtils.isTesting()) {
            return;
        }
        if (execution instanceof ExecutionEntity && ModelType.NoCodeFlow.name().equals(((ExecutionEntity)execution).getProcessType())) {
            new NoCodeSendTextMessageForNodeCmd(execution, activityId, ret, sentevtOut, true).execute(Context.getCommandContext());
        } else {
            new SendTextMessageForNodeCmd(execution, activityId, ret, sentevtOut, true).execute(Context.getCommandContext());
        }
    }

    @Override
    public void sendMessageForNode(TaskEntity taskEntity, String taskModelNumber, List<MessageSendModel> ret, String eventName) {
        if (WfUtils.isTesting()) {
            return;
        }
        new SendTextMessageForNodeCmd(taskEntity, taskModelNumber, ret, eventName, true).execute(Context.getCommandContext());
    }

    public String getAccountId() {
        return this.accountId;
    }

    @Override
    public String getDefaultNotifyType(String type) {
        String channelsOfType = MessageServiceHelper.getChannelsByMsgTypeNum((String)type);
        return channelsOfType;
    }

    @Override
    public String getHashTag() {
        return this.hashTag;
    }

    @Override
    public String getCacheConfigValue(String type, String configName, String pubaccNumber, String entityNumber) {
        String key = String.format("%s%s%s", type, pubaccNumber = pubaccNumber == null || StringUtils.isBlank((CharSequence)pubaccNumber.trim()) ? SYSTEMPUBACC : pubaccNumber, configName);
        String value = this.cacheConfigValue.get(key);
        if (WfUtils.isEmpty(value) && this.messageServiceConfigs != null && this.messageServiceConfigs.size() > 0) {
            for (MessageServiceConfig config : this.messageServiceConfigs) {
                String mobileappconfig;
                if (!config.getServiceKey().equalsIgnoreCase(type) || !StringUtils.isNotEmpty((CharSequence)(mobileappconfig = config.getMobileappconfig()))) continue;
                JSONArray configArray = JSONArray.parseArray((String)mobileappconfig);
                String targetKey = null;
                JSONObject targetConfigObject = null;
                JSONObject systemConfigObject = null;
                if (StringUtils.isNotBlank((CharSequence)pubaccNumber)) {
                    targetKey = pubaccNumber;
                } else {
                    targetKey = MetadataServiceHelper.getDataEntityType((String)entityNumber).getAppId();
                    if (StringUtils.isBlank((CharSequence)targetKey)) {
                        targetKey = SYSTEMPUBACC;
                    }
                }
                for (int i = 0; i < configArray.size(); ++i) {
                    JSONObject configObject = configArray.getJSONObject(i);
                    if (targetKey.equalsIgnoreCase(configObject.getString(PUBACCNUMBER))) {
                        targetConfigObject = configObject;
                    }
                    if (!SYSTEMPUBACC.equalsIgnoreCase(configObject.getString(PUBACCNUMBER))) continue;
                    systemConfigObject = configObject;
                }
                if (targetConfigObject == null) {
                    targetConfigObject = systemConfigObject;
                }
                if (targetConfigObject != null) {
                    value = targetConfigObject.getString(configName);
                    Set keys = targetConfigObject.keySet();
                    for (String tmp : keys) {
                        String tempKey = String.format("%s%s%s", type, pubaccNumber, tmp);
                        this.cacheConfigValue.put(tempKey, targetConfigObject.getString(tmp));
                    }
                } else {
                    logger.debug("targetConfigObject is null!");
                }
                this.cacheConfigValue.put(key, value);
            }
        }
        value = value == null ? "" : value;
        return value;
    }

    @Override
    public void deleteProcessIntacne(Long processInstId) {
        ExecutionEntity processInstance = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById(processInstId);
        if (processInstance != null) {
            MessageContext ctx = new MessageContext();
            ctx.setProcessInstanceId(processInstId);
            ctx.setBusinessKey(processInstance.getBusinessKey());
            ctx.setEntityNumber(processInstance.getEntityNumber());
            ctx.setStartUserId(processInstance.getStartUserId());
            ctx.setBillNo(processInstance.getBillNo());
            String notify = MessageServiceHelper.getChannelsByMsgTypeNum((String)"task");
            if (StringUtils.isNotBlank((CharSequence)notify)) {
                String[] notifyArr = notify.split(",");
                for (int i = 0; i < notifyArr.length; ++i) {
                    AbstractMessageServiceHandler service;
                    String channel = notifyArr[i];
                    if (!WfUtils.isNotEmpty(channel) || (service = this.getService(channel)) == null) continue;
                    service.deleteProcessInstance(ctx, processInstId);
                }
            }
        }
    }

    @Override
    public void sendProcessInstanceAsync(Long processInstId, String processInstState) {
        String[] notifies;
        List<StartEvent> startEvents;
        if (WfUtils.isEmpty(processInstId)) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntity processInstance = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(processInstId);
        if (ProcessType.BizFlow.name().equals(processInstance.getProcessType())) {
            return;
        }
        String elementId = "";
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processInstance.getProcessDefinitionId(), processInstId);
        if (bpmnModel != null && (startEvents = bpmnModel.getMainProcess().findFlowElementsOfType(StartEvent.class)) != null && !startEvents.isEmpty()) {
            StartEvent startEvent = startEvents.get(0);
            elementId = startEvent.getId();
        }
        MessageContext ctx = new MessageContext();
        ctx.setElementId(elementId);
        ctx.setProcessInstanceId(processInstId);
        ctx.setProcessDefinitionId(processInstance.getProcessDefinitionId());
        ctx.setBusinessKey(processInstance.getBusinessKey());
        ctx.setEntityNumber(processInstance.getEntityNumber());
        ctx.setExecutionId(processInstance.getId());
        ctx.setCreateDate(processInstance.getCreateDate());
        ctx.setStartUserId(processInstance.getStartUserId());
        ctx.setEntityName(processInstance.getEntraBillName().getLocaleValue());
        ctx.setBillNo(processInstance.getBillNo());
        ctx.getParams().put("processInstState", processInstState);
        ToDoInfo model = new ToDoInfo();
        switch (processInstState) {
            case "start": {
                model.setState(ToDoInfo.State.START);
                break;
            }
            case "processrestart": {
                model.setState(ToDoInfo.State.PROCESSRESTART);
                break;
            }
            case "terminate": {
                model.setState(ToDoInfo.State.TERMINATE);
                break;
            }
            case "end": {
                model.setState(ToDoInfo.State.COMPLETE);
                break;
            }
            default: {
                model.setState(ToDoInfo.State.COMPLETE);
            }
        }
        String notify = MessageServiceHelper.getChannelsByMsgTypeNum((String)"task");
        if (WfUtils.isEmpty(notify)) {
            return;
        }
        for (String channel : notifies = notify.split(",")) {
            if (!WfUtils.isNotEmpty(channel)) continue;
            JobEntity job = commandContext.getJobManager().createToDoJob(ctx, model, channel);
            commandContext.getJobManager().scheduleAsyncJob(job);
        }
    }

    @Override
    public void createCoordinateToDo(Long taskId, List<Long> userIds, LocaleString taskSubject) {
        new CreateToDoCmd(taskId, null, true, MessageTypeEnum.COORDINATE.getNumber(), userIds, taskSubject).execute(Context.getCommandContext());
    }

    @Override
    public ILocaleString calcMessageTemplate(DynamicObject entityObject, Map<String, String> messageTemplate) {
        if (entityObject == null || messageTemplate.isEmpty()) {
            return null;
        }
        return MessageTemplateCalculate.calcMessageTemplate(entityObject, messageTemplate);
    }

    @Override
    public void dealMessage(List<Long> messageIds, String channel, Long userId, Boolean isResend) {
        new DealMessageCmd(messageIds, channel, userId, isResend).execute(Context.getCommandContext());
    }
}

