/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.RevProxyUtil;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.BillPagePluginUtil;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.msg.MessageService;
import kd.bos.workflow.engine.msg.MessageServiceConfig;
import kd.bos.workflow.engine.msg.MessageTemplateCalculate;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.ITaskMsg;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaCommonUtil;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public final class MessageServiceUtil {
    private static Log logger = LogFactory.getLog(MessageServiceUtil.class);
    public static final String FLOWASSISTS = "flowassist";
    public static final String PCAPTION = "pCaption";
    public static final String MCAPTION = "mCaption";
    public static final String EMAILTITLE = "emailTitle";
    public static final String EMAILCONTENT = "emailContent";
    private static final String BUILDWEBPAGEURLPART = "buildWebPageUrl:";
    private static final String MESSAGESERVICEUTIL1 = "MessageServiceUtil_1";
    private static final String MSGDOMAIN = "msgDomain";

    private MessageServiceUtil() {
    }

    public static String buildWebPageUrl(String formId, String mobileFormId, Long activityId, String businessKey, Boolean isUserTask, Long taskId, String taskType, String pCaption, String mCaption) {
        if (!isUserTask.booleanValue()) {
            formId = MessageServiceUtil.getRealProcessingPage(formId);
            mobileFormId = MessageServiceUtil.getRealProcessingMobilePage(mobileFormId);
        }
        if ("botp_convertop".equals(formId)) {
            formId = "wf_approvalpage_bac";
        }
        String clientUrl = UrlService.getDomainContextUrl();
        StringBuilder urlWithEncodedParams = new StringBuilder(clientUrl);
        if (!clientUrl.trim().endsWith("/")) {
            urlWithEncodedParams.append('/');
        }
        urlWithEncodedParams.append("integration/yzjShareOpen.do?").append("formId=").append(YunzhijiaCommonUtil.encode(formId)).append("&mb_formId=").append(YunzhijiaCommonUtil.encode(mobileFormId)).append("&pkId=").append(YunzhijiaCommonUtil.encode(businessKey)).append("&src=").append(YunzhijiaCommonUtil.encode("wf")).append("&accountId=").append(RequestContext.get().getAccountId());
        if (activityId != null && WfUtils.isNotEmpty(activityId)) {
            urlWithEncodedParams.append("&activityId=").append(YunzhijiaCommonUtil.encode(activityId.toString()));
        } else {
            if (taskId != null) {
                urlWithEncodedParams.append("&taskId=").append(YunzhijiaCommonUtil.encode(taskId.toString()));
            }
            if (taskType != null) {
                urlWithEncodedParams.append("&type=").append(YunzhijiaCommonUtil.encode(taskType));
            }
        }
        if (WfUtils.isNotEmpty(taskId)) {
            urlWithEncodedParams.append("&tId=").append(taskId);
        }
        String url = urlWithEncodedParams.toString();
        logger.debug(BUILDWEBPAGEURLPART + url);
        return url;
    }

    public static String buildWebPageUrl(String formId, String mobileFormId, String businessKey, Boolean isUserTask, String pCaption, String mCaption, Long processInstanceId) {
        StringBuilder urlWithEncodedParams = MessageServiceUtil.getBaseWebPageUrl(formId, mobileFormId, businessKey, isUserTask, pCaption, mCaption);
        urlWithEncodedParams.append("&processInstanceId=").append(processInstanceId);
        String url = urlWithEncodedParams.toString();
        logger.debug(BUILDWEBPAGEURLPART + url);
        return url;
    }

    private static StringBuilder getBaseWebPageUrl(String formId, String mobileFormId, String businessKey, Boolean isUserTask, String pCaption, String mCaption) {
        if (!isUserTask.booleanValue()) {
            formId = MessageServiceUtil.getRealProcessingPage(formId);
            mobileFormId = MessageServiceUtil.getRealProcessingMobilePage(mobileFormId);
        }
        String clientUrl = UrlService.getDomainContextUrl();
        StringBuilder urlWithEncodedParams = new StringBuilder(clientUrl);
        if (!clientUrl.trim().endsWith("/")) {
            urlWithEncodedParams.append('/');
        }
        urlWithEncodedParams.append("integration/yzjShareOpen.do?").append("formId=").append(YunzhijiaCommonUtil.encode(formId)).append("&mb_formId=").append(YunzhijiaCommonUtil.encode(mobileFormId)).append("&pkId=").append(YunzhijiaCommonUtil.encode(businessKey)).append("&src=").append(YunzhijiaCommonUtil.encode("wf")).append("&accountId=").append(RequestContext.get().getAccountId());
        return urlWithEncodedParams;
    }

    public static String buildWebPageUrl(String formId, String mobileFormId, Long activityId, String businessKey, Boolean isUserTask, String pCaption, String mCaption) {
        return MessageServiceUtil.buildWebPageUrl(formId, mobileFormId, activityId, businessKey, isUserTask, null, null, pCaption, mCaption);
    }

    public static String buildWebPageUrlForTaskEntity(TaskEntity task) {
        HistoricActivityInstanceEntity activityEntity = Context.getCommandContext().getWithdrawHistActInst(String.valueOf(task.getId()));
        Long activityId = 0L;
        activityId = activityEntity == null ? Context.getCommandContext().getHistoricActivityInstanceEntityManager().findActivityIdByTask(task.getId()) : activityEntity.getId();
        String webPageUrl = MessageServiceUtil.getWebPageUrl(task, activityId);
        if (task.isBizTask()) {
            StringBuilder url = new StringBuilder();
            String[] urls = webPageUrl.split("&");
            List urlParts = Arrays.stream(urls).filter(u -> !u.startsWith("tId=") && !u.startsWith("mb_formId=")).collect(Collectors.toList());
            urlParts.stream().forEach(up -> url.append((String)up).append("&"));
            url.append("bizTask=true");
            webPageUrl = url.toString();
        }
        return webPageUrl;
    }

    public static String buildWebPageUrlForMyInitiation(Long processInstanceId) {
        String url = null;
        HistoricTaskInstanceEntity task = Context.getCommandContext().getHistoricTaskInstanceEntityManager().findEntityForMyInitiation(processInstanceId);
        if (null != task) {
            String pCatpion = MessageServiceUtil.getPCCaption(task);
            String mCatpion = MessageServiceUtil.getMBCaption(task);
            url = MessageServiceUtil.buildWebPageUrl(task.getProcessingPage(), "wf_approvalpagemobile_bac", task.getBusinessKey(), BpmnModelUtil.instanceofUserTaskOnly(task.getCategory()), pCatpion, mCatpion, processInstanceId);
        }
        logger.debug(BUILDWEBPAGEURLPART + url);
        return url;
    }

    public static String buildWebPageUrlForMyApplyed(Long processInstanceId) {
        HistoricProcessInstanceEntity entity;
        CommandContext commandContext = Context.getCommandContext();
        if (WfUtils.isNullObject(commandContext)) {
            WorkflowService service = (WorkflowService)ServiceFactory.getService((String)"WorkflowService");
            entity = service.getHistoryService().getHistoricProcessInstance(processInstanceId);
        } else {
            entity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(processInstanceId);
        }
        return MessageServiceUtil.buildWebPageUrlForMyApplyed(entity);
    }

    public static String buildWebPageUrlForMyApplyed(HistoricProcessInstanceEntity entity) {
        if (null == entity) {
            return null;
        }
        TaskEntityImpl taskEntity = new TaskEntityImpl();
        taskEntity.setEntityName(entity.getEntraBillName());
        taskEntity.setStartName(entity.getStartName());
        String formIdForPc = MessageServiceUtil.getViewFormId(null, true);
        String formIdForMob = MessageServiceUtil.getViewFormId(null, false);
        String businessKey = entity.getBusinessKey();
        String pCatpion = MessageServiceUtil.getPCCaption(taskEntity);
        String mCatpion = MessageServiceUtil.getMBCaption(taskEntity);
        String url = MessageServiceUtil.buildWebPageUrl(formIdForPc, formIdForMob, businessKey, false, pCatpion, mCatpion, entity.getId()) + "&type=dynApply";
        logger.debug(BUILDWEBPAGEURLPART + url);
        return url;
    }

    public static String buildDealToDoUrlForTaskEntity(TaskEntity task, Long actId) {
        HistoricActivityInstanceEntity activityEntity = Context.getCommandContext().getWithdrawHistActInst(String.valueOf(task.getId()));
        Long activityId = 0L;
        if (activityEntity != null) {
            activityId = activityEntity.getId();
        } else if (WfUtils.isNotEmpty(actId)) {
            activityId = actId;
        } else {
            QFilter[] filters = new QFilter[]{new QFilter("taskId", "=", (Object)task.getId())};
            DynamicObject entity = QueryServiceHelper.queryOne((String)"wf_hiactinst", (String)"id", (QFilter[])filters);
            if (entity != null) {
                activityId = entity.getLong("id");
            }
        }
        return MessageServiceUtil.getWebPageUrl(task, activityId);
    }

    private static String getWebPageUrl(TaskEntity task, Long activityId) {
        String pCatpion = MessageServiceUtil.getPCCaption(task);
        String mCatpion = MessageServiceUtil.getMBCaption(task);
        String url = MessageServiceUtil.buildWebPageUrl(task.getProcessingPage(), task.getProcessingMobilePage(), activityId, task.getBusinessKey(), BpmnModelUtil.instanceofUserTaskOnly(task.getCategory()), task.getId(), null, pCatpion, mCatpion);
        logger.debug(BUILDWEBPAGEURLPART + url);
        return url;
    }

    public static String getMBCaption(TaskInfo task) {
        return task.getEntityName() == null ? "" : task.getEntityName().getLocaleValue();
    }

    public static ILocaleString getMBCaptionLocale(TaskInfo task) {
        return task.getEntityName() == null ? WfUtils.getMultiLangValue("") : task.getEntityName();
    }

    public static String getMBCaption(String entityName) {
        return entityName;
    }

    public static String getPCCaption(TaskInfo task) {
        ILocaleString entityNameLocal = task.getEntityName();
        String entityName = WfUtils.isNotEmptyString(entityNameLocal) ? entityNameLocal.getLocaleValue() : "";
        String bizApplier = task.getStartName().getLocaleValue();
        return (WfUtils.isNotEmptyString(bizApplier) ? String.format(ResManager.loadKDString((String)"%s\u7684", (String)"MessageServiceUtil_4", (String)"bos-wf-engine", (Object[])new Object[0]), bizApplier) : "") + entityName;
    }

    public static ILocaleString getPCCaptionLocale(TaskInfo task) {
        ILocaleString entityNameLocal = task.getEntityName();
        ILocaleString entityName = WfUtils.isNotEmptyString(entityNameLocal) ? entityNameLocal : WfUtils.getMultiLangValue("");
        ILocaleString bizApplier = task.getStartName();
        return WfMultiLangUtils.getMultiLangValueCaption(bizApplier, entityName);
    }

    public static String getPCCaption(String startName, String entityName) {
        return String.format(ResManager.loadKDString((String)"%s\u7684", (String)"MessageServiceUtil_4", (String)"bos-wf-engine", (Object[])new Object[0]), startName) + entityName;
    }

    public static String buildWebPageForTaskUrl(String formId, String mobileFormId, Long taskId, String taskType, String businessKey, Boolean isUserTask, String pCaption, String mCaption) {
        return MessageServiceUtil.buildWebPageUrl(formId, mobileFormId, null, businessKey, isUserTask, taskId, taskType, pCaption, mCaption);
    }

    public static String buildWebPageForTaskEntity(TaskEntity task, String taskType) {
        return MessageServiceUtil.buildWebPage(task, task.getProcessingPage(), task.getProcessingMobilePage(), taskType);
    }

    public static String buildWebPageForTaskEntityAndCirculation(TaskEntity task, String taskType) {
        return MessageServiceUtil.buildWebPageForTaskEntityAndCirculation(task);
    }

    public static String buildWebPageForTaskInfoAndCirculation(TaskInfo task) {
        if (null == task) {
            return "";
        }
        String formIdForPc = MessageServiceUtil.getViewFormId(task, true);
        String formIdForMob = MessageServiceUtil.getViewFormId(task, false);
        String pCaption = SerializationUtils.toJsonString((Object)MessageServiceUtil.getPCCaptionLocale(task));
        String mCaption = SerializationUtils.toJsonString((Object)MessageServiceUtil.getMBCaptionLocale(task));
        Long activityId = null;
        HistoricActivityInstanceEntity activityEntity = Context.getCommandContext().getHistoricActivityInstanceEntityManager().findActivityByTaskId(task.getId());
        if (null != activityEntity) {
            activityId = activityEntity.getId();
        }
        if (WfUtils.isEmpty(activityId)) {
            return MessageServiceUtil.buildWebPageForTaskUrl(formIdForPc, formIdForMob, task.getId(), "circulation", task.getBusinessKey(), BpmnModelUtil.instanceofUserTaskOnly(task.getCategory()), pCaption, mCaption);
        }
        boolean isUserTask = UserTask.class.equals(task.getClass());
        String businessKey = task.getBusinessKey();
        return MessageServiceUtil.buildWebPageUrl(formIdForPc, formIdForMob, activityId, businessKey, isUserTask, pCaption, mCaption);
    }

    public static String buildWebPageForTaskEntityAndCirculation(TaskEntity task) {
        return MessageServiceUtil.buildWebPageForTaskInfoAndCirculation(task);
    }

    private static String buildWebPage(TaskEntity task, String processingPage, String processingMobilePage, String taskType) {
        String pCatpion = MessageServiceUtil.getPCCaption(task);
        String mCatpion = MessageServiceUtil.getMBCaption(task);
        return MessageServiceUtil.buildWebPageForTaskUrl(processingPage, processingMobilePage, task.getId(), taskType, task.getBusinessKey(), BpmnModelUtil.instanceofUserTaskOnly(task.getCategory()), pCatpion, mCatpion);
    }

    public static MessageContext buildMessageContext(AgentExecution execution) {
        MessageContext ctx = new MessageContext();
        if (null != execution) {
            ctx.setBusinessKey(execution.getBusinessKey());
            if (execution.getCurrentFlowElement() != null) {
                ctx.setElementId(execution.getCurrentFlowElement().getId());
            }
            ctx.setEntityNumber(execution.getEntityNumber());
            ctx.setProcessDefinitionId(execution.getProcessDefinitionId());
            ctx.setExecutionId(execution.getId());
            ctx.setProcessInstanceId(execution.getProcessInstanceId());
            ctx.setTaskId(execution.getCurrentTaskId());
            if (execution instanceof ExecutionEntity) {
                ctx.setBillNo(((ExecutionEntity)execution).getBillNo());
            }
        }
        return ctx;
    }

    public static MessageContext buildMessageContext(TaskInfo task) {
        MessageContext ctx = new MessageContext();
        if (task != null) {
            ctx.setBusinessKey(task.getBusinessKey());
            ctx.setElementId(task.getTaskDefinitionKey());
            ctx.setEntityNumber(task.getEntityNumber());
            ctx.setProcessDefinitionId(task.getProcessDefinitionId());
            ctx.setProcessInstanceId(task.getProcessInstanceId());
            ctx.setExecutionId(task.getExecutionId());
            ctx.setTaskId(task.getId());
            ctx.setCreateDate(task.getCreateDate());
            ctx.setStartUserId(task.getStarterId());
            ctx.setEntityName(task.getEntityName().getLocaleValue());
            ctx.setBillNo(task.getBillNo());
        }
        return ctx;
    }

    public static MessageContext buildMessageContext(TaskEntity taskEntity) {
        if (taskEntity == null) {
            return null;
        }
        MessageContext ctx = new MessageContext();
        ctx.setBusinessKey(taskEntity.getBusinessKey());
        ctx.setElementId(taskEntity.getTaskDefinitionKey());
        ctx.setEntityNumber(taskEntity.getEntityNumber());
        ctx.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
        ctx.setProcessInstanceId(taskEntity.getProcessInstanceId());
        ctx.setExecutionId(taskEntity.getExecutionId());
        ctx.setTaskId(taskEntity.getId());
        ctx.setCreateDate(taskEntity.getCreateDate());
        ctx.setStartUserId(taskEntity.getStarterId());
        ctx.setEntityName(taskEntity.getEntityName().getLocaleValue());
        ctx.setBillNo(taskEntity.getBillNo());
        return ctx;
    }

    public static MessageContext buildMessageContext(Long taskId) {
        MessageContext ctx = new MessageContext();
        TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(taskId);
        if (task != null) {
            ctx = MessageServiceUtil.buildMessageContext(task);
        } else {
            HistoricTaskInstanceEntity hisTask = (HistoricTaskInstanceEntity)Context.getCommandContext().getHistoricTaskInstanceEntityManager().findById(taskId);
            if (hisTask != null) {
                ctx.setTaskId(taskId);
                ctx.setProcessInstanceId(hisTask.getProcessInstanceId());
                ctx.setProcessDefinitionId(hisTask.getProcessDefinitionId());
                ctx.setElementId(hisTask.getTaskDefinitionKey());
                ctx.setBusinessKey(hisTask.getBusinessKey());
                ctx.setEntityNumber(hisTask.getEntityNumber());
                ctx.setExecutionId(hisTask.getExecutionId());
                ctx.setCreateDate(hisTask.getCreateDate());
                ctx.setStartUserId(hisTask.getStarterId());
                ctx.setEntityName(hisTask.getEntityName().getLocaleValue());
                ctx.setBillNo(hisTask.getBillNo());
            }
        }
        return ctx;
    }

    public static MessageInfo buildMessageInfo(Long proInstId, String actId) {
        MessageInfo info = new MessageInfo();
        info.setNotifyType(MessageServiceUtil.getNotifyTypeByNode("message"));
        return info;
    }

    public static MessageInfo buildAlarmMessageInfo(Long proInstId, String actId) {
        MessageInfo info = new MessageInfo();
        info.setNotifyType(MessageServiceUtil.getNotifyTypeByNode("alarm"));
        return info;
    }

    public static String getNotifyTypeByNode(String type) {
        MessageService service = MessageServiceUtil.getMessageService();
        return service.getDefaultNotifyType(type);
    }

    public static MessageService getMessageService() {
        MessageService service;
        MessageService messageService = service = Context.getCommandContext() == null ? null : Context.getCommandContext().getMessageService();
        if (service == null) {
            service = ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration().getMessageService();
        }
        return service;
    }

    public static MessageQuantitySummaryServcie getMessageQuantitySummaryService() {
        return MessageQuantitySummaryServcie.create();
    }

    public static ToDoInfo buildDealToDoModel(CommandContext commandContext, Long userId, Long actId, TaskInfo taskInfo) {
        ToDoInfo model = new ToDoInfo();
        model.setTaskId(taskInfo.getId());
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        model.setUserIds(userIds);
        if (taskInfo instanceof TaskEntity) {
            model.setUrl(MessageServiceUtil.buildDealToDoUrlForTaskEntity((TaskEntity)taskInfo, actId));
        }
        model.setState(ToDoInfo.State.DEAL);
        model.setNotifyType(MessageServiceUtil.getNotifyTypeByNode("task"));
        model.setCheck(true);
        model.setBillNo(taskInfo.getBillNo());
        return model;
    }

    public static String getChangeNotifyType(String taskEndType) {
        String notifyType = MessageServiceUtil.getNotifyTypeByNode("task");
        if (WfUtils.isNotEmpty(notifyType) && "pc".equals(taskEndType)) {
            String[] types = notifyType.split(",");
            StringBuilder sb = new StringBuilder();
            for (String type : types) {
                if (!"email".equals(type) && !"sms".equals(type)) continue;
                sb.append(type).append(',');
            }
            return sb.toString();
        }
        return notifyType;
    }

    public static void updateToDoMsgContent(MessageServiceConfig config, MessageInfo messageInfo) {
        if (messageInfo != null) {
            MessageTemplateCalculate.updateToDoMsgContent(config, messageInfo, null);
        } else {
            logger.warn("updateMsgContent--function parameter is error and not use template");
        }
    }

    public static void updateToDoMsgContent(MessageServiceConfig config, ITaskMsg taskMsg) {
        if (config != null && taskMsg != null && taskMsg.getTaskId() != null && taskMsg.getTaskId() > 0L) {
            MessageTemplateCalculate.updateToDoMsgContent(config, null, taskMsg);
        } else {
            logger.warn("updateToDoContent--function parameter is error and not use template");
        }
    }

    public static Map<String, Object> updateToDoMsgContentForYunzhijia(MessageServiceConfig config, ITaskMsg taskMsg) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        if (config != null && taskMsg != null && taskMsg.getTaskId() != null && taskMsg.getTaskId() > 0L) {
            resultMap = MessageTemplateCalculate.updateToDoMsgContent(config, null, taskMsg);
        } else {
            logger.warn("updateToDoContent--function parameter is error and not use template");
        }
        return resultMap;
    }

    public static String getRealProcessingMobilePage(String processingMobilePage) {
        if (WfUtils.isEmptyString(processingMobilePage)) {
            return "wf_approvalpagemobile_bac";
        }
        return processingMobilePage;
    }

    public static String getRealProcessingPage(String processingPage) {
        if (WfUtils.isEmptyString(processingPage) || "wf_approvalpage".equals(processingPage)) {
            return "wf_approvalpage_bac";
        }
        return processingPage;
    }

    public static String buildWebPageForAuditTaskUrl(Long taskId, String taskType, String businessKey) {
        return MessageServiceUtil.buildWebPageForTaskUrl(null, null, taskId, taskType, businessKey, Boolean.FALSE, null, null);
    }

    public static MessageInfo getMessageInfoFromString(String msgStr) {
        String TAG = "tag";
        String TITLE = "title";
        String CONTENT = "content";
        String SENDERNAME = "senderName";
        String MESSAGETAG = "messageTag";
        String MESSAGECONTENT = "messageContent";
        String MESSAGETITLE = "messageTitle";
        String MESSAGESENDERNAME = "messageSenderName";
        Map msg = (Map)SerializationUtils.fromJsonString((String)msgStr, Map.class);
        String tag = (String)msg.get("tag");
        String title = (String)msg.get("title");
        String content = (String)msg.get("content");
        String senderName = (String)msg.get("senderName");
        msg.remove("tag");
        msg.remove("title");
        msg.remove("content");
        msg.remove("senderName");
        Object messageContent = msg.get("messageContent");
        LocaleString multiContent = null;
        if (messageContent instanceof Map) {
            msg.remove("messageContent");
            multiContent = LocaleString.fromMap((Map)((Map)messageContent));
        }
        Object messageTitle = msg.get("messageTitle");
        LocaleString multiTitle = null;
        if (messageTitle instanceof Map) {
            msg.remove("messageTitle");
            multiTitle = LocaleString.fromMap((Map)((Map)messageTitle));
        }
        Object messageTag = msg.get("messageTag");
        LocaleString multiTag = null;
        if (messageTag instanceof Map) {
            msg.remove("messageTag");
            multiTag = LocaleString.fromMap((Map)((Map)messageTag));
        }
        Object messageSenderName = msg.get("messageSenderName");
        LocaleString multiSenderName = null;
        if (messageSenderName instanceof Map) {
            msg.remove("messageSenderName");
            multiSenderName = LocaleString.fromMap((Map)((Map)messageSenderName));
        }
        MessageInfo info = (MessageInfo)JSON.parseObject((String)JSON.toJSONString((Object)msg), MessageInfo.class);
        if (multiTitle != null) {
            info.setMessageTitle((ILocaleString)multiTitle);
        } else {
            info.setTitle(title);
        }
        if (multiContent != null) {
            info.setMessageContent((ILocaleString)multiContent);
        } else {
            info.setContent(content);
        }
        if (multiTag != null) {
            info.setMessageTag((ILocaleString)multiTag);
        } else {
            info.setTag(tag);
        }
        if (multiSenderName != null) {
            info.setMessageSenderName((ILocaleString)multiSenderName);
        } else {
            info.setSenderName(senderName);
        }
        return info;
    }

    public static String getContent(String content) {
        int MAX_CONTENT = 2000;
        if (content.length() > 2000) {
            return content.substring(0, 2000);
        }
        return content;
    }

    public static String getTitle(String title) {
        int MAX_TITLE = 200;
        if (title.length() > 200) {
            return title.substring(0, 197).concat("...");
        }
        return title;
    }

    public static boolean canUseYunzhijia(String notifyType) {
        String[] types;
        for (String type : types = notifyType.split(",")) {
            if (!WfUtils.isNotEmpty(type) || !"yunzhijia".equalsIgnoreCase(type) && (!"yunzhijiaeco".equalsIgnoreCase(type) || !WfConfigurationUtil.isEnabled(type))) continue;
            return true;
        }
        logger.debug("no yunzhijia:" + notifyType);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getJobEntityRestries(AbstractJobEntity job, String channelNumber, int retries) {
        Map config;
        if (job != null && StringUtils.isBlank((CharSequence)channelNumber)) {
            String jobHandlerConfiguration = job.getJobHandlerConfiguration();
            Map payload = (Map)SerializationUtils.fromJsonString((String)jobHandlerConfiguration, Map.class);
            String model = (String)payload.get("model");
            if (!StringUtils.isNotBlank((CharSequence)model)) return retries;
            ToDoInfo todoInfo = (ToDoInfo)SerializationUtils.fromJsonString((String)model, ToDoInfo.class);
            if (!StringUtils.isNotBlank((CharSequence)todoInfo.getTodoType())) return retries;
            if (!"todo".equals(todoInfo.getTodoType())) return retries;
            channelNumber = (String)payload.get("service");
        }
        if ((config = MessageChannelUtils.getChannelRetryConfig((String)channelNumber)) == null) return retries;
        if (config.isEmpty()) return retries;
        Object retry = config.get("retries");
        if (!StringUtils.isNotBlank(retry)) return retries;
        return (Integer)retry;
    }

    public static int getJobWaitTime(AbstractJobEntity job, int waitTime) {
        Object timeStep;
        String channelNumber;
        Map config;
        ToDoInfo todoInfo;
        String jobHandlerConfiguration = job.getJobHandlerConfiguration();
        Map payload = (Map)SerializationUtils.fromJsonString((String)jobHandlerConfiguration, Map.class);
        String model = (String)payload.get("model");
        if (StringUtils.isNotBlank((CharSequence)model) && StringUtils.isNotBlank((CharSequence)(todoInfo = (ToDoInfo)SerializationUtils.fromJsonString((String)model, ToDoInfo.class)).getTodoType()) && "todo".equals(todoInfo.getTodoType()) && (config = MessageChannelUtils.getChannelRetryConfig((String)(channelNumber = (String)payload.get("service")))) != null && !config.isEmpty() && StringUtils.isNotBlank(timeStep = config.get("timestep"))) {
            waitTime = (Integer)timeStep;
        }
        return waitTime;
    }

    @Deprecated
    public static String wrapSystemDomain(String url) {
        return MessageServiceUtil.wrapSystemDomain(url, null);
    }

    public static String wrapSystemDomain(String url, String notifyType) {
        String d;
        String wrapUrl = "";
        String domain = RevProxyUtil.addSlash((String)UrlService.getDomainContextUrl());
        wrapUrl = url.indexOf(domain) >= 0 ? ((d = MessageServiceUtil.getMsgDomain(url)).equals(domain) ? (WfUtils.isNotEmpty(notifyType) ? MessageServiceUtil.getReplacedUrl(url, notifyType) : url) : url.replace(domain, d)) : url;
        return wrapUrl;
    }

    public static String getMsgDomain(String url) {
        String domain = RevProxyUtil.addSlash((String)UrlService.getDomainContextUrl());
        Object configDomain = MessageServiceUtil.getConfigCenterProperty("message", "msg.domain");
        if (configDomain == null) {
            return domain;
        }
        if (WfUtils.isJSONFormat(configDomain)) {
            JSONObject obj = JSONObject.parseObject((String)((String)configDomain));
            if (obj != null && WfUtils.isNotEmpty(url)) {
                for (Map.Entry entry : obj.entrySet()) {
                    if (url.indexOf((String)entry.getKey()) < 0) continue;
                    domain = RevProxyUtil.addSlash((String)String.valueOf(entry.getValue()));
                    break;
                }
            }
        } else {
            domain = RevProxyUtil.addSlash((String)String.valueOf(configDomain));
        }
        logger.debug("getMsgDomain : " + domain);
        return domain;
    }

    @Deprecated
    public static String getSystemDomain() {
        String domain = UrlService.getDomainContextUrl();
        Object configDomain = MessageServiceUtil.getConfigCenterProperty("message", "msg.domain");
        if (configDomain != null) {
            domain = (String)configDomain;
        }
        return domain;
    }

    public static Object getConfigCenterProperty(String type, String key) {
        Object propertyValue = null;
        try {
            QFilter f1 = new QFilter("type", "=", (Object)type);
            QFilter f2 = new QFilter("key", "=", (Object)key);
            DynamicObject configCenterObj = BusinessDataServiceHelper.loadSingle((String)"wf_confcenter", (String)"value", (QFilter[])new QFilter[]{f1, f2});
            if (configCenterObj != null) {
                propertyValue = configCenterObj.get("value");
            }
        }
        catch (Exception e) {
            logger.info("getConfigCenterProperty:" + e.getMessage());
        }
        return propertyValue;
    }

    public static String getViewFormId(TaskInfo task, boolean isPC) {
        boolean userTask;
        if (task != null && task.isBizTask()) {
            return isPC ? task.getProcessingPage() : task.getProcessingMobilePage();
        }
        String viewFormId = null;
        String queryKey = null;
        queryKey = isPC ? "approvalviewpage_pc" : "approvalviewpage_mob";
        viewFormId = WfConfigurationUtil.getApprovalViewPageByDeviceType(queryKey);
        if (WfUtils.isNotEmpty(viewFormId)) {
            return viewFormId;
        }
        String formId = null;
        boolean exist = false;
        if (null != task && WfUtils.isNotEmpty(formId = isPC ? task.getProcessingPage() : task.getProcessingMobilePage())) {
            viewFormId = formId + "_view";
            exist = BillPagePluginUtil.isExistForFormId(viewFormId);
        }
        if (exist) {
            return viewFormId;
        }
        boolean bl = userTask = null == task ? true : BpmnModelUtil.instanceofUserTaskOnly(task.getCategory());
        return isPC ? (userTask ? "wf_approvalbill_view" : "wf_approvalpageview_bac") : (userTask ? "wf_approvalbillmob_view" : ("wf_approvalpage_mob".equals(formId) ? "wf_approvalpageview_mob" : "wf_approvalmobileview_bac"));
    }

    public static final boolean isCurrentDomain(String url) {
        return StringUtils.isNotBlank((CharSequence)url) && url.indexOf(MessageServiceUtil.getMsgDomain(url)) >= 0;
    }

    public static boolean isAllowSendTodo(TaskInfo task) {
        return !ProcessType.BizFlow.name().equals(task.getProcessType()) || !"BillTask".equals(task.getCategory());
    }

    public static String getReplacedUrl(String url, String notifyType) {
        MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)notifyType);
        logger.info(String.format("AbstractServiceHandler_wrappMessageUrlDomain notifyType[%s], msgChannelInfo[%s] ", notifyType, msgChannelInfo));
        if (msgChannelInfo == null) {
            return url;
        }
        String config = msgChannelInfo.getConfig();
        logger.info("AbstractServiceHandler_wrappMessageUrlDomain config");
        if (WfUtils.isEmpty(config)) {
            return url;
        }
        try {
            JSONObject jsonConfig = JSONObject.parseObject((String)config);
            return MessageServiceUtil.replaceUrl(url, jsonConfig.getString(MSGDOMAIN));
        }
        catch (Exception e) {
            logger.error(String.format("AbstractServiceHandler_wrappMessageUrlDomain has error: %s", WfUtils.getExceptionStacktrace(e)));
            return url;
        }
    }

    private static String replaceUrl(String originalUrl, String configDomain) {
        if (WfUtils.isEmpty(originalUrl) || WfUtils.isEmpty(configDomain)) {
            return originalUrl;
        }
        String url = originalUrl;
        String replacedDomain = "";
        if (WfUtils.isJSONFormat(configDomain)) {
            logger.info("AbstractServiceHandler_replaceUrl is multiple domain");
            JSONObject obj = JSONObject.parseObject((String)configDomain);
            if (obj == null || WfUtils.isEmptyForMap((Map)obj)) {
                return originalUrl;
            }
            logger.info(String.format("AbstractServiceHandler_replaceUrl obj[%s] ", obj));
            for (Map.Entry entry : obj.entrySet()) {
                String originalDomain = (String)entry.getKey();
                if (!originalUrl.contains(originalDomain)) continue;
                replacedDomain = String.valueOf(entry.getValue());
                url = originalUrl.replace(originalDomain, replacedDomain);
                logger.info(String.format("AbstractServiceHandler_getReplacedUrl originalDomain[%s], replacedDomain[%s]", entry.getKey(), replacedDomain));
                break;
            }
        } else {
            logger.info(String.format("AbstractServiceHandler_replaceUrl danyuming configDomain[%s]", configDomain));
            String domain = RevProxyUtil.addSlash((String)UrlService.getDomainContextUrl());
            if (originalUrl.contains(domain)) {
                replacedDomain = RevProxyUtil.addSlash((String)configDomain);
                url = originalUrl.replace(domain, replacedDomain);
                logger.info(String.format("AbstractServiceHandler_getReplacedUrl originalDomain[%s], replacedDomain[%s]", domain, replacedDomain));
            }
        }
        return url;
    }
}

