/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.message.utils.MessageEventListenerUtils;
import kd.bos.message.utils.MessageUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.ExpressionParseResult;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;
import kd.bos.workflow.engine.msg.MessageServiceConfig;
import kd.bos.workflow.engine.msg.info.ITaskMsg;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class MessageTemplateCalculate {
    private static Log logger = LogFactory.getLog(MessageTemplateCalculate.class);
    private static final String BIZENTITYOBJECT = "bizEntityObject";
    private static final String MESSAGECONTENT = "messageContent";
    private static final String MESSAGETITLE = "messageTitle";
    private static final String TPLCONTENT = "tplContent";
    private static final String BIZPLUGIN = "bizPlugin";
    private static final String CONTENT = "content";
    private static final String TASKTYPE = "task";
    private static final String TITLE = "title";
    private static final String TODOTITLE = "toDoTitle";
    private static final String TODOCONTENT = "toDoContent";
    private static final String ISTEMPLATE = "isTemplate";
    private static final String APPTYPE = "apptype";
    private static final String MSGID = "msgId";

    public static Map<String, Object> updateToDoMsgContent(MessageServiceConfig config, MessageInfo messageInfo, ITaskMsg taskMsg) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean isTemplate = false;
        Object toDoTitle = null;
        Object toDoContent = null;
        if (messageInfo != null) {
            Map<String, Object> tplMapData = MessageTemplateCalculate.getMessageTemplateData(config, messageInfo);
            if (tplMapData != null && !tplMapData.isEmpty()) {
                String entityNumber = messageInfo.getEntityNumber();
                Object bizPluginInfo = tplMapData.get(BIZPLUGIN);
                if (StringUtils.isNotBlank((Object)bizPluginInfo)) {
                    Map bizPlugin = (Map)SerializationUtils.fromJsonString((String)((String)bizPluginInfo), Map.class);
                    MessageTemplateCalculate.calculateMessageByBizPlugin(entityNumber, messageInfo, (String)bizPlugin.get(BIZPLUGIN));
                } else {
                    Object tplContent = tplMapData.get(TPLCONTENT);
                    if (WfUtils.isNotEmptyString(tplContent) && !"null".equalsIgnoreCase((String)tplContent)) {
                        ILocaleString template = (ILocaleString)SerializationUtils.fromJsonString((String)((String)tplContent), LocaleString.class);
                        MessageTemplateCalculate.calculateMessageByTemplate(template, messageInfo, entityNumber);
                    } else {
                        MessageTemplateCalculate.wrapMessageContent(messageInfo.getNotifyType(), messageInfo, taskMsg);
                    }
                }
            } else {
                logger.debug("updateToDoMsgContent--find template is zero");
            }
        } else {
            String entityNumber = "wf_task";
            Map tplMapData = MessageUtils.getMessageTemplateInfo(null, (String)TASKTYPE, (String)config.getServiceKey(), (String)taskMsg.getBizType(), (String)entityNumber);
            if (tplMapData != null && !tplMapData.isEmpty()) {
                Object bizPluginInfo = tplMapData.get(BIZPLUGIN);
                Map<Object, Object> temMap = new HashMap();
                if (StringUtils.isNotBlank(bizPluginInfo)) {
                    Map bizPlugin = (Map)SerializationUtils.fromJsonString((String)((String)bizPluginInfo), Map.class);
                    temMap = MessageTemplateCalculate.calculateMessageByBizPlugin(entityNumber, taskMsg, (String)bizPlugin.get(BIZPLUGIN));
                } else {
                    Object tplContent = tplMapData.get(TPLCONTENT);
                    if (WfUtils.isNotEmptyString(tplContent) && !"null".equalsIgnoreCase((String)tplContent)) {
                        ILocaleString template = (ILocaleString)SerializationUtils.fromJsonString((String)((String)tplContent), LocaleString.class);
                        temMap = MessageTemplateCalculate.calculateMessageByTemplate(template, taskMsg, entityNumber, config.getServiceKey());
                    } else {
                        MessageTemplateCalculate.wrapMessageContent(config.getServiceKey(), messageInfo, taskMsg);
                    }
                }
                if (!temMap.isEmpty()) {
                    toDoTitle = temMap.get(TODOTITLE);
                    toDoContent = temMap.get(TODOCONTENT);
                    if (WfUtils.isNotEmpty((ILocaleString)((LocaleString)toDoContent))) {
                        isTemplate = true;
                    }
                }
            } else {
                logger.debug("updateToDoMsgContent--find template is zero");
                MessageTemplateCalculate.wrapMessageContent(config.getServiceKey(), messageInfo, taskMsg);
            }
        }
        resultMap.put(ISTEMPLATE, isTemplate);
        resultMap.put(TODOTITLE, toDoTitle);
        return resultMap;
    }

    private static Map<String, Object> getMessageTemplateData(MessageServiceConfig config, MessageInfo messageInfo) {
        String channel;
        Map tplMapData = null;
        String string = channel = config != null ? config.getServiceKey() : messageInfo.getNotifyType();
        if (StringUtils.isNotBlank((CharSequence)messageInfo.getTemplateNumber())) {
            tplMapData = MessageUtils.getMessageTemplateLocalByNumber((String)messageInfo.getTemplateNumber());
        } else if (StringUtils.isNotBlank((CharSequence)messageInfo.getEntityNumber())) {
            String scene = messageInfo.getTplScene() != null ? messageInfo.getTplScene() : messageInfo.getBizType();
            String type = messageInfo.getType();
            tplMapData = MessageUtils.getMessageTemplateInfo(null, (String)type, (String)channel, (String)scene, (String)messageInfo.getEntityNumber());
            Object tplNumber = tplMapData.get("tplNumber");
            if (!WfUtils.isNullObject(tplNumber) && !MessageChannels.MC.getNumber().equals(channel)) {
                messageInfo.setTemplateNumber(String.valueOf(tplNumber));
            }
        } else {
            logger.debug("updateToDoMsgContent--\u6d88\u606f\u5b9e\u4f53or\u6d88\u606f\u7c7b\u578b\u4e3akong\uff0c\u4e0d\u80fd\u6b63\u5e38\u4f7f\u7528\u6a21\u677f");
        }
        return tplMapData;
    }

    private static Map<String, Object> calculateMessageByBizPlugin(String entityNumber, Object info, String bizPlugin) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        logger.debug(String.format("calculateMessageByBizPlugin, and plugin is %s", bizPlugin));
        Long businessKey = 0L;
        if (info instanceof MessageInfo) {
            MessageInfo messageInfo = (MessageInfo)info;
            businessKey = messageInfo.getBizDataId();
        } else {
            ToDoInfo todoInfo = (ToDoInfo)info;
            businessKey = todoInfo.getTaskId();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("entityNumber", entityNumber);
        params.put("businessKey", businessKey);
        try {
            ToDoInfo todoInfo;
            MessageInfo messageInfo;
            Map calculateResult = MessageEventListenerUtils.calculateMessageContent((String)bizPlugin, params);
            if (StringUtils.isNotBlank(calculateResult.get(MESSAGETITLE))) {
                if (info instanceof MessageInfo) {
                    messageInfo = (MessageInfo)info;
                    messageInfo.setMessageTitle((ILocaleString)((LocaleString)calculateResult.get(MESSAGETITLE)));
                } else {
                    todoInfo = (ToDoInfo)info;
                    todoInfo.setToDoTitle((LocaleString)calculateResult.get(MESSAGETITLE));
                    resultMap.put(TODOTITLE, calculateResult.get(MESSAGETITLE));
                }
            }
            if (StringUtils.isNotBlank(calculateResult.get(MESSAGECONTENT))) {
                if (info instanceof MessageInfo) {
                    messageInfo = (MessageInfo)info;
                    messageInfo.setMessageContent((ILocaleString)((LocaleString)calculateResult.get(MESSAGECONTENT)));
                } else {
                    todoInfo = (ToDoInfo)info;
                    todoInfo.setToDoContent((LocaleString)calculateResult.get(MESSAGECONTENT));
                    resultMap.put(TODOCONTENT, calculateResult.get(MESSAGECONTENT));
                }
            }
        }
        catch (Exception e) {
            logger.info("calculateMessageByBizPlugin-hasException:" + WfUtils.getExceptionStacktrace(e));
        }
        return resultMap;
    }

    private static void calculateMessageByTemplate(ILocaleString template, MessageInfo messageInfo, String entityNumber) {
        block10: {
            String channel = messageInfo.getNotifyType();
            if (template != null) {
                Map<String, ILocaleString> templateInfo = MessageTemplateCalculate.splitMessageTemplate(template, channel);
                try {
                    DynamicObject bizEntityObject = null;
                    if (messageInfo.getParams().get(BIZENTITYOBJECT) != null) {
                        String bizEntity = (String)messageInfo.getParams().get(BIZENTITYOBJECT);
                        bizEntityObject = DynamicObjectJsonSerializer.parseDynamicObjectJson(bizEntity, entityNumber);
                    }
                    if (WfUtils.isNotEmpty(templateInfo.get(CONTENT))) {
                        ILocaleString messageContent = null;
                        Map params = messageInfo.getParams();
                        params.put(MSGID, messageInfo.getId());
                        params.put("messageSenderId", messageInfo.getSenderId());
                        messageContent = bizEntityObject != null ? MessageTemplateCalculate.calcContent(bizEntityObject, templateInfo.get(CONTENT), params, channel, false) : MessageTemplateCalculate.calcContent(messageInfo.getBizDataId(), entityNumber, templateInfo.get(CONTENT), params, channel, false);
                        if (WfUtils.isNotEmpty(messageContent)) {
                            messageInfo.setMessageContent(messageContent);
                        } else {
                            MessageTemplateCalculate.wrapMessageContent(channel, messageInfo, null);
                        }
                    } else {
                        MessageTemplateCalculate.wrapMessageContent(channel, messageInfo, null);
                    }
                    if (!WfUtils.isNotEmpty(templateInfo.get(TITLE))) break block10;
                    ILocaleString messageTitle = null;
                    messageTitle = bizEntityObject != null ? MessageTemplateCalculate.calcContent(bizEntityObject, templateInfo.get(TITLE), messageInfo.getParams(), channel, true) : MessageTemplateCalculate.calcContent(messageInfo.getBizDataId(), entityNumber, templateInfo.get(TITLE), messageInfo.getParams(), channel, true);
                    if (WfUtils.isNotEmpty(messageTitle)) {
                        messageInfo.setMessageTitle(messageTitle);
                    }
                }
                catch (Exception e) {
                    logger.error("updateTaskToDoMsgContentForEmail--\u89e3\u6790\u6a21\u677f\u5185\u5bb9\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + WfUtils.getExceptionStacktrace(e));
                }
            } else {
                MessageTemplateCalculate.wrapMessageContent(channel, messageInfo, null);
            }
        }
    }

    private static Map<String, Object> calculateMessageByTemplate(ILocaleString template, ITaskMsg taskMsg, String entityNumber, String channel) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (template != null) {
            Map<String, ILocaleString> templateInfo = MessageTemplateCalculate.splitMessageTemplate(template, channel);
            try {
                LocaleString messageContent = (LocaleString)MessageTemplateCalculate.calcContent(taskMsg.getTaskId(), entityNumber, templateInfo.get(CONTENT), taskMsg.getParams(), channel, false);
                if (WfUtils.isNotEmpty((ILocaleString)messageContent)) {
                    taskMsg.setContent(messageContent.getLocaleValue());
                    taskMsg.setToDoContent(messageContent);
                    resultMap.put(TODOCONTENT, messageContent);
                } else {
                    MessageTemplateCalculate.wrapMessageContent(channel, null, taskMsg);
                }
                LocaleString messageTitle = (LocaleString)MessageTemplateCalculate.calcContent(taskMsg.getTaskId(), entityNumber, templateInfo.get(TITLE), taskMsg.getParams(), channel, true);
                if (WfUtils.isNotEmpty((ILocaleString)messageTitle)) {
                    taskMsg.setTitle(messageTitle.getLocaleValue());
                    taskMsg.setToDoTitle(messageTitle);
                    resultMap.put(TODOTITLE, messageTitle);
                }
            }
            catch (Exception e) {
                logger.error("updateTaskToDoMsgContentForEmail--\u89e3\u6790\u6a21\u677f\u5185\u5bb9\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + WfUtils.getExceptionStacktrace(e));
                MessageTemplateCalculate.wrapMessageContent(channel, null, taskMsg);
            }
        } else {
            MessageTemplateCalculate.wrapMessageContent(channel, null, taskMsg);
        }
        return resultMap;
    }

    private static Map<String, ILocaleString> splitMessageTemplate(ILocaleString msgTemplate, String channel) {
        HashMap<String, ILocaleString> templateInfo = new HashMap<String, ILocaleString>();
        LocaleString titleLocalString = new LocaleString();
        LocaleString contentLocalString = new LocaleString();
        for (Map.Entry entry : msgTemplate.entrySet()) {
            String value = (String)entry.getValue();
            if (!WfUtils.isNotEmpty(value)) continue;
            Object title = null;
            String content = null;
            try {
                Map template = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
                title = template.get(TITLE);
                if (WfUtils.isEmptyString(title)) {
                    title = template.get("emailTitle");
                }
                if (WfUtils.isEmptyString(content = template.get(CONTENT))) {
                    content = template.get("emailContent");
                }
            }
            catch (Exception e) {
                content = value;
            }
            if (title != null && StringUtils.isNotBlank(title)) {
                titleLocalString.setItem((String)entry.getKey(), (Object)title);
            }
            if (content == null || !StringUtils.isNotBlank((Object)content)) continue;
            contentLocalString.setItem((String)entry.getKey(), (Object)content);
        }
        templateInfo.put(TITLE, (ILocaleString)titleLocalString);
        templateInfo.put(CONTENT, (ILocaleString)contentLocalString);
        return templateInfo;
    }

    private static ILocaleString calcContent(DynamicObject bizEntityObject, ILocaleString messageTemplate, Map<String, Object> param, String channel, boolean isTitle) {
        LocaleString resultContent = new LocaleString();
        if (bizEntityObject == null) {
            logger.debug(String.format("calcContent--dynamicEntityObject is null--tpl=%s", messageTemplate));
            return resultContent;
        }
        String key = null;
        String value = null;
        try {
            logger.debug(String.format("calcContent--inter--tpl=%s", messageTemplate));
            for (Map.Entry entry : messageTemplate.entrySet()) {
                key = (String)entry.getKey();
                if (MessageChannels.MC.getNumber().equals(channel) && "commonlang".equalsIgnoreCase(key)) continue;
                value = (String)entry.getValue();
                ExpressionParseResult parseResult = null;
                logger.debug(String.format("calcContent--forbefore--key=%s--value=%s", key, value));
                if (WfUtils.isNotEmpty(value)) {
                    WorkflowService service = (WorkflowService)ServiceFactory.getService((String)"WorkflowService");
                    BusinessModelVariableScope scope = new BusinessModelVariableScope(bizEntityObject);
                    scope.setTransientVariable(APPTYPE, channel);
                    scope.setTransientVariable("lang", key);
                    parseResult = service.getRepositoryService().getMsgTemplateParseValuesCmd(value, bizEntityObject, scope, null);
                }
                if (parseResult != null) {
                    resultContent.setItem(key, (Object)parseResult.getParsedContent());
                    MessageTemplateCalculate.adornParams(channel, param, key, null, parseResult.getVariables(), isTitle);
                    continue;
                }
                logger.debug(String.format("calcContent--forafter--key=%s--tpl=%s--parseResult=null", key, value));
            }
        }
        catch (Exception e) {
            MessageTemplateCalculate.adornParams(channel, param, key, e.getMessage(), new ArrayList<Map<String, String>>(), isTitle);
            logger.debug(String.format("calcContent--catch--key=%s--value=%s--exception=%s", key, value, WfUtils.getExceptionStacktrace(e)));
        }
        return resultContent;
    }

    protected static ILocaleString calcMessageTemplate(DynamicObject entityObject, Map<String, String> template) {
        LocaleString resultContent = new LocaleString();
        for (Map.Entry<String, String> entry : template.entrySet()) {
            String lang = entry.getKey();
            String value = entry.getValue();
            String content = "";
            long entityId = entityObject.getLong("id");
            logger.debug(String.format("calcContent--for--id=%s---key=%s--value=%s", entityId, lang, value));
            if (WfUtils.isNotEmpty(value)) {
                WorkflowService service = (WorkflowService)ServiceFactory.getService((String)"WorkflowService");
                BusinessModelVariableScope scope = new BusinessModelVariableScope(entityObject);
                scope.setTransientVariable("lang", lang);
                ExpressionParseResult parseResult = service.getRepositoryService().getMsgTemplateParseValuesCmd(value, entityObject, scope, null);
                content = parseResult.getParsedContent();
                logger.debug(String.format("calcContent--catch--id=%s--key=%s-", entityId, lang));
            }
            resultContent.setItem(lang, (Object)content);
        }
        return resultContent;
    }

    private static ILocaleString calcContent(Long bussinessKey, String entityNumber, ILocaleString messageTemplate, Map<String, Object> param, String channel, boolean isTitle) {
        LocaleString resultContent = new LocaleString();
        if (WfUtils.isEmpty(entityNumber) || WfUtils.isEmpty(bussinessKey)) {
            logger.debug(String.format("calcContent--functionParamterError--id=%s--entity=%s--tpl=%s", bussinessKey, entityNumber, messageTemplate));
            return resultContent;
        }
        DynamicObject entityObject = null;
        String key = null;
        String value = null;
        try {
            block16: {
                logger.debug(String.format("calcContent--inter--id=%s--entity=%s--tpl=%s", bussinessKey, entityNumber, messageTemplate));
                try {
                    entityObject = BusinessDataServiceHelper.loadSingle((Object)bussinessKey, (String)entityNumber);
                }
                catch (Exception e) {
                    if (entityObject != null || !"wf_task".equalsIgnoreCase(entityNumber)) break block16;
                    try {
                        entityObject = BusinessDataServiceHelper.loadSingle((Object)bussinessKey, (String)"wf_hitaskinst");
                    }
                    catch (Exception e1) {
                        logger.warn(String.format("calcContent--loadEntityError-notfindhitask--id=%s--entity=%s-", bussinessKey, entityNumber));
                    }
                }
            }
            logger.debug(String.format("calcContent--loadover--id=%s--entity=%s", bussinessKey, entityNumber));
            param.put(APPTYPE, channel);
            for (Map.Entry entry : messageTemplate.entrySet()) {
                key = (String)entry.getKey();
                if (MessageChannels.MC.getNumber().equals(channel) && "commonlang".equalsIgnoreCase(key)) continue;
                value = (String)entry.getValue();
                logger.debug(String.format("calcContent--for--id=%s--entity=%s--key=%s--value=%s", bussinessKey, entityNumber, key, value));
                ExpressionParseResult parseResult = null;
                if (WfUtils.isNotEmpty(value)) {
                    WorkflowService service = (WorkflowService)ServiceFactory.getService((String)"WorkflowService");
                    if ("wf_task".equalsIgnoreCase(entityNumber)) {
                        BusinessModelVariableScope scope;
                        TaskEntity entity = (TaskEntity)service.getTaskService().getTask(bussinessKey);
                        if (entity != null) {
                            if (entity.isBizTask()) {
                                scope = new BusinessModelVariableScope(entity.getDynamicObject());
                                scope.setTransientVariable(APPTYPE, channel);
                                parseResult = service.getRepositoryService().getMsgTemplateParseValuesCmd(value, entity.getDynamicObject(), scope, MessageTemplateCalculate.wrapMessageParam(param, key));
                            } else {
                                parseResult = service.getRepositoryService().getMsgTemplateParseValuesCmd(value, entity.getDynamicObject(), entity, MessageTemplateCalculate.wrapMessageParam(param, key));
                            }
                        } else {
                            scope = new BusinessModelVariableScope(entityObject);
                            scope.setTransientVariable(APPTYPE, channel);
                            parseResult = service.getRepositoryService().getMsgTemplateParseValuesCmd(value, entityObject, scope, MessageTemplateCalculate.wrapMessageParam(param, key));
                        }
                    } else {
                        BusinessModelVariableScope scope = new BusinessModelVariableScope(entityObject);
                        scope.setTransientVariable(APPTYPE, channel);
                        scope.setTransientVariable("lang", key);
                        parseResult = service.getRepositoryService().getMsgTemplateParseValuesCmd(String.valueOf(bussinessKey), entityNumber, value, scope);
                    }
                }
                if (parseResult != null) {
                    MessageTemplateCalculate.adornParams(channel, param, key, null, parseResult.getVariables(), isTitle);
                    resultContent.setItem(key, (Object)parseResult.getParsedContent());
                    continue;
                }
                logger.debug(String.format("calcContent--result--id=%s--entity=%s--key=%s--value=%s--praseResult=null", bussinessKey, entityNumber, key, value));
            }
        }
        catch (Exception e) {
            logger.warn(String.format("calcContent--catch--id=%s--entity=%s--key=%s--value=%s--exception=%s", bussinessKey, entityNumber, key, value, WfUtils.getExceptionStacktrace(e)));
        }
        return resultContent;
    }

    private static void adornParams(String channel, Map<String, Object> params, String lang, String failReason, List<Map<String, String>> variables, boolean isTitle) {
        if (!"sms".equalsIgnoreCase(channel) || "commonlang".equalsIgnoreCase(lang)) {
            return;
        }
        Map<String, List<HashMap<String, String>>> msgTplParser = null;
        if (params.containsKey("msgTplParser")) {
            msgTplParser = (Map)params.get("msgTplParser");
        } else {
            msgTplParser = new HashMap();
            msgTplParser.put("channel", (List<HashMap<String, String>>)((Object)channel));
            params.put("msgTplParser", msgTplParser);
        }
        List parseResult = null;
        String parseResultKey = isTitle ? "titleParseResult" : "contentParseResult";
        Map<String, List<Map<String, String>>> result = null;
        if (msgTplParser.containsKey(parseResultKey)) {
            parseResult = (List)msgTplParser.get(parseResultKey);
            boolean isExistLang = false;
            for (int i = 0; i < parseResult.size(); ++i) {
                Map temp = (Map)parseResult.get(i);
                String tLang = (String)temp.get("lang");
                boolean tSuccess = (Boolean)temp.get("success");
                if (!lang.equals(tLang)) continue;
                if (!tSuccess) {
                    result = temp;
                }
                isExistLang = true;
                break;
            }
            if (!isExistLang) {
                result = new HashMap(4);
                parseResult.add(result);
            }
        } else {
            parseResult = new ArrayList();
            msgTplParser.put(parseResultKey, parseResult);
            result = new HashMap<String, Object>(4);
            parseResult.add(result);
        }
        if (result != null) {
            result.put("lang", (List<Map<String, String>>)((Object)lang));
            result.put("success", (List<Map<String, String>>)(WfUtils.isEmpty(failReason) ? 1 : 0));
            result.put("failReason", (List<Map<String, String>>)((Object)failReason));
            result.put("variables", variables);
        }
    }

    private static Map<String, Object> wrapMessageParam(Map<String, Object> param, String lang) {
        HashMap<String, Object> p = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if ("parsesubject".equals(key) && StringUtils.isNotBlank((Object)value)) {
                value = SerializationUtils.fromJsonString((String)((String)value), LocaleString.class);
            }
            if (value instanceof LocaleString) {
                LocaleString pp = (LocaleString)value;
                if (StringUtils.isBlank((CharSequence)((CharSequence)pp.getItem(lang))) && StringUtils.isNotBlank((CharSequence)((CharSequence)pp.getItem("GLang")))) {
                    p.put(key, pp.getItem("GLang"));
                    continue;
                }
                p.put(key, pp.getItem(lang));
                continue;
            }
            p.put(key, value);
        }
        p.put("lang", lang);
        return p;
    }

    private static void wrapMessageContent(String channel, MessageInfo messageInfo, ITaskMsg taskMsg) {
        if (taskMsg != null) {
            Object showUrlInSms = taskMsg.getParams().get("showurlinwfsms");
            if (MessageChannels.SMS.getNumber().equals(channel) && (showUrlInSms == null || ((Boolean)showUrlInSms).booleanValue())) {
                MessageTemplateCalculate.wrapMessageContent(taskMsg, taskMsg.getToDoContent());
            }
            if (MessageChannels.EMAIL.getNumber().equals(channel)) {
                MessageTemplateCalculate.wrapMessageContent(taskMsg, taskMsg.getToDoContent());
            }
        } else {
            Object showUrlInSms = messageInfo.getParams().get("showurlinwfsms");
            if (MessageChannels.SMS.getNumber().equals(channel) && (showUrlInSms == null || ((Boolean)showUrlInSms).booleanValue())) {
                MessageTemplateCalculate.wrapMessageContent(messageInfo, messageInfo.getMessageContent());
            }
            if (MessageChannels.EMAIL.getNumber().equals(channel)) {
                MessageTemplateCalculate.wrapMessageContent(messageInfo, messageInfo.getMessageContent());
            }
        }
    }

    private static void wrapMessageContent(ITaskMsg taskMsg, LocaleString content) {
        String url = taskMsg.getUrl();
        LocaleString tips = new LocaleString();
        if (WfUtils.isNotEmpty(url)) {
            String valueCN = content.getLocaleValue_zh_CN();
            tips = WfUtils.isNotEmpty(valueCN) && (valueCN.endsWith("\u3002") || valueCN.endsWith("\uff01")) ? WfUtils.getPromptWordLocaleString("\u53ef\u4ee5\u6253\u5f00\u4e0b\u9762\u94fe\u63a5\u5904\u7406 ", "MessageServiceUtil_3", "bos-wf-engine") : WfUtils.getPromptWordLocaleString("\uff1b\u53ef\u4ee5\u6253\u5f00\u4e0b\u9762\u94fe\u63a5\u5904\u7406 ", "MessageServiceUtil_2", "bos-wf-engine");
            taskMsg.setToDoContent((LocaleString)WfMultiLangUtils.getMessageContentMultiLangValue((ILocaleString)content, (ILocaleString)tips, url));
        } else {
            taskMsg.setToDoContent(content);
        }
    }

    private static void wrapMessageContent(MessageInfo messageInfo, ILocaleString content) {
        String url = messageInfo.getMobContentUrl();
        LocaleString tips = new LocaleString();
        if (WfUtils.isNotEmpty(url)) {
            String valueCN = content.getLocaleValue_zh_CN();
            tips = WfUtils.isNotEmpty(valueCN) && (valueCN.endsWith("\u3002") || valueCN.endsWith("\uff01")) ? WfUtils.getPromptWordLocaleString("\u53ef\u4ee5\u6253\u5f00\u4e0b\u9762\u94fe\u63a5\u5904\u7406 ", "MessageServiceUtil_3", "bos-wf-engine") : WfUtils.getPromptWordLocaleString("\uff1b\u53ef\u4ee5\u6253\u5f00\u4e0b\u9762\u94fe\u63a5\u5904\u7406 ", "MessageServiceUtil_2", "bos-wf-engine");
            messageInfo.setMessageContent(WfMultiLangUtils.getMessageContentMultiLangValue(content, (ILocaleString)tips, url));
        } else {
            messageInfo.setMessageContent(content);
        }
    }
}

