/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.workflow.bpmn.model.IMessageSupport;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFTaskException;
import kd.bos.workflow.message.api.MsgTypeEnum;
import kd.bos.workflow.service.WfTraceType;

public final class WFMessageServiceHelper {
    public static final String OPINION = "opinion";
    public static final String USER_NAME = "userName";
    private static Log logger = LogFactory.getLog(WFMessageServiceHelper.class);

    public static void sendMessageToAdmins(MessageContext ctx, MessageInfo msg) {
        MessageServiceUtil.getMessageService().sendMessage(ctx, msg);
    }

    public static void sendLinkMessageForReminders(Long taskId, ILocaleString reminderMsg, List<Long> userIds, Long senderUserId) {
        String urgeName = WfConfigurationUtil.getUrgeName("zh_CN");
        ILocaleString prefix = WfUtils.getPromptWordLocaleString(urgeName, "WFMessageServiceHelper_13", "bos-wf-engine");
        WFMessageServiceHelper.sendLinkMessage(taskId, reminderMsg, userIds, senderUserId, prefix, null, null, MessageTypeEnum.REMINDERS.getNumber(), null);
    }

    public static void sendLinkMessageForCirculation(Long taskId, ILocaleString circulationMsg, List<Long> userIds, Long senderUserId) {
        WFMessageServiceHelper.sendLinkMessageForCirculation(taskId, circulationMsg, userIds, senderUserId, null);
    }

    public static void sendLinkMessageForCirculation(Long taskId, ILocaleString circulationMsg, List<Long> userIds, Long senderUserId, Long msgId) {
        CommandContext commandContext = Context.getCommandContext();
        HistoricTaskInstanceEntity task = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(taskId);
        String formIdForPc = MessageServiceUtil.getViewFormId(task, true);
        String formIdForMob = MessageServiceUtil.getViewFormId(task, false);
        ILocaleString prefix = WfConfigurationUtil.getLocalCirculationName();
        for (Map.Entry entry : prefix.entrySet()) {
            String prefixString = (String)entry.getValue() + ResManager.loadKDString((String)"\uff1a", (String)"WFMessageServiceHelper_14", (String)"bos-wf-engine", (Object[])new Object[0]);
            prefix.put(entry.getKey(), (Object)prefixString);
        }
        WFMessageServiceHelper.sendLinkMessage(taskId, circulationMsg, userIds, senderUserId, prefix, formIdForPc, formIdForMob, MessageTypeEnum.CIRCULATION.getNumber(), msgId);
    }

    public static void sendMessageForWarning(Long taskId, ILocaleString content, ILocaleString title, List<Long> userIds, Long senderUserId, String notifyType, String type, String templateNumber, boolean carryUrl) {
        MessageInfo info;
        CommandContext commandContext = Context.getCommandContext();
        MessageContext ctx = MessageServiceUtil.buildMessageContext(taskId);
        ILocaleString preTitle = WfUtils.getPromptWordLocaleString("\u9884\u8b66\uff1a", "WFMessageServiceHelper_3", "bos-wf-engine");
        if (MsgTypeEnum.ALARM.getNumber().equalsIgnoreCase(type)) {
            preTitle = WfUtils.getPromptWordLocaleString("\u62a5\u8b66\uff1a", "WFMessageServiceHelper_4", "bos-wf-engine");
        }
        LocaleString titleTotal = new LocaleString();
        if (WfUtils.isNotEmpty(title)) {
            for (Map.Entry entry : title.entrySet()) {
                String key = (String)entry.getKey();
                titleTotal.put((Object)key, (Object)WfUtils.getEmptyStringValue(title, key));
            }
        } else {
            HistoricTaskInstanceEntity task = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(taskId);
            for (Map.Entry entry : preTitle.entrySet()) {
                String value = (String)entry.getValue();
                String key = (String)entry.getKey();
                if (value == null) continue;
                titleTotal.put((Object)key, (Object)String.format("%s%s", WfUtils.getEmptyStringValue(preTitle, key), WfUtils.getEmptyStringValue(task.getEntityName(), key)));
            }
        }
        if (null != (info = WFMessageServiceHelper.buildMessageInfo(commandContext, taskId, content, userIds, senderUserId, (ILocaleString)titleTotal, null, null, null, carryUrl))) {
            info.setNotifyType(notifyType);
            info.setBizType(type);
            info.setType(type);
            if (StringUtil.isNotEmpty((String)templateNumber)) {
                info.setTemplateNumber(templateNumber);
            }
            commandContext.getMessageService().sendMessage(ctx, info);
        }
    }

    public static void sendMessageForWarning(Long taskId, ILocaleString content, ILocaleString title, List<Long> userIds, Long senderUserId, String notifyType, String type, String templateNumber) {
        WFMessageServiceHelper.sendMessageForWarning(taskId, content, title, userIds, senderUserId, notifyType, type, templateNumber, true);
    }

    public static void sendMessageForWarning(Long taskId, ILocaleString content, ILocaleString title, List<Long> userIds, Long senderUserId, String notifyType, String type) {
        WFMessageServiceHelper.sendMessageForWarning(taskId, content, title, userIds, senderUserId, notifyType, type, null);
    }

    private static void sendLinkMessage(Long taskId, ILocaleString message, List<Long> userIds, Long senderUserId, ILocaleString preTitle, String formId, String mobileFormId, String bizType, Long msgId) {
        CommandContext commandContext = Context.getCommandContext();
        MessageContext ctx = MessageServiceUtil.buildMessageContext(taskId);
        HistoricTaskInstanceEntity task = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(taskId);
        ILocaleString entityName = task.getEntityName();
        LocaleString title = new LocaleString();
        for (Map.Entry entry : preTitle.entrySet()) {
            String value = (String)entry.getValue();
            String key = (String)entry.getKey();
            if (value == null) continue;
            String secondPart = WfUtils.getEmptyStringValue(entityName, key);
            if (task.isBizTask() && WfUtils.isEmpty(secondPart)) {
                secondPart = (String)task.getSubject().getItem(key);
            }
            if (!WfUtils.isNotEmpty(secondPart)) continue;
            title.put((Object)key, (Object)String.format("%s%s", WfUtils.getEmptyStringValue(preTitle, key), secondPart));
        }
        ILocaleString userName = WfUtils.findUserName(task.getStarterId());
        ILocaleString localeValue = WfUtils.getPromptWordLocaleString("\u7533\u8bf7\u4eba\uff1a%1$s <br>\u610f\u89c1\uff1a%2$s", "WFMessageServiceHelper_11", "bos-wf-engine");
        ILocaleString content = WfMultiLangUtils.getMultiLangValue(localeValue, userName, message);
        MessageInfo info = WFMessageServiceHelper.buildMessageInfo(commandContext, taskId, content, userIds, senderUserId, (ILocaleString)title, formId, mobileFormId, bizType, true);
        if (null != info) {
            if (WfUtils.isNotEmpty(msgId)) {
                info.setId(msgId);
            }
            info.setBizType(bizType);
            commandContext.getMessageService().sendMessage(ctx, info);
        }
    }

    private static MessageInfo buildMessageInfo(CommandContext commandContext, Long taskId, ILocaleString content, List<Long> userIds, Long senderId, ILocaleString title, String formId, String mobileFormId, String bizType, boolean carryUrl) {
        IMessageSupport userTask;
        HistoricTaskInstanceEntity task = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(taskId);
        if (null == task) {
            if (null != WfTraceType.get() && null != WfTraceType.get().getJobInfo()) {
                return null;
            }
            throw new WFTaskException(WFErrorCode.taskNotExist());
        }
        if (null == formId) {
            formId = task.getProcessingPage();
        }
        if (null == mobileFormId) {
            mobileFormId = task.getProcessingMobilePage();
        }
        boolean isUserTask = (userTask = (IMessageSupport)((Object)ProcessDefinitionUtil.getFlowElement(task.getProcessDefinitionId(), task.getProcessInstanceId(), task.getTaskDefinitionKey()))) != null && UserTask.class.equals(userTask.getClass());
        HistoricActivityInstanceEntity activityEntity = BpmnModelUtil.instanceofYunzhijiaTask(task.getCategory()) && task.getParentTaskId() == null ? commandContext.getHistoricActivityInstanceEntityManager().findActivityByYzjAuditParentTaskId(task.getProcessInstanceId(), taskId) : commandContext.getHistoricActivityInstanceEntityManager().findActivityByTaskId(taskId);
        Long activityId = activityEntity != null ? activityEntity.getId() : 0L;
        String pCaption = "";
        String mCaption = "";
        if (WfUtils.isNotEmpty(bizType)) {
            pCaption = SerializationUtils.toJsonString((Object)MessageServiceUtil.getPCCaptionLocale(task));
            mCaption = SerializationUtils.toJsonString((Object)MessageServiceUtil.getMBCaptionLocale(task));
        } else {
            pCaption = MessageServiceUtil.getPCCaption(task);
            mCaption = MessageServiceUtil.getMBCaption(task);
        }
        MessageInfo msg = new MessageInfo();
        if (carryUrl) {
            if (task.isBizTask()) {
                msg.setContentUrl(task.getUrl());
                msg.setMobContentUrl(task.getMobileUrl());
            } else {
                String url = MessageServiceUtil.buildWebPageUrl(formId, mobileFormId, activityId, task.getBusinessKey(), isUserTask, pCaption, mCaption);
                msg.setContentUrl(url);
                msg.setMobContentUrl(url);
            }
        }
        msg.setMessageTitle(title);
        msg.setMessageContent(content);
        msg.setUserIds(userIds);
        msg.setSenderId(senderId);
        msg.setBizDataId(taskId);
        msg.setTplScene(bizType);
        String notifyTypeNumber = "message";
        if (MessageTypeEnum.CIRCULATION.getNumber().equals(bizType)) {
            msg.setType("circulate");
            notifyTypeNumber = "circulate";
        }
        msg.setNotifyType(MessageServiceUtil.getNotifyTypeByNode(notifyTypeNumber));
        return msg;
    }
}

