/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.IMessageSupport;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.cmd.MessageScheduleHelper;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class CreateToDoCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Log logger = LogFactory.getLog(this.getClass());
    private Long taskId;
    private TaskEntity task;
    private boolean async = true;
    private String todoType;
    private List<Long> userIds;
    private LocaleString taskSubject = null;

    public CreateToDoCmd(Long taskId, TaskEntity task, boolean async) {
        this.task = task;
        this.taskId = taskId;
        this.async = async;
        if (WfUtils.isEmpty(taskId) && task != null) {
            this.taskId = task.getId();
        }
    }

    public CreateToDoCmd(Long taskId, TaskEntity task, boolean async, String todoType) {
        this.taskId = taskId;
        this.task = task;
        this.async = async;
        this.todoType = todoType;
        if (WfUtils.isEmpty(taskId) && task != null) {
            this.taskId = task.getId();
        }
    }

    public CreateToDoCmd(Long taskId, TaskEntity task, boolean async, String todoType, List<Long> userIds) {
        this.taskId = taskId;
        this.task = task;
        this.async = async;
        this.todoType = todoType;
        this.userIds = userIds;
        if (WfUtils.isEmpty(taskId) && task != null) {
            this.taskId = task.getId();
        }
    }

    public CreateToDoCmd(Long taskId, TaskEntity task, boolean async, String todoType, List<Long> userIds, LocaleString taskSubject) {
        this.taskId = taskId;
        this.task = task;
        this.async = async;
        this.todoType = todoType;
        this.userIds = userIds;
        this.taskSubject = taskSubject;
        if (WfUtils.isEmpty(taskId) && task != null) {
            this.taskId = task.getId();
        }
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.argumentsCheck();
        if (this.task == null) {
            this.task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        }
        if (this.task == null) {
            throw ExceptionUtil.createWFMessageServiceException(null, null, WFErrorCode.taskNotFound(), new Object[0]);
        }
        MessageContext ctx = MessageServiceUtil.buildMessageContext(this.task.getId());
        ToDoInfo model = this.buildModel(commandContext, this.task, this.userIds);
        if (WfUtils.isEmptyForCollection(model.getUserIds())) {
            this.logger.debug(String.format("\u4efb\u52a1[%s]\u8ba1\u7b97\u7684\u53d1\u9001\u6d88\u606f\u7684\u4eba\u5458\u4e3a\u7a7a.[%s]", model.getTaskId(), model.getTitle()));
            return null;
        }
        ExecutionEntity execution = this.task.getExecution();
        if (execution != null && execution.getTransientVariableLocal("allowSendTaskReceivedMsg") != null) {
            StringBuilder sb = new StringBuilder();
            for (Long userid : this.userIds) {
                sb.append(userid).append(',');
            }
            this.task.setTransientVariableLocal("taskReceivers", sb.toString().substring(0, sb.toString().length() - 1));
            this.sendMessageForNodeOnlyTaskReceived(execution);
            execution.removeTransientVariableLocal("allowSendTaskReceivedMsg");
        }
        if (execution != null && execution.getTransientVariableLocal("isNotAllowSendTodo") != null) {
            this.logger.debug(String.format("[%s], send TaskReceived mesagge successful, not allow send to do!", this.task.getName()));
            execution.removeTransientVariableLocal("isNotAllowSendTodo");
            return null;
        }
        boolean isAllowSendTodo = MessageServiceUtil.isAllowSendTodo(this.task);
        if (this.async && isAllowSendTodo) {
            MessageScheduleHelper.sendToDoAsync(ctx, model);
        }
        commandContext.addCloseListener(new DefaultCommandContextCloseListener("todo-handler-" + model.getState().name()){

            @Override
            public void closed(CommandContext commandContext) {
                super.closed(commandContext);
            }
        });
        return null;
    }

    private void argumentsCheck() {
        if (this.task == null && WfUtils.isEmpty(this.taskId)) {
            throw new WFIllegalArgumentException("task and taskId cannot both be null");
        }
    }

    protected ToDoInfo buildModel(CommandContext commandContext, TaskEntity task, List<Long> oriUserIds) {
        LocaleString content;
        LocaleString title;
        ToDoInfo model = new ToDoInfo();
        model.setTaskId(this.taskId);
        if (WfUtils.isEmpty(this.todoType)) {
            FlowElement elem;
            BpmnModel bp;
            String taskSource = task.getSource();
            if (taskSource.equalsIgnoreCase("wf") && (bp = ProcessDefinitionUtil.getBpmnModel(task.getProcessDefinitionId(), task.getProcessInstanceId())) != null && (elem = bp.getFlowElement(task.getTaskDefinitionKey())) != null && elem.isAddSign()) {
                model.setTodoType(MessageTypeEnum.ADDSIGN.getNumber());
            }
            if ("dismissed".equalsIgnoreCase(task.getHandleState())) {
                model.setTodoType(MessageTypeEnum.REJECT.getNumber());
            }
            if (100 == task.getPriority()) {
                model.setTodoType(MessageTypeEnum.URGENCY.getNumber());
            }
            if (WfUtils.isEmpty(model.getTodoType())) {
                model.setTodoType(MessageTypeEnum.TODO.getNumber());
            }
        } else {
            model.setTodoType(this.todoType);
        }
        if (oriUserIds == null || oriUserIds.isEmpty()) {
            oriUserIds = this.getUserIds(commandContext, task);
        }
        if (this.userIds == null || this.userIds.isEmpty()) {
            this.userIds = oriUserIds;
        }
        if (oriUserIds == null || oriUserIds.isEmpty() || !MessageTypeEnum.COORDINATE.getNumber().equalsIgnoreCase(this.todoType) && !"withdrawTansferTask".equalsIgnoreCase(this.todoType)) {
            this.filterAutoTransferRule(commandContext, task, this.userIds);
        }
        if ((title = (LocaleString)this.buildTitle()) != null) {
            model.setTitle(title.getLocaleValue());
            model.setToDoTitle(title);
        }
        if ((content = (LocaleString)this.buildContent(task, this.taskSubject)) != null) {
            model.setContent(content.getLocaleValue());
            model.setToDoContent(content);
        }
        String url = TaskUtils.isBizTask(task.getSource()) ? task.getMobileUrl() : MessageServiceUtil.buildWebPageUrlForTaskEntity(task);
        model.setUserIds(oriUserIds);
        model.setUrl(url);
        model.setState(ToDoInfo.State.NEW);
        model.setNotifyType(MessageServiceUtil.getChangeNotifyType(task.getEndType()));
        model.setCheck(true);
        model.setCategory(task.getCategory());
        model.setBillNo(task.getBillNo());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("parsesubject", SerializationUtils.toJsonString((Object)this.taskSubject));
        Object subject = null;
        subject = WfUtils.isNotEmpty((ILocaleString)this.taskSubject) ? this.taskSubject : task.getSubject();
        param.put("subject", subject == null ? "" : SerializationUtils.toJsonString((Object)subject));
        param.put("entityname", SerializationUtils.toJsonString((Object)task.getEntityName()));
        param.put("processType", task != null ? task.getProcessType() : "");
        param.put("isBizTask", task.isBizTask());
        model.setParams(param);
        return model;
    }

    private ILocaleString buildTitle() {
        ILocaleString splicingTitle = WfUtils.getPromptWordLocaleString("\u8bf7\u5904\u7406%1$s\u63d0\u4ea4\u7684%2$s", "CreateToDoCmd_4", "bos-wf-engine");
        ILocaleString startName = this.task.getStartName();
        ILocaleString entityName = this.task.getEntityName();
        return WfMultiLangUtils.getMultiLangValue(splicingTitle, startName, entityName);
    }

    private ILocaleString buildContent(TaskEntity task, LocaleString taskSubject) {
        Object subject = taskSubject != null ? taskSubject : task.getSubject();
        int maxLen = 500;
        for (Map.Entry entry : subject.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!WfUtils.isNotEmpty(value) || value.length() <= 500) continue;
            subject.setItem(key, (Object)value.substring(0, 500));
        }
        ILocaleString contentPrefix = WfUtils.getPromptWordLocaleString("\u8bf7\u5904\u7406:", "CreateToDoCmd_3", "bos-wf-engine");
        return WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{new LocaleString("%s%s%s"), contentPrefix, task.getEntityName(), subject});
    }

    private List<Long> getUserIds(CommandContext commandContext, TaskEntity task) {
        ArrayList<Long> identityLinkUserIds = new ArrayList<Long>();
        if (MessageTypeEnum.COORDINATE.getNumber().equalsIgnoreCase(this.todoType)) {
            return this.userIds;
        }
        HashSet<Long> notReceiveMsgUserIds = new HashSet<Long>();
        this.findTargetUserIds(commandContext, task, identityLinkUserIds, notReceiveMsgUserIds);
        if (!identityLinkUserIds.isEmpty() && !notReceiveMsgUserIds.isEmpty()) {
            identityLinkUserIds.removeAll(notReceiveMsgUserIds);
        }
        return identityLinkUserIds;
    }

    private void filterAutoTransferRule(CommandContext commandContext, TaskEntity task, List<Long> userIds) {
        if (userIds == null || userIds.isEmpty()) {
            return;
        }
        Map<Long, Boolean> ret = commandContext.getTaskCenterRuleEntityManager().matchAutoTransferRule(task, userIds);
        if (ret == null || ret.isEmpty()) {
            return;
        }
        HashMap<Long, Long> existsDelegateAndNeedCreateToDo = new HashMap<Long, Long>();
        if (WfConfigurationUtil.existsDelegateAndNotTransfer()) {
            List<IdentityLinkEntity> identityLinkEntities = task.getIdentityLinks();
            for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                if (!"participant".equals(identityLinkEntity.getType()) || !userIds.contains(identityLinkEntity.getUserId()) || identityLinkEntity.getDelegateId() == 0L || identityLinkEntity.getOwnerId() == 0L) continue;
                existsDelegateAndNeedCreateToDo.put(identityLinkEntity.getOwnerId(), identityLinkEntity.getUserId());
            }
        }
        Iterator<Long> iter = userIds.iterator();
        while (iter.hasNext()) {
            Long t = iter.next();
            if (ret.get(t) == null || !ret.get(t).booleanValue()) continue;
            this.logger.debug(String.format("task[%s] participant[%s] match auto transfer rule", task.getId(), t));
            boolean delete = true;
            if (existsDelegateAndNeedCreateToDo.size() > 0 && WfUtils.isNotEmpty((Long)existsDelegateAndNeedCreateToDo.get(t))) {
                delete = false;
            }
            if (!delete) continue;
            iter.remove();
        }
    }

    private void findTargetUserIds(CommandContext commandContext, TaskEntity task, List<Long> identityLinkUserIds, Set<Long> notReceiveMsgUserIds) {
        List<IdentityLinkEntity> identityLinks = task.getIdentityLinks();
        for (IdentityLinkEntity identityLink : identityLinks) {
            Boolean isReceiveMsg;
            DelegateSettingEntity delegate;
            Long identityLinkUserId = identityLink.getUserId();
            Long delegateId = identityLink.getDelegateId();
            if (!WfUtils.isEmpty(delegateId) && (delegate = (DelegateSettingEntity)commandContext.getDelegateSettingEntityManager().findById(delegateId)) != null && "1".equals(delegate.getStatus()) && (isReceiveMsg = delegate.isReceiveTodoTask()) != null && !isReceiveMsg.booleanValue()) {
                notReceiveMsgUserIds.add(delegate.getAssignorId());
            }
            if (identityLink.isDeleted() || !WfUtils.isEmpty(identityLink.getCompositeTaskId())) continue;
            identityLinkUserIds.add(identityLinkUserId);
        }
    }

    private void sendMessageForNodeOnlyTaskReceived(ExecutionEntity execution) {
        FlowElement flowElement = execution.getCurrentFlowElement();
        if (!(flowElement instanceof YunzhijiaTask) || flowElement instanceof YunzhijiaTask && ((YunzhijiaTask)flowElement).getBehavior() instanceof SequentialMultiInstanceBehavior) {
            this.dispatchTaskReceivedListener(execution, flowElement);
        }
    }

    private void dispatchTaskReceivedListener(ExecutionEntity execution, FlowElement flowElement) {
        Object taskReceivers;
        boolean flag = false;
        if (flowElement instanceof IMessageSupport) {
            MessageSendModel msg;
            List<MessageSendModel> inMsgs = ((IMessageSupport)((Object)flowElement)).getInMsg();
            if (inMsgs == null) {
                return;
            }
            Iterator<MessageSendModel> iterator = inMsgs.iterator();
            while (iterator.hasNext() && !(flag = "taskReceived".equals((msg = iterator.next()).getSendevt()))) {
            }
        }
        if (flag && (taskReceivers = this.task.getTransientVariableLocal("taskReceivers")) != null) {
            this.task.setTransientVariable("auditType", "Consent");
            Object currentParticipant = this.task.getTransientVariable("currentParticipant");
            this.task.setTransientVariableLocal("currentParticipant", taskReceivers);
            this.logger.debug(String.format("over, currentParticipant[%s]", this.task.getVariable("currentParticipant")));
            this.executeTaskReceivedExecutionListeners(execution, (Activity)flowElement);
            this.task.setTransientVariableLocal("currentParticipant", currentParticipant);
            this.task.removeTransientVariable("auditType");
        }
    }

    private void executeTaskReceivedExecutionListeners(ExecutionEntity execution, Activity activity) {
        Context.getCommandContext().getProcessEngineConfiguration().getListenerNotificationHelper().executeExecutionListeners(activity, execution, "taskReceived");
    }
}

