/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.cmd;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.utils.FailMessageUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.ReflectUtil;
import kd.bos.workflow.engine.msg.AbstractMessageServiceHandler;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;

public class DealMessageCmd
implements Command<Void>,
Serializable {
    private static Log logger = LogFactory.getLog(DealMessageCmd.class);
    private static final long serialVersionUID = 1L;
    private List<Long> messageIds;
    private Long userId;
    private Boolean isResend;
    private String dealChannel;
    private static final String STR_CONFIG = "config";

    public DealMessageCmd(List<Long> messageIds, String dealChannel, Long userId, Boolean isResend) {
        this.messageIds = messageIds;
        this.dealChannel = dealChannel;
        this.userId = userId;
        this.isResend = isResend;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.messageIds == null || this.messageIds.isEmpty() || StringUtils.isBlank((Object)this.userId)) {
            return null;
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(this.userId);
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"wf_msg_message", (String)"id,title,content,entitynumber,sendername,channels,tplscene,config,toall", (QFilter[])new QFilter[]{new QFilter("id", "in", this.messageIds)});
        JSONObject failMsgs = new JSONObject();
        HashMap<Long, HashMap<String, MessageInfo>> successMsgs = new HashMap<Long, HashMap<String, MessageInfo>>();
        Map<Object, Object> unenableChannels = new HashMap();
        for (DynamicObject dynamicObject : dynObjs) {
            String[] channleArr;
            Map param;
            String msgParams = dynamicObject.getString(STR_CONFIG);
            if (msgParams != null && msgParams.contains("isAutoDeal") && !((Boolean)(param = (Map)SerializationUtils.fromJsonString((String)msgParams, Map.class)).get("isAutoDeal")).booleanValue()) continue;
            String channels = this.dealChannel;
            if (StringUtils.isBlank((CharSequence)this.dealChannel) && StringUtils.isBlank((CharSequence)(channels = dynamicObject.getString("channels")))) continue;
            for (String channel : channleArr = channels.split(",")) {
                MessageInfo message = null;
                try {
                    AbstractMessageServiceHandler serviceHandler;
                    MsgChannelInfo config = MessageChannelUtils.getChannelConfig((String)channel);
                    HashMap<String, MsgChannelInfo> params = new HashMap<String, MsgChannelInfo>();
                    message = this.buildMessageInfo(dynamicObject, channel, userIds);
                    if (config != null) {
                        params.put("msgChannelInfo", config);
                        serviceHandler = DealMessageCmd.getMessageServiceHandler(config);
                        if (!serviceHandler.canDealMessage(message, params)) continue;
                        serviceHandler.dealMessage(null, message);
                        if (!this.isResend.booleanValue()) continue;
                        HashMap<String, MessageInfo> map = (HashMap<String, MessageInfo>)successMsgs.get(message.getId());
                        if (map == null) {
                            map = new HashMap<String, MessageInfo>();
                        }
                        map.put(channel, message);
                        successMsgs.put(message.getId(), map);
                        continue;
                    }
                    if (unenableChannels.isEmpty()) {
                        unenableChannels = DealMessageCmd.getUnenbleChannels();
                    }
                    if ((config = (MsgChannelInfo)unenableChannels.get(channel)) == null) continue;
                    params.put("msgChannelInfo", config);
                    serviceHandler = DealMessageCmd.getMessageServiceHandler(config);
                    if (!serviceHandler.canDealMessage(message, params)) continue;
                    logger.info("deal message : [%s];channel : [%s] is not enable.", (Object)dynamicObject.getLong("id"), (Object)channel);
                    throw new WFMessageServiceException(null, WFErrorCode.dealMessageError(), new Object[]{channel, "channel is not enable."});
                }
                catch (Exception e) {
                    String errorInfo = WfUtils.getExceptionStacktrace(e);
                    if (message == null) {
                        message = this.buildMessageInfo(dynamicObject, channel, userIds);
                    }
                    MessageServiceUtil.updateToDoMsgContent(null, message);
                    JSONObject messageJson = failMsgs.getJSONObject(message.getId().toString());
                    if (messageJson == null) {
                        messageJson = new JSONObject();
                    }
                    JSONObject channelMessageJson = new JSONObject();
                    channelMessageJson.put("message", (Object)message);
                    channelMessageJson.put("failReason", (Object)errorInfo);
                    messageJson.put(channel, (Object)channelMessageJson);
                    failMsgs.put(message.getId().toString(), (Object)messageJson);
                }
            }
        }
        if (this.isResend.booleanValue() || !this.isResend.booleanValue() && !failMsgs.isEmpty()) {
            FailMessageUtil.dealFailMessage((JSONObject)failMsgs, successMsgs);
        }
        return null;
    }

    private MessageInfo buildMessageInfo(DynamicObject dynamicObject, String channel, List<Long> userIds) {
        MessageInfo message = new MessageInfo();
        message.setId(Long.valueOf(dynamicObject.getLong("id")));
        message.setUserIds(userIds);
        message.setTplScene(dynamicObject.getString("tplscene"));
        message.setMessageTitle(dynamicObject.getLocaleString("title"));
        message.setMessageContent(dynamicObject.getLocaleString("content"));
        message.setEntityNumber(dynamicObject.getString("entitynumber"));
        message.setMessageSenderName(dynamicObject.getLocaleString("sendername"));
        message.setTplScene(dynamicObject.getString("tplscene"));
        message.setNotifyType(channel);
        message.setToAll(dynamicObject.getBoolean("toall"));
        String params = dynamicObject.getString(STR_CONFIG);
        if (StringUtils.isNotBlank((CharSequence)params)) {
            message.setParams((Map)SerializationUtils.fromJsonString((String)params, Map.class));
        }
        return message;
    }

    private static AbstractMessageServiceHandler getMessageServiceHandler(MsgChannelInfo config) {
        logger.debug("channelServiceClass: " + config.getServiceclass());
        String serviceClass = config.getServiceclass().trim();
        String serviceClazz = serviceClass.endsWith(".java") ? serviceClass.substring(0, serviceClass.length() - 5) : serviceClass;
        return (AbstractMessageServiceHandler)ReflectUtil.instantiate(serviceClazz);
    }

    private static Map<String, MsgChannelInfo> getUnenbleChannels() {
        DynamicObject[] dynObjs;
        HashMap<String, MsgChannelInfo> channels = new HashMap<String, MsgChannelInfo>(10);
        for (DynamicObject dynObj : dynObjs = BusinessDataServiceHelper.load((String)"msg_channel", (String)"number,serviceclass,config", null)) {
            MsgChannelInfo channelInfo = new MsgChannelInfo();
            channelInfo.setServiceclass(dynObj.getString("serviceclass"));
            channelInfo.setNumber(dynObj.getString("number"));
            channelInfo.setConfig(dynObj.getString(STR_CONFIG));
            channels.put(dynObj.getString("number"), channelInfo);
        }
        return channels;
    }
}

