/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.msg.AbstractMessageServiceHandler;
import kd.bos.workflow.engine.msg.MessageServiceImpl;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.cmd.MessageScheduleHelper;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.service.IWorkflowCoreService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.task.service.MessageLogService;

public class DealToDoCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(DealToDoCmd.class);
    private Long userId;
    private boolean async = true;
    private boolean check = true;
    private boolean onlySync = false;
    private List<TaskInfo> tasks = new ArrayList<TaskInfo>();

    public DealToDoCmd(TaskInfo task, Long userId, boolean async, boolean check, boolean onlySync) {
        this.tasks.add(task);
        this.userId = userId;
        this.async = async;
        this.check = check;
        this.onlySync = onlySync;
    }

    public DealToDoCmd(TaskInfo task, Long userId, boolean async, boolean check) {
        this.tasks.add(task);
        this.userId = userId;
        this.async = async;
        this.check = check;
    }

    public DealToDoCmd(List<TaskEntity> tasks, Long userId, boolean async, boolean check) {
        this.tasks.addAll(tasks);
        this.userId = userId;
        this.async = async;
        this.check = check;
    }

    private void filterUserTasks4MismatchUserId(CommandContext commandContext) {
        try {
            List userTasks = this.tasks.stream().filter(task -> "UserTask".equalsIgnoreCase(task.getCategory())).collect(Collectors.toList());
            if (userTasks.isEmpty()) {
                return;
            }
            List userTaskIds = userTasks.stream().map(task -> task.getId()).collect(Collectors.toList());
            QFilter[] filters = new QFilter[]{new QFilter("taskid", "in", userTaskIds)};
            HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager = commandContext.getProcessEngineConfiguration().getHistoricIdentityLinkEntityManager();
            List historicIdentityLinkEntities = historicIdentityLinkEntityManager.findByQueryFilters(filters);
            historicIdentityLinkEntities.stream().forEach(identityLinkEntity -> {
                if (this.userId.equals(identityLinkEntity.getUserId())) {
                    userTaskIds.remove(identityLinkEntity.getTaskId());
                }
            });
            if (userTaskIds.isEmpty()) {
                return;
            }
            Iterator<TaskInfo> iterator = this.tasks.iterator();
            while (iterator.hasNext()) {
                TaskInfo task2 = iterator.next();
                if (!userTaskIds.contains(task2.getId())) continue;
                iterator.remove();
            }
        }
        catch (Exception e) {
            logger.info("filterUserTasks4MismatchUserId has error" + WfUtils.getExceptionStacktrace(e));
        }
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.argumentsCheck();
        this.filterUserTasks4MismatchUserId(commandContext);
        if (WfUtils.isEmptyForCollection(this.tasks)) {
            logger.debug("tasks collection is empty, stop deal todo.");
            return null;
        }
        if (this.async) {
            ArrayList<Long> ids = new ArrayList<Long>(this.tasks.size());
            for (TaskInfo task : this.tasks) {
                ids.add(task.getId());
            }
            logger.debug(String.format("dealtodocmd-taskid:%s-userid:%s-async:%s", ((Object)ids).toString(), this.userId, this.async));
            String fields = String.format("%s, %s", "id", "taskId");
            QFilter[] filters = new QFilter[]{new QFilter("taskId", "in", ids)};
            DynamicObjectCollection entities = QueryServiceHelper.query((String)"wf_hiactinst", (String)fields, (QFilter[])filters);
            HashMap<Long, Long> idMap = new HashMap<Long, Long>();
            for (DynamicObject entity : entities) {
                idMap.put(entity.getLong("taskId"), entity.getLong("id"));
            }
            for (TaskInfo task : this.tasks) {
                boolean isSSCApprove = BpmnModelUtil.instanceofSSCApprover(task.getCategory());
                if (isSSCApprove) {
                    logger.debug(String.format("sscapprove task[%s] should not be deal!", task.getId()));
                    continue;
                }
                if (ModelType.NoCodeFlow.name().equalsIgnoreCase(task.getProcessType())) continue;
                MessageContext ctx = MessageServiceUtil.buildMessageContext(task);
                ToDoInfo info = MessageServiceUtil.buildDealToDoModel(commandContext, this.userId, (Long)idMap.get(task.getId()), task);
                MessageScheduleHelper.sendDealToDoAsync(ctx, info);
            }
        } else {
            TaskInfo taskInfo = this.tasks.get(0);
            logger.debug(String.format("dealtodocmd-taskid:%s-userid:%s-async:%s", taskInfo.getId(), this.userId, this.async));
            MessageContext ctx = MessageServiceUtil.buildMessageContext(taskInfo);
            ToDoInfo model = MessageServiceUtil.buildDealToDoModel(commandContext, this.userId, null, taskInfo);
            boolean isSSCApprove = BpmnModelUtil.instanceofSSCApprover(taskInfo.getCategory());
            if (isSSCApprove) {
                logger.debug(String.format("sscapprove task[%s] should not be deal!", taskInfo.getId()));
                return null;
            }
            if (ModelType.NoCodeFlow.name().equalsIgnoreCase(taskInfo.getProcessType())) {
                return null;
            }
            if (WfUtils.isNotEmpty(model.getNotifyType())) {
                String[] todoChannels = model.getNotifyType().split(",");
                logger.debug(String.format("dealtodocmd-taskid:%s-todochanels:%s", model.getTaskId(), todoChannels));
                ArrayList<String> chas = new ArrayList<String>(Arrays.asList(todoChannels));
                for (String channel : todoChannels) {
                    try {
                        channel = channel.trim();
                        MessageServiceImpl impl = (MessageServiceImpl)commandContext.getMessageService();
                        AbstractMessageServiceHandler messageServiceHandler = impl.getService(channel);
                        if (!WfUtils.isNotEmpty(channel) || !MessageScheduleHelper.canSynch(channel, messageServiceHandler)) continue;
                        chas.remove(channel);
                        model.setState(ToDoInfo.State.DEAL);
                        messageServiceHandler.dealToDo(ctx, model);
                        if (ToDoInfo.State.NEW.equals((Object)model.getState()) || ToDoInfo.State.DEAL.equals((Object)model.getState()) || ToDoInfo.State.DELETE.equals((Object)model.getState()) || ToDoInfo.State.DELETEANDCREATE.equals((Object)model.getState())) {
                            ((MessageLogService)((IWorkflowCoreService)ServiceFactory.getService(IWorkflowCoreService.class)).getService(MessageLogService.class)).insertTaskJob(ctx, model, channel, "DEALSUCCESS");
                        }
                        if (!this.check || !MessageScheduleHelper.canCheckJob(messageServiceHandler)) continue;
                        commandContext.getJobManager().createTimeJobForCheckToDoJob(ctx, model, channel);
                    }
                    catch (Exception e) {
                        logger.warn(String.format("dealtodocmd-invoke synchronization errored, taskId: %s, channel: %s", model.getTaskId(), model.getNotifyType()));
                        if (this.onlySync) continue;
                        model.setState(ToDoInfo.State.DEAL);
                        MessageScheduleHelper.sendDealToDoAsync(ctx, model);
                    }
                }
                if (!this.onlySync && chas != null && chas.size() > 0) {
                    String channelArray = MessageScheduleHelper.getChannelInfo(chas);
                    logger.debug(String.format("dealtodocmd-taskid:%s-todochanels:%s-notcansynch", model.getTaskId(), channelArray));
                    if (channelArray.length() > 0) {
                        model.setState(ToDoInfo.State.DEAL);
                        model.setNotifyType(channelArray);
                        MessageScheduleHelper.sendDealToDoAsync(ctx, model);
                    }
                }
            }
        }
        commandContext.addCloseListener(new DefaultCommandContextCloseListener("dealToDoCmd-execute"){

            @Override
            public void closed(CommandContext commandContext) {
                super.closed(commandContext);
            }
        });
        return null;
    }

    private void argumentsCheck() {
        if (this.tasks.isEmpty()) {
            throw new WFIllegalArgumentException("tasks is empty!");
        }
        if (this.userId == null) {
            throw new WFIllegalArgumentException("userId is null");
        }
    }
}

