/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.cmd;

import java.util.List;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.cmd.CreateToDoCmd;
import kd.bos.workflow.engine.msg.cmd.MessageScheduleHelper;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class DeleteDealToDoAndCreateToDoCmd
implements Command<Void> {
    private Long taskId;
    private boolean async = true;
    private List<Long> userIds;
    private String todoType;

    public DeleteDealToDoAndCreateToDoCmd(Long taskId, boolean async) {
        this.taskId = taskId;
        this.async = async;
    }

    public DeleteDealToDoAndCreateToDoCmd(Long taskId, boolean async, List<Long> userIds, String todoType) {
        this.taskId = taskId;
        this.async = async;
        this.userIds = userIds;
        this.todoType = todoType;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new WFIllegalArgumentException("taskId is null!");
        }
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        ToDoInfo model = new CreateToDoCmd(this.taskId, task, this.async).buildModel(commandContext, task, this.userIds);
        if (this.userIds == null || this.userIds.isEmpty()) {
            this.userIds = model.getUserIds();
        }
        model.setTodoType(WfUtils.isEmpty(this.todoType) ? MessageTypeEnum.TODO.getNumber() : this.todoType);
        model.setState(ToDoInfo.State.DELETEANDCREATE);
        MessageContext ctx = MessageServiceUtil.buildMessageContext(this.taskId);
        boolean isAllowSendTodo = MessageServiceUtil.isAllowSendTodo(task);
        if (!isAllowSendTodo || ModelType.NoCodeFlow.name().equalsIgnoreCase(task.getProcessType())) {
            return null;
        }
        MessageScheduleHelper.sendToDoAsync(ctx, model);
        commandContext.addCloseListener(new DefaultCommandContextCloseListener("deleteDealToDoAndCreateToDoCmd-execute"){

            @Override
            public void closed(CommandContext commandContext) {
                super.closed(commandContext);
            }
        });
        return null;
    }
}

