/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.msg.AbstractMessageServiceHandler;
import kd.bos.workflow.engine.msg.MessageServiceImpl;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.cmd.MessageScheduleHelper;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.service.IWorkflowCoreService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.task.service.MessageLogService;

public class DeleteToDoCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(DeleteToDoCmd.class);
    private Long taskId;
    private List<Long> userIds;
    private boolean async = true;
    private boolean check;

    public DeleteToDoCmd(Long taskId, List<Long> userIds, boolean async, boolean check) {
        this.taskId = taskId;
        this.userIds = userIds;
        this.async = async;
        this.check = check;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.argumentsCheck();
        MessageContext ctx = MessageServiceUtil.buildMessageContext(this.taskId);
        ToDoInfo model = new ToDoInfo();
        model.setTaskId(this.taskId);
        model.setUserIds(this.userIds);
        model.setState(ToDoInfo.State.DELETE);
        model.setCheck(this.check);
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        Long processInstanceId = 0L;
        String taskDefinitionKey = "";
        boolean isAllowSendTodo = true;
        String processType = "";
        if (task != null) {
            model.setNotifyType(MessageServiceUtil.getChangeNotifyType(task.getEndType()));
            model.setBillNo(task.getBillNo());
            processInstanceId = task.getProcessInstanceId();
            taskDefinitionKey = task.getTaskDefinitionKey();
            isAllowSendTodo = MessageServiceUtil.isAllowSendTodo(task);
            processType = task.getProcessType();
        } else {
            HistoricTaskInstanceEntity hisTask = (HistoricTaskInstanceEntity)Context.getCommandContext().getHistoricTaskInstanceEntityManager().findById(this.taskId);
            if (hisTask != null) {
                model.setNotifyType(MessageServiceUtil.getChangeNotifyType(hisTask.getEndType()));
                model.setBillNo(hisTask.getBillNo());
                processInstanceId = hisTask.getProcessInstanceId();
                taskDefinitionKey = hisTask.getTaskDefinitionKey();
                isAllowSendTodo = MessageServiceUtil.isAllowSendTodo(hisTask);
                processType = hisTask.getProcessType();
            } else {
                model.setNotifyType(MessageServiceUtil.getNotifyTypeByNode("task"));
            }
        }
        if (!isAllowSendTodo || ModelType.NoCodeFlow.name().equalsIgnoreCase(processType)) {
            return null;
        }
        if (this.async) {
            MessageScheduleHelper.sendToDoAsync(ctx, model);
        } else if (WfUtils.isNotEmpty(model.getNotifyType())) {
            String channelArray;
            String[] todoChannels = model.getNotifyType().split(",");
            ArrayList<String> chas = new ArrayList<String>(Arrays.asList(todoChannels));
            for (String channel : todoChannels) {
                try {
                    MessageServiceImpl impl = (MessageServiceImpl)commandContext.getMessageService();
                    AbstractMessageServiceHandler messageServiceHandler = impl.getService(channel);
                    if (!MessageScheduleHelper.canSynch(channel, messageServiceHandler)) continue;
                    chas.remove(channel);
                    messageServiceHandler.deleteToDo(ctx, model);
                    logger.debug(String.format("invoke synchronization successfully, taskId: %s, channel: %s", model.getTaskId(), channel));
                    ((MessageLogService)((IWorkflowCoreService)ServiceFactory.getService(IWorkflowCoreService.class)).getService(MessageLogService.class)).insertTaskJob(ctx, model, channel, "DEALSUCCESS");
                }
                catch (Exception e) {
                    MessageScheduleHelper.sendToDoAsync(ctx, model);
                    logger.error(e.getMessage());
                }
            }
            if (chas != null && chas.size() > 0 && (channelArray = MessageScheduleHelper.getChannelInfo(chas)).length() > 0) {
                model.setNotifyType(channelArray);
                MessageScheduleHelper.sendToDoAsync(ctx, model);
            }
        }
        commandContext.addCloseListener(new DefaultCommandContextCloseListener("deleteToDoCmd-execute"){

            @Override
            public void closed(CommandContext commandContext) {
                super.closed(commandContext);
            }
        });
        return null;
    }

    private void argumentsCheck() {
        if (this.taskId == null) {
            throw new WFIllegalArgumentException("taskId is null");
        }
        if (this.userIds == null || this.userIds.isEmpty()) {
            throw new WFIllegalArgumentException("userIds is null or empty");
        }
    }
}

