/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.cmd;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.msg.AbstractMessageServiceHandler;
import kd.bos.workflow.engine.msg.MessageServiceImpl;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;

public final class MessageScheduleHelper {
    private static Log logger = LogFactory.getLog(MessageScheduleHelper.class);

    public static void sendToDoAsync(MessageContext ctx, ToDoInfo info) {
        if (info.getNotifyType() != null && info.getNotifyType().length() > 0) {
            String[] types = info.getNotifyType().split(",");
            CommandContext commandContext = Context.getCommandContext();
            String url = info.getUrl();
            for (String type : types) {
                if (!WfUtils.isNotEmpty(type) || !WfConfigurationUtil.isEnabled(type)) continue;
                if (!("dingding".equals(type) || "weixinqy".equals(type) || "welink".equals(type))) {
                    if (WfUtils.isNotEmpty(url)) {
                        StringBuilder newUrl = new StringBuilder(url);
                        newUrl = newUrl.append("&apptype=").append(type);
                        info.setUrl(newUrl.toString());
                    }
                } else {
                    info.setUrl(url);
                }
                boolean showUrlInWFSmsMessgae = WfConfigurationUtil.isShowUrlInWFSmsMessgae();
                info.getParams().put("showurlinwfsms", showUrlInWFSmsMessgae);
                JobEntity job = commandContext.getJobManager().createToDoJob(ctx, info, type);
                commandContext.getJobManager().scheduleAsyncJob(job);
            }
        }
    }

    public static void sendDealToDoAsync(MessageContext ctx, ToDoInfo info) {
        if (info.getNotifyType() != null && info.getNotifyType().length() > 0) {
            String[] types = info.getNotifyType().split(",");
            CommandContext commandContext = Context.getCommandContext();
            for (String type : types) {
                if (!WfUtils.isNotEmpty(type) || !WfConfigurationUtil.isEnabled(type)) continue;
                info.setState(ToDoInfo.State.DEAL);
                JobEntity job = commandContext.getJobManager().createToDoJob(ctx, info, type);
                commandContext.getJobManager().scheduleAsyncJob(job);
                MessageServiceImpl impl = (MessageServiceImpl)commandContext.getMessageService();
                AbstractMessageServiceHandler messageServiceHandler = impl.getService(type);
                logger.debug(String.format("messageScheduleHelper-taskId: %s, serviceHandler:%s", info.getTaskId(), type));
                if (!MessageScheduleHelper.canCheckJob(messageServiceHandler)) continue;
                commandContext.getJobManager().createTimeJobForCheckToDoJob(ctx, info, type);
                logger.debug(String.format("messageScheduleHelper-taskId: %s, serviceHandler:%s-pushcheckjob", info.getTaskId(), type));
            }
        }
    }

    @Deprecated
    public static void sendToDoAsyncExceptYunzhijia(MessageContext ctx, ToDoInfo info) {
        if (info.getNotifyType() != null && info.getNotifyType().length() > 0) {
            String[] types = info.getNotifyType().split(",");
            CommandContext commandContext = Context.getCommandContext();
            for (String type : types) {
                if (!WfUtils.isNotEmpty(type) || !WfConfigurationUtil.isEnabled(type) || "yunzhijia".equalsIgnoreCase(type) || "yunzhijiaeco".equalsIgnoreCase(type)) continue;
                JobEntity job = commandContext.getJobManager().createToDoJob(ctx, info, type);
                commandContext.getJobManager().scheduleAsyncJob(job);
            }
        }
    }

    public static void sendMessageAsync(MessageContext ctx, List<MessageInfo> infos) {
        if (infos != null && !infos.isEmpty()) {
            CommandContext commandContext = Context.getCommandContext();
            for (MessageInfo messageInfo : infos) {
                String notifyType = messageInfo.getNotifyType();
                if (WfUtils.isNotEmpty(notifyType)) {
                    String[] channels = notifyType.split(",");
                    StringBuilder channelBuilders = new StringBuilder();
                    for (String channel : channels) {
                        String c = channel.trim();
                        if (MessageChannels.MC.getNumber().equalsIgnoreCase(c)) {
                            channelBuilders.append(c).append(",");
                            continue;
                        }
                        if (WfUtils.isEmpty(c) || MsgServiceCache.getMsgChannel((String)c) == null) {
                            logger.debug(String.format("MessageScheduleHelper-sendMessageAsync-%s is not enable", notifyType));
                            continue;
                        }
                        channelBuilders.append(c).append(",");
                    }
                    logger.debug(String.format("MessageScheduleHelper-sendMessageAsync-%s and channel is %s", messageInfo.getContent(), channelBuilders.toString()));
                    messageInfo.setNotifyType(channelBuilders.toString());
                }
                messageInfo = MessageScheduleHelper.buildMessage(ctx, messageInfo);
                JobEntity job = commandContext.getJobManager().createMessageJob(ctx, messageInfo);
                commandContext.getJobManager().scheduleAsyncJob(job);
            }
        }
    }

    private static MessageInfo buildMessage(MessageContext ctx, MessageInfo info) {
        DynamicObject proc;
        ILocaleString content = info.getMessageContent();
        if (WfUtils.isNotEmpty(content)) {
            ILocaleString title = info.getMessageTitle();
            boolean titleIsEmpty = WfUtils.isEmpty(title);
            LocaleString tempTitle = new LocaleString();
            for (Map.Entry entry : content.entrySet()) {
                String value = (String)entry.getValue();
                entry.setValue(MessageServiceUtil.getContent(value));
                if (!titleIsEmpty) continue;
                tempTitle.put(entry.getKey(), (Object)MessageServiceUtil.getTitle(value));
            }
            info.setMessageContent(content);
            if (titleIsEmpty) {
                title = tempTitle;
            } else {
                for (Map.Entry entry : title.entrySet()) {
                    entry.setValue(MessageServiceUtil.getTitle((String)entry.getValue()));
                }
            }
            info.setMessageTitle(title);
        }
        info.setSendTime(new Date(System.currentTimeMillis()));
        if (!MessageTypeEnum.PROCEND.getNumber().equals(info.getTplScene()) && !MessageTypeEnum.ADMINALARM.getNumber().equals(info.getTplScene())) {
            info.setBizDataId(ctx.getTaskId());
        }
        Long procInstId = ctx.getProcessInstanceId();
        boolean isBizFlow = false;
        boolean isNoCodeFlow = false;
        if (WfUtils.isNotEmpty(procInstId) && (proc = BusinessDataServiceHelper.loadSingle((Object)procInstId, (String)EntityNumberConstant.getHiProcInstEntityNumber(), (String)"processtype")) != null) {
            String procType = proc.getString("processtype");
            if ("BizFlow".equalsIgnoreCase(procType)) {
                isBizFlow = true;
            }
            if (ModelType.NoCodeFlow.name().equals(procType)) {
                isNoCodeFlow = true;
            }
        }
        if (isBizFlow) {
            info.setMessageTag(WfUtils.getPromptWordLocaleString("\u4e1a\u52a1\u6d41", "MessageScheduleHelper_0", "bos-wf-engine"));
        } else if (isNoCodeFlow) {
            info.setSource(ModelType.NoCodeFlow.name());
            info.setMessageTag(WfUtils.getPromptWordLocaleString("\u65e0\u4ee3\u7801\u5e73\u53f0", "MessageScheduleHelper_2", "bos-wf-engine"));
            if (info.getMessageSenderName() == null) {
                info.setMessageSenderName(WfUtils.getPromptWordLocaleString("\u6d41\u7a0b\u4e2d\u5fc3", "MessageScheduleHelper_3", "bos-wf-engine"));
            }
        } else {
            info.setMessageTag(WfUtils.getPromptWordLocaleString("\u5de5\u4f5c\u6d41", "MessageScheduleHelper_1", "bos-wf-engine"));
        }
        if ("NoCodeFlow".equals(info.getSource())) {
            info.setEntityNumber("wf_task");
        } else {
            info.setEntityNumber("wfNode".equals(info.getSource()) ? "" : ctx.getEntityNumber());
        }
        info.setPubaccNumber("flowassist");
        if (MessageTypeEnum.CIRCULATION.getNumber().equals(info.getTplScene())) {
            info.setOperation(MessageTypeEnum.CIRCULATION.getNumber());
        }
        Map param = info.getParams();
        param.put("messageContext", SerializationUtils.toJsonString((Object)ctx));
        boolean showUrlInWFSmsMessgae = WfConfigurationUtil.isShowUrlInWFSmsMessgae();
        param.put("showurlinwfsms", showUrlInWFSmsMessgae);
        return info;
    }

    public static String getChannelInfo(List<String> channelList) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < channelList.size(); ++i) {
            String chan = channelList.get(i);
            if (!WfUtils.isNotEmpty(chan)) continue;
            if (i == channelList.size() - 1) {
                sb.append(chan.trim());
                continue;
            }
            sb.append(chan.trim()).append(",");
        }
        return sb.toString();
    }

    public static boolean canSynch(String channel, AbstractMessageServiceHandler serviceHandler) {
        boolean canSynch = false;
        if (WfConfigurationUtil.isEnabled(channel) && serviceHandler != null && serviceHandler.canSynch()) {
            canSynch = true;
        }
        return canSynch;
    }

    public static boolean canCheckJob(AbstractMessageServiceHandler serviceHandler) {
        boolean canCheckJob = false;
        if (serviceHandler != null && serviceHandler.canCheck()) {
            canCheckJob = true;
        }
        return canCheckJob;
    }
}

