/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.msg.cmd.SendTextMessageForNodeCmd;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.nocode.NoCodeFlowUtil;

public class NoCodeSendTextMessageForNodeCmd
extends SendTextMessageForNodeCmd {
    private transient Log log = LogFactory.getLog(this.getClass());

    public NoCodeSendTextMessageForNodeCmd(DelegateExecution execution, String activityId, List<MessageSendModel> messageModel, String sendEvt, boolean async) {
        super(execution, activityId, messageModel, sendEvt, async);
    }

    @Override
    protected List<MessageInfo> buildSendModelInfo(CommandContext commandContext, List<MessageSendModel> models) {
        List<MessageInfo> modelInfos = super.buildSendModelInfo(commandContext, models);
        String businessKey = this.execution.getBusinessKey();
        String entityNumber = this.execution.getEntityNumber();
        ExecutionEntity executionEntity = (ExecutionEntity)this.execution;
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(executionEntity.getProcessDefinitionId(), executionEntity.getSchemeId(), executionEntity.getProcessInstanceId());
        FlowElement flowElement = bpmnModel.getFlowElement(this.activityId);
        String phones = flowElement.getAttributeValue("extData.noCode_phones");
        String emails = flowElement.getAttributeValue("extData.noCode_emails");
        List<Object> phoneList = new ArrayList();
        if (WfUtils.isNotEmpty(phones)) {
            phoneList = Arrays.asList(phones.split(";"));
        }
        List<Object> emailList = new ArrayList();
        if (WfUtils.isNotEmpty(emails)) {
            emailList = Arrays.asList(emails.split(";"));
        }
        if (phoneList.isEmpty() && emailList.isEmpty()) {
            return modelInfos;
        }
        String notifyType = null;
        if (models != null && !models.isEmpty()) {
            MessageSendModel model = models.get(0);
            notifyType = model.getNotifytype();
        }
        notifyType = notifyType != null ? notifyType : "";
        String smsType = "sms";
        String emailType = "email";
        boolean enableSms = false;
        boolean enableEmail = false;
        if (notifyType.contains(smsType)) {
            MsgChannelInfo smsConfig = MessageChannelUtils.getChannelConfig((String)smsType);
            if (smsConfig != null && smsConfig.isEnable()) {
                enableSms = true;
            } else {
                this.log.debug("Sms not enabled.");
            }
        }
        if (notifyType.contains(emailType)) {
            MsgChannelInfo emailConfig = MessageChannelUtils.getChannelConfig((String)emailType);
            if (emailConfig != null && emailConfig.isEnable()) {
                enableEmail = true;
            } else {
                this.log.debug("Email not enabled.");
            }
        }
        if (!enableSms && !enableEmail) {
            this.log.debug("Sms or Email not enabled.");
            return modelInfos;
        }
        DynamicObject dynObj = WfUtils.findBusinessObject(businessKey, entityNumber);
        for (MessageSendModel model : models) {
            MessageInfo info;
            if (enableSms && !phoneList.isEmpty()) {
                info = this.createMessageInfo(businessKey, entityNumber, model);
                info.setNotifyType(smsType);
                info.getParams().put("phone", this.getRealValueList(phoneList, dynObj));
                modelInfos.add(info);
            }
            if (!enableEmail || emailList.isEmpty()) continue;
            info = this.createMessageInfo(businessKey, entityNumber, model);
            info.setSignleEmail(true);
            info.setNotifyType(emailType);
            info.getParams().put("email", this.getRealValueList(emailList, dynObj));
            modelInfos.add(info);
        }
        return modelInfos;
    }

    private List<String> getRealValueList(List<String> list, DynamicObject dynObj) {
        ArrayList<String> ret = new ArrayList<String>(list.size());
        for (String item : list) {
            Object value = null;
            try {
                item = item.replaceAll("\\$(\\{\\s*proc\\..+?\\})", "$1");
                value = NoCodeFlowUtil.parseNoCodeCommonExpression(item, this.execution, false, dynObj);
            }
            catch (Exception e) {
                this.log.error(String.format("parse email or phone failed, %s", WfUtils.getExceptionStacktrace(e)));
            }
            if (value == null) continue;
            if (value instanceof String) {
                String[] arr;
                for (String realValue : arr = ((String)value).split(",")) {
                    ret.add(realValue.replace("'", ""));
                }
                continue;
            }
            this.log.debug(String.format("Incorrect format. expression: %s  value: %s", item, value));
        }
        return ret;
    }

    private MessageInfo createMessageInfo(String businessKey, String entityNumber, MessageSendModel model) {
        String value;
        String lang;
        MessageInfo info = new MessageInfo();
        if (WfUtils.isNotEmpty(model.getContent())) {
            ILocaleString content = this.handleData(model.getContent());
            LocaleString messageContent = new LocaleString();
            for (Map.Entry entry : content.entrySet()) {
                lang = (String)entry.getKey();
                value = (String)entry.getValue();
                messageContent.put((Object)lang, (Object)ExpressionCalculatorUtil.contentParser(value, businessKey, entityNumber, this.execution, lang, true));
            }
            info.setMessageContent((ILocaleString)messageContent);
        }
        if (WfUtils.isJSONObject(model.getNotifysubject())) {
            ILocaleString title = this.handleData(model.getNotifysubject());
            LocaleString messageTitle = new LocaleString();
            for (Map.Entry entry : title.entrySet()) {
                lang = (String)entry.getKey();
                value = (String)entry.getValue();
                messageTitle.put((Object)lang, (Object)ExpressionCalculatorUtil.contentParser(value, businessKey, entityNumber, this.execution, lang, true));
            }
            info.setMessageTitle((ILocaleString)messageTitle);
        }
        info.setSendEvt(model.getSendevt());
        info.setMessageType(model.getMessagetype());
        info.setNotifyType(model.getNotifytype());
        info.setNotify(model.isNotify());
        info.setTemplateNumber(model.getTemplateid());
        info.setSource("wfNode");
        return info;
    }
}

