/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.msg.cmd.MessageScheduleHelper;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class SendMessageCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private MessageContext ctx;
    private MessageInfo msg;
    private boolean async = true;

    public SendMessageCmd(MessageContext ctx, MessageInfo msg, boolean async) {
        this.ctx = ctx;
        this.msg = msg;
        this.async = async;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.argumentsCheck();
        ArrayList<MessageInfo> infos = new ArrayList<MessageInfo>();
        infos.add(this.msg);
        if (this.async) {
            MessageScheduleHelper.sendMessageAsync(this.ctx, infos);
        }
        return null;
    }

    private void argumentsCheck() {
        if (this.ctx == null) {
            throw new WFIllegalArgumentException("ctx is null");
        }
        if (this.msg == null) {
            throw new WFIllegalArgumentException("msg is null");
        }
    }
}

