/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.util.PhoneI18nValidator;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.msg.AbstractMessageServiceHandler;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.ITaskMsg;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.util.dingding.DingdingCommonUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaToDoUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;
import org.apache.commons.collections.CollectionUtils;

public class AbstractServiceHandler
extends AbstractMessageServiceHandler {
    private static final Log logger = LogFactory.getLog(AbstractServiceHandler.class);
    protected static final String TYPE = "";

    public String getServiceType() {
        return TYPE;
    }

    private String getServiceType(Object info) {
        String serviceType = this.getServiceType();
        if (WfUtils.isEmpty(serviceType)) {
            ToDoInfo todoInfo;
            Map params;
            if (info instanceof MessageInfo) {
                serviceType = ((MessageInfo)info).getNotifyType();
            } else if (info instanceof ToDoInfo && (params = (todoInfo = (ToDoInfo)info).getParams()) != null && params.containsKey("serviceType")) {
                serviceType = (String)params.get("serviceType");
            }
        }
        logger.debug(String.format("AbstractServiceHandler_serviceType[%s]", serviceType));
        return serviceType;
    }

    public void updateTodoContent(ToDoInfo todoInfo) {
        MessageServiceUtil.updateToDoMsgContent(this.config, (ITaskMsg)todoInfo);
    }

    public void createToDo(MessageContext ctx, ToDoInfo todoInfo) {
        this.inspectChannelInfo(todoInfo);
        try {
            String processType;
            logger.debug("create wexinqy task todo " + todoInfo);
            this.wrappMessageUrlDomain(todoInfo, null);
            String string = processType = WfUtils.isNotEmptyForMap(todoInfo.getParams()) ? todoInfo.getParams().get("processType") : TYPE;
            if (!ModelType.NoCodeFlow.name().equals(processType)) {
                this.updateTodoContent(todoInfo);
            }
            this.clearMessageUserCollection(todoInfo, null);
        }
        catch (Exception e) {
            logger.error(String.format("AbstractServiceHandler_createtodo has error: %s", WfUtils.getExceptionStacktrace(e)));
        }
    }

    protected void clearMessageUserCollection(ToDoInfo todoInfo, MessageInfo messageInfo) {
        List userIds;
        String notifyType;
        String string = notifyType = WfUtils.isNotNullObject(messageInfo) ? messageInfo.getNotifyType() : TYPE;
        if ("mcenter".equalsIgnoreCase(notifyType)) {
            return;
        }
        List list = userIds = todoInfo != null ? todoInfo.getUserIds() : messageInfo.getUserIds();
        if (userIds == null || userIds.isEmpty()) {
            return;
        }
        ArrayList backupUserIds = new ArrayList(userIds);
        ArrayList<Long> afterClearUserIds = new ArrayList<Long>();
        try {
            QFilter f1 = new QFilter("enable", "=", (Object)Character.valueOf('1'));
            QFilter f2 = new QFilter("id", "in", (Object)userIds);
            DynamicObjectCollection userDatas = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{f1, f2});
            if (userDatas != null && !userDatas.isEmpty()) {
                for (DynamicObject userData : userDatas) {
                    Long uId = userData.getLong("id");
                    afterClearUserIds.add(uId);
                    backupUserIds.remove(uId);
                }
                if (afterClearUserIds.size() != userIds.size()) {
                    logger.debug(String.format("part users[%s]  is not enable", CollectionUtils.subtract((Collection)userIds, afterClearUserIds)));
                }
            } else {
                logger.debug(String.format("all user of msg is not enable [%s]", userIds));
            }
        }
        catch (Exception e) {
            logger.error(String.format("query user is error[%s]", WfUtils.getExceptionStacktrace(e)));
        }
        if (todoInfo != null) {
            todoInfo.setUserIds(afterClearUserIds);
        } else {
            messageInfo.setUserIds(afterClearUserIds);
            if (!backupUserIds.isEmpty()) {
                Map userFilter = (Map)messageInfo.getParams().get("userFilter");
                if (userFilter.containsKey("systemDisabled")) {
                    List systemDisableUserIds = (List)userFilter.get("systemDisabled");
                    systemDisableUserIds.addAll(backupUserIds);
                } else {
                    userFilter.put("systemDisabled", backupUserIds);
                }
            }
        }
    }

    public void dealToDo(MessageContext ctx, ToDoInfo info) {
    }

    public void deleteToDo(MessageContext ctx, ToDoInfo info) {
    }

    public void checkTodo(MessageContext ctx, ToDoInfo info) {
    }

    public void sendMessage(MessageContext ctx, MessageInfo messageInfo) {
        this.inspectChannelInfo(messageInfo);
        try {
            this.wrappMessageUrlDomain(null, messageInfo);
            if (!ModelType.NoCodeFlow.name().equalsIgnoreCase(messageInfo.getSource())) {
                MessageServiceUtil.updateToDoMsgContent(this.config, messageInfo);
            }
            this.clearMessageUserCollection(null, messageInfo);
        }
        catch (Exception e) {
            logger.error(String.format("AbstractServiceHandler_sendMessage has error: %s", WfUtils.getExceptionStacktrace(e)));
        }
    }

    private void inspectChannelInfo(Object info) {
        String serviceType = this.getServiceType(info);
        if (WfUtils.isEmpty(serviceType)) {
            return;
        }
        MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)serviceType);
        if (!"mcenter".equals(serviceType) && msgChannelInfo == null) {
            logger.debug(String.format("%s is disable state.", serviceType));
            throw new KDException(WFErrorCode.sendMsgErrorCode(serviceType), new Object[]{String.format("[%s] channel is disable state.", serviceType)});
        }
        if (!this.inspectChannelInfo(msgChannelInfo)) {
            throw new KDException(WFErrorCode.sendMsgErrorCode(serviceType), new Object[]{String.format("[%s] channel configuration error.", serviceType)});
        }
    }

    public boolean inspectChannelInfo(MsgChannelInfo msgChannelInfo) {
        return true;
    }

    public void dealMessage(MessageContext ctx, MessageInfo messageInfo) {
    }

    public void startProcessInstance(MessageContext ctx, Long proceInstanceId) {
    }

    public void deleteProcessInstance(MessageContext ctx, Long proceInstanceId) {
    }

    public void completeProcessInstance(MessageContext ctx, Long proceInstanceId) {
    }

    public boolean canDealMessage(MessageInfo message, Map<String, Object> param) {
        return super.canDealMessage(message, param);
    }

    public boolean canSynch() {
        return super.canSynch();
    }

    public boolean canCheck() {
        return super.canCheck();
    }

    protected void wrappMessageUrlDomain(ToDoInfo todoInfo, MessageInfo messageInfo) {
        String originalUrl;
        logger.debug("AbstractServiceHandler_wrappMessageUrlDomain enter");
        boolean isTodoUrl = todoInfo != null;
        String string = originalUrl = isTodoUrl ? todoInfo.getUrl() : messageInfo.getMobContentUrl();
        if (WfUtils.isEmpty(originalUrl)) {
            return;
        }
        String notifyType = isTodoUrl ? todoInfo.getNotifyType() : messageInfo.getNotifyType();
        String url = MessageServiceUtil.getReplacedUrl(originalUrl, notifyType);
        if (WfUtils.isNotEmpty(url)) {
            if (!url.contains("accountId") && !url.contains("accountid")) {
                url = url + "&accountId=" + RequestContext.get().getAccountId();
            }
            if (isTodoUrl) {
                todoInfo.setUrl(url);
            } else {
                messageInfo.setMobContentUrl(url);
            }
        }
    }

    public List<MessageUser> getMessageUser(MessageInfo messageInfo) {
        ArrayList backupUserIds = new ArrayList(messageInfo.getUserIds());
        List<MessageUser> messageUsers = this.getMessageUserImapping(messageInfo);
        for (MessageUser messageUser : messageUsers) {
            backupUserIds.remove(messageUser.getUserId());
        }
        if (backupUserIds.isEmpty()) {
            return messageUsers;
        }
        messageInfo.getUserIds().removeAll(backupUserIds);
        logger.debug(String.format("message user[%s] no openIds, and traceId[%s]", backupUserIds, RequestContext.get().getTraceId()));
        Map params = messageInfo.getParams();
        Map userFilter = (Map)params.get("userFilter");
        if (userFilter.containsKey("noOpenId")) {
            List noOpenUserIds = (List)userFilter.get("noOpenId");
            noOpenUserIds.addAll(backupUserIds);
        } else {
            userFilter.put("noOpenId", backupUserIds);
        }
        return messageUsers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<MessageUser> getMessageUserImapping(MessageInfo message) {
        List userIds = message.getUserIds();
        List<MessageUser> messageUsers = new ArrayList<MessageUser>(userIds.size());
        String serviceType = this.getServiceType(message);
        if (WfUtils.isEmpty(serviceType)) {
            return messageUsers;
        }
        if ("sms".equals(serviceType) || "email".equals(serviceType) || "yunzhijia".equals(serviceType) || "yunzhijiaeco".equals(serviceType) || "yunzhijiaup".equals(serviceType)) {
            boolean isEmailOrSms;
            boolean bl = isEmailOrSms = "sms".equals(serviceType) || "email".equals(serviceType);
            if (userIds.isEmpty()) {
                Object openIds;
                if (!isEmailOrSms) return messageUsers;
                Map param = message.getParams();
                Object v = openIds = "sms".equals(serviceType) ? param.get("phone") : param.get("email");
                if (openIds == null) return messageUsers;
                boolean isVerifyPhoneFormat = true;
                try {
                    MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)serviceType);
                    String config = msgChannelInfo.getConfig();
                    JSONObject channelConfig = JSONObject.parseObject((String)config);
                    if (channelConfig != null && channelConfig.containsKey((Object)"isVerifyPhone")) {
                        isVerifyPhoneFormat = channelConfig.getBoolean("isVerifyPhone");
                    }
                }
                catch (Exception e) {
                    logger.error(String.format("AbstractServiceHandler_getMessageUserImapping has error: %s", WfUtils.getExceptionStacktrace(e)));
                }
                List oIds = (List)openIds;
                for (String oId : oIds) {
                    PhoneI18nValidator validator;
                    String errorMsg;
                    if (WfUtils.isEmpty(oId)) continue;
                    if (isVerifyPhoneFormat && "sms".equals(serviceType) && WfUtils.isNotEmpty(errorMsg = (validator = new PhoneI18nValidator(oId, false)).getErrorMsg())) {
                        Map verifyInfo = (Map)message.getParams().get("msgVerifyInfo");
                        verifyInfo.put(oId, errorMsg);
                        continue;
                    }
                    messageUsers.add(new MessageUser(0L, oId, null, null));
                }
                return messageUsers;
            }
            try {
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)userIds)};
                DynamicObjectCollection userDatas = QueryServiceHelper.query((String)"bos_user", (String)"id,phone,email,useropenid,eid", (QFilter[])filters);
                if (userDatas == null || userDatas.isEmpty()) return messageUsers;
                for (DynamicObject user : userDatas) {
                    String openId;
                    if (isEmailOrSms) {
                        String string = openId = "sms".equals(serviceType) ? user.getString("phone") : user.getString("email");
                        if (WfUtils.isEmpty(openId)) continue;
                        messageUsers.add(new MessageUser(user.getLong("id"), openId, null, null));
                        continue;
                    }
                    openId = user.getString("useropenid");
                    String eId = user.getString("eid");
                    if (WfUtils.isEmpty(eId) || WfUtils.isEmpty(openId)) continue;
                    messageUsers.add(new MessageUser(user.getLong("id"), openId, null, eId));
                }
                return messageUsers;
            }
            catch (Exception e) {
                logger.error(String.format("%s", WfUtils.getExceptionStacktrace(e)));
                return messageUsers;
            }
        }
        int imappingTypeID = 0;
        switch (this.getServiceType(message)) {
            case "weixinqy": {
                imappingTypeID = 3;
                break;
            }
            case "welink": {
                imappingTypeID = 4;
                break;
            }
            case "kingdee_sky": {
                imappingTypeID = 3;
                break;
            }
            case "dingding": {
                imappingTypeID = 2;
                break;
            }
        }
        messageUsers = DingdingCommonUtil.getOpenIds(userIds, imappingTypeID);
        Map params = message.getParams();
        boolean useCipher = false;
        if (params.containsKey("useCipher")) {
            useCipher = (Boolean)params.get("useCipher");
        }
        Iterator<MessageUser> iterator = messageUsers.iterator();
        while (iterator.hasNext()) {
            MessageUser messageUser = iterator.next();
            String oId = useCipher ? messageUser.getEncryOpenId() : messageUser.getOpenId();
            if (!WfUtils.isEmpty(oId)) continue;
            iterator.remove();
        }
        params.remove("useCipher");
        return messageUsers;
    }

    public List<MessageInfo> rebuildMessageInfos(MessageInfo message) {
        return YunzhijiaToDoUtil.rebuildMessage(message);
    }

    public void sendServiceMessage(List<MessageInfo> messages, List<MessageUser> messageUsers, boolean canBatch) {
        ArrayList<String> exceptions = new ArrayList<String>(messages.size());
        for (MessageInfo messageInfo : messages) {
            List userIds = messageInfo.getUserIds();
            boolean isUseUserId = userIds != null && !userIds.isEmpty();
            ArrayList<MessageUser> mus = new ArrayList<MessageUser>();
            if (isUseUserId) {
                for (MessageUser item : messageUsers) {
                    String openId;
                    if (!userIds.contains(item.getUserId()) || !WfUtils.isNotEmpty(openId = item.isCipher() ? item.getEncryOpenId() : item.getOpenId())) continue;
                    mus.add(item);
                }
                if (mus.isEmpty()) {
                    continue;
                }
            } else {
                mus.addAll(messageUsers);
            }
            this.beforePostMessage(messageInfo);
            if (canBatch) {
                this.postServiceMessage(messageInfo, mus, isUseUserId, exceptions);
                continue;
            }
            for (MessageUser messageUser : mus) {
                ArrayList<MessageUser> currentMus = new ArrayList<MessageUser>();
                currentMus.add(messageUser);
                this.postServiceMessage(messageInfo, currentMus, isUseUserId, exceptions);
            }
        }
        if (!exceptions.isEmpty()) {
            StringBuilder exception = new StringBuilder();
            for (String ex : exceptions) {
                exception.append(ex).append(" | ");
            }
            String string = exception.substring(0, exception.length() - 3);
            throw new WFMessageServiceException(null, WFErrorCode.sendMsgErrorCode(this.getServiceType(messages.get(0))), new Object[]{String.format("[%s]", string)});
        }
    }

    private void postServiceMessage(MessageInfo messageInfo, List<MessageUser> messageUsers, boolean isUseUserId, List<String> exceptions) {
        List successSendUser = (List)messageInfo.getParams().get("successSendUser");
        try {
            Map<String, Object> result = this.postMessage(messageInfo, messageUsers);
            if (result != null && ((Boolean)result.get("result")).booleanValue()) {
                if (!isUseUserId) {
                    ArrayList receivers = new ArrayList();
                    messageUsers.stream().forEach(item -> receivers.add(item.getOpenId()));
                    successSendUser.addAll(receivers);
                } else {
                    ArrayList sUIds = new ArrayList();
                    messageUsers.stream().forEach(item -> sUIds.add(item.getUserId()));
                    successSendUser.addAll(sUIds);
                }
                logger.debug(String.format("[%s] send msg success msgId[%s], traceId[%s]", this.getServiceType(messageInfo), messageInfo.getId(), RequestContext.get().getTraceId()));
            } else {
                exceptions.add(result != null ? (String)result.get("description") : "result is null");
                logger.debug(String.format("[%s] send msg fail msgId[%s], traceId[%s]", this.getServiceType(messageInfo), messageInfo.getId(), RequestContext.get().getTraceId()));
            }
        }
        catch (Exception e) {
            exceptions.add(e.getMessage());
            logger.debug(String.format("postServiceMessage task error [%s]", WfUtils.getExceptionStacktrace(e)));
        }
    }

    public void beforePostMessage(MessageInfo message) {
    }

    public Map<String, Object> postMessage(MessageInfo messageInfo, List<MessageUser> messageUsers) {
        return null;
    }
}

