/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.DingdingMessageInfo;
import kd.bos.message.api.DingdingMsgOperateType;
import kd.bos.message.api.DingdingTodoInfo;
import kd.bos.message.api.DingdingTodoOperateType;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.handler.AbstractServiceHandler;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.util.MessageUtils;
import kd.bos.workflow.engine.msg.util.dingding.DingdingCommonUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaToDoUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;

public class DingdingServiceHandler
extends AbstractServiceHandler {
    private static Log logger = LogFactory.getLog(DingdingServiceHandler.class);
    public static final String TYPE = "dingding";
    public static final int DINGDINGTYPEID = 2;
    private static final String EXCEPTIONDESCRIPTION = "take DingdingHandler has exception ";

    @Override
    public String getServiceType() {
        return TYPE;
    }

    @Override
    public void createToDo(MessageContext ctx, ToDoInfo info) {
        super.createToDo(ctx, info);
        try {
            List<ToDoInfo> toDoInfos = YunzhijiaToDoUtil.rebuildToDoInfo(info);
            for (ToDoInfo toDoInfo : toDoInfos) {
                JSONObject tplMap;
                JSONArray dingTaskList = DingdingCommonUtil.getdingTodoInfo(toDoInfo);
                if (!dingTaskList.isEmpty()) {
                    return;
                }
                Long startUserId = ctx.getStartUserId();
                ArrayList<Long> startUserIds = new ArrayList<Long>();
                startUserIds.add(startUserId);
                List<MessageUser> startUserList = DingdingCommonUtil.getOpenIds(startUserIds, 2);
                if (startUserList == null || startUserList.size() == 0) {
                    throw new WFMessageServiceException(null, WFErrorCode.dingdingMsgError(), new Object[]{ResManager.loadKDString((String)"\u6d41\u7a0b\u53d1\u8d77\u4ebaOpenID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DingdingServiceHandler_5", (String)"bos-wf-engine", (Object[])new Object[0])});
                }
                String startUserOpenId = startUserList.get(0).getOpenId();
                logger.info("DingdingServiceHandler--create todo info:" + toDoInfo);
                List userIds = toDoInfo.getUserIds();
                List<MessageUser> users = DingdingCommonUtil.getOpenIds(userIds, 2);
                String lang = Lang.get().toString();
                if (userIds != null && !userIds.isEmpty()) {
                    lang = WfMultiLangUtils.getUserDefaultLang((Long)userIds.get(0));
                }
                if ((tplMap = DingdingCommonUtil.getDingTpl(ctx.getEntityNumber(), ctx.getEntityName())) == null) {
                    throw new WFMessageServiceException(null, WFErrorCode.dingdingMsgError(), new Object[]{ResManager.loadKDString((String)"\u5e94\u7528ID\u672a\u914d\u7f6e\u3002", (String)"DingdingServiceHandler_4", (String)"bos-wf-engine", (Object[])new Object[0])});
                }
                for (MessageUser messageUser : users) {
                    String content;
                    String userId = messageUser.getOpenId();
                    if (userId == null || StringUtils.isBlank((CharSequence)userId)) {
                        logger.info("createToDo--userId:" + userId + " openId is null");
                        continue;
                    }
                    DingdingTodoInfo dingdingTodoInfo = new DingdingTodoInfo();
                    String title = DingdingCommonUtil.wrapContent(lang, toDoInfo.getTitle());
                    if (!WfUtils.isEmpty(title)) {
                        dingdingTodoInfo.setTitle(title);
                    }
                    if (!WfUtils.isEmpty(content = DingdingCommonUtil.wrapContent(lang, toDoInfo.getContent()))) {
                        dingdingTodoInfo.setContent(content);
                    }
                    dingdingTodoInfo.setOriginatorUserId(startUserOpenId);
                    dingdingTodoInfo.setUserId(userId);
                    dingdingTodoInfo.setTodoUrl(toDoInfo.getUrl());
                    dingdingTodoInfo.setTodoType(DingdingTodoOperateType.CREATE.getNumber());
                    boolean isHasTpl = tplMap.getBoolean("ishastpl");
                    if (isHasTpl) {
                        dingdingTodoInfo.setHasDingTpl(isHasTpl);
                        dingdingTodoInfo.setTplProcessCode(tplMap.getString("tplid"));
                        dingdingTodoInfo.setTplName(tplMap.getString("tplname"));
                        dingdingTodoInfo.setTplDescription(tplMap.getString("tpldescription"));
                    } else {
                        if (StringUtils.isNotBlank((CharSequence)tplMap.getString("tplcode"))) {
                            dingdingTodoInfo.setTplProcessCode(tplMap.getString("tplcode"));
                        }
                        dingdingTodoInfo.setHasDingTpl(isHasTpl);
                        dingdingTodoInfo.setTplName(ctx.getEntityName());
                        dingdingTodoInfo.setTplDescription(String.format(ResManager.loadKDString((String)"%s\u5ba1\u6279\u6a21\u677f", (String)"DingdingServiceHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]), ctx.getEntityName()));
                    }
                    String dingProcessInstanceId = DingdingCommonUtil.getDingProcessInstance(ctx.getProcessInstanceId());
                    if (StringUtils.isNotBlank((CharSequence)dingProcessInstanceId)) {
                        dingdingTodoInfo.setProcessInstanceId(dingProcessInstanceId);
                    } else {
                        String instanceUrl = MessageServiceUtil.buildWebPageUrlForMyInitiation(ctx.getProcessInstanceId());
                        dingdingTodoInfo.setInstanceUrl(MessageServiceUtil.getReplacedUrl(instanceUrl, TYPE));
                    }
                    Map resultMap = MessageServiceHelper.dingdingTodo((DingdingTodoInfo)dingdingTodoInfo);
                    if (!isHasTpl) {
                        DingdingCommonUtil.saveDingTpl(ctx, dingdingTodoInfo, resultMap);
                    }
                    DingdingCommonUtil.saveDingTodo(ctx.getProcessInstanceId(), toDoInfo.getTaskId(), messageUser.getUserId(), dingdingTodoInfo, resultMap);
                    if (resultMap != null && resultMap.get("code") != null && resultMap.get("code").equals("0")) continue;
                    throw new WFMessageServiceException(null, WFErrorCode.dingdingMsgError(), new Object[]{"createDingTodoError:" + resultMap});
                }
                logger.info("DingdingServiceHandler--createToDo success");
            }
        }
        catch (Exception e) {
            logger.info("DingdingServiceHandler--CreateTodoFail:" + e.getMessage());
            throw new WFMessageServiceException(e, WFErrorCode.dingdingMsgError(), e.getMessage());
        }
    }

    @Override
    public void dealToDo(MessageContext ctx, ToDoInfo info) {
        try {
            logger.info("DingdingServiceHandler--deal todo info:" + info);
            JSONArray dingTaskList = DingdingCommonUtil.getdingTodoInfo(info);
            if (dingTaskList.isEmpty()) {
                logger.info("DingdingServiceHandler--dealToDo--\u9489\u9489\u4efb\u52a1task\u548c\u5b9e\u4f8bID\u4e3a\u7a7a ");
                return;
            }
            ArrayList<String> successTaskIds = new ArrayList<String>(dingTaskList.size());
            for (int i = 0; i < dingTaskList.size(); ++i) {
                Long dingTaskId = dingTaskList.getJSONObject(i).getLong("taskid");
                String processInstanceId = dingTaskList.getJSONObject(i).getString("processinstanceid");
                DingdingTodoInfo todoInfo = new DingdingTodoInfo();
                todoInfo.setProcessInstanceId(processInstanceId);
                todoInfo.setTaskId(dingTaskId.longValue());
                todoInfo.setTodoType(DingdingTodoOperateType.DEAL.getNumber());
                Map resultMap = MessageServiceHelper.dingdingTodo((DingdingTodoInfo)todoInfo);
                if (resultMap == null || resultMap.get("code") == null || !resultMap.get("code").equals("0")) {
                    throw new WFMessageServiceException(null, WFErrorCode.dingdingMsgError(), new Object[]{EXCEPTIONDESCRIPTION + resultMap});
                }
                successTaskIds.add(String.valueOf(dingTaskId));
            }
            DingdingCommonUtil.updateDingTodo(successTaskIds);
            logger.info("DingdingServiceHandler--dealToDo success");
        }
        catch (Exception e) {
            logger.info("DingdingServiceHandler--deleteTodoFail:" + e.getMessage());
            throw new WFMessageServiceException(e, WFErrorCode.dingdingMsgError(), e.getMessage());
        }
    }

    @Override
    public void deleteToDo(MessageContext ctx, ToDoInfo info) {
        try {
            logger.info("DingdingServiceHandler-- delete todo info:" + info);
            JSONArray dingTaskList = DingdingCommonUtil.getdingTodoInfo(info);
            if (dingTaskList.isEmpty()) {
                logger.info("DingdingServiceHandler--dealToDo--\u9489\u9489\u4efb\u52a1task\u548c\u5b9e\u4f8bID\u4e3a\u7a7a ");
                return;
            }
            ArrayList<String> successTaskIds = new ArrayList<String>(dingTaskList.size());
            for (int i = 0; i < dingTaskList.size(); ++i) {
                Long dingTaskId = dingTaskList.getJSONObject(i).getLong("taskid");
                String processInstanceId = dingTaskList.getJSONObject(i).getString("processinstanceid");
                DingdingTodoInfo todoInfo = new DingdingTodoInfo();
                todoInfo.setProcessInstanceId(processInstanceId);
                todoInfo.setTaskId(dingTaskId.longValue());
                todoInfo.setTodoType(DingdingTodoOperateType.DELETE.getNumber());
                Map resultMap = MessageServiceHelper.dingdingTodo((DingdingTodoInfo)todoInfo);
                if (resultMap == null || resultMap.get("code") == null || !resultMap.get("code").equals("0")) {
                    throw new WFMessageServiceException(null, WFErrorCode.dingdingMsgError(), new Object[]{EXCEPTIONDESCRIPTION + resultMap});
                }
                successTaskIds.add(String.valueOf(dingTaskId));
            }
            DingdingCommonUtil.updateDingTodo(successTaskIds);
            logger.info("DingdingServiceHandler--deleteToDo success");
        }
        catch (Exception e) {
            logger.info("DingdingServiceHandler--deleteTodoFail:" + e.getMessage());
            throw new WFMessageServiceException(e, WFErrorCode.dingdingMsgError(), e.getMessage());
        }
    }

    @Override
    public void sendMessage(MessageContext ctx, MessageInfo message) {
        try {
            super.sendMessage(ctx, message);
            List<MessageUser> messageUsers = this.getMessageUser(message);
            if (messageUsers.isEmpty()) {
                logger.info(String.format("content: %s, userIds not have openIds, and stop send message", message.getContent()));
                throw new WFMessageServiceException(null, WFErrorCode.dingdingMsgError(), new Object[]{"message userIds has no openIds all"});
            }
            List<MessageInfo> messages = this.rebuildMessageInfos(message);
            if (MessageUtils.isBlankMessage(messages)) {
                logger.info("DingdingServiceHandler-- messagecontent is blank");
                throw new WFMessageServiceException(null, WFErrorCode.sendMsgWithoutContentError(), new Object[0]);
            }
            this.sendServiceMessage(messages, messageUsers, true);
        }
        catch (Exception e) {
            throw new WFMessageServiceException(null, WFErrorCode.dingdingMsgError(), new Object[]{WfUtils.getExceptionStacktrace(e)});
        }
    }

    @Override
    public boolean inspectChannelInfo(MsgChannelInfo msgChannelInfo) {
        String corpId = msgChannelInfo.getCorpid();
        String agentId = msgChannelInfo.getAgentid();
        String appKey = msgChannelInfo.getAppkey();
        String appSecret = msgChannelInfo.getAppsecret();
        return !WfUtils.isEmpty(corpId) && !WfUtils.isEmpty(agentId) && !WfUtils.isEmpty(appKey) && !WfUtils.isEmpty(appSecret);
    }

    @Override
    public Map<String, Object> postMessage(MessageInfo messageInfo, List<MessageUser> messageUsers) {
        DingdingMessageInfo dingdingMessageInfo = this.buildDingdingMessageInfo(messageInfo, messageUsers);
        return MessageServiceHelper.dingdingMessage((DingdingMessageInfo)dingdingMessageInfo);
    }

    private DingdingMessageInfo buildDingdingMessageInfo(MessageInfo message, List<MessageUser> messageUsers) {
        StringBuilder dingUserIds = new StringBuilder();
        for (int i = 0; i < messageUsers.size(); ++i) {
            MessageUser user = messageUsers.get(i);
            if (i == messageUsers.size() - 1) {
                dingUserIds.append(user.getOpenId());
                continue;
            }
            dingUserIds.append(user.getOpenId()).append(',');
        }
        DingdingMessageInfo messageInfo = new DingdingMessageInfo();
        messageInfo.setContent(message.getContent());
        messageInfo.setUserIds(dingUserIds.toString());
        if (StringUtils.isBlank((CharSequence)message.getMobContentUrl())) {
            messageInfo.setLinkMsg(false);
        } else {
            messageInfo.setLinkMsg(true);
            messageInfo.setMsgUrl(message.getMobContentUrl());
            messageInfo.setTitle(message.getTitle());
            messageInfo.setOpenInDing(true);
        }
        messageInfo.setMessageType(DingdingMsgOperateType.CREATE.getNumber());
        return messageInfo;
    }

    @Override
    public void completeProcessInstance(MessageContext ctx, Long proceInstanceId) {
        DingdingCommonUtil.updateProcessInstanceState(ctx, proceInstanceId);
    }

    @Override
    public void deleteProcessInstance(MessageContext ctx, Long proceInstanceId) {
        DingdingCommonUtil.updateProcessInstanceState(ctx, proceInstanceId);
    }
}

