/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.EmailInfo;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.handler.EmailHandler;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.handler.AbstractServiceHandler;
import kd.bos.workflow.engine.msg.info.MessageAttachment;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.util.MessageUtils;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaToDoUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;

public class EmailServiceHandler
extends AbstractServiceHandler {
    private static Log logger = LogFactory.getLog(EmailServiceHandler.class);
    public static final String TYPE = "email";

    @Override
    public String getServiceType() {
        return TYPE;
    }

    @Override
    public void createToDo(MessageContext ctx, ToDoInfo info) {
        super.createToDo(ctx, info);
        try {
            List<ToDoInfo> toDoInfos = YunzhijiaToDoUtil.rebuildToDoInfo(info);
            for (ToDoInfo toDoInfo : toDoInfos) {
                toDoInfo.setUrl(toDoInfo.getUrl() + "&ado=view");
                EmailInfo emailInfo = this.buildEmailInfo(ctx, toDoInfo, null);
                logger.info(String.format("\u90ae\u4ef6\u670d\u52a1\uff1a\u521b\u5efa\u5f85\u529e\u6d88\u606fctx:%s,todo:%s", ctx == null ? "" : ctx.toString(), toDoInfo.toString()));
                Map res = EmailHandler.sendEmail((EmailInfo)emailInfo);
                if (!((Boolean)res.get("result")).booleanValue()) {
                    throw new WFMessageServiceException(null, WFErrorCode.emailSendMsgError(), new Object[]{"take EmailHandler has exception " + res.get("description")});
                }
                logger.info(String.format("[%s]\u53d1\u9001\u90ae\u4ef6\u5f85\u529e\u6d88\u606f\u6210\u529f", RequestContext.get().getTraceId()));
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            throw new WFMessageServiceException(e, WFErrorCode.emailSendTodoError(), e.getMessage());
        }
    }

    @Override
    public void dealToDo(MessageContext ctx, ToDoInfo info) {
        logger.info(String.format("nothing to do for[%s] when dealing email todo", info.getTaskId()));
    }

    @Override
    public void deleteToDo(MessageContext ctx, ToDoInfo info) {
        logger.info(String.format("nothing to do for[%s] when deleting email todo", info.getTaskId()));
    }

    @Override
    public void sendMessage(MessageContext ctx, MessageInfo message) {
        try {
            super.sendMessage(ctx, message);
            MessageUtils.wrapMessageContent(message, TYPE);
            List<MessageUser> messageUsers = this.getMessageUser(message);
            if (messageUsers.isEmpty()) {
                logger.info(String.format("content: %s, userIds not have openIds, and stop send message", message.getContent()));
                throw new WFMessageServiceException(null, WFErrorCode.smsSendMsgError(), new Object[]{"message userIds has no openIds all"});
            }
            List<MessageInfo> messages = this.rebuildMessageInfos(message);
            if (MessageUtils.isBlankMessage(messages)) {
                logger.info("EmailServiceHandler-- messagecontent is blank");
                throw new WFMessageServiceException(null, WFErrorCode.sendMsgWithoutContentError(), new Object[0]);
            }
            this.sendServiceMessage(messages, messageUsers, !message.isSignleEmail());
        }
        catch (Exception e) {
            throw new WFMessageServiceException(e, WFErrorCode.emailSendMsgError(), e.getMessage());
        }
    }

    @Override
    public boolean inspectChannelInfo(MsgChannelInfo msgChannelInfo) {
        String smtpHost = msgChannelInfo.getSmtphost();
        String smtpPort = msgChannelInfo.getSmtpport();
        String mobileAppConfig = msgChannelInfo.getMobileappconfig();
        if (WfUtils.isEmpty(smtpHost) || WfUtils.isEmpty(smtpPort) || WfUtils.isEmpty(mobileAppConfig)) {
            return false;
        }
        JSONObject configs = JSON.parseObject((String)mobileAppConfig);
        String auth = configs.getString("auth");
        if (Boolean.parseBoolean(auth)) {
            String username = msgChannelInfo.getUsername();
            String password = msgChannelInfo.getPassword();
            if (WfUtils.isEmpty(username) || WfUtils.isEmpty(password)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Map<String, Object> postMessage(MessageInfo messageInfo, List<MessageUser> messageUsers) {
        EmailInfo emailInfo = this.buildEmailInfo(messageInfo, messageUsers);
        logger.info(String.format("\u90ae\u4ef6\u670d\u52a1\uff1a\u521b\u5efa\u6d88\u606f,message:%s", messageInfo));
        return EmailHandler.sendEmail((EmailInfo)emailInfo);
    }

    private EmailInfo buildEmailInfo(MessageInfo messageInfo, List<MessageUser> messageUsers) {
        Map param;
        ArrayList<String> address = new ArrayList<String>();
        for (MessageUser messageUser : messageUsers) {
            String openId = messageUser.getOpenId();
            if (!WfUtils.isNotEmpty(openId)) continue;
            address.add(openId);
        }
        EmailInfo emailInfo = new EmailInfo();
        emailInfo.setParams(this.getParams(null, null, messageInfo));
        emailInfo.setContentMimeType("HTML");
        emailInfo.setReceiver(address);
        emailInfo.setTitle(messageInfo.getTitle());
        emailInfo.setContent(messageInfo.getContent());
        emailInfo.setSignleEmail(messageInfo.isSignleEmail());
        MessageAttachment attachment = messageInfo.getAttachment();
        if (attachment != null) {
            emailInfo.setAttachments(attachment.getAttachments());
            emailInfo.setAttachmentNames(attachment.getAttachmentNames());
        }
        if ((param = messageInfo.getParams()) != null && !param.isEmpty()) {
            Object secretReceivers;
            Object copyRecevers = param.get("emailCR");
            if (StringUtils.isNotBlank(copyRecevers)) {
                emailInfo.setCopyReceiver((List)copyRecevers);
            }
            if (StringUtils.isNotBlank(secretReceivers = param.get("emailSR"))) {
                emailInfo.setSecretReceiver((List)secretReceivers);
            }
        }
        return emailInfo;
    }

    private EmailInfo buildEmailInfo(MessageContext ctx, ToDoInfo todoInfo, MessageInfo messageInfo) {
        EmailInfo emailInfo = new EmailInfo();
        emailInfo.setParams(this.getParams(ctx, todoInfo, messageInfo));
        emailInfo.setContentMimeType("HTML");
        List<String> address = MessageUtils.getPhonesEmailAddressByParams(todoInfo, messageInfo, TYPE);
        emailInfo.setReceiver(address);
        if (todoInfo != null) {
            emailInfo.setTitle(todoInfo.getTitle());
            emailInfo.setContent(todoInfo.getContent());
        } else {
            Map param;
            emailInfo.setTitle(messageInfo.getTitle());
            emailInfo.setContent(messageInfo.getContent());
            emailInfo.setSignleEmail(messageInfo.isSignleEmail());
            MessageAttachment attachment = messageInfo.getAttachment();
            if (attachment != null) {
                emailInfo.setAttachments(attachment.getAttachments());
                emailInfo.setAttachmentNames(attachment.getAttachmentNames());
            }
            if ((param = messageInfo.getParams()) != null && !param.isEmpty()) {
                Object secretReceivers;
                Object copyRecevers = param.get("emailCR");
                if (StringUtils.isNotBlank(copyRecevers)) {
                    emailInfo.setCopyReceiver((List)copyRecevers);
                }
                if (StringUtils.isNotBlank(secretReceivers = param.get("emailSR"))) {
                    emailInfo.setSecretReceiver((List)secretReceivers);
                }
            }
        }
        return emailInfo;
    }

    private Map<String, Object> getParams(MessageContext ctx, ToDoInfo todoInfo, MessageInfo messageInfo) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("resourceType", messageInfo != null ? "message" : "task");
        params.put("resourceId", messageInfo != null ? messageInfo.getId() : todoInfo.getTaskId());
        params.put("scene", messageInfo != null ? messageInfo.getTplScene() : todoInfo.getTodoType());
        params.put("senderId", messageInfo != null ? messageInfo.getSenderId() : ctx.getStartUserId());
        params.put("channel", messageInfo != null ? messageInfo.getNotifyType() : todoInfo.getNotifyType());
        params.put("businessKey", messageInfo != null ? messageInfo.getBizDataId() : ctx.getBusinessKey());
        params.put("entityNumber", messageInfo != null ? messageInfo.getEntityNumber() : ctx.getEntityNumber());
        return params;
    }
}

