/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.handler;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.utils.MessageEventListenerUtils;
import kd.bos.message.utils.MessageEventType;
import kd.bos.message.utils.MsgCenterEventEnum;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.handler.AbstractServiceHandler;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;
import kd.bos.workflow.message.api.IMessageCenterService;
import kd.bos.workflow.nocode.NoCodeFlowUtil;
import kd.bos.workflow.service.impl.ServiceFactory;

public class MCenterServiceHandler
extends AbstractServiceHandler {
    private static final Log logger = LogFactory.getLog(MCenterServiceHandler.class);
    public static final String TYPE = "mcenter";

    @Override
    public String getServiceType() {
        return TYPE;
    }

    @Override
    public void updateTodoContent(ToDoInfo todoInfo) {
        super.updateTodoContent(todoInfo);
    }

    @Override
    public void wrappMessageUrlDomain(ToDoInfo todoInfo, MessageInfo messageInfo) {
    }

    @Override
    public void sendMessage(MessageContext ctx, MessageInfo messageInfo) {
        Map params = messageInfo.getParams();
        if (params.get("noSaveMessage") != null) {
            String result = String.format("[%s]-[%s] not save InnerMsg", messageInfo.getTitle(), messageInfo.getContent());
            messageInfo.putParam("sendResult", result);
            logger.debug(result);
            return;
        }
        Object userFilter = null;
        Object successSendUser = null;
        try {
            super.sendMessage(ctx, messageInfo);
            if (params.get("bizEntityObject") != null) {
                params.remove("bizEntityObject");
            }
            logger.debug("MCenterServiceHandler-start save msg db");
            userFilter = params.remove("userFilter");
            successSendUser = params.remove("successSendUser");
            IMessageCenterService service = (IMessageCenterService)ServiceFactory.getService((String)"MessageCenterService");
            service.saveMessage(messageInfo);
            this.createMessageEvent(messageInfo);
            this.noCodeFlowPopup(messageInfo);
            logger.debug(String.format("MCenterServiceHandler-[%s]trigger event success", messageInfo.getId()));
        }
        catch (Exception e) {
            if (userFilter != null) {
                params.put("userFilter", userFilter);
            }
            if (successSendUser != null) {
                params.put("successSendUser", successSendUser);
            }
            logger.error(String.format("MCenterServiceHandler has error: %s", WfUtils.getExceptionStacktrace(e)));
            throw new WFMessageServiceException(e, WFErrorCode.sendMsgErrorCode(TYPE), WfUtils.getExceptionStacktrace(e));
        }
    }

    private void createMessageEvent(MessageInfo messageInfo) throws Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(6);
        paramMap.put("messageTitle", messageInfo.getMessageTitle());
        paramMap.put("entityNumber", messageInfo.getEntityNumber());
        paramMap.put("tag", messageInfo.getTag());
        paramMap.put("id", messageInfo.getId());
        paramMap.put("userIds", messageInfo.getUserIds());
        String paramJson = SerializationUtils.toJsonString(paramMap);
        if (WfConfigurationUtil.isEnableMsgBecEvent().booleanValue() && WfUtils.isNotEmpty(paramJson)) {
            try {
                EventServiceHelper.triggerEventSubscribe((String)MsgCenterEventEnum.CREATE_MSG_EVT.getCode(), (String)paramJson);
            }
            catch (Exception e) {
                logger.error("event of create message occurred exception:" + e.getMessage());
            }
        }
    }

    private void noCodeFlowPopup(MessageInfo messageInfo) {
        try {
            if (NoCodeFlowUtil.hasNoCodeLicense() && "NoCodeFlow".equalsIgnoreCase(messageInfo.getSource())) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>(6);
                paramMap.put("messageTitle", messageInfo.getMessageTitle());
                paramMap.put("entityNumber", "wf_nocodeflow_popup");
                paramMap.put("tag", messageInfo.getTag());
                paramMap.put("id", messageInfo.getId());
                paramMap.put("userIds", messageInfo.getUserIds());
                MessageEventListenerUtils.subscribeMsgResult((String)"*", (String)"wf_nocodeflow_popup", (MessageEventType)MessageEventType.SUBSCRIBESUCCESSMSG, (Long)messageInfo.getId(), paramMap);
            }
        }
        catch (Exception e) {
            logger.error("nocodeflow popup occurred exception:" + e.getMessage());
        }
    }

    @Override
    public void dealMessage(MessageContext ctx, MessageInfo messageInfo) {
        super.dealMessage(ctx, messageInfo);
    }
}

