/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.handler.AbstractServiceHandler;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.util.sysnotice.SystemNoticeCommonUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;

public class SysNoticeServiceHandler
extends AbstractServiceHandler {
    private static Log logger = LogFactory.getLog(SysNoticeServiceHandler.class);
    public static final String TYPE = "sysnotice";
    private static final String SYSTEMNOTICE = "systemNotice";
    private static final String SHOWTYPE = "showType";
    private static final String TIMEOUT = "timeOut";
    private static final String URL = "url";
    private static final String DURATION = "duration";
    private static final String CLICKCLASSNAME = "clickClassName";
    private static final String NOTICETYPE = "noticeType";

    @Override
    public String getServiceType() {
        return TYPE;
    }

    @Override
    public void createToDo(MessageContext ctx, ToDoInfo info) {
    }

    @Override
    public void dealToDo(MessageContext ctx, ToDoInfo info) {
    }

    @Override
    public void deleteToDo(MessageContext ctx, ToDoInfo info) {
    }

    @Override
    public void wrappMessageUrlDomain(ToDoInfo todoInfo, MessageInfo messageInfo) {
    }

    @Override
    public void sendMessage(MessageContext ctx, MessageInfo message) {
        logger.debug(String.format("SysNotice-sendMsg, content:%s", message.getContent()));
        try {
            super.sendMessage(ctx, message);
            List userIds = message.getUserIds();
            boolean toAll = message.isToAll();
            if (!toAll && (userIds == null || userIds.isEmpty())) {
                throw new WFMessageServiceException(null, WFErrorCode.yzjsendMsgError(), new Object[]{"sysnotice toAll=false or userIds=null"});
            }
            Map params = message.getParams();
            if (!params.isEmpty() && StringUtils.isNotBlank(params.get(SYSTEMNOTICE))) {
                this.sendSystemNoticeMessage(message);
            }
        }
        catch (Exception e) {
            throw new WFMessageServiceException(e, WFErrorCode.sendMsgErrorCode(TYPE), WfUtils.getExceptionStacktrace(e));
        }
    }

    private void sendSystemNoticeMessage(MessageInfo message) {
        Map params = message.getParams();
        Map systemNoticeParam = (Map)params.get(SYSTEMNOTICE);
        int showType = 1;
        Object st = systemNoticeParam.get(SHOWTYPE);
        if (st instanceof String) {
            showType = Integer.parseInt((String)st);
        } else if (st instanceof Integer) {
            showType = (Integer)st;
        }
        if (3 == showType) {
            logger.debug("SystemNoticeCommonUtil--showType=\u5217\u8868\u63d0\u793a");
            return;
        }
        long timeOut = SystemNoticeCommonUtil.TIMEOUT;
        Object to = systemNoticeParam.get(TIMEOUT);
        if (to instanceof String) {
            timeOut = Long.parseLong((String)to);
        } else if (to instanceof Integer) {
            timeOut = (long)((Integer)to).intValue() + 0L;
        } else if (to instanceof Long) {
            timeOut = (Long)to;
        }
        String url = "";
        Integer duration = 0;
        String clickClassName = "";
        String noticeType = "";
        if (StringUtils.isNotBlank(systemNoticeParam.get(URL))) {
            url = systemNoticeParam.get(URL);
        }
        if (StringUtils.isNotBlank(systemNoticeParam.get(DURATION))) {
            duration = systemNoticeParam.get(DURATION);
        }
        if (StringUtils.isNotBlank(systemNoticeParam.get(CLICKCLASSNAME))) {
            clickClassName = (String)systemNoticeParam.get(CLICKCLASSNAME);
        }
        if (StringUtils.isNotBlank(systemNoticeParam.get(NOTICETYPE))) {
            noticeType = (String)systemNoticeParam.get(NOTICETYPE);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(SHOWTYPE, showType);
        param.put(TIMEOUT, timeOut);
        param.put(URL, url);
        param.put(DURATION, duration);
        param.put(CLICKCLASSNAME, clickClassName);
        param.put("content", message.getContent());
        param.put("title", message.getTitle());
        param.put("messageContent", message.getMessageContent());
        param.put("messageTitle", message.getMessageTitle());
        param.put("accountId", RequestContext.get().getAccountId());
        param.put("userId", message.getUserIds());
        param.put("toAll", message.isToAll());
        param.put("msgId", message.getId());
        param.put("msgType", WfUtils.isNotEmpty(noticeType) ? noticeType : message.getType());
        SystemNoticeCommonUtil.sendSystemNoticeMessage(param);
        logger.debug("SysNotice-sendMsgOK");
    }
}

