/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.handler.AbstractServiceHandler;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.welink.WeLinkMessageInfo;
import kd.bos.workflow.engine.msg.model.welink.WeLinkTodoInfo;
import kd.bos.workflow.engine.msg.model.welink.WeLinkTodoType;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.util.MessageUtils;
import kd.bos.workflow.engine.msg.util.welink.WeLinkCommonUtil;
import kd.bos.workflow.engine.msg.util.welink.WeLinkHandleUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaToDoUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;

public class WeLinkServiceHandler
extends AbstractServiceHandler {
    private static Log logger = LogFactory.getLog(WeLinkServiceHandler.class);
    public static final String TYPE = "welink";
    public static final int WEIXINQYTYPEID = 4;
    private static final String DESCRIPTION = "description";
    private static final String LOGDESCRIPTION = " is fail";

    @Override
    public String getServiceType() {
        return TYPE;
    }

    @Override
    public void createToDo(MessageContext ctx, ToDoInfo info) {
        super.createToDo(ctx, info);
        List<ToDoInfo> toDoInfos = YunzhijiaToDoUtil.rebuildToDoInfo(info);
        for (ToDoInfo toDoInfo : toDoInfos) {
            ArrayList<WeLinkTodoInfo> successWeLinkTodo = new ArrayList<WeLinkTodoInfo>();
            ArrayList<WeLinkTodoInfo> errorWeLinkTodo = new ArrayList<WeLinkTodoInfo>();
            try {
                List<WeLinkTodoInfo> weLinkTodoList = WeLinkCommonUtil.transformTodo(ctx, toDoInfo, WeLinkTodoType.CREATE);
                StringBuilder errorUser = new StringBuilder();
                for (WeLinkTodoInfo weLinkTodoInfo : weLinkTodoList) {
                    String uid = weLinkTodoInfo.getApplicantUserId();
                    weLinkTodoInfo.setApplicantUserId(weLinkTodoInfo.getUserId());
                    errorWeLinkTodo.add(weLinkTodoInfo);
                    Map<String, Object> res = WeLinkHandleUtil.sendTodo(weLinkTodoInfo, null);
                    weLinkTodoInfo.setApplicantUserId(uid);
                    if (res.get("code").equals("0")) {
                        successWeLinkTodo.add(weLinkTodoInfo);
                        errorWeLinkTodo.remove(weLinkTodoInfo);
                        continue;
                    }
                    errorUser.append(uid).append('-').append(res.get(DESCRIPTION)).append(',');
                }
                if (weLinkTodoList.size() != 0) {
                    this.addTodoLog(errorUser.toString(), toDoInfo.getUserIds(), toDoInfo.getTaskId(), WeLinkTodoType.CREATE);
                }
                if (errorWeLinkTodo.size() == 0) continue;
                throw new WFMessageServiceException(new Exception(), WFErrorCode.weLinkCreateTodoError(), "the part of user create welink todo is fail ");
            }
            catch (Exception e) {
                logger.info("create todo is fail and the msg is " + e.getMessage());
                throw new WFMessageServiceException(e, WFErrorCode.weLinkCreateTodoError(), e.getMessage());
            }
            finally {
                if (successWeLinkTodo.size() == 0 && errorWeLinkTodo.size() == 0) continue;
                WeLinkCommonUtil.updateWelinkTodoState(ctx.getProcessInstanceId(), toDoInfo, successWeLinkTodo, errorWeLinkTodo, WeLinkTodoType.CREATE);
            }
        }
    }

    @Override
    public void dealToDo(MessageContext ctx, ToDoInfo info) {
        logger.info("deal welink todo begine");
        ArrayList<WeLinkTodoInfo> successWeLinkTodo = new ArrayList<WeLinkTodoInfo>();
        ArrayList<WeLinkTodoInfo> errorWeLinkTodo = new ArrayList<WeLinkTodoInfo>();
        try {
            List<WeLinkTodoInfo> weLinkTodoList = WeLinkCommonUtil.transformTodo(ctx, info, WeLinkTodoType.DEAL);
            StringBuilder errorUser = new StringBuilder();
            for (WeLinkTodoInfo weLinkTodoInfo : weLinkTodoList) {
                String uid = weLinkTodoInfo.getApplicantUserId();
                String configData = weLinkTodoInfo.getTaskDesc();
                errorWeLinkTodo.add(weLinkTodoInfo);
                Map<String, Object> res = WeLinkHandleUtil.sendTodo(weLinkTodoInfo, configData);
                if (res.get("code").equals("0")) {
                    successWeLinkTodo.add(weLinkTodoInfo);
                    errorWeLinkTodo.remove(weLinkTodoInfo);
                    continue;
                }
                errorUser.append(uid).append('-').append(res.get(DESCRIPTION)).append(',');
            }
            if (weLinkTodoList.size() != 0) {
                this.addTodoLog(errorUser.toString(), info.getUserIds(), info.getTaskId(), WeLinkTodoType.DEAL);
            }
            if (errorWeLinkTodo.size() != 0) {
                throw new WFMessageServiceException(new Exception(), WFErrorCode.weLinkDealTodoError(), "the part of user deal welink todo is fail ");
            }
        }
        catch (Exception e) {
            logger.info("deal todo is fail and the msg is " + e.getMessage());
            throw new WFMessageServiceException(e, WFErrorCode.weLinkDealTodoError(), e.getMessage());
        }
        finally {
            if (successWeLinkTodo.size() != 0 || errorWeLinkTodo.size() != 0) {
                WeLinkCommonUtil.updateWelinkTodoState(ctx.getProcessInstanceId(), info, successWeLinkTodo, errorWeLinkTodo, WeLinkTodoType.DEAL);
            }
        }
    }

    @Override
    public void deleteToDo(MessageContext ctx, ToDoInfo info) {
        logger.info("delete welink todo begine");
        ArrayList<WeLinkTodoInfo> successWeLinkTodo = new ArrayList<WeLinkTodoInfo>();
        ArrayList<WeLinkTodoInfo> errorWeLinkTodo = new ArrayList<WeLinkTodoInfo>();
        try {
            List<WeLinkTodoInfo> weLinkTodoList = WeLinkCommonUtil.transformTodo(ctx, info, WeLinkTodoType.DELETE);
            StringBuilder errorUser = new StringBuilder();
            for (WeLinkTodoInfo weLinkTodoInfo : weLinkTodoList) {
                String uid = weLinkTodoInfo.getApplicantUserId();
                String configData = weLinkTodoInfo.getTaskDesc();
                errorWeLinkTodo.add(weLinkTodoInfo);
                Map<String, Object> res = WeLinkHandleUtil.sendTodo(weLinkTodoInfo, configData);
                if (res.get("code").equals("0")) {
                    successWeLinkTodo.add(weLinkTodoInfo);
                    errorWeLinkTodo.remove(weLinkTodoInfo);
                    continue;
                }
                errorUser.append(uid).append('-').append(res.get(DESCRIPTION)).append(',');
            }
            if (weLinkTodoList.size() != 0) {
                this.addTodoLog(errorUser.toString(), info.getUserIds(), info.getTaskId(), WeLinkTodoType.DELETE);
            }
            if (errorWeLinkTodo.size() != 0) {
                throw new WFMessageServiceException(new Exception(), WFErrorCode.weLinkDeleteTodoError(), "the part of user delete welink todo is fail ");
            }
        }
        catch (Exception e) {
            logger.info("delete todo is fail and the msg is " + e.getMessage());
            throw new WFMessageServiceException(e, WFErrorCode.weLinkDeleteTodoError(), e.getMessage());
        }
        finally {
            if (successWeLinkTodo.size() != 0 || errorWeLinkTodo.size() != 0) {
                WeLinkCommonUtil.updateWelinkTodoState(ctx.getProcessInstanceId(), info, successWeLinkTodo, errorWeLinkTodo, WeLinkTodoType.DELETE);
            }
        }
    }

    @Override
    public void sendMessage(MessageContext ctx, MessageInfo message) {
        try {
            super.sendMessage(ctx, message);
            List<MessageUser> messageUsers = this.getMessageUser(message);
            if (messageUsers.isEmpty()) {
                logger.info(String.format("content: %s, userIds not have openIds, and stop send Message", message.getContent()));
                throw new WFMessageServiceException(null, WFErrorCode.weLinkSendMsgError(), new Object[]{"message userIds has no openIds all"});
            }
            List<MessageInfo> messages = this.rebuildMessageInfos(message);
            if (MessageUtils.isBlankMessage(messages)) {
                logger.info("WeLinkServiceHandler-- messagecontent is blank");
                throw new WFMessageServiceException(null, WFErrorCode.sendMsgWithoutContentError(), new Object[0]);
            }
            this.sendServiceMessage(messages, messageUsers, true);
        }
        catch (Exception e) {
            throw new WFMessageServiceException(null, WFErrorCode.weLinkSendMsgError(), new Object[]{WfUtils.getExceptionStacktrace(e)});
        }
    }

    @Override
    public boolean inspectChannelInfo(MsgChannelInfo msgChannelInfo) {
        String mobileAppConfig = msgChannelInfo.getMobileappconfig();
        if (WfUtils.isEmpty(mobileAppConfig)) {
            return false;
        }
        JSONObject configs = JSON.parseObject((String)mobileAppConfig);
        String corpId = configs.getString("wlcorpid");
        String appId = configs.getString("wlappid");
        String appSecret = configs.getString("wlappsecret");
        String pubaccId = configs.getString("wlpubaccid");
        return !WfUtils.isEmpty(corpId) && !WfUtils.isEmpty(appId) && !WfUtils.isEmpty(appSecret) && !WfUtils.isEmpty(pubaccId);
    }

    @Override
    public Map<String, Object> postMessage(MessageInfo messageInfo, List<MessageUser> messageUsers) {
        WeLinkMessageInfo weLinkMessageInfo = this.buildWeLinkMessageInfo(messageInfo, messageUsers);
        return WeLinkHandleUtil.sendMessage(weLinkMessageInfo);
    }

    private WeLinkMessageInfo buildWeLinkMessageInfo(MessageInfo message, List<MessageUser> messageUsers) {
        ILocaleString messageOwnerName;
        ArrayList<String> userOpenIds = new ArrayList<String>();
        Long userId = null;
        for (MessageUser messageUser : messageUsers) {
            userId = messageUser.getUserId();
            userOpenIds.add(messageUser.isCipher() ? messageUser.getEncryOpenId() : messageUser.getOpenId());
        }
        WeLinkMessageInfo messageInfo = new WeLinkMessageInfo();
        messageInfo.setMsgRange(0);
        messageInfo.setToUserIds(userOpenIds);
        messageInfo.setTitle(message.getTitle());
        messageInfo.setContent(message.getContent());
        if (!StringUtils.isEmpty((CharSequence)message.getMobContentUrl())) {
            messageInfo.setUrlType("html");
            messageInfo.setUrl(message.getMobContentUrl());
        }
        String lang = RequestContext.get().getLang().toString();
        if (userId != null) {
            lang = WfMultiLangUtils.getUserDefaultLang(userId);
        }
        if ((messageOwnerName = WfUtils.getPromptWordLocaleString("\u6d88\u606f\u4e2d\u5fc3", "WeLinkServiceHandler_1", "bos-wf-engine")) != null && WfUtils.isEmpty((String)messageOwnerName.get((Object)lang))) {
            messageInfo.setOwnerName((String)messageOwnerName.get((Object)lang));
        }
        messageInfo.setPublicAccID("");
        return messageInfo;
    }

    @Override
    public void completeProcessInstance(MessageContext ctx, Long proceInstanceId) {
        WeLinkCommonUtil.deleteWeLinkTodoStateByProcessInstanceId(proceInstanceId);
    }

    @Override
    public void deleteProcessInstance(MessageContext ctx, Long proceInstanceId) {
        WeLinkCommonUtil.deleteWeLinkTodoStateByProcessInstanceId(proceInstanceId);
    }

    private void addTodoLog(String errorUser, List<Long> userIds, Long taskId, WeLinkTodoType todoType) {
        if (todoType == WeLinkTodoType.CREATE) {
            if (StringUtils.isNotBlank((CharSequence)errorUser)) {
                logger.info(String.format("users [userIds = %s]create welink todo [taskId=%s] is ok", userIds.toString(), taskId));
            } else {
                logger.info("create welink todo of " + errorUser + LOGDESCRIPTION);
            }
        } else if (todoType == WeLinkTodoType.DEAL) {
            if (StringUtils.isNotBlank((CharSequence)errorUser)) {
                logger.info(String.format("users [userIds = %s] deal welink todo [taskId=%s] is ok", userIds.toString(), taskId));
            } else {
                logger.info("deal todo of " + errorUser + LOGDESCRIPTION);
            }
        } else if (StringUtils.isNotBlank((CharSequence)errorUser)) {
            logger.info(String.format("users [userIds = %s] delete welink todo [taskId=%s] is ok", userIds.toString(), taskId));
        } else {
            logger.info("deal todo of " + errorUser + LOGDESCRIPTION);
        }
    }
}

