/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.WeixinqyMessageInfo;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.handler.WeixinqyPublicHandler;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.handler.AbstractServiceHandler;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.util.MessageUtils;
import kd.bos.workflow.engine.msg.util.dingding.DingdingCommonUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaToDoUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;

public class WeixinqyPublicServiceHandler
extends AbstractServiceHandler {
    private static Log logger = LogFactory.getLog(WeixinqyPublicServiceHandler.class);
    private static final String TYPE = "kingdee_sky";
    public static final int WEIXINQYTYPEID = 3;
    private static final String TODO = "todo";
    private static final String COMMON = "common";

    @Override
    public String getServiceType() {
        return TYPE;
    }

    @Override
    public void createToDo(MessageContext ctx, ToDoInfo info) {
        super.createToDo(ctx, info);
        List<ToDoInfo> toDoInfos = YunzhijiaToDoUtil.rebuildToDoInfo(info);
        for (ToDoInfo toDoInfo : toDoInfos) {
            List userIds = toDoInfo.getUserIds();
            List<MessageUser> wxUsers = this.getUserOpenIds(userIds);
            if (wxUsers == null || wxUsers.isEmpty()) {
                logger.info("createToDo-- wxUserIds is null");
                return;
            }
            String lang = Lang.get().toString();
            if (userIds != null && !userIds.isEmpty()) {
                lang = WfMultiLangUtils.getUserDefaultLang((Long)userIds.get(0));
            }
            for (int i = 0; i < wxUsers.size(); ++i) {
                Map res;
                if (!StringUtils.isNotBlank((CharSequence)wxUsers.get(i).getEncryOpenId())) continue;
                WeixinqyMessageInfo weixinqyMessageInfo = new WeixinqyMessageInfo();
                weixinqyMessageInfo.setMsgId(toDoInfo.getTaskId().longValue());
                weixinqyMessageInfo.setToAlluser(false);
                weixinqyMessageInfo.setUserIds(wxUsers.get(i).getEncryOpenId());
                weixinqyMessageInfo.setContent(toDoInfo.getContent());
                weixinqyMessageInfo.setMsgType(TODO);
                weixinqyMessageInfo.setLinkMsg(true);
                weixinqyMessageInfo.setMsgUrl(toDoInfo.getUrl());
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("uid", wxUsers.get(i).getUserId());
                weixinqyMessageInfo.setParams(params);
                String title = DingdingCommonUtil.wrapContent(lang, toDoInfo.getTitle());
                if (!WfUtils.isEmpty(title)) {
                    weixinqyMessageInfo.setTitle(title);
                }
                if (((Boolean)(res = WeixinqyPublicHandler.sendMessage((WeixinqyMessageInfo)weixinqyMessageInfo)).get("result")).booleanValue()) continue;
                throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"WeixinqyPublicServiceHandler HaveException " + res.get("description")});
            }
            logger.info("createToDo--- push todo success taskId:" + toDoInfo.getTaskId());
        }
    }

    private List<MessageUser> getUserOpenIds(List<Long> userIds) {
        List<MessageUser> wxUsers = DingdingCommonUtil.getOpenIds(userIds, 3);
        if (wxUsers != null) {
            return wxUsers.stream().filter(item -> WfUtils.isNotEmpty(item.getEncryOpenId())).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void sendMessage(MessageContext ctx, MessageInfo message) {
        try {
            super.sendMessage(ctx, message);
            List<MessageUser> messageUsers = this.getMessageUser(message);
            if (messageUsers.isEmpty()) {
                logger.info(String.format("content: %s, userIds not have openIds, and stop send message", message.getContent()));
                throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"message userIds has no openIds all"});
            }
            if (this.checkOpenIdEmpty(messageUsers)) {
                logger.info("WeixinqyServiceHandler-- openId is blank");
                throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"message userIds has no openIds all"});
            }
            List<MessageInfo> messages = this.rebuildMessageInfos(message);
            if (MessageUtils.isBlankMessage(messages)) {
                logger.info("WeixinqyPublicServiceHandler-- messagecontent is null");
                throw new WFMessageServiceException(null, WFErrorCode.sendMsgWithoutContentError(), new Object[0]);
            }
            this.sendServiceMessage(messages, messageUsers, false);
        }
        catch (Exception e) {
            throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{WfUtils.getExceptionStacktrace(e)});
        }
    }

    @Override
    public boolean inspectChannelInfo(MsgChannelInfo msgChannelInfo) {
        String mobileAppConfig = msgChannelInfo.getMobileappconfig();
        String agentId = msgChannelInfo.getAgentid();
        return !WfUtils.isEmpty(mobileAppConfig) && !WfUtils.isEmpty(agentId);
    }

    @Override
    public List<MessageUser> getMessageUser(MessageInfo messageInfo) {
        messageInfo.addParam("useCipher", (Object)true);
        List<MessageUser> messageUser = super.getMessageUser(messageInfo);
        messageUser.stream().forEach(item -> item.setCipher(true));
        return messageUser;
    }

    private boolean checkOpenIdEmpty(List<MessageUser> messageUsers) {
        boolean isEmpty = true;
        for (MessageUser messageUser : messageUsers) {
            String openId = messageUser.isCipher() ? messageUser.getEncryOpenId() : messageUser.getOpenId();
            if (!WfUtils.isNotEmpty(openId)) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    @Override
    public Map<String, Object> postMessage(MessageInfo messageInfo, List<MessageUser> messageUsers) {
        WeixinqyMessageInfo weixinqyMessageInfo = this.buildWeixinqyMessageInfo(messageInfo, messageUsers.get(0));
        return WeixinqyPublicHandler.sendMessage((WeixinqyMessageInfo)weixinqyMessageInfo);
    }

    private WeixinqyMessageInfo buildWeixinqyMessageInfo(MessageInfo message, MessageUser messageUser) {
        WeixinqyMessageInfo messageInfo = new WeixinqyMessageInfo();
        messageInfo.setMsgId(message.getId() == null ? 0L : message.getId());
        messageInfo.setToAlluser(false);
        messageInfo.setUserIds(messageUser.getEncryOpenId());
        messageInfo.setContent(message.getContent());
        messageInfo.setMsgType(COMMON);
        if (StringUtils.isBlank((CharSequence)message.getMobContentUrl())) {
            messageInfo.setLinkMsg(false);
        } else {
            messageInfo.setLinkMsg(true);
            messageInfo.setMsgUrl(message.getMobContentUrl());
            messageInfo.setTitle(message.getTitle());
        }
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("uid", messageUser.getUserId());
        if (message.getParams().containsKey("domain")) {
            params.put("domain", (Long)message.getParams().get("domain"));
        }
        messageInfo.setParams(params);
        return messageInfo;
    }

    @Override
    public void dealToDo(MessageContext ctx, ToDoInfo info) {
        List userIds = info.getUserIds();
        List<MessageUser> wxUsers = DingdingCommonUtil.getOpenIds(userIds, 3);
        if (wxUsers.isEmpty()) {
            logger.info("weixinqyuserid is null:" + userIds);
            throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"weixinqyuserid is null:" + userIds});
        }
        for (int i = 0; i < wxUsers.size(); ++i) {
            if (!StringUtils.isNotBlank((Object)wxUsers.get(i))) continue;
            WeixinqyMessageInfo messageInfo = new WeixinqyMessageInfo();
            messageInfo.setMsgId(ctx.getTaskId().longValue());
            messageInfo.setMsgType(TODO);
            messageInfo.setUserIds(wxUsers.get(i).getEncryOpenId());
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("uid", wxUsers.get(i).getUserId());
            messageInfo.setParams(params);
            Map res = WeixinqyPublicHandler.dealMessage((WeixinqyMessageInfo)messageInfo);
            if (((Boolean)res.get("result")).booleanValue()) continue;
            throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"take WeixinqyHandler has exception " + res.get("description")});
        }
        logger.info("update todo state is success, msgId is " + ctx.getTaskId());
    }

    @Override
    public void deleteToDo(MessageContext ctx, ToDoInfo info) {
        List userIds = info.getUserIds();
        List<MessageUser> wxUsers = DingdingCommonUtil.getOpenIds(userIds, 3);
        if (wxUsers.isEmpty()) {
            logger.info("weixinqyuserid is null:" + userIds);
            throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"weixinqyuserid is null:" + userIds});
        }
        for (int i = 0; i < wxUsers.size(); ++i) {
            if (!StringUtils.isNotBlank((Object)wxUsers.get(i))) continue;
            WeixinqyMessageInfo messageInfo = new WeixinqyMessageInfo();
            messageInfo.setMsgId(ctx.getTaskId().longValue());
            messageInfo.setMsgType(TODO);
            messageInfo.setUserIds(wxUsers.get(i).getEncryOpenId());
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("uid", wxUsers.get(i).getUserId());
            messageInfo.setParams(params);
            Map res = WeixinqyPublicHandler.dealMessage((WeixinqyMessageInfo)messageInfo);
            if (((Boolean)res.get("result")).booleanValue() || ToDoInfo.State.DELETEANDCREATE.equals((Object)info.getState()) && BpmnModelUtil.instanceofUserTaskOnly(this.getTaskCategory(info))) continue;
            logger.info("ToDoInfo is :" + info.toString() + this.getTaskCategory(info));
            throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"delete WeixinHnadler has exception " + res.get("description")});
        }
        logger.info("delete todo is success, msgId is " + ctx.getTaskId());
    }

    @Override
    public void dealMessage(MessageContext ctx, MessageInfo message) {
        if (!WfConfigurationUtil.isEnabled(TYPE)) {
            return;
        }
        super.dealMessage(ctx, message);
        List userIds = message.getUserIds();
        List<MessageUser> wxUsers = DingdingCommonUtil.getOpenIds(userIds, 3);
        if (wxUsers.isEmpty()) {
            logger.info("weixinqyuserid is null:" + userIds);
            throw new WFMessageServiceException(null, WFErrorCode.dealMessageError(), new Object[]{"weixinqyuserid is null:" + userIds});
        }
        wxUsers.forEach(wxUser -> {
            if (StringUtils.isNotBlank((Object)wxUser)) {
                WeixinqyMessageInfo messageInfo = new WeixinqyMessageInfo();
                messageInfo.setMsgId(message.getId().longValue());
                messageInfo.setUserIds(wxUser.getEncryOpenId());
                messageInfo.setMsgType(COMMON);
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("uid", wxUser.getUserId());
                messageInfo.setParams(params);
                Map res = WeixinqyPublicHandler.dealMessage((WeixinqyMessageInfo)messageInfo);
                if (!((Boolean)res.get("result")).booleanValue()) {
                    logger.info("messageInfo is :" + message.toString());
                    throw new WFMessageServiceException(null, WFErrorCode.dealMessageError(), new Object[]{TYPE, res.get("description")});
                }
            }
        });
    }

    @Override
    public boolean canDealMessage(MessageInfo message, Map<String, Object> param) {
        return true;
    }

    private String getTaskCategory(ToDoInfo info) {
        TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(info.getTaskId());
        if (task != null) {
            return task.getCategory();
        }
        return null;
    }
}

