/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.WeixinqyMessageInfo;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.handler.WeixinqyHandler;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.handler.AbstractServiceHandler;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.util.MessageUtils;
import kd.bos.workflow.engine.msg.util.dingding.DingdingCommonUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaToDoUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;

public class WeixinqyServiceHandler
extends AbstractServiceHandler {
    private static Log logger = LogFactory.getLog(WeixinqyServiceHandler.class);
    public static final String TYPE = "weixinqy";
    public static final int WEIXINQYTYPEID = 3;
    private static final String TODO = "todo";
    private static final String COMMON = "common";

    @Override
    public String getServiceType() {
        return TYPE;
    }

    @Override
    public void createToDo(MessageContext ctx, ToDoInfo info) {
        super.createToDo(ctx, info);
        boolean isReplaceApp = this.isReplaceAppModel();
        List userIds = info.getUserIds();
        List<MessageUser> wxUsers = DingdingCommonUtil.getOpenIds(userIds, 3);
        if (wxUsers.isEmpty()) {
            logger.debug("WeixinqyServiceHandler-- weixinqyuserid is blank");
            throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"weixinqyuserid is blank:" + userIds});
        }
        boolean allOpenIdEmpty = true;
        for (MessageUser messageUser : wxUsers) {
            String openId = isReplaceApp ? messageUser.getEncryOpenId() : messageUser.getOpenId();
            if (!WfUtils.isNotEmpty(openId)) continue;
            allOpenIdEmpty = false;
            break;
        }
        if (allOpenIdEmpty) {
            logger.debug("WeixinqyServiceHandler-- openId is blank");
            throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"openId is blank:" + userIds});
        }
        List<ToDoInfo> toDoInfos = YunzhijiaToDoUtil.rebuildToDoInfo(info);
        for (ToDoInfo toDoInfo : toDoInfos) {
            String lang = Lang.get().toString();
            if (userIds != null && !userIds.isEmpty()) {
                lang = WfMultiLangUtils.getUserDefaultLang((Long)userIds.get(0));
            }
            List currentUserIds = toDoInfo.getUserIds();
            List currentUsers = wxUsers.stream().filter(item -> currentUserIds.contains(item.getUserId())).collect(Collectors.toList());
            for (int i = 0; i < currentUsers.size(); ++i) {
                Map res;
                String openId;
                String string = openId = isReplaceApp ? ((MessageUser)currentUsers.get(i)).getEncryOpenId() : ((MessageUser)currentUsers.get(i)).getOpenId();
                if (!StringUtils.isNotBlank((CharSequence)openId)) continue;
                WeixinqyMessageInfo weixinqyMessageInfo = new WeixinqyMessageInfo();
                weixinqyMessageInfo.setMsgId(toDoInfo.getTaskId().longValue());
                weixinqyMessageInfo.setToAlluser(false);
                weixinqyMessageInfo.setUserIds(openId);
                weixinqyMessageInfo.setContent(toDoInfo.getContent());
                weixinqyMessageInfo.setMsgType(TODO);
                weixinqyMessageInfo.setLinkMsg(true);
                weixinqyMessageInfo.setMsgUrl(toDoInfo.getUrl());
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("uid", ((MessageUser)currentUsers.get(i)).getUserId());
                weixinqyMessageInfo.setParams(params);
                String title = DingdingCommonUtil.wrapContent(lang, toDoInfo.getTitle());
                if (!WfUtils.isEmpty(title)) {
                    weixinqyMessageInfo.setTitle(title);
                }
                if (((Boolean)(res = MessageServiceHelper.sendWeixinqyMessage((WeixinqyMessageInfo)weixinqyMessageInfo)).get("result")).booleanValue()) continue;
                throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"take WeixinqyHandler has exception " + res.get("description")});
            }
            logger.debug("createToDo--- push todo success taskId:" + toDoInfo.getTaskId());
        }
    }

    private boolean isReplaceAppModel() {
        boolean isReplaceApp = false;
        try {
            MsgChannelInfo weixinCacheInfo = MsgServiceCache.getMsgChannel((String)TYPE);
            String mobileappconfig = weixinCacheInfo.getMobileappconfig();
            if (WfUtils.isNotEmpty(mobileappconfig)) {
                JSONObject config = JSONObject.parseObject((String)mobileappconfig);
                isReplaceApp = config.getBooleanValue("isreplaceapp");
            }
        }
        catch (Exception e) {
            logger.error(String.format("WeixinqyServiceHandler-error:%s", WfUtils.getExceptionStacktrace(e)));
        }
        return isReplaceApp;
    }

    private boolean checkOpenIdEmpty(List<MessageUser> messageUsers) {
        boolean isEmpty = true;
        for (MessageUser messageUser : messageUsers) {
            String openId = messageUser.isCipher() ? messageUser.getEncryOpenId() : messageUser.getOpenId();
            if (!WfUtils.isNotEmpty(openId)) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    @Override
    public List<MessageUser> getMessageUser(MessageInfo messageInfo) {
        boolean isReplaceApp = this.isReplaceAppModel();
        messageInfo.addParam("useCipher", (Object)isReplaceApp);
        List<MessageUser> messageUser = super.getMessageUser(messageInfo);
        messageUser.stream().forEach(item -> {
            if (isReplaceApp) {
                item.setCipher(true);
            }
        });
        return messageUser;
    }

    @Override
    public void sendMessage(MessageContext ctx, MessageInfo message) {
        try {
            super.sendMessage(ctx, message);
            logger.debug("WeixinqyServiceHandler send message");
            List<MessageUser> messageUsers = this.getMessageUser(message);
            if (messageUsers.isEmpty()) {
                logger.debug(String.format("content: %s, userIds not have openIds, and stop send Message", message.getContent()));
                throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"message userIds has no openIds all"});
            }
            if (this.checkOpenIdEmpty(messageUsers)) {
                logger.debug("WeixinqyServiceHandler-- openId is blank");
                throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"message userIds has no openIds all"});
            }
            List<MessageInfo> messages = this.rebuildMessageInfos(message);
            if (MessageUtils.isBlankMessage(messages)) {
                logger.debug("WeixinqyServiceHandler-- messagecontent is blank");
                throw new WFMessageServiceException(null, WFErrorCode.sendMsgWithoutContentError(), new Object[0]);
            }
            this.sendServiceMessage(messages, messageUsers, false);
        }
        catch (Exception e) {
            throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{WfUtils.getExceptionStacktrace(e)});
        }
    }

    @Override
    public boolean inspectChannelInfo(MsgChannelInfo msgChannelInfo) {
        String corpId = msgChannelInfo.getCorpid();
        String appSecret = msgChannelInfo.getAppsecret();
        String agentId = msgChannelInfo.getAgentid();
        return !WfUtils.isEmpty(corpId) && !WfUtils.isEmpty(appSecret) && !WfUtils.isEmpty(agentId);
    }

    @Override
    public Map<String, Object> postMessage(MessageInfo messageInfo, List<MessageUser> messageUsers) {
        WeixinqyMessageInfo weixinqyMessageInfo = this.buildWeixinqyMessageInfo(messageInfo, messageUsers.get(0));
        return MessageServiceHelper.sendWeixinqyMessage((WeixinqyMessageInfo)weixinqyMessageInfo);
    }

    private WeixinqyMessageInfo buildWeixinqyMessageInfo(MessageInfo message, MessageUser messageUser) {
        String openId = messageUser.isCipher() ? messageUser.getEncryOpenId() : messageUser.getOpenId();
        WeixinqyMessageInfo messageInfo = new WeixinqyMessageInfo();
        messageInfo.setMsgId(message.getId() == null ? 0L : message.getId());
        messageInfo.setToAlluser(false);
        messageInfo.setUserIds(openId);
        messageInfo.setContent(message.getContent());
        messageInfo.setMsgType(COMMON);
        if (StringUtils.isBlank((CharSequence)message.getMobContentUrl())) {
            messageInfo.setLinkMsg(false);
        } else {
            messageInfo.setLinkMsg(true);
            messageInfo.setMsgUrl(message.getMobContentUrl());
            messageInfo.setTitle(message.getTitle());
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("uid", messageUser.getUserId());
            messageInfo.setParams(params);
        }
        return messageInfo;
    }

    @Override
    public void dealToDo(MessageContext ctx, ToDoInfo info) {
        List userIds = info.getUserIds();
        List<MessageUser> wxUsers = DingdingCommonUtil.getOpenIds(userIds, 3);
        if (wxUsers.isEmpty()) {
            logger.debug("weixinqyuserid is blank:" + userIds);
            throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"weixinqyuserid is blank:" + userIds});
        }
        boolean isReplaceApp = this.isReplaceAppModel();
        for (int i = 0; i < wxUsers.size(); ++i) {
            if (!StringUtils.isNotBlank((Object)wxUsers.get(i))) continue;
            String openId = isReplaceApp ? wxUsers.get(i).getEncryOpenId() : wxUsers.get(i).getOpenId();
            WeixinqyMessageInfo messageInfo = new WeixinqyMessageInfo();
            messageInfo.setMsgId(ctx.getTaskId().longValue());
            messageInfo.setMsgType(TODO);
            messageInfo.setUserIds(openId);
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("uid", wxUsers.get(i).getUserId());
            messageInfo.setParams(params);
            Map res = WeixinqyHandler.dealTodo((WeixinqyMessageInfo)messageInfo);
            if (((Boolean)res.get("result")).booleanValue()) continue;
            throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"take WeixinqyHandler has exception " + res.get("description")});
        }
        logger.debug("update todo state is success, msgId is " + ctx.getTaskId());
    }

    @Override
    public void deleteToDo(MessageContext ctx, ToDoInfo info) {
        List userIds = info.getUserIds();
        List<MessageUser> wxUsers = DingdingCommonUtil.getOpenIds(userIds, 3);
        if (wxUsers.isEmpty()) {
            logger.debug("weixinqyuserid is blank:" + userIds);
            throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"weixinqyuserid is blank:" + userIds});
        }
        boolean isReplaceApp = this.isReplaceAppModel();
        for (int i = 0; i < wxUsers.size(); ++i) {
            if (!StringUtils.isNotBlank((Object)wxUsers.get(i))) continue;
            String openId = isReplaceApp ? wxUsers.get(i).getEncryOpenId() : wxUsers.get(i).getOpenId();
            WeixinqyMessageInfo messageInfo = new WeixinqyMessageInfo();
            messageInfo.setMsgId(ctx.getTaskId().longValue());
            messageInfo.setMsgType(TODO);
            messageInfo.setUserIds(openId);
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("uid", wxUsers.get(i).getUserId());
            messageInfo.setParams(params);
            Map res = WeixinqyHandler.dealTodo((WeixinqyMessageInfo)messageInfo);
            if (((Boolean)res.get("result")).booleanValue() || ToDoInfo.State.DELETEANDCREATE.equals((Object)info.getState()) && BpmnModelUtil.instanceofUserTaskOnly(this.getTaskCategory(info))) continue;
            logger.debug("ToDoInfo is :" + info.toString() + this.getTaskCategory(info));
            throw new WFMessageServiceException(null, WFErrorCode.weixinqyMsgError(), new Object[]{"delete WeixinHnadler has exception " + res.get("description")});
        }
        logger.debug("delete todo is success, msgId is " + ctx.getTaskId());
    }

    @Override
    public void dealMessage(MessageContext ctx, MessageInfo message) {
        if (!WfConfigurationUtil.isEnabled(TYPE)) {
            return;
        }
        super.dealMessage(ctx, message);
        List userIds = message.getUserIds();
        List<MessageUser> wxUsers = DingdingCommonUtil.getOpenIds(userIds, 3);
        boolean isReplaceApp = this.isReplaceAppModel();
        wxUsers.forEach(wxUser -> {
            if (StringUtils.isNotBlank((Object)wxUser)) {
                String openId = isReplaceApp ? wxUser.getEncryOpenId() : wxUser.getOpenId();
                WeixinqyMessageInfo messageInfo = new WeixinqyMessageInfo();
                messageInfo.setMsgId(message.getId().longValue());
                messageInfo.setUserIds(openId);
                messageInfo.setMsgType(COMMON);
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("uid", wxUser.getUserId());
                messageInfo.setParams(params);
                Map res = WeixinqyHandler.dealTodo((WeixinqyMessageInfo)messageInfo);
                if (!((Boolean)res.get("result")).booleanValue()) {
                    throw new WFMessageServiceException(null, WFErrorCode.dealMessageError(), new Object[]{TYPE, res.get("description")});
                }
            }
        });
    }

    @Override
    public boolean canDealMessage(MessageInfo message, Map<String, Object> param) {
        return true;
    }

    private String getTaskCategory(ToDoInfo info) {
        TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(info.getTaskId());
        if (task != null) {
            return task.getCategory();
        }
        return null;
    }
}

