/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.handler.AbstractServiceHandler;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.model.yzj.YzjToDoState;
import kd.bos.workflow.engine.msg.util.MessageUtils;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaCommonUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaPubUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaToDoUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;

public class YunzhijiaEcologyServiceHandler
extends AbstractServiceHandler {
    private static Log logger = LogFactory.getLog(YunzhijiaEcologyServiceHandler.class);
    public static final String TYPE = "yunzhijiaeco";

    @Override
    public String getServiceType() {
        return TYPE;
    }

    @Override
    public void createToDo(MessageContext ctx, ToDoInfo info) {
        super.createToDo(ctx, info);
        try {
            List<ToDoInfo> toDoInfos = YunzhijiaToDoUtil.rebuildToDoInfo(info);
            for (ToDoInfo toDoInfo : toDoInfos) {
                Map<String, List<MessageUser>> messageUsers_eid = YunzhijiaCommonUtil.getMessageUserGroupByEid(toDoInfo.getUserIds());
                if (messageUsers_eid == null || messageUsers_eid.size() <= 0) continue;
                for (Map.Entry<String, List<MessageUser>> entrySet : messageUsers_eid.entrySet()) {
                    List<Long> userIds = YunzhijiaCommonUtil.getUserIds(entrySet.getValue());
                    info.setUserIds(userIds);
                    YunzhijiaCommonUtil.createUserToDo(ctx, toDoInfo, YzjToDoState.CREATE, TYPE);
                }
            }
        }
        catch (Exception e) {
            logger.info("\u751f\u6001\u4e91\u4e4b\u5bb6\u521b\u5efa\u5f85\u529e\u5931\u8d25" + e.getMessage());
            throw new WFMessageServiceException(e, WFErrorCode.yzjSendTodoError(), e.getMessage());
        }
    }

    @Override
    public void dealToDo(MessageContext ctx, ToDoInfo info) {
        block9: {
            logger.info("\u4e91\u4e4b\u5bb6\u670d\u52a1dealToDo ctx: " + ctx.toString() + ", taskId:" + info.getTaskId());
            YunzhijiaCommonUtil.checkTaskId(info.getTaskId());
            try {
                YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DEAL, TYPE);
            }
            catch (Exception e) {
                logger.info("\u66f4\u6539\u4e91\u4e4b\u5bb6\u4efb\u52a1\u72b6\u6001\u4e3a\u201c\u5df2\u529e\u201d\u5931\u8d25\u3002 " + e.getMessage());
                if (ctx.isImmediatelyRetry()) {
                    try {
                        Thread.sleep(500L);
                        YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DEAL, TYPE);
                    }
                    catch (Exception e1) {
                        logger.info("[\u7b2c\u4e00\u6b21\u91cd\u8bd5]\u66f4\u6539\u4e91\u4e4b\u5bb6\u4efb\u52a1\u72b6\u6001\u4e3a\u201c\u5df2\u529e\u201d\u5931\u8d25\u3002 " + e.getMessage());
                        try {
                            Thread.sleep(1000L);
                            YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DEAL, TYPE);
                            break block9;
                        }
                        catch (Exception e2) {
                            logger.info("[\u7b2c\u4e8c\u6b21\u91cd\u8bd5]\u66f4\u6539\u4e91\u4e4b\u5bb6\u4efb\u52a1\u72b6\u6001\u4e3a\u201c\u5df2\u529e\u201d\u5931\u8d25\u3002 " + e.getMessage());
                            try {
                                Thread.sleep(3000L);
                                YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DEAL, TYPE);
                                break block9;
                            }
                            catch (Exception e3) {
                                logger.info("[\u7b2c\u4e09\u6b21\u91cd\u8bd5]\u66f4\u6539\u4e91\u4e4b\u5bb6\u4efb\u52a1\u72b6\u6001\u4e3a\u201c\u5df2\u529e\u201d\u5931\u8d25\u3002 " + e.getMessage());
                                throw new WFMessageServiceException(e, WFErrorCode.yzjdealTodoError(), e.getMessage());
                            }
                        }
                    }
                }
                throw new WFMessageServiceException(e, WFErrorCode.yzjdealTodoError(), e.getMessage());
            }
        }
    }

    @Override
    public void deleteToDo(MessageContext ctx, ToDoInfo info) {
        block9: {
            logger.info("\u4e91\u4e4b\u5bb6\u670d\u52a1deleteToDo ctx: " + ctx.toString());
            YunzhijiaCommonUtil.checkTaskId(info.getTaskId());
            try {
                YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DELETE, TYPE);
            }
            catch (Exception e) {
                logger.info("\u5220\u9664\u4e91\u4e4b\u5bb6\u5f85\u529e\u5931\u8d25\u3002 " + e.getMessage());
                if (ctx.isImmediatelyRetry()) {
                    try {
                        Thread.sleep(500L);
                        YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DELETE, TYPE);
                    }
                    catch (Exception e1) {
                        logger.info("[\u7b2c\u4e00\u6b21\u91cd\u8bd5]\u5220\u9664\u4e91\u4e4b\u5bb6\u5f85\u529e\u5931\u8d25\u3002 " + e.getMessage());
                        try {
                            Thread.sleep(1000L);
                            YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DELETE, TYPE);
                            break block9;
                        }
                        catch (Exception e2) {
                            logger.info("[\u7b2c\u4e8c\u6b21\u91cd\u8bd5]\u5220\u9664\u4e91\u4e4b\u5bb6\u5f85\u529e\u5931\u8d25\u3002 " + e.getMessage());
                            try {
                                Thread.sleep(3000L);
                                YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DELETE, TYPE);
                                break block9;
                            }
                            catch (Exception e3) {
                                logger.info("[\u7b2c\u4e09\u6b21\u91cd\u8bd5]\u5220\u9664\u4e91\u4e4b\u5bb6\u5f85\u529e\u5931\u8d25\u3002 " + e.getMessage());
                                throw new WFMessageServiceException(e, WFErrorCode.yzjdeleteTodoError(), e.getMessage());
                            }
                        }
                    }
                }
                throw new WFMessageServiceException(e, WFErrorCode.yzjdeleteTodoError(), e.getMessage());
            }
        }
    }

    @Override
    public void checkTodo(MessageContext ctx, ToDoInfo info) {
        logger.info("\u4e91\u4e4b\u5bb6\u670d\u52a1deleteToDo ctx: " + ctx.toString());
        YunzhijiaCommonUtil.checkTaskId(info.getTaskId());
        try {
            YunzhijiaCommonUtil.checkUserToDo(ctx, info, YzjToDoState.CHECK, TYPE);
        }
        catch (Exception e) {
            logger.info("check user todo is error:" + e.getMessage());
            throw new WFMessageServiceException(e, WFErrorCode.yzjcheckTodoError(), e.getMessage());
        }
    }

    @Override
    public void sendMessage(MessageContext ctx, MessageInfo message) {
        try {
            super.sendMessage(ctx, message);
            YunzhijiaCommonUtil.embellishTodoUrl(null, message, TYPE);
            List<MessageUser> messageUsers = this.getMessageUser(message);
            if (messageUsers.isEmpty()) {
                logger.info(String.format("content: %s, userIds not have openIds, and stop send Message", message.getContent()));
                throw new WFMessageServiceException(null, WFErrorCode.yzjsendMsgError(), new Object[]{"message userIds has no openIds all"});
            }
            List<MessageInfo> messages = this.rebuildMessageInfos(message);
            if (MessageUtils.isBlankMessage(messages)) {
                logger.info("YunzhijiaEcologyServiceHandler-- messagecontent is blank");
                throw new WFMessageServiceException(null, WFErrorCode.sendMsgWithoutContentError(), new Object[0]);
            }
            this.sendServiceMessage(messages, messageUsers, YunzhijiaPubUtil.isEidSame(messageUsers));
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            throw new WFMessageServiceException(e, WFErrorCode.yzjsendMsgError(), e.getMessage());
        }
    }

    @Override
    public boolean inspectChannelInfo(MsgChannelInfo msgChannelInfo) {
        String mobileappconfig = msgChannelInfo.getMobileappconfig();
        if (WfUtils.isEmpty(mobileappconfig)) {
            return false;
        }
        JSONArray configs = JSON.parseArray((String)mobileappconfig);
        for (int i = 0; i < configs.size(); ++i) {
            JSONObject pubacc = configs.getJSONObject(i);
            String pubaccId = pubacc.getString("pubaccid");
            String pubaccKey = pubacc.getString("pubacckey");
            String pubaccApiUrl = pubacc.getString("pubaccapiurl");
            String accrEditUrl = pubacc.getString("accrediturl");
            if (WfUtils.isEmpty(pubaccId) || WfUtils.isEmpty(pubaccKey) || WfUtils.isEmpty(pubaccApiUrl) || WfUtils.isEmpty(accrEditUrl)) {
                return false;
            }
            if (!pubacc.getString("pubaccnumber").equalsIgnoreCase("flowassist")) continue;
            String appId = pubacc.getString("appid");
            String appKey = pubacc.getString("appkey");
            String mainId = pubacc.getString("maineid");
            String ecologySecret = pubacc.getString("ecologysecret");
            String createTodoUrl = pubacc.getString("createtodourl");
            String handleTodoUrl = pubacc.getString("handletodourl");
            String checkTodoUrl = pubacc.getString("checktodourl");
            if (!WfUtils.isEmpty(appId) && !WfUtils.isEmpty(appKey) && !WfUtils.isEmpty(mainId) && !WfUtils.isEmpty(ecologySecret) && !WfUtils.isEmpty(createTodoUrl) && !WfUtils.isEmpty(handleTodoUrl) && !WfUtils.isEmpty(checkTodoUrl)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> postMessage(MessageInfo messageInfo, List<MessageUser> messageUsers) {
        String eId = messageUsers.get(0).getEid();
        ArrayList<String> openIds = new ArrayList<String>(messageUsers.size());
        for (MessageUser messageUser : messageUsers) {
            openIds.add(messageUser.getOpenId());
        }
        YunzhijiaPubUtil.sendMessage(eId, openIds, messageInfo, TYPE);
        return MessageUtils.wrapResult("success", null);
    }

    @Override
    public void completeProcessInstance(MessageContext ctx, Long proceInstanceId) {
        YunzhijiaToDoUtil.deleteYzjTodoStateByProcessInstanceId(proceInstanceId);
    }

    @Override
    public void deleteProcessInstance(MessageContext ctx, Long proceInstanceId) {
        YunzhijiaToDoUtil.deleteYzjTodoStateByProcessInstanceId(proceInstanceId);
    }

    @Override
    public boolean canSynch() {
        return true;
    }

    @Override
    public boolean canCheck() {
        return true;
    }
}

