/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.handler.AbstractServiceHandler;
import kd.bos.workflow.engine.msg.handler.YunzhijiaServiceHandler;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.model.yzj.YzjToDoState;
import kd.bos.workflow.engine.msg.util.MessageUtils;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaCommonUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaPubUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaToDoUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class YunzhijiaNewEditionServiceHandler
extends AbstractServiceHandler {
    private static Log logger = LogFactory.getLog(YunzhijiaServiceHandler.class);
    public static final String TYPE = "yunzhijiaup";
    private static final String ISSENDTONOTIFYCENTER = "isSendToNotifyCenter";

    @Override
    public String getServiceType() {
        return TYPE;
    }

    @Override
    public void createToDo(MessageContext ctx, ToDoInfo info) {
        try {
            YunzhijiaCommonUtil.initNewYzjTemplate(ctx, info);
            List<ToDoInfo> toDoInfos = YunzhijiaToDoUtil.rebuildNewYzjToDoInfo(info);
            for (ToDoInfo toDoInfo : toDoInfos) {
                YunzhijiaCommonUtil.createNewYzjToDo(ctx, toDoInfo);
                logger.info("create todo content=" + toDoInfo.getContent());
            }
        }
        catch (Exception e) {
            logger.info("\u4e91\u4e4b\u5bb6\u521b\u5efa\u5f85\u529e\u5931\u8d25! " + e.getMessage());
            throw new WFMessageServiceException(e, WFErrorCode.yzjSendTodoError(), e.getMessage());
        }
    }

    @Override
    public void dealToDo(MessageContext ctx, ToDoInfo info) {
        logger.info("\u4e91\u4e4b\u5bb6\u670d\u52a1dealToDo ctx: " + ctx + ",taskId:" + info.getTaskId());
        YunzhijiaCommonUtil.checkTaskId(info.getTaskId());
        try {
            YunzhijiaCommonUtil.updateNewYzjToDo(ctx, info, YzjToDoState.DEAL);
        }
        catch (Exception e) {
            logger.info("\u66f4\u6539\u4e91\u4e4b\u5bb6\u4efb\u52a1\u72b6\u6001\u4e3a\u201c\u5df2\u529e\u201d\u5931\u8d25\u3002 " + e.getMessage());
            throw new WFMessageServiceException(e, WFErrorCode.yzjdealTodoError(), e.getMessage());
        }
    }

    @Override
    public void deleteToDo(MessageContext ctx, ToDoInfo info) {
        block2: {
            logger.info("\u4e91\u4e4b\u5bb6\u670d\u52a1deleteToDo ctx: " + ctx);
            YunzhijiaCommonUtil.checkTaskId(info.getTaskId());
            try {
                YunzhijiaCommonUtil.updateNewYzjToDo(ctx, info, YzjToDoState.DELETE);
            }
            catch (Exception e) {
                logger.info("\u5220\u9664\u4e91\u4e4b\u5bb6\u5f85\u529e\u5931\u8d25\u3002 " + e.getMessage());
                if (!ctx.isImmediatelyRetry()) break block2;
                throw new WFMessageServiceException(e, WFErrorCode.yzjdeleteTodoError(), e.getMessage());
            }
        }
    }

    @Override
    public void checkTodo(MessageContext ctx, ToDoInfo info) {
        logger.info("\u4e91\u4e4b\u5bb6\u670d\u52a1deleteToDo ctx: " + ctx);
    }

    @Override
    public void startProcessInstance(MessageContext ctx, Long processInstanceId) {
        logger.info("\u4e91\u4e4b\u5bb6\u670d\u52a1startProcess procId: " + processInstanceId);
        try {
            YunzhijiaCommonUtil.resetNewYzj(ctx.getBusinessKey());
        }
        catch (Exception e) {
            logger.info("\u6d41\u7a0b\u5f00\u59cb\uff0c\u5904\u7406\u4e91\u4e4b\u5bb6\u7edf\u4e00\u6d41\u7a0b\u4e2d\u5fc3\u5931\u8d25:[%s]", (Object)WfUtils.getExceptionStacktrace(e));
        }
    }

    @Override
    public void deleteProcessInstance(MessageContext ctx, Long processInstanceId) {
        logger.info("\u4e91\u4e4b\u5bb6\u670d\u52a1deleteProcess procId: " + processInstanceId);
        try {
            YunzhijiaCommonUtil.deleteProcess(processInstanceId, TYPE, ctx.getBusinessKey());
        }
        catch (Exception e) {
            logger.info("\u5220\u9664\u4e91\u4e4b\u5bb6\u6d41\u7a0b\u5931\u8d25! " + e.getMessage());
        }
    }

    @Override
    public void completeProcessInstance(MessageContext ctx, Long processInstanceId) {
        logger.info("\u4e91\u4e4b\u5bb6\u670d\u52a1completeProcess procId: " + processInstanceId);
        try {
            YunzhijiaCommonUtil.completeProcess(processInstanceId, TYPE, ctx.getBusinessKey());
            logger.info("yzjup completeprocess is ok");
        }
        catch (Exception e) {
            logger.info("\u6807\u8bb0\u4e91\u4e4b\u5bb6\u6d41\u7a0b\u4e3a\u5df2\u5b8c\u6210\u5931\u8d25! " + e.getMessage());
        }
    }

    @Override
    public void sendMessage(MessageContext ctx, MessageInfo message) {
        try {
            super.sendMessage(ctx, message);
            if (MessageTypeEnum.CIRCULATION.getNumber().equals(message.getTplScene())) {
                YunzhijiaCommonUtil.embellishTodoUrl(null, message, TYPE);
                List<MessageUser> messageUsers = this.getMessageUser(message);
                if (messageUsers.isEmpty()) {
                    logger.info(String.format("content: %s, userIds not have openIds, and stop send Message", message.getContent()));
                    throw new WFMessageServiceException(null, WFErrorCode.yzjsendMsgError(), new Object[]{"message userIds has no openIds all"});
                }
                List<MessageInfo> messages = this.rebuildMessageInfos(message);
                if (MessageUtils.isBlankMessage(messages)) {
                    logger.info("YunzhijiaNewEditionServiceHandler-- messagecontent is blank");
                    throw new WFMessageServiceException(null, WFErrorCode.sendMsgWithoutContentError(), new Object[0]);
                }
                this.sendServiceMessage(messages, messageUsers, YunzhijiaPubUtil.isEidSame(messageUsers));
            } else {
                MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)TYPE);
                String config = msgChannelInfo.getConfig();
                boolean isSendToNotifyCenter = false;
                if (StringUtils.isNotBlank((CharSequence)config) && config.contains("sendtonotifycenter")) {
                    JSONObject configJson = JSONObject.parseObject((String)config.trim());
                    isSendToNotifyCenter = configJson.getBoolean("sendtonotifycenter");
                }
                message.addParam(ISSENDTONOTIFYCENTER, (Object)isSendToNotifyCenter);
                YunzhijiaCommonUtil.embellishTodoUrl(null, message, TYPE);
                List<MessageUser> messageUsers = this.getMessageUser(message);
                if (messageUsers.isEmpty()) {
                    logger.info(String.format("content: %s, userIds not have openIds, and stop send Message", message.getContent()));
                    throw new WFMessageServiceException(null, WFErrorCode.yzjsendMsgError(), new Object[]{"message userIds has no openIds all"});
                }
                logger.info("userId have filter by system and openId");
                List<MessageInfo> messages = this.rebuildMessageInfos(message);
                if (MessageUtils.isBlankMessage(messages)) {
                    logger.info("YunzhijiaNewEditionServiceHandler-- messagecontent is blank");
                    throw new WFMessageServiceException(null, WFErrorCode.sendMsgWithoutContentError(), new Object[0]);
                }
                this.sendServiceMessage(messages, messageUsers, YunzhijiaPubUtil.isEidSame(messageUsers));
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            throw new WFMessageServiceException(e, WFErrorCode.yzjsendMsgError(), e.getMessage());
        }
    }

    @Override
    public boolean inspectChannelInfo(MsgChannelInfo msgChannelInfo) {
        String mobileappconfig = msgChannelInfo.getMobileappconfig();
        if (WfUtils.isEmpty(mobileappconfig)) {
            return false;
        }
        JSONArray configs = JSON.parseArray((String)mobileappconfig);
        for (int i = 0; i < configs.size(); ++i) {
            JSONObject pubacc = configs.getJSONObject(i);
            String pubaccId = pubacc.getString("pubaccid");
            String pubaccKey = pubacc.getString("pubacckey");
            String pubaccApiUrl = pubacc.getString("pubaccapiurl");
            String accrEditUrl = pubacc.getString("accrediturl");
            if (WfUtils.isEmpty(pubaccId) || WfUtils.isEmpty(pubaccKey) || WfUtils.isEmpty(pubaccApiUrl) || WfUtils.isEmpty(accrEditUrl)) {
                return false;
            }
            if (!pubacc.getString("pubaccnumber").equalsIgnoreCase("flowassist")) continue;
            String appId = pubacc.getString("appid");
            String appKey = pubacc.getString("appkey");
            String approveAppId = pubacc.getString("approveappid");
            String approveAppKey = pubacc.getString("approveappkey");
            String eId = pubacc.getString("eid");
            String domain = pubacc.getString("domainname");
            if (!WfUtils.isEmpty(appId) && !WfUtils.isEmpty(appKey) && !WfUtils.isEmpty(approveAppId) && !WfUtils.isEmpty(approveAppKey) && !WfUtils.isEmpty(eId) && !WfUtils.isEmpty(domain)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<MessageInfo> rebuildMessageInfos(MessageInfo message) {
        List<MessageInfo> messages = null;
        if (MessageTypeEnum.CIRCULATION.getNumber().equals(message.getTplScene())) {
            MessageContext ctxObj = (MessageContext)SerializationUtils.fromJsonString((String)((String)message.getParams().get("messageContext")), MessageContext.class);
            WorkflowService service = (WorkflowService)ServiceFactory.getService((String)"WorkflowService");
            DynamicObject taskDynobj = null;
            TaskEntity task = (TaskEntity)service.getTaskService().getTask(ctxObj.getTaskId());
            if (task == null) {
                HistoricTaskInstanceEntityImpl hisTask = (HistoricTaskInstanceEntityImpl)service.getTaskService().getHistoricTask(ctxObj.getTaskId());
                if (hisTask == null) {
                    logger.info("task is null, please check taskId");
                    throw new WFMessageServiceException(null, WFErrorCode.emptyErrorCode(), new Object[]{"task is null"});
                }
                taskDynobj = hisTask.getDynamicObject();
            } else {
                taskDynobj = task.getDynamicObject();
            }
            messages = YunzhijiaToDoUtil.rebuildNewYzjMessage(message, taskDynobj);
        } else {
            messages = super.rebuildMessageInfos(message);
        }
        return messages;
    }

    @Override
    public Map<String, Object> postMessage(MessageInfo messageInfo, List<MessageUser> messageUsers) {
        String eId = messageUsers.get(0).getEid();
        ArrayList<String> openIds = new ArrayList<String>(messageUsers.size());
        for (MessageUser messageUser : messageUsers) {
            openIds.add(messageUser.getOpenId());
        }
        if (MessageTypeEnum.CIRCULATION.getNumber().equals(messageInfo.getTplScene())) {
            YunzhijiaCommonUtil.copySendYunzhijiaUp(messageInfo, openIds);
        } else {
            boolean isSendToNotifyCenter = (Boolean)messageInfo.getParams().get(ISSENDTONOTIFYCENTER);
            if (isSendToNotifyCenter) {
                YunzhijiaCommonUtil.sendMessageToNoticeCenter(eId, openIds, messageInfo, TYPE);
            } else {
                YunzhijiaPubUtil.sendMessage(eId, openIds, messageInfo, TYPE);
            }
        }
        return MessageUtils.wrapResult("success", null);
    }

    @Override
    public void dealMessage(MessageContext ctx, MessageInfo message) {
        if (!WfConfigurationUtil.isEnabled(TYPE)) {
            return;
        }
        logger.info("\u4e91\u4e4b\u5bb6\u670d\u52a1dealMessage messageId: " + message.getId());
        try {
            Long userId = (Long)message.getUserIds().get(0);
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)userId)};
            DynamicObject[] userObjects = BusinessDataServiceHelper.load((String)"bos_user", (String)"id, useropenid", (QFilter[])filters);
            String openId = userObjects[0].getString("useropenid");
            if (StringUtils.isBlank((CharSequence)openId)) {
                logger.info("\u6807\u8bb0\u4e91\u4e4b\u5bb6\u6d41\u7a0b\u4e3a\u5df2\u5b8c\u6210\u5931\u8d25! " + userId);
                throw new WFMessageServiceException(null, WFErrorCode.yzjCheckUserOpenIdError(), new Object[]{userId});
            }
            if (MessageTypeEnum.CIRCULATION.getNumber().equals(message.getTplScene())) {
                Object[] msgIds = new Object[]{message.getId() + openId};
                YunzhijiaCommonUtil.setCopyMsgRead(msgIds);
            } else {
                YunzhijiaCommonUtil.dealMessage(openId, message, TYPE);
            }
            logger.info("yzjup dealMessage is ok");
        }
        catch (Exception e) {
            logger.info("\u6807\u8bb0\u4e91\u4e4b\u5bb6\u6d41\u7a0b\u4e3a\u5df2\u5b8c\u6210\u5931\u8d25! " + e.getMessage());
            throw new WFMessageServiceException(e, WFErrorCode.dealMessageError(), TYPE, e.getMessage());
        }
    }

    @Override
    public boolean canDealMessage(MessageInfo message, Map<String, Object> param) {
        MsgChannelInfo msgChannelInfo;
        String channelConfig;
        if (MessageTypeEnum.CIRCULATION.getNumber().equals(message.getTplScene())) {
            return false;
        }
        if (param != null && !param.isEmpty() && param.get("msgChannelInfo") instanceof MsgChannelInfo && (channelConfig = (msgChannelInfo = (MsgChannelInfo)param.get("msgChannelInfo")).getConfig()) != null && channelConfig.contains("sendtonotifycenter")) {
            JSONObject configJson = JSONObject.parseObject((String)channelConfig.trim());
            return configJson.getBoolean("sendtonotifycenter");
        }
        return false;
    }
}

