/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.handler.AbstractServiceHandler;
import kd.bos.workflow.engine.msg.info.ITaskMsg;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.model.yzj.YzjToDoState;
import kd.bos.workflow.engine.msg.util.MessageUtils;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaCommonUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaPubUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaToDoUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;

public class YunzhijiaServiceHandler
extends AbstractServiceHandler {
    private static Log logger = LogFactory.getLog(YunzhijiaServiceHandler.class);
    public static final String TYPE = "yunzhijia";

    @Override
    public String getServiceType() {
        return TYPE;
    }

    @Override
    public void updateTodoContent(ToDoInfo todoInfo) {
        Map<String, Object> resultMap = MessageServiceUtil.updateToDoMsgContentForYunzhijia(this.config, (ITaskMsg)todoInfo);
        YunzhijiaCommonUtil.wrapContent(todoInfo, resultMap, TYPE, todoInfo.getParams());
    }

    @Override
    public void createToDo(MessageContext ctx, ToDoInfo info) {
        super.createToDo(ctx, info);
        List<ToDoInfo> toDoInfos = YunzhijiaToDoUtil.rebuildToDoInfo(info);
        for (ToDoInfo toDoInfo : toDoInfos) {
            try {
                YunzhijiaCommonUtil.createUserToDo(ctx, toDoInfo, YzjToDoState.CREATE, TYPE);
                logger.debug("create todo content=" + toDoInfo.getTaskId());
            }
            catch (Exception e) {
                throw new WFMessageServiceException(e, WFErrorCode.yzjSendTodoError(), e.getMessage());
            }
        }
    }

    @Override
    public void dealToDo(MessageContext ctx, ToDoInfo info) {
        block9: {
            logger.debug("\u4e91\u4e4b\u5bb6\u670d\u52a1dealToDo ctx: " + ctx.toString() + ",taskId:" + info.getTaskId());
            YunzhijiaCommonUtil.checkTaskId(info.getTaskId());
            try {
                YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DEAL, TYPE);
            }
            catch (Exception e) {
                this.logYzjError(e, 0, YzjToDoState.DEAL);
                if (ctx.isImmediatelyRetry()) {
                    try {
                        Thread.sleep(500L);
                        YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DEAL, TYPE);
                    }
                    catch (Exception e1) {
                        this.logYzjError(e1, 1, YzjToDoState.DEAL);
                        try {
                            Thread.sleep(1000L);
                            YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DEAL, TYPE);
                            break block9;
                        }
                        catch (Exception e2) {
                            this.logYzjError(e2, 2, YzjToDoState.DEAL);
                            try {
                                Thread.sleep(3000L);
                                YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DEAL, TYPE);
                                break block9;
                            }
                            catch (Exception e3) {
                                this.logYzjError(e3, 3, YzjToDoState.DEAL);
                                throw new WFMessageServiceException(e, WFErrorCode.yzjdealTodoError(), e.getMessage());
                            }
                        }
                    }
                }
                throw new WFMessageServiceException(e, WFErrorCode.yzjdealTodoError(), e.getMessage());
            }
        }
    }

    @Override
    public void deleteToDo(MessageContext ctx, ToDoInfo info) {
        block9: {
            logger.info("\u4e91\u4e4b\u5bb6\u670d\u52a1deleteToDo ctx: " + ctx.toString());
            YunzhijiaCommonUtil.checkTaskId(info.getTaskId());
            try {
                YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DELETE, TYPE);
            }
            catch (Exception e) {
                this.logYzjError(e, 0, YzjToDoState.DELETE);
                if (ctx.isImmediatelyRetry()) {
                    try {
                        Thread.sleep(500L);
                        YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DELETE, TYPE);
                    }
                    catch (Exception e1) {
                        this.logYzjError(e1, 1, YzjToDoState.DELETE);
                        try {
                            Thread.sleep(1000L);
                            YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DELETE, TYPE);
                            break block9;
                        }
                        catch (Exception e2) {
                            this.logYzjError(e2, 2, YzjToDoState.DELETE);
                            try {
                                Thread.sleep(3000L);
                                YunzhijiaCommonUtil.updateUserToDo(ctx, info, YzjToDoState.DELETE, TYPE);
                                break block9;
                            }
                            catch (Exception e3) {
                                this.logYzjError(e3, 3, YzjToDoState.DELETE);
                                throw new WFMessageServiceException(e, WFErrorCode.yzjdeleteTodoError(), e.getMessage());
                            }
                        }
                    }
                }
                throw new WFMessageServiceException(e, WFErrorCode.yzjdeleteTodoError(), e.getMessage());
            }
        }
    }

    private void logYzjError(Exception e, int times, YzjToDoState todostate) {
        StringBuilder errorInfo = new StringBuilder();
        if (1 == times) {
            errorInfo.append(ResManager.loadKDString((String)"[\u7b2c\u4e00\u6b21\u91cd\u8bd5]", (String)"YunzhijiaServiceHandler_0", (String)"bos-wf-engine", (Object[])new Object[0]));
        } else if (2 == times) {
            errorInfo.append(ResManager.loadKDString((String)"[\u7b2c\u4e8c\u6b21\u91cd\u8bd5]", (String)"YunzhijiaServiceHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        } else if (3 == times) {
            errorInfo.append(ResManager.loadKDString((String)"[\u7b2c\u4e09\u6b21\u91cd\u8bd5]", (String)"YunzhijiaServiceHandler_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (YzjToDoState.DELETE == todostate) {
            errorInfo.append(ResManager.loadKDString((String)"\u5220\u9664\u4e91\u4e4b\u5bb6\u5f85\u529e\u5931\u8d25\u3002", (String)"YunzhijiaServiceHandler_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        } else {
            errorInfo.append(ResManager.loadKDString((String)"\u66f4\u6539\u4e91\u4e4b\u5bb6\u4efb\u52a1\u72b6\u6001\u4e3a\u201c\u5df2\u529e\u201d\u5931\u8d25\u3002", (String)"YunzhijiaServiceHandler_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        errorInfo.append(e.getMessage());
        logger.info(errorInfo.toString());
    }

    @Override
    public void checkTodo(MessageContext ctx, ToDoInfo info) {
        logger.debug("\u4e91\u4e4b\u5bb6\u670d\u52a1checkToDo ctx: " + ctx.toString());
        YunzhijiaCommonUtil.checkTaskId(info.getTaskId());
        try {
            YunzhijiaCommonUtil.checkUserToDo(ctx, info, YzjToDoState.CHECK, TYPE);
        }
        catch (Exception e) {
            logger.info("check user todo is error:" + e.getMessage());
            throw new WFMessageServiceException(e, WFErrorCode.yzjcheckTodoError(), e.getMessage());
        }
    }

    @Override
    public void sendMessage(MessageContext ctx, MessageInfo message) {
        try {
            super.sendMessage(ctx, message);
            YunzhijiaCommonUtil.embellishTodoUrl(null, message, TYPE);
            List<MessageUser> messageUsers = this.getMessageUser(message);
            if (messageUsers.isEmpty()) {
                logger.debug(String.format("content: %s, userIds not have openIds, and stop send Message", message.getContent()));
                throw new WFMessageServiceException(null, WFErrorCode.yzjsendMsgError(), new Object[]{"message userIds has no openIds all"});
            }
            List<MessageInfo> messages = this.rebuildMessageInfos(message);
            if (MessageUtils.isBlankMessage(messages)) {
                logger.debug("YunzhijiaServiceHandler-messagecontent is blank");
                throw new WFMessageServiceException(null, WFErrorCode.sendMsgWithoutContentError(), new Object[0]);
            }
            this.sendServiceMessage(messages, messageUsers, YunzhijiaPubUtil.isEidSame(messageUsers));
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            throw new WFMessageServiceException(e, WFErrorCode.yzjsendMsgError(), e.getMessage());
        }
    }

    @Override
    public boolean inspectChannelInfo(MsgChannelInfo msgChannelInfo) {
        String mobileappconfig = msgChannelInfo.getMobileappconfig();
        if (WfUtils.isEmpty(mobileappconfig)) {
            return false;
        }
        JSONArray configs = JSON.parseArray((String)mobileappconfig);
        for (int i = 0; i < configs.size(); ++i) {
            JSONObject pubacc = configs.getJSONObject(i);
            String pubaccId = pubacc.getString("pubaccid");
            String pubaccKey = pubacc.getString("pubacckey");
            String pubaccApiUrl = pubacc.getString("pubaccapiurl");
            String accrEditUrl = pubacc.getString("accrediturl");
            if (WfUtils.isEmpty(pubaccId) || WfUtils.isEmpty(pubaccKey) || WfUtils.isEmpty(pubaccApiUrl) || WfUtils.isEmpty(accrEditUrl)) {
                return false;
            }
            if (!pubacc.getString("pubaccnumber").equalsIgnoreCase("flowassist")) continue;
            String appId = pubacc.getString("appid");
            String appKey = pubacc.getString("appkey");
            String createTodoUrl = pubacc.getString("createtodourl");
            String handleTodoUrl = pubacc.getString("handletodourl");
            String checkTodoUrl = pubacc.getString("checktodourl");
            if (!WfUtils.isEmpty(appId) && !WfUtils.isEmpty(appKey) && !WfUtils.isEmpty(createTodoUrl) && !WfUtils.isEmpty(handleTodoUrl) && !WfUtils.isEmpty(checkTodoUrl)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> postMessage(MessageInfo messageInfo, List<MessageUser> messageUsers) {
        String eId = messageUsers.get(0).getEid();
        ArrayList<String> openIds = new ArrayList<String>(messageUsers.size());
        for (MessageUser messageUser : messageUsers) {
            openIds.add(messageUser.getOpenId());
        }
        YunzhijiaPubUtil.sendMessage(eId, openIds, messageInfo, TYPE);
        return MessageUtils.wrapResult("success", null);
    }

    @Override
    public void completeProcessInstance(MessageContext ctx, Long proceInstanceId) {
        YunzhijiaToDoUtil.deleteYzjTodoStateByProcessInstanceId(proceInstanceId);
    }

    @Override
    public void deleteProcessInstance(MessageContext ctx, Long proceInstanceId) {
        YunzhijiaToDoUtil.deleteYzjTodoStateByProcessInstanceId(proceInstanceId);
    }

    @Override
    public boolean canSynch() {
        return true;
    }

    @Override
    public boolean canCheck() {
        return true;
    }
}

