/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.quantitysum;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.menuconfig.MenuConfigUtil;
import kd.bos.message.menuconfig.MessageMenuConfigObject;
import kd.bos.message.utils.MessageUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.quantitysum.QuantitySummaryInfo;

public class MessageQuantitySummaryCorrectUtils {
    private static Log logger = LogFactory.getLog(MessageQuantitySummaryCorrectUtils.class);
    private static final String MESSAGE = "message";
    private static final String BILLTYPE = "billtype";
    private static final String USERID = "userid";

    public static void getMessageQuantitySummary(Long userId, List<QuantitySummaryInfo> quantitySummaryInfos) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        MessageQuantitySummaryCorrectUtils.getMessageQuantitySummary(userIds, quantitySummaryInfos);
    }

    public static void getMessageQuantitySummary(List<Long> userIds, List<QuantitySummaryInfo> quantitySummaryInfos) {
        MessageQuantitySummaryCorrectUtils.queryProcessSummary(userIds, quantitySummaryInfos);
        MessageQuantitySummaryCorrectUtils.queryTaskSummary(userIds, quantitySummaryInfos);
        MessageQuantitySummaryCorrectUtils.queryMessageSummary(userIds, quantitySummaryInfos);
    }

    public static void getMessageQuantitySummary(Long userId, String scene, List<QuantitySummaryInfo> quantitySummaryInfos) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        if ("userAvatarBadge".equals(scene)) {
            MessageQuantitySummaryCorrectUtils.getToHandleSummary(userIds, quantitySummaryInfos);
            MessageQuantitySummaryCorrectUtils.queryMessageSummaryOfUserAvatar(userId, quantitySummaryInfos);
        } else if ("mainPageCard".equals(scene)) {
            MessageQuantitySummaryCorrectUtils.getToApplySummary(userIds, quantitySummaryInfos);
            MessageQuantitySummaryCorrectUtils.getApplyedSummary(userIds, quantitySummaryInfos);
            MessageQuantitySummaryCorrectUtils.getToHandleSummary(userIds, quantitySummaryInfos);
            MessageQuantitySummaryCorrectUtils.getHandledSummary(userIds, quantitySummaryInfos);
            MessageQuantitySummaryCorrectUtils.queryMessageSummary(userIds, quantitySummaryInfos);
        } else {
            switch (scene) {
                case "toapply": {
                    MessageQuantitySummaryCorrectUtils.getToApplySummary(userIds, quantitySummaryInfos);
                    break;
                }
                case "applyed": {
                    MessageQuantitySummaryCorrectUtils.getApplyedSummary(userIds, quantitySummaryInfos);
                    break;
                }
                case "tohandle": {
                    MessageQuantitySummaryCorrectUtils.getToHandleSummary(userIds, quantitySummaryInfos);
                    break;
                }
                case "handled": {
                    MessageQuantitySummaryCorrectUtils.getHandledSummary(userIds, quantitySummaryInfos);
                    break;
                }
                case "delegate": {
                    MessageQuantitySummaryCorrectUtils.getDelegateSummary(userIds, quantitySummaryInfos);
                    break;
                }
                case "transfer": {
                    MessageQuantitySummaryCorrectUtils.getTransferSummary(userIds, quantitySummaryInfos);
                    break;
                }
                case "custom": {
                    MessageQuantitySummaryCorrectUtils.getCustomSummary(userIds, quantitySummaryInfos);
                    break;
                }
                case "msg": {
                    MessageQuantitySummaryCorrectUtils.queryMessageSummary(userIds, quantitySummaryInfos);
                    break;
                }
            }
        }
    }

    private static void queryProcessSummary(List<Long> userIds, List<QuantitySummaryInfo> quantitySummaryInfos) {
        MessageQuantitySummaryCorrectUtils.getToApplySummary(userIds, quantitySummaryInfos);
        MessageQuantitySummaryCorrectUtils.getApplyedSummary(userIds, quantitySummaryInfos);
    }

    private static void queryTaskSummary(List<Long> userIds, List<QuantitySummaryInfo> quantitySummaryInfos) {
        MessageQuantitySummaryCorrectUtils.getToHandleSummary(userIds, quantitySummaryInfos);
        MessageQuantitySummaryCorrectUtils.getHandledSummary(userIds, quantitySummaryInfos);
        MessageQuantitySummaryCorrectUtils.getTransferSummary(userIds, quantitySummaryInfos);
        MessageQuantitySummaryCorrectUtils.getDelegateSummary(userIds, quantitySummaryInfos);
        MessageQuantitySummaryCorrectUtils.getCustomSummary(userIds, quantitySummaryInfos);
    }

    private static void queryMessageSummaryOfUserAvatar(Long userId, List<QuantitySummaryInfo> quantitySummaryInfos) {
        HashSet<Long> messageIds = new HashSet<Long>();
        List menuConfigObjects = MenuConfigUtil.getPersonMenuConfig();
        if (menuConfigObjects.size() > 0) {
            StringBuilder sql = new StringBuilder();
            String alisa = "";
            if (WfConfigurationUtil.isRepaireMsgReceiverComplete().booleanValue()) {
                sql.append("select top 100 b.fmessageid id from t_wf_msgreceiver b ");
                sql.append("where b.freceiverid = ? and b.freadstate = 'unread' ");
                alisa = "b";
            } else {
                sql.append("select top 100 b.fmessageid id from t_wf_message a lefe join t_wf_msgreceiver b on b.fmessageid = a.fid ");
                sql.append("where b.freceiverid = ? and b.freadstate = 'unread' ");
                alisa = "a";
            }
            sql.append(" and ").append(alisa).append(".ftype in (");
            for (int i = 0; i < menuConfigObjects.size(); ++i) {
                sql.append(((MessageMenuConfigObject)menuConfigObjects.get(i)).getMsgtypeid());
                if (i >= menuConfigObjects.size() - 1) continue;
                sql.append(",");
            }
            sql.append(");");
            try (DataSet dataSet = DB.queryDataSet((String)"bos.wf.MessageQuantitySummaryCorrectUtils.getMsgQuantitySummary", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[]{userId});){
                if (dataSet != null) {
                    for (Row next : dataSet) {
                        messageIds.add(next.getLong("id"));
                    }
                }
            }
            catch (Exception e) {
                logger.error(String.format("queryDBError and sql[%s], message[%s]", sql, MessageUtils.getExceptionStacktrace((Throwable)e)));
            }
        }
        quantitySummaryInfos.add(new QuantitySummaryInfo(userId, "msg", "unread", messageIds.size()));
    }

    private static void queryMessageSummary(List<Long> userIds, List<QuantitySummaryInfo> quantitySummaryInfos) {
        StringBuilder sql = new StringBuilder();
        if (WfConfigurationUtil.isRepaireMsgReceiverComplete().booleanValue()) {
            sql.append("select b.ftype billtype, b.freceiverid userid ");
            sql.append("from t_wf_msgreceiver b ");
        } else {
            sql.append("select a.ftype billtype, b.freceiverid userid ");
            sql.append("from t_wf_msgreceiver b ");
            sql.append("inner join t_wf_message a on a.fid = b.fmessageid ");
        }
        sql.append("where b.freceiverid in ").append(MessageQuantitySummaryCorrectUtils.wrapSql(userIds));
        sql.append("and b.freadstate = 'unread';");
        List<QuantitySummaryInfo> qsInfos = MessageQuantitySummaryCorrectUtils.getQuantitySummarySummaryByDataType(sql.toString(), userIds.toArray(), "msg");
        Map<String, String> typeMapping = MessageQuantitySummaryCorrectUtils.getMsgType("msg");
        HashSet<Long> uIds = new HashSet<Long>(userIds);
        for (QuantitySummaryInfo quantitySummaryInfo : qsInfos) {
            String billType = quantitySummaryInfo.getBillType();
            if (typeMapping.containsKey(billType)) {
                quantitySummaryInfo.setBillType(typeMapping.get(billType));
            }
            uIds.remove(quantitySummaryInfo.getUserId());
        }
        if (uIds.size() > 0) {
            for (Long uId : uIds) {
                qsInfos.add(new QuantitySummaryInfo(uId, "msg", MESSAGE, 0));
            }
        }
        quantitySummaryInfos.addAll(qsInfos);
    }

    private static void getTransferSummary(List<Long> userIds, List<QuantitySummaryInfo> quantitySummaryInfos) {
        StringBuilder sql = new StringBuilder();
        if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateTaskHandleLogComplete().booleanValue()) {
            sql.append("select ftaskid taskid, fownerid userid from t_wf_taskhandlelog where  ftype = 'transfer' AND fisadminforward = '0' ");
            sql.append(" and FOWNERID in ").append(MessageQuantitySummaryCorrectUtils.wrapSql(userIds));
            sql.append("and fendtype != 'mobile' AND ftaskid > 0 and fcompositetaskid = 0 AND FISDISPLAY = '1' and fendtime is null");
        } else {
            sql.append("select a.fid taskid, c.fownerid userid from t_wf_task a ");
            sql.append("left join t_wf_taskhandlelog c ON a.fid = c.ftaskid AND c.ftype = 'transfer' AND c.fisadminforward = '0' ");
            sql.append("left join t_wf_participant p on a.fid = p.ftaskid ");
            sql.append("WHERE c.FOWNERID in ").append(MessageQuantitySummaryCorrectUtils.wrapSql(userIds));
            sql.append("and a.fendtype != 'mobile' AND p.ftaskid > 0 and p.fcompositetaskid = 0 AND a.FISDISPLAY = '1';");
        }
        List<QuantitySummaryInfo> qsInfos = MessageQuantitySummaryCorrectUtils.getQuantitySummarySummaryByDataType(sql.toString(), userIds.toArray(), "transfer");
        quantitySummaryInfos.addAll(qsInfos);
    }

    private static void getDelegateSummary(List<Long> userIds, List<QuantitySummaryInfo> quantitySummaryInfos) {
        StringBuilder sql = new StringBuilder();
        if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateTaskToParticipantComplete().booleanValue()) {
            sql.append("select count(1) count, fownerid userid from t_wf_participant ");
            sql.append("where fisdisplay = '1' and ftaskdisplay = '1' and fendtype != 'mobile' and fownerid in ").append(MessageQuantitySummaryCorrectUtils.wrapSql(userIds));
            sql.append("and fcompositetaskid = 0 and fdelegateid != 0 ");
            sql.append("group by fownerid;");
        } else {
            sql.append("select count(1) count, p.fownerid userid from t_wf_task a ");
            sql.append("left join t_wf_participant p on a.fid = p.ftaskid ");
            sql.append("where a.fisdisplay = '1' and a.fendtype != 'mobile' and p.fownerid in ").append(MessageQuantitySummaryCorrectUtils.wrapSql(userIds));
            sql.append("and p.fcompositetaskid = 0 and p.fdelegateid != 0 ");
            sql.append("group by p.fownerid;");
        }
        DynamicObjectCollection dataCollection = MessageQuantitySummaryCorrectUtils.getMsgQuantitySummary(sql.toString(), userIds.toArray());
        MessageQuantitySummaryCorrectUtils.wrapMsgQuantitySummarys("delegate", dataCollection, quantitySummaryInfos);
    }

    private static void getCustomSummary(List<Long> userIds, List<QuantitySummaryInfo> quantitySummaryInfos) {
        QFilter f1 = new QFilter(USERID, "in", userIds);
        QFilter f2 = new QFilter("activitstate", "=", (Object)"enable");
        DynamicObject[] customRules = BusinessDataServiceHelper.load((String)"wf_tasknavigation", (String)"userid,taskcenterruleid", (QFilter[])new QFilter[]{f1, f2});
        if (customRules == null || customRules.length == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) count, c.fruleid billtype, b.fuserid userid ");
        sql.append("from t_wf_task a ");
        sql.append("left join t_wf_participant b on a.fid = b.ftaskid ");
        sql.append("inner join t_wf_rtrelation c on a.fid = c.ftaskid and b.fuserid = c.fuserid ");
        sql.append("where c.fruleid in (");
        for (int i = 0; i < customRules.length; ++i) {
            if (i == customRules.length - 1) {
                sql.append(customRules[i].getLong("id")).append(") ");
                continue;
            }
            sql.append(customRules[i].getLong("id")).append(",");
        }
        sql.append("and a.fisdisplay = '1' and a.fendtype != 'mobile' ");
        sql.append("and b.ftaskid > 0 and b.fcompositetaskid = 0 and b.fisdisplay = '1' and b.fuserid in ").append(MessageQuantitySummaryCorrectUtils.wrapSql(userIds));
        sql.append("group by b.fuserid, c.fruleid;");
        DynamicObjectCollection dataCollection = MessageQuantitySummaryCorrectUtils.getMsgQuantitySummary(sql.toString(), userIds.toArray());
        MessageQuantitySummaryCorrectUtils.wrapMsgQuantitySummarys("custom", dataCollection, quantitySummaryInfos);
    }

    private static void getApplyedSummary(List<Long> userIds, List<QuantitySummaryInfo> quantitySummaryInfos) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fbilltype billtype, fcreatorid userid from t_wf_hiprocinst ");
        sql.append("where fcreatorid in ").append(MessageQuantitySummaryCorrectUtils.wrapSql(userIds));
        sql.append("and fendtime is not null and fendtype != '20';");
        List<QuantitySummaryInfo> qsInfos = MessageQuantitySummaryCorrectUtils.getQuantitySummarySummaryByDataType(sql.toString(), userIds.toArray(), "applyed");
        quantitySummaryInfos.addAll(qsInfos);
        StringBuilder noCodeSql = new StringBuilder();
        noCodeSql.append("select fbilltype billtype, fcreatorid userid from t_wf_nocode_hiprocinst ");
        noCodeSql.append("where fcreatorid in ").append(MessageQuantitySummaryCorrectUtils.wrapSql(userIds));
        noCodeSql.append("and fendtime is not null and fendtype != '20';");
        qsInfos = MessageQuantitySummaryCorrectUtils.getQuantitySummarySummaryByDataType(noCodeSql.toString(), userIds.toArray(), "applyed");
        quantitySummaryInfos.addAll(qsInfos);
    }

    private static void getToApplySummary(List<Long> userIds, List<QuantitySummaryInfo> quantitySummaryInfos) {
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) count, a.fbilltype billtype, a.fcreatorid userid ");
        sql.append("from t_wf_execution a ");
        sql.append("where a.fcreatorid in ").append(MessageQuantitySummaryCorrectUtils.wrapSql(userIds));
        sql.append("and a.fparentid = 0 and a.fsuperexec = 0 and a.fisactive = '1' ");
        sql.append("group by a.fcreatorid, a.fbilltype;");
        DynamicObjectCollection dataCollection = MessageQuantitySummaryCorrectUtils.getMsgQuantitySummary(sql.toString(), userIds.toArray());
        MessageQuantitySummaryCorrectUtils.wrapMsgQuantitySummarys("toapply", dataCollection, quantitySummaryInfos);
    }

    private static void getHandledSummary(List<Long> userIds, List<QuantitySummaryInfo> quantitySummaryInfos) {
        String originalSql;
        ArrayList<Long> noHandledUserIds = new ArrayList<Long>(userIds);
        boolean enableQS = !WfConfigurationUtil.diableUseQuantitySummary();
        boolean correctHandleQSData = WfConfigurationUtil.isCorrectHandleQSData();
        if (enableQS && !correctHandleQSData) {
            logger.debug("msg.correctHandleQSData is false");
            QFilter f1 = new QFilter(USERID, "in", userIds);
            QFilter f2 = new QFilter("datatype", "=", (Object)"handled");
            QFilter[] filters = new QFilter[]{f1, f2};
            DynamicObject[] quantitySummarys = BusinessDataServiceHelper.load((String)"msg_quantitysum", (String)"userid, billtype, quantitysum", (QFilter[])filters);
            if (quantitySummarys != null && quantitySummarys.length > 0) {
                for (DynamicObject qs : quantitySummarys) {
                    Long userId = qs.getLong(USERID);
                    if (noHandledUserIds.contains(userId)) {
                        noHandledUserIds.remove(userId);
                    }
                    String billType = qs.getString(BILLTYPE);
                    int quantitySum = qs.getInt("quantitysum");
                    quantitySummaryInfos.add(new QuantitySummaryInfo(userId, "handled", billType, quantitySum));
                }
            }
        }
        if (noHandledUserIds.isEmpty()) {
            return;
        }
        logger.debug(String.format("msg.correctHandleQSData is false and noHandledUserIds[%s]", ((Object)noHandledUserIds).toString()));
        StringBuilder sqlPart = new StringBuilder();
        int range = MessageQuantitySummaryCorrectUtils.getHandleTaskQueryRange();
        if (range > 0) {
            try {
                Date currentDate = new Date();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(currentDate);
                calendar.add(2, -range);
                Date sd = calendar.getTime();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String startDate = simpleDateFormat.format(sd);
                sqlPart.append("and d.ftime >= {ts'").append(startDate).append("'} ");
            }
            catch (Exception e) {
                logger.info("getHandleTaskQueryRange function has exception:" + WfUtils.getExceptionStacktrace(e));
            }
        }
        StringBuilder sql = new StringBuilder();
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            sql.append("select count(1) count, d.fbilltype billtype, d.fuserid userid ");
            sql.append("from t_wf_hicomment d ");
            sql.append("where d.fuserid in ").append(MessageQuantitySummaryCorrectUtils.wrapSql(noHandledUserIds));
            sql.append("and d.ftype != 'suggestion' and d.fexecutiontype != 'byAuto' and d.fisdisplay = '1' and d.fendtype != 'mobile' ");
            if (WfUtils.isNotEmpty(sqlPart.toString())) {
                sql.append((CharSequence)sqlPart);
            }
            sql.append("group by d.fuserid, d.fbilltype;");
            logger.debug(String.format("queryCard, %s", sql));
            DynamicObjectCollection dataCollection = MessageQuantitySummaryCorrectUtils.getMsgQuantitySummary(sql.toString(), noHandledUserIds.toArray());
            MessageQuantitySummaryCorrectUtils.wrapMsgQuantitySummarys("handled", dataCollection, quantitySummaryInfos);
            originalSql = sql.toString();
            String noCodeSql = originalSql.replace("t_wf_hicomment", "t_wf_nocode_hicomment");
            logger.debug(String.format("queryCard_noCode, %s", noCodeSql));
            dataCollection = MessageQuantitySummaryCorrectUtils.getMsgQuantitySummary(noCodeSql, noHandledUserIds.toArray());
            MessageQuantitySummaryCorrectUtils.wrapMsgQuantitySummarys("handled", dataCollection, quantitySummaryInfos);
        } else {
            sql.append("select a.fbilltype billtype, d.fuserid userid ");
            sql.append("from t_wf_hicomment d inner join t_wf_hitaskinst a on a.fid = d.ftaskid ");
            sql.append("where d.fuserid in ").append(MessageQuantitySummaryCorrectUtils.wrapSql(noHandledUserIds));
            sql.append("and d.ftype != 'suggestion' and d.fexecutiontype != 'byAuto' and a.fisdisplay = '1' and a.fendtype != 'mobile' ");
            if (WfUtils.isNotEmpty(sqlPart.toString())) {
                sql.append((CharSequence)sqlPart);
            }
            sql.append(";");
            logger.debug(String.format("queryCard, %s", sql));
            List<QuantitySummaryInfo> qsInfos = MessageQuantitySummaryCorrectUtils.getQuantitySummarySummaryByDataType(sql.toString(), noHandledUserIds.toArray(), "handled");
            quantitySummaryInfos.addAll(qsInfos);
            originalSql = sql.toString();
            String noCodeSql = originalSql.replace("t_wf_hicomment", "t_wf_nocode_hicomment");
            noCodeSql = noCodeSql.replace("t_wf_hitaskinst", "t_wf_nocode_hitaskinst");
            logger.debug(String.format("queryCard_noCode, %s", noCodeSql));
            qsInfos = MessageQuantitySummaryCorrectUtils.getQuantitySummarySummaryByDataType(noCodeSql, noHandledUserIds.toArray(), "handled");
            quantitySummaryInfos.addAll(qsInfos);
        }
    }

    private static int getHandleTaskQueryRange() {
        int range = 0;
        try {
            QFilter qs = new QFilter("key", "=", (Object)"msg.handleTaskQueryRange");
            DynamicObject ret = BusinessDataServiceHelper.loadSingleFromCache((String)"wf_confcenter", (String)"value", (QFilter[])new QFilter[]{qs});
            if (ret != null) {
                String ds = ret.getString("value");
                range = Integer.parseInt(ds);
            }
        }
        catch (Exception e) {
            logger.info("getHandleTaskQueryRange function has exception:" + WfUtils.getExceptionStacktrace(e));
        }
        return range;
    }

    private static void getToHandleSummary(List<Long> userIds, List<QuantitySummaryInfo> quantitySummaryInfos) {
        StringBuilder sql = new StringBuilder();
        if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateTaskToParticipantComplete().booleanValue()) {
            sql.append("select count(1) count, fbilltype billtype, fuserid userid ");
            sql.append("from t_wf_participant ");
            sql.append("where fuserid in ").append(MessageQuantitySummaryCorrectUtils.wrapSql(userIds));
            sql.append(" and ftaskid > 0 and fcompositetaskid = 0 and fisdisplay = '1' and ftaskdisplay = '1' and fendtype != 'mobile' ");
            sql.append("group by fuserid, fbilltype;");
        } else {
            sql.append("select count(1) count, t.fbilltype billtype, p.fuserid userid ");
            sql.append("from t_wf_task t  left join  t_wf_participant p  on  t.fid =p.ftaskid ");
            sql.append("where p.fuserid in ").append(MessageQuantitySummaryCorrectUtils.wrapSql(userIds));
            sql.append("and p.ftaskid > 0 and p.fcompositetaskid = 0 and t.fisdisplay = '1' and t.fendtype != 'mobile' and p.fisdisplay = '1' ");
            sql.append("group by p.fuserid, t.fbilltype;");
        }
        DynamicObjectCollection dataCollection = MessageQuantitySummaryCorrectUtils.getMsgQuantitySummary(sql.toString(), userIds.toArray());
        MessageQuantitySummaryCorrectUtils.wrapMsgQuantitySummarys("tohandle", dataCollection, quantitySummaryInfos);
    }

    private static List<QuantitySummaryInfo> getQuantitySummarySummaryByDataType(String sql, Object[] params, String dataType) {
        HashMap<String, QuantitySummaryInfo> mapping = new HashMap<String, QuantitySummaryInfo>();
        HashMap userTaskIds = new HashMap();
        String alogKey = "bos.wf.correctQSInfos." + dataType;
        try {
            DataSet dataSet = DB.queryDataSet((String)alogKey, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);
            Object object = null;
            try {
                if (dataSet != null) {
                    for (Row next : dataSet) {
                        QuantitySummaryInfo quantitySummaryInfo;
                        String billType = dataType.equals("transfer") ? dataType : next.getString(BILLTYPE);
                        Long userId = next.getLong(USERID);
                        if (WfUtils.isEmpty(billType) || WfUtils.isEmpty(userId) || dataType.equals("msg") && billType.equals("475779174288613376")) continue;
                        String k = userId + billType;
                        if (mapping.containsKey(k)) {
                            quantitySummaryInfo = (QuantitySummaryInfo)mapping.get(k);
                            quantitySummaryInfo.setQuantitysum(quantitySummaryInfo.getQuantitysum() + 1);
                        } else {
                            quantitySummaryInfo = new QuantitySummaryInfo(userId, dataType, billType, 1);
                            mapping.put(k, quantitySummaryInfo);
                        }
                        if (!dataType.equals("transfer")) continue;
                        if (userTaskIds.containsKey(k)) {
                            ((Set)userTaskIds.get(k)).add(next.getLong("taskid"));
                            continue;
                        }
                        HashSet<Long> taskIds = new HashSet<Long>();
                        taskIds.add(next.getLong("taskid"));
                        userTaskIds.put(k, taskIds);
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("queryDBError and sql[%s], message[%s]", sql, MessageUtils.getExceptionStacktrace((Throwable)e)));
        }
        if (dataType.equals("transfer")) {
            Set entries = userTaskIds.entrySet();
            for (Map.Entry entry : entries) {
                QuantitySummaryInfo quantitySummaryInfo = (QuantitySummaryInfo)mapping.get(entry.getKey());
                quantitySummaryInfo.setQuantitysum(((Set)entry.getValue()).size());
            }
        }
        return mapping.values().stream().collect(Collectors.toList());
    }

    private static DynamicObjectCollection getMsgQuantitySummary(String sql, Object[] params) {
        DynamicObjectCollection dataCollection = null;
        try (DataSet ds = DB.queryDataSet((String)"bos.wf.MessageQuantitySummaryCorrectUtils.getMsgQuantitySummary", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            dataCollection = ORM.create().toPlainDynamicObjectCollection(ds);
        }
        catch (Exception e) {
            logger.error(String.format("queryDBError and sql[%s], params[%s], message[%s]", sql, Arrays.toString(params), MessageUtils.getExceptionStacktrace((Throwable)e)));
        }
        return dataCollection;
    }

    private static void wrapMsgQuantitySummarys(String dataType, DynamicObjectCollection dataCollection, List<QuantitySummaryInfo> quantitySummaryInfos) {
        if (dataCollection == null) {
            return;
        }
        Map<String, String> typeMap = MessageQuantitySummaryCorrectUtils.getMsgType(dataType);
        for (DynamicObject data : dataCollection) {
            Long userId = data.getLong(USERID);
            int quantitysum = data.getInt("count");
            if (quantitysum == 0) continue;
            String billType = "";
            billType = dataType.equals("msg") ? (typeMap.containsKey(data.getString(BILLTYPE)) ? typeMap.get(data.getString(BILLTYPE)) : data.getString(BILLTYPE)) : (dataType.equals("transfer") || dataType.equals("delegate") ? dataType : data.getString(BILLTYPE));
            quantitySummaryInfos.add(new QuantitySummaryInfo(userId, dataType, billType, quantitysum));
        }
    }

    private static Map<String, String> getMsgType(String dataType) {
        HashMap<String, String> typeMapping = new HashMap<String, String>(1);
        if (!dataType.equals("msg")) {
            return typeMapping;
        }
        DynamicObject[] typeCollection = BusinessDataServiceHelper.load((String)"msg_type", (String)"id, number", null);
        if (typeCollection == null || typeCollection.length == 0) {
            return typeMapping;
        }
        for (DynamicObject type : typeCollection) {
            typeMapping.put(type.getString("id"), type.getString("number"));
        }
        return typeMapping;
    }

    private static String wrapSql(List<Long> userIds) {
        StringBuilder sql = new StringBuilder();
        sql.append("(");
        for (int i = 0; i < userIds.size(); ++i) {
            if (i == userIds.size() - 1) {
                sql.append("?) ");
                continue;
            }
            sql.append("?,");
        }
        return sql.toString();
    }

    public static void getMessageQuantitySummaryByItemKey(Long userId, String scene, List<QuantitySummaryInfo> quantitySummaryInfos, List<String> itemKey) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        if ("mainPageCard".equals(scene)) {
            ArrayList<String> msgList = new ArrayList<String>(itemKey.size());
            for (String item : itemKey) {
                if (item.equalsIgnoreCase("tohandle")) {
                    MessageQuantitySummaryCorrectUtils.getToHandleSummary(userIds, quantitySummaryInfos);
                    continue;
                }
                if (item.equalsIgnoreCase("handled")) {
                    MessageQuantitySummaryCorrectUtils.getHandledSummary(userIds, quantitySummaryInfos);
                    continue;
                }
                if (item.equalsIgnoreCase("toapply")) {
                    MessageQuantitySummaryCorrectUtils.getToApplySummary(userIds, quantitySummaryInfos);
                    continue;
                }
                if (item.equalsIgnoreCase("applyed")) {
                    MessageQuantitySummaryCorrectUtils.getApplyedSummary(userIds, quantitySummaryInfos);
                    continue;
                }
                if (!MessageQuantitySummaryCorrectUtils.isNumeric(item) && !item.equalsIgnoreCase("unread")) continue;
                msgList.add(item);
            }
            if (msgList.size() > 0) {
                MessageQuantitySummaryCorrectUtils.queryMessageSummaryByItemKey(userIds, quantitySummaryInfos, msgList);
            }
        }
    }

    public static final boolean isNumeric(String s) {
        if (s != null && !"".equals(s.trim())) {
            return s.matches("^[0-9]*$");
        }
        return false;
    }

    private static void queryMessageSummaryByItemKey(List<Long> userIds, List<QuantitySummaryInfo> quantitySummaryInfos, List<String> msgTypeList) {
        ArrayList<Long> msgTypes = new ArrayList<Long>(msgTypeList.size());
        for (String msgType : msgTypeList) {
            if (msgType.equalsIgnoreCase("unread")) continue;
            msgTypes.add(Long.parseLong(msgType));
        }
        StringBuilder sql = new StringBuilder();
        if (WfConfigurationUtil.isRepaireMsgReceiverComplete().booleanValue()) {
            sql.append("select b.ftype billtype, b.freceiverid userid ");
            sql.append("from t_wf_msgreceiver b ");
        } else {
            sql.append("select a.ftype billtype, b.freceiverid userid ");
            sql.append("from t_wf_msgreceiver b ");
            sql.append("inner join t_wf_message a on a.fid = b.fmessageid ");
        }
        sql.append("where b.freceiverid in ").append(MessageQuantitySummaryCorrectUtils.wrapSql(userIds));
        if (msgTypes.size() > 0 && !msgTypeList.contains("unread")) {
            sql.append(" and b.ftype in ").append(MessageQuantitySummaryCorrectUtils.getContactSqlParam(msgTypes));
        }
        sql.append(" and b.freadstate = 'unread';");
        List<QuantitySummaryInfo> qsInfos = MessageQuantitySummaryCorrectUtils.getQuantitySummarySummaryByDataType(sql.toString(), userIds.toArray(), "msg");
        Map<String, String> typeMapping = MessageQuantitySummaryCorrectUtils.getMsgType("msg");
        HashSet<Long> uIds = new HashSet<Long>(userIds);
        for (QuantitySummaryInfo quantitySummaryInfo : qsInfos) {
            String billType = quantitySummaryInfo.getBillType();
            if (typeMapping.containsKey(billType)) {
                quantitySummaryInfo.setBillType(typeMapping.get(billType));
            }
            uIds.remove(quantitySummaryInfo.getUserId());
        }
        if (uIds.size() > 0) {
            for (Long uId : uIds) {
                qsInfos.add(new QuantitySummaryInfo(uId, "msg", MESSAGE, 0));
            }
        }
        quantitySummaryInfos.addAll(qsInfos);
    }

    public static List<QuantitySummaryInfo> getQTYSummaryFromBizDataByItemKey(Long userId, List<String> itemKey) {
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        ArrayList<String> msgList = new ArrayList<String>(itemKey.size());
        for (String key : itemKey) {
            if (key.equalsIgnoreCase("tohandle")) {
                MessageQuantitySummaryCorrectUtils.getToHandleSummary(userIds, quantitySummaryInfos);
                continue;
            }
            if (key.equalsIgnoreCase("handled")) {
                MessageQuantitySummaryCorrectUtils.getHandledSummary(userIds, quantitySummaryInfos);
                continue;
            }
            if (key.equalsIgnoreCase("toapply")) {
                MessageQuantitySummaryCorrectUtils.getToApplySummary(userIds, quantitySummaryInfos);
                continue;
            }
            if (key.equalsIgnoreCase("applyed")) {
                MessageQuantitySummaryCorrectUtils.getApplyedSummary(userIds, quantitySummaryInfos);
                continue;
            }
            if (!MessageQuantitySummaryCorrectUtils.isNumeric(key) && !key.equalsIgnoreCase("unread")) continue;
            msgList.add(key);
        }
        if (msgList.size() > 0) {
            MessageQuantitySummaryCorrectUtils.queryMessageSummaryByItemKey(userIds, quantitySummaryInfos, msgList);
        }
        return quantitySummaryInfos;
    }

    private static String getContactSqlParam(List<Long> param) {
        StringBuilder sql = new StringBuilder();
        sql.append("(");
        for (int i = 0; i < param.size(); ++i) {
            if (i == param.size() - 1) {
                sql.append("'").append(param.get(i)).append("'").append(")");
                continue;
            }
            sql.append("'").append(param.get(i)).append("'").append(",");
        }
        return sql.toString();
    }
}

