/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.quantitysum;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.quantitysum.IdModifyRecord;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;
import kd.bos.workflow.engine.msg.quantitysum.QuantitySummary;
import kd.bos.workflow.engine.msg.quantitysum.QuantitySummaryInfo;

public class MessageQuantitySummaryUtils {
    private static final String MESSAGEID = "messageid";
    private static final String READSTATE = "readstate";
    private static final String RECEIVERID = "receiverid";
    private static final String ENTITY_MESSAGE = "wf_msg_message";
    private static final String ENTITY_TYPE = "msg_type";
    private static final String ID = "id";
    public static final String SETREADSTATE = "setReadState";
    public static final String DELETEMESAGE = "deleteMessge";

    private static void updateQuantitySummary(List<QuantitySummaryInfo> quantitySummaryInfos, MessageQuantitySummaryServcie service) {
        if (service == null) {
            service = MessageServiceUtil.getMessageQuantitySummaryService();
        }
        service.updateQuantitySummary(quantitySummaryInfos);
    }

    public static void updateMessageQuantitySummary(MessageInfo messageInfo, List<Long> userIds) {
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        List<QuantitySummaryInfo> quantitySummaryInfos = service.gatherQuantitySummaryOfMessage(userIds, messageInfo, QuantitySummary.PLUS);
        service.updateQuantitySummary(quantitySummaryInfos);
    }

    private static Set<Long> wrapBillTypesMappings(DynamicObject[] msgTypes, Long typeId, Long messageId, Map<Long, String> msgIdMappingType) {
        HashSet<Long> msgIds = new HashSet<Long>(msgTypes.length);
        if (WfUtils.isNotEmpty(typeId)) {
            for (DynamicObject type : msgTypes) {
                if (!typeId.equals(type.getLong(ID))) continue;
                msgIdMappingType.put(messageId, type.getString("number"));
                break;
            }
            if (!msgIdMappingType.containsKey(messageId)) {
                msgIdMappingType.put(messageId, String.valueOf(typeId));
            }
        } else {
            msgIds.add(messageId);
        }
        return msgIds;
    }

    private static Map<Long, String> getBillTypesMappings(DynamicObject[] msgReceivers) {
        DynamicObject[] messages;
        HashMap<Long, String> msgIdMappingType = new HashMap<Long, String>();
        DynamicObject[] msgTypes = BusinessDataServiceHelper.load((String)ENTITY_TYPE, (String)"id, number", null);
        Set<Long> msgIds = null;
        for (DynamicObject msgReceiver : msgReceivers) {
            msgIds = MessageQuantitySummaryUtils.wrapBillTypesMappings(msgTypes, msgReceiver.getLong("type"), msgReceiver.getLong(MESSAGEID), msgIdMappingType);
        }
        if (msgIds != null && !msgIds.isEmpty() && (messages = BusinessDataServiceHelper.load((String)ENTITY_MESSAGE, (String)"id, type", (QFilter[])new QFilter[]{new QFilter(ID, "in", msgIds)})) != null && messages.length > 0) {
            for (DynamicObject message : messages) {
                MessageQuantitySummaryUtils.wrapBillTypesMappings(msgTypes, message.getLong("type"), message.getLong(ID), msgIdMappingType);
            }
        }
        return msgIdMappingType;
    }

    @Deprecated
    public static List<QuantitySummaryInfo> updateMessageQuantitySummary(DynamicObject[] msgReceivers, DynamicObject[] messageObjects, String setState, String triggerScene) {
        return MessageQuantitySummaryUtils.updateMessageQuantitySummary(msgReceivers, setState, triggerScene);
    }

    public static List<QuantitySummaryInfo> updateMessageQuantitySummary(DynamicObject[] msgReceivers, String setState, String triggerScene) {
        if (msgReceivers == null || msgReceivers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
        Map<Long, String> msgIdMappingType = MessageQuantitySummaryUtils.getBillTypesMappings(msgReceivers);
        if (triggerScene.equals(SETREADSTATE)) {
            for (DynamicObject msgReceiver : msgReceivers) {
                Long messageId;
                String billType;
                if (msgReceiver.getString(READSTATE).equalsIgnoreCase(setState) || WfUtils.isEmpty(billType = msgIdMappingType.get(messageId = Long.valueOf(msgReceiver.getLong(MESSAGEID))))) continue;
                QuantitySummary qs = setState.equals("read") ? QuantitySummary.MINUS : QuantitySummary.PLUS;
                Long userId = msgReceiver.getLong(RECEIVERID);
                MessageQuantitySummaryUtils.wrapMsgQuantitySummaryInfos(userId, billType, messageId, qs, quantitySummaryInfos);
            }
        } else if (triggerScene.equals(DELETEMESAGE)) {
            for (DynamicObject msgReceiver : msgReceivers) {
                String readState = msgReceiver.getString(READSTATE);
                if (!WfUtils.isNotEmpty(readState) || !"unread".equals(readState)) continue;
                Long messageId = msgReceiver.getLong(MESSAGEID);
                Long userId = msgReceiver.getLong(RECEIVERID);
                String billType = msgIdMappingType.get(messageId);
                if (WfUtils.isEmpty(billType)) continue;
                MessageQuantitySummaryUtils.wrapMsgQuantitySummaryInfos(userId, billType, messageId, QuantitySummary.MINUS, quantitySummaryInfos);
            }
            MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
            service.updateQuantitySummary(quantitySummaryInfos);
            service.gatherDiffData(quantitySummaryInfos);
        }
        return quantitySummaryInfos;
    }

    private static void wrapMsgQuantitySummaryInfos(Long userId, String billType, Long messageId, QuantitySummary qs, List<QuantitySummaryInfo> quantitySummaryInfos) {
        boolean isExitList = Boolean.FALSE;
        for (QuantitySummaryInfo qsInfo : quantitySummaryInfos) {
            if (!userId.equals(qsInfo.getUserId()) || !billType.equals(qsInfo.getBillType())) continue;
            qsInfo.setQuantitysum(qsInfo.getQuantitysum() + qs.getValue());
            if (!qsInfo.getIdModifyRecords().isEmpty()) {
                List<IdModifyRecord> idModifyRecords = qsInfo.getIdModifyRecords();
                idModifyRecords.add(new IdModifyRecord(IdModifyRecord.IdTypeEnum.MESSAGE, messageId, qs, new Date()));
            }
            isExitList = Boolean.TRUE;
            break;
        }
        if (!isExitList) {
            QuantitySummaryInfo qsInfo = new QuantitySummaryInfo(userId, "msg", billType, qs.getValue());
            qsInfo.getIdModifyRecords().add(new IdModifyRecord(IdModifyRecord.IdTypeEnum.MESSAGE, messageId, qs, new Date()));
            quantitySummaryInfos.add(qsInfo);
        }
    }

    public static void updateProcessQuantitySummary(ExecutionEntity executionEntity, String deleteReason) {
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        quantitySummaryInfos.addAll(service.gatherQuantitySummaryOfToApply(executionEntity, QuantitySummary.MINUS));
        quantitySummaryInfos.addAll(service.gatherQuantitySummaryOfApplyed(executionEntity, deleteReason, QuantitySummary.PLUS));
        MessageQuantitySummaryUtils.updateQuantitySummary(quantitySummaryInfos, service);
    }
}

