/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.quantitysum.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.menuconfig.MenuConfigUtil;
import kd.bos.message.menuconfig.MessageMenuConfigObject;
import kd.bos.message.utils.MessageEventListenerUtils;
import kd.bos.message.utils.MessageEventType;
import kd.bos.message.utils.MessageQuantitySummaryCacheUtils;
import kd.bos.message.utils.MessageUtils;
import kd.bos.message.utils.personalSetting.MessageBussinessInfo;
import kd.bos.message.utils.personalSetting.MessageBussinessPublishUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.portal.NewPortalServiceHelper;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentBizType;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentDataService;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityManager;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.quantitysum.CompensationType;
import kd.bos.workflow.engine.msg.quantitysum.IdModifyRecord;
import kd.bos.workflow.engine.msg.quantitysum.LocalVariables;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryCorrectUtils;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;
import kd.bos.workflow.engine.msg.quantitysum.QuantitySummary;
import kd.bos.workflow.engine.msg.quantitysum.QuantitySummaryInfo;
import kd.bos.workflow.engine.task.AttributeModifyRecord;
import kd.bos.workflow.nocode.NoCodeFlowUtil;

public class MessageQuantitySummaryServcieImpl
implements MessageQuantitySummaryServcie {
    private Log logger = LogFactory.getLog(MessageQuantitySummaryServcieImpl.class);
    private static final String KEY = "key";
    private static final String DATA = "data";
    private static final String VALUE = "value";
    private static final String USERID = "userId";
    private static final String HASHCODE = "hashCode";
    private static final String QUANTITYSUMMARYFIELDS = "id,userid,datatype,billtype,quantitysum";
    private static final String ISCORRECTFROMBIZDB = "isCorrectFormBizDB";
    private static final String QUANTITYSUMMARYINFOS = "quantitySummaryInfos";
    public static final String USERAVATAEBADGE = "userAvatarBadge";
    public static final String TASKTYPE = "taskType";
    public static final String MAINPAGECARD = "mainPageCard";
    public static final int MSGIDMODIFYRECORDMAXLEVEL = 300;
    private ConcurrentDataService concurrentDataService = ConcurrentDataService.create();

    @Override
    public List<QuantitySummaryInfo> gatherQuantitySummaryOfMessage(List<Long> userIds, MessageInfo messageInfo, QuantitySummary qs) {
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>(userIds.size());
        for (Long userId : userIds) {
            quantitySummaryInfos.add(this.wrapMessageQuantitySummary(userId, "msg", messageInfo.getType(), qs, messageInfo));
        }
        return quantitySummaryInfos;
    }

    private QuantitySummaryInfo wrapQuantitySummary(Long userId, String dataType, String billType, QuantitySummary qs) {
        return new QuantitySummaryInfo(userId, dataType, billType, qs.getValue());
    }

    private QuantitySummaryInfo wrapMessageQuantitySummary(Long userId, String dataType, String billType, QuantitySummary qs, MessageInfo messageInfo) {
        QuantitySummaryInfo quantitySummaryInfo = this.wrapQuantitySummary(userId, dataType, billType, qs);
        if ("msg".equals(dataType)) {
            quantitySummaryInfo.getIdModifyRecords().add(new IdModifyRecord(IdModifyRecord.IdTypeEnum.MESSAGE, messageInfo.getId(), qs, new Date()));
        }
        return quantitySummaryInfo;
    }

    private QuantitySummaryInfo wrapTaskQuantitySummary(Long userId, String dataType, String billType, QuantitySummary qs, TaskEntity taskEntity, IdentityLinkEntity identityLinkEntity) {
        QuantitySummaryInfo quantitySummaryInfo = this.wrapQuantitySummary(userId, dataType, billType, qs);
        if ("tohandle".equals(dataType)) {
            IdModifyRecord idModifyRecord = new IdModifyRecord(IdModifyRecord.IdTypeEnum.TASK, taskEntity.getId(), qs, new Date());
            if (qs == QuantitySummary.MINUS && identityLinkEntity.getCompositeTaskId() != null && identityLinkEntity.getCompositeTaskId() == 0L && identityLinkEntity.getOwnerId() != null && identityLinkEntity.getOwnerId() > 0L && identityLinkEntity.getDelegateId() != null && identityLinkEntity.getDelegateId() > 0L) {
                Map<String, String> params = idModifyRecord.getParams();
                params.put(TASKTYPE, "delegate");
                params.put("ownerId", String.valueOf(identityLinkEntity.getOwnerId()));
            }
            if (QuantitySummary.PLUS == qs && "coordinate".equals(identityLinkEntity.getType())) {
                idModifyRecord.getParams().put(TASKTYPE, "coordinate");
            }
            quantitySummaryInfo.getIdModifyRecords().add(idModifyRecord);
        }
        return quantitySummaryInfo;
    }

    @Override
    public List<QuantitySummaryInfo> gatherQuantitySummaryOfToApply(ExecutionEntity executionEntity, QuantitySummary qs) {
        boolean isScope;
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
        boolean bl = isScope = executionEntity.isScope() && WfUtils.isEmpty(executionEntity.getSuperExecutionId());
        if (isScope) {
            Long userId = executionEntity.getCreatorId();
            String billType = executionEntity.getBillType();
            quantitySummaryInfos.add(this.wrapQuantitySummary(userId, "toapply", billType, qs));
        }
        return quantitySummaryInfos;
    }

    @Override
    public List<QuantitySummaryInfo> gatherQuantitySummaryOfApplyed(ExecutionEntity executionEntity, String deleteReason, QuantitySummary qs) {
        boolean isScope;
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
        boolean bl = isScope = executionEntity.isScope() && WfUtils.isEmpty(executionEntity.getSuperExecutionId());
        if (isScope) {
            Long userId = executionEntity.getCreatorId();
            String billType = executionEntity.getBillType();
            if (deleteReason == null || !"process instance withdraw".equalsIgnoreCase(deleteReason)) {
                quantitySummaryInfos.add(this.wrapQuantitySummary(userId, "applyed", billType, qs));
            }
        }
        return quantitySummaryInfos;
    }

    @Override
    public List<QuantitySummaryInfo> gatherQuantitySummaryOfApplyed(HistoricProcessInstanceEntity historicProcessInstanceEntity, QuantitySummary qs) {
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
        Long creatorId = historicProcessInstanceEntity.getCreatorId();
        String billType = historicProcessInstanceEntity.getBillType();
        if (WfUtils.isNotEmpty(creatorId)) {
            quantitySummaryInfos.add(this.wrapQuantitySummary(creatorId, "applyed", billType, qs));
        }
        return quantitySummaryInfos;
    }

    private void printQuantitySummaryTraceLog(List<QuantitySummaryInfo> quantitySummaryInfos) {
        List<Long> traceUserIds = this.getQuantitySummaryTraceUserIds();
        if (!traceUserIds.isEmpty()) {
            HashMap qsInfosMapping = new HashMap();
            for (QuantitySummaryInfo qs : quantitySummaryInfos) {
                Long userId = qs.getUserId();
                if (!traceUserIds.contains(userId)) continue;
                if (qsInfosMapping.containsKey(userId)) {
                    ((List)qsInfosMapping.get(userId)).add(qs);
                    continue;
                }
                ArrayList<QuantitySummaryInfo> qsInfos = new ArrayList<QuantitySummaryInfo>();
                qsInfos.add(qs);
                qsInfosMapping.put(userId, qsInfos);
            }
            if (!qsInfosMapping.isEmpty()) {
                Exception logException = new Exception("message qs trace log");
                String stack = WfUtils.getExceptionStacktrace(logException);
                String traceId = RequestContext.get().getTraceId();
                Set entrySet = qsInfosMapping.entrySet();
                for (Map.Entry entry : entrySet) {
                    Long traceUserId = (Long)entry.getKey();
                    List value = (List)entry.getValue();
                    String v = "";
                    if (value != null && !value.isEmpty()) {
                        v = value.toString();
                    }
                    this.logger.debug(String.format("msgqs_traceLog_%s, traceId [%s], qsValue: [%s], stack: [%s] ", traceUserId, traceId, v, stack));
                }
            }
        }
    }

    private boolean isIdModifyRecordBeyondMaxLevel(QuantitySummaryInfo quantitySummaryInfo) {
        return "msg".equals(quantitySummaryInfo.getDataType()) && (quantitySummaryInfo.getQuantitysum() > 300 || quantitySummaryInfo.getQuantitysum() < -300);
    }

    @Override
    public void updateQuantitySummary(List<QuantitySummaryInfo> quantitySummaryInfos) {
        if (quantitySummaryInfos == null || quantitySummaryInfos.isEmpty()) {
            return;
        }
        this.logger.debug(String.format("MessageQuantitySummaryServcieImpl_updateqs: %s", quantitySummaryInfos.toString()));
        for (QuantitySummaryInfo quantitySummaryInfo : quantitySummaryInfos) {
            if (!this.isIdModifyRecordBeyondMaxLevel(quantitySummaryInfo)) continue;
            quantitySummaryInfo.getIdModifyRecords().clear();
        }
        final String data = SerializationUtils.toJsonString(quantitySummaryInfos);
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null && commandContext.getAttribute("isClose") == null) {
            commandContext.addCloseListener(new DefaultCommandContextCloseListener("message-updateqs"){

                @Override
                public void closed(CommandContext commandContext) {
                    MessageQuantitySummaryServcieImpl.this.concurrentDataService.gatherConcurrentData(data, ConcurrentBizType.MESSAGEQUANTITYSUMMARY, null);
                }
            });
        } else {
            this.concurrentDataService.gatherConcurrentData(data, ConcurrentBizType.MESSAGEQUANTITYSUMMARY, null);
        }
    }

    @Override
    public void dealConcurrentQuantitySummary(List<QuantitySummaryInfo> quantitySummaryInfos) {
        List<Long> correctedUserIds = null;
        try {
            correctedUserIds = this.updateQuantitySummaryCache(quantitySummaryInfos);
        }
        catch (Exception e) {
            this.logger.debug("MessageQuantitySummaryUtils updateQSError andMessageIs:" + MessageUtils.getExceptionStacktrace((Throwable)e));
        }
        ArrayList<QuantitySummaryInfo> needUpdateQsDBInfos = new ArrayList<QuantitySummaryInfo>();
        if (correctedUserIds != null && !correctedUserIds.isEmpty()) {
            for (QuantitySummaryInfo quantitySummaryInfo : quantitySummaryInfos) {
                if (correctedUserIds.contains(quantitySummaryInfo.getUserId())) {
                    this.logger.debug(String.format("MessageQuantitySummaryUtils hasCorrectFormBizDB[%s]", quantitySummaryInfo.getUserId()));
                    continue;
                }
                needUpdateQsDBInfos.add(quantitySummaryInfo);
            }
        } else {
            needUpdateQsDBInfos.addAll(quantitySummaryInfos);
        }
        if (!needUpdateQsDBInfos.isEmpty()) {
            this.updateQuantitySummaryDB(needUpdateQsDBInfos);
        }
        this.clearDiffData(quantitySummaryInfos);
        try {
            this.updateUserAvatarBadge(quantitySummaryInfos);
        }
        catch (Exception e) {
            this.logger.warn("MessageQuantitySummaryUtils updateUserAvatarError andMessageIs:" + MessageUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private List<Long> updateQuantitySummaryCache(List<QuantitySummaryInfo> quantitySummaryInfos) {
        HashSet userIds = new HashSet(quantitySummaryInfos.size());
        quantitySummaryInfos.forEach(quantitySummaryInfo -> userIds.add(quantitySummaryInfo.getUserId()));
        ArrayList<Long> correctedUserIds = new ArrayList<Long>(userIds.size());
        HashMap<Long, JSONObject> quantitySummaryCacheDatas = new HashMap<Long, JSONObject>(userIds.size());
        for (Long userId : userIds) {
            Map<String, Object> qsInfos = this.getMsgQuantitySummary(userId, Boolean.FALSE);
            boolean isCorrectFormBizDB = (Boolean)qsInfos.get(ISCORRECTFROMBIZDB);
            if (isCorrectFormBizDB) {
                correctedUserIds.add(userId);
            }
            List oneUserQuantitySummaryInfos = (List)qsInfos.get(QUANTITYSUMMARYINFOS);
            JSONArray oneUserQuantitySummaryCacheDatas = this.db2CacheConverter(oneUserQuantitySummaryInfos);
            JSONObject onUserQsCacheData = oneUserQuantitySummaryCacheDatas.getJSONObject(0);
            quantitySummaryCacheDatas.put(onUserQsCacheData.getLong(USERID), onUserQsCacheData);
        }
        quantitySummaryInfos.forEach(quantitySummaryInfo -> {
            Long userId = quantitySummaryInfo.getUserId();
            if (!correctedUserIds.contains(userId)) {
                JSONObject qsCache = (JSONObject)quantitySummaryCacheDatas.get(userId);
                String dataType = quantitySummaryInfo.getDataType();
                String billType = quantitySummaryInfo.getBillType();
                int diffCount = quantitySummaryInfo.getQuantitysum();
                JSONObject dataCache = qsCache.getJSONObject(DATA);
                JSONObject dataTypeCache = new JSONObject();
                if (!dataCache.isEmpty() && dataCache.containsKey((Object)dataType)) {
                    dataTypeCache = dataCache.getJSONObject(dataType);
                }
                int newQuantitySum = 0;
                newQuantitySum = !dataTypeCache.isEmpty() && dataTypeCache.containsKey((Object)billType) ? dataTypeCache.getIntValue(billType) + diffCount : diffCount;
                dataTypeCache.put(billType, (Object)newQuantitySum);
                dataCache.put(dataType, (Object)dataTypeCache);
                String data = qsCache.getString(DATA);
                qsCache.put(HASHCODE, (Object)data.hashCode());
            }
        });
        MessageQuantitySummaryCacheUtils.pushQuantitySummaryCache(quantitySummaryCacheDatas);
        return correctedUserIds;
    }

    private Map<String, Object> getMsgQuantitySummary(Long userId, Boolean updateCache) {
        return this.getMsgQuantitySummary(userId, updateCache, null);
    }

    private Map<String, Object> getMsgQuantitySummary(Long userId, Boolean updateCache, String dataType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean isCorrectFormBizDB = Boolean.FALSE;
        List<Object> quantitySummaryInfos = null;
        if (WfConfigurationUtil.diableUseQuantitySummary()) {
            if (WfUtils.isNotEmpty(dataType)) {
                quantitySummaryInfos = new ArrayList();
                MessageQuantitySummaryCorrectUtils.getMessageQuantitySummary(userId, dataType, quantitySummaryInfos);
            } else {
                quantitySummaryInfos = this.getQuantitySummaryFromBizData(userId);
            }
            isCorrectFormBizDB = Boolean.TRUE;
            this.logger.debug(String.format("MessageQuantitySummaryServcieImpl_getqs_%s", userId));
        } else {
            JSONObject qsCacheData = MessageQuantitySummaryCacheUtils.getQuantitySummaryCacheData((Long)userId);
            if (qsCacheData != null) {
                JSONArray qsCacheDatas = new JSONArray();
                qsCacheDatas.add((Object)qsCacheData);
                quantitySummaryInfos = this.cache2DBConverter(qsCacheDatas);
            } else {
                QFilter[] filters = new QFilter[]{new QFilter("userid", "=", (Object)userId)};
                quantitySummaryInfos = this.getQuantitySummaryDataFromQst(filters);
                if (!quantitySummaryInfos.isEmpty()) {
                    if (updateCache.booleanValue()) {
                        JSONArray qsCacheDatas = this.db2CacheConverter(quantitySummaryInfos);
                        MessageQuantitySummaryCacheUtils.pushQuantitySummaryCache((JSONArray)qsCacheDatas);
                    }
                } else {
                    quantitySummaryInfos = this.correctQuantitySummaryFromBizData(userId, updateCache);
                    isCorrectFormBizDB = Boolean.TRUE;
                }
            }
            String traceId = RequestContext.get().getTraceId();
            this.logger.debug(String.format("msgqs_traceLog_%s, traceId: %s, qsValue: %s, isCorrectFormBizDB: %s", userId, traceId, "", isCorrectFormBizDB));
            if (USERAVATAEBADGE.equals(dataType) && quantitySummaryInfos.size() > 0) {
                List menuConfigObjects = MenuConfigUtil.getPersonMenuConfig();
                if (menuConfigObjects.size() == 0) {
                    quantitySummaryInfos = quantitySummaryInfos.stream().filter(quantitySummaryInfo -> !"msg".equals(quantitySummaryInfo.getDataType())).collect(Collectors.toList());
                } else {
                    List numbers = menuConfigObjects.stream().map(MessageMenuConfigObject::getNumber).collect(Collectors.toList());
                    quantitySummaryInfos = quantitySummaryInfos.stream().filter(quantitySummaryInfo -> !"msg".equals(quantitySummaryInfo.getDataType()) || "msg".equals(quantitySummaryInfo.getDataType()) && numbers.contains(quantitySummaryInfo.getBillType())).collect(Collectors.toList());
                }
            }
        }
        result.put(ISCORRECTFROMBIZDB, isCorrectFormBizDB);
        result.put(QUANTITYSUMMARYINFOS, quantitySummaryInfos);
        return result;
    }

    @Override
    public List<QuantitySummaryInfo> getMsgQuantitySummary(Long userId) {
        Map<String, Object> qsInfos = this.getMsgQuantitySummary(userId, Boolean.TRUE);
        return (List)qsInfos.get(QUANTITYSUMMARYINFOS);
    }

    @Override
    public List<QuantitySummaryInfo> getMsgQuantitySummary(Long userId, String dataType) {
        Map<String, Object> qsMapInfos = this.getMsgQuantitySummary(userId, Boolean.TRUE, dataType);
        List qsInfos = (List)qsMapInfos.get(QUANTITYSUMMARYINFOS);
        if (USERAVATAEBADGE.equals(dataType) || MAINPAGECARD.equals(dataType)) {
            return qsInfos;
        }
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
        qsInfos.forEach(quantitySummaryInfo -> {
            if (dataType.equalsIgnoreCase(quantitySummaryInfo.getDataType())) {
                quantitySummaryInfos.add((QuantitySummaryInfo)quantitySummaryInfo);
            }
        });
        return quantitySummaryInfos;
    }

    @Override
    public int getQuantitySummaryCount(List<QuantitySummaryInfo> quantitySummaryInfos, String dataType, String billType) {
        int count = 0;
        if (quantitySummaryInfos.isEmpty()) {
            return count;
        }
        for (QuantitySummaryInfo quantitySummaryInfo : quantitySummaryInfos) {
            if (!dataType.equals(quantitySummaryInfo.getDataType())) continue;
            if (MessageUtils.isNotEmpty((String)billType)) {
                if (!billType.equals(quantitySummaryInfo.getBillType())) continue;
                count += quantitySummaryInfo.getQuantitysum();
                continue;
            }
            count += quantitySummaryInfo.getQuantitysum();
        }
        count = count < 0 ? 0 : count;
        return count;
    }

    private List<QuantitySummaryInfo> getQuantitySummaryDataFromQst(QFilter[] filters) {
        DynamicObject[] quantitySummarys = BusinessDataServiceHelper.load((String)"msg_quantitysum", (String)QUANTITYSUMMARYFIELDS, (QFilter[])filters);
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
        if (quantitySummarys != null && quantitySummarys.length > 0) {
            for (DynamicObject qs : quantitySummarys) {
                Long userId = qs.getLong("userid");
                String dataType = qs.getString("datatype");
                String billType = qs.getString("billtype");
                int quantitySum = qs.getInt("quantitysum");
                QuantitySummaryInfo quantitySummaryInfo = new QuantitySummaryInfo(userId, dataType, billType, quantitySum);
                quantitySummaryInfos.add(quantitySummaryInfo);
            }
        }
        return quantitySummaryInfos;
    }

    private void updateQuantitySummaryDB(List<QuantitySummaryInfo> quantitySummaryInfos) {
        this.updateQuantitySummaryDB(quantitySummaryInfos, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuantitySummaryDB(List<QuantitySummaryInfo> quantitySummaryInfos, boolean isDiffQuantity) {
        if (quantitySummaryInfos.isEmpty()) {
            return;
        }
        HashSet userIds = new HashSet();
        quantitySummaryInfos.forEach(quantitySummaryInfo -> userIds.add(quantitySummaryInfo.getUserId()));
        try (TXHandle txHandle = TX.requiresNew();){
            QFilter[] filters;
            ArrayList<DynamicObject> updateQsDynamicObjects = new ArrayList<DynamicObject>(quantitySummaryInfos.size());
            if (isDiffQuantity) {
                String selectFields = "id,userid,datatype,billtype,quantitysum,updatedate";
                filters = new QFilter[]{new QFilter("userid", "in", userIds)};
                DynamicObject[] qsCollection = BusinessDataServiceHelper.load((String)"msg_quantitysum", (String)selectFields, (QFilter[])filters);
                if (qsCollection == null || qsCollection.length == 0) {
                    quantitySummaryInfos.forEach(quantitySummaryInfo -> updateQsDynamicObjects.add(this.packQuantitySumObject((QuantitySummaryInfo)quantitySummaryInfo)));
                } else {
                    for (QuantitySummaryInfo qsInfo : quantitySummaryInfos) {
                        Long userId = qsInfo.getUserId();
                        String dataType = qsInfo.getDataType();
                        String billType = qsInfo.getBillType();
                        boolean isExitInDB = Boolean.FALSE;
                        for (DynamicObject qsDynamicObject : qsCollection) {
                            if (!userId.equals(qsDynamicObject.getLong("userid")) || !dataType.equals(qsDynamicObject.getString("datatype")) || !billType.equals(qsDynamicObject.getString("billtype"))) continue;
                            isExitInDB = Boolean.TRUE;
                            int newCount = qsDynamicObject.getInt("quantitysum") + qsInfo.getQuantitysum();
                            qsDynamicObject.set("quantitysum", (Object)newCount);
                            qsDynamicObject.set("updatedate", (Object)new Date());
                            updateQsDynamicObjects.add(qsDynamicObject);
                            break;
                        }
                        boolean isExitInWillUpdate = Boolean.FALSE;
                        if (!isExitInDB && !updateQsDynamicObjects.isEmpty()) {
                            for (DynamicObject updateQsDo : updateQsDynamicObjects) {
                                if (!userId.equals(updateQsDo.getLong("userid")) || !dataType.equals(updateQsDo.getString("datatype")) || !billType.equals(updateQsDo.getString("billtype"))) continue;
                                isExitInWillUpdate = Boolean.TRUE;
                                int newCount = updateQsDo.getInt("quantitysum") + qsInfo.getQuantitysum();
                                updateQsDo.set("quantitysum", (Object)newCount);
                                break;
                            }
                        }
                        if (isExitInDB || isExitInWillUpdate) continue;
                        updateQsDynamicObjects.add(this.packQuantitySumObject(qsInfo));
                    }
                }
            } else {
                filters = new QFilter[]{new QFilter("userid", "in", userIds)};
                DeleteServiceHelper.delete((String)"msg_quantitysum", (QFilter[])filters);
                quantitySummaryInfos.forEach(quantitySummaryInfo -> updateQsDynamicObjects.add(this.packQuantitySumObject((QuantitySummaryInfo)quantitySummaryInfo)));
            }
            if (!updateQsDynamicObjects.isEmpty()) {
                DynamicObject[] qm = new DynamicObject[updateQsDynamicObjects.size()];
                SaveServiceHelper.save((DynamicObject[])updateQsDynamicObjects.toArray(qm));
            }
        }
    }

    private DynamicObject packQuantitySumObject(QuantitySummaryInfo quantitySummaryInfo) {
        DynamicObject qs = BusinessDataServiceHelper.newDynamicObject((String)"msg_quantitysum");
        qs.set("userid", (Object)quantitySummaryInfo.getUserId());
        qs.set("datatype", (Object)quantitySummaryInfo.getDataType());
        qs.set("billtype", (Object)quantitySummaryInfo.getBillType());
        qs.set("quantitysum", (Object)quantitySummaryInfo.getQuantitysum());
        qs.set("updatedate", (Object)new Date());
        return qs;
    }

    @Override
    public void correctAllQuantitySummaryFromBizData(boolean isCompensation) {
        if (isCompensation) {
            String sql = "select fuserid userid from t_msg_quantitysum tmq where fdatatype in ('tohandle', 'handled') group by fuserid;";
            HashSet<Long> userIds = new HashSet<Long>();
            try (DataSet dataSet = DB.queryDataSet((String)"correctAllQuantitySummaryFromBizData", (DBRoute)DBRoute.workflow, (String)sql, null);){
                if (dataSet != null) {
                    Iterator iter = dataSet.iterator();
                    while (iter.hasNext()) {
                        userIds.add(((Row)iter.next()).getLong("userid"));
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(String.format("correctAllQuantitySummaryFromBizData and sql[%s], message[%s]", sql, MessageUtils.getExceptionStacktrace((Throwable)e)));
            }
            if (!userIds.isEmpty()) {
                long ct1 = System.currentTimeMillis();
                for (Long userId : userIds) {
                    if (userId <= 0L) continue;
                    this.correctQuantitySummaryFromBizData(userId, Boolean.TRUE);
                }
                long l = System.currentTimeMillis();
            }
        } else {
            MessageBussinessInfo messageBussinessInfo = new MessageBussinessInfo();
            messageBussinessInfo.setType(MessageBussinessInfo.Type.CORRECTAllQUANTITYSUMMARY.getNumber());
            messageBussinessInfo.setData(null);
            try {
                MessageBussinessPublishUtil.publishBizMessage((MessageBussinessInfo)messageBussinessInfo);
            }
            catch (Exception e) {
                this.logger.error(String.format("correctAllQuantitySummaryFromBizData, message[%s]", MessageUtils.getExceptionStacktrace((Throwable)e)));
            }
        }
    }

    private List<QuantitySummaryInfo> correctQuantitySummaryFromBizData(Long userId, boolean updateCache) {
        List<QuantitySummaryInfo> quantitySummaryInfos = this.getQuantitySummaryFromBizData(userId);
        if (!quantitySummaryInfos.isEmpty()) {
            this.updateQuantitySummaryDB(quantitySummaryInfos, Boolean.FALSE);
            if (updateCache) {
                JSONArray quantitySummaryCacheDatas = this.db2CacheConverter(quantitySummaryInfos);
                MessageQuantitySummaryCacheUtils.pushQuantitySummaryCache((JSONArray)quantitySummaryCacheDatas);
            }
        }
        return quantitySummaryInfos;
    }

    private List<QuantitySummaryInfo> getQuantitySummaryFromBizData(Long userId) {
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
        MessageQuantitySummaryCorrectUtils.getMessageQuantitySummary(userId, quantitySummaryInfos);
        return quantitySummaryInfos;
    }

    private JSONArray db2CacheConverter(List<QuantitySummaryInfo> quantitySummaryInfos) {
        JSONArray quantitySummaryCacheDatas = new JSONArray();
        if (quantitySummaryInfos != null && !quantitySummaryInfos.isEmpty()) {
            for (QuantitySummaryInfo quantitySummaryInfo : quantitySummaryInfos) {
                Long userId = quantitySummaryInfo.getUserId();
                String dataType = quantitySummaryInfo.getDataType();
                String billType = quantitySummaryInfo.getBillType();
                int quantitySum = quantitySummaryInfo.getQuantitysum();
                boolean isUserNotExit = Boolean.TRUE;
                for (int i = 0; i < quantitySummaryCacheDatas.size(); ++i) {
                    JSONObject dataTypeCache;
                    JSONObject qsCache = quantitySummaryCacheDatas.getJSONObject(i);
                    if (!qsCache.getLong(USERID).equals(userId)) continue;
                    isUserNotExit = Boolean.FALSE;
                    JSONObject dataCache = qsCache.getJSONObject(DATA);
                    if (dataCache.containsKey((Object)dataType)) {
                        dataTypeCache = dataCache.getJSONObject(dataType);
                        dataTypeCache.put(billType, (Object)quantitySum);
                    } else {
                        dataTypeCache = new JSONObject();
                        dataTypeCache.put(billType, (Object)quantitySum);
                        dataCache.put(dataType, (Object)dataTypeCache);
                    }
                    qsCache.put(HASHCODE, (Object)qsCache.getString(DATA).hashCode());
                }
                if (!isUserNotExit) continue;
                JSONObject qsCache = new JSONObject();
                qsCache.put(USERID, (Object)userId);
                JSONObject dataCache = new JSONObject();
                JSONObject dataTypeCacheData = new JSONObject();
                dataTypeCacheData.put(billType, (Object)quantitySum);
                dataCache.put(dataType, (Object)dataTypeCacheData);
                qsCache.put(DATA, (Object)dataCache);
                qsCache.put(HASHCODE, (Object)qsCache.getString(DATA).hashCode());
                quantitySummaryCacheDatas.add((Object)qsCache);
            }
        }
        return quantitySummaryCacheDatas;
    }

    private List<QuantitySummaryInfo> cache2DBConverter(JSONArray quantitySummaryCacheDatas) {
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>(quantitySummaryCacheDatas.size());
        if (quantitySummaryCacheDatas != null && !quantitySummaryCacheDatas.isEmpty()) {
            for (int i = 0; i < quantitySummaryCacheDatas.size(); ++i) {
                JSONObject qsCache = quantitySummaryCacheDatas.getJSONObject(i);
                JSONObject dataCache = qsCache.getJSONObject(DATA);
                Long userId = qsCache.getLong(USERID);
                if (dataCache == null || dataCache.isEmpty()) continue;
                Set dataSets = dataCache.entrySet();
                for (Map.Entry dataEntry : dataSets) {
                    String dataType = (String)dataEntry.getKey();
                    JSONObject dataTypeCache = dataCache.getJSONObject(dataType);
                    if (dataTypeCache == null || dataTypeCache.isEmpty()) continue;
                    Set dataTypeSets = dataTypeCache.entrySet();
                    for (Map.Entry dataTypeEntry : dataTypeSets) {
                        String billType = (String)dataTypeEntry.getKey();
                        int quantitySum = dataTypeCache.getIntValue(billType);
                        QuantitySummaryInfo qsInfo = new QuantitySummaryInfo(userId, dataType, billType, quantitySum);
                        quantitySummaryInfos.add(qsInfo);
                    }
                }
            }
        }
        return quantitySummaryInfos;
    }

    private void updateUserAvatarBadge(List<QuantitySummaryInfo> quantitySummaryInfos) {
        HashMap<Long, List<QuantitySummaryInfo>> userQsImmapping = new HashMap<Long, List<QuantitySummaryInfo>>();
        quantitySummaryInfos.forEach(quantitySummaryInfo -> {
            String dataType = quantitySummaryInfo.getDataType();
            Long userId = quantitySummaryInfo.getUserId();
            if ("tohandle".equals(dataType) || "msg".equals(dataType)) {
                if (userQsImmapping.containsKey(userId)) {
                    ((List)userQsImmapping.get(userId)).add(quantitySummaryInfo);
                } else {
                    ArrayList<QuantitySummaryInfo> qs = new ArrayList<QuantitySummaryInfo>();
                    qs.add((QuantitySummaryInfo)quantitySummaryInfo);
                    userQsImmapping.put(userId, qs);
                }
            }
        });
        if (userQsImmapping.isEmpty()) {
            return;
        }
        try {
            if (NoCodeFlowUtil.hasNoCodeLicense()) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("userIds", userQsImmapping.keySet());
                param.put("entityNumber", "wf_nocodeflow");
                MessageEventListenerUtils.subscribeMsgResult((String)"*", (String)"wf_nocodeflow", (MessageEventType)MessageEventType.UPDATENOCODEFLOWUSERAVATARBADGE, null, param);
            }
        }
        catch (Exception e) {
            this.logger.debug("updateNoCodeFlowUserAvatarBadge is error :" + WfUtils.getExceptionStacktrace(e));
        }
        Set<Long> userIds = this.filterUserAvtarBadge(userQsImmapping.keySet());
        if (userIds.isEmpty()) {
            return;
        }
        this.updateUserAvatarBadge(userIds, userQsImmapping);
    }

    private void updateUserAvatarBadge(Set<Long> userIds, Map<Long, List<QuantitySummaryInfo>> userQsImmapping) {
        if (userIds == null || userIds.size() > 1000) {
            return;
        }
        boolean isUseNewPortal = NewPortalServiceHelper.isPersonalSettingNewPortal();
        for (Long userId : userIds) {
            long count = 0L;
            List<QuantitySummaryInfo> quantitySummaryInfos = this.getMsgQuantitySummary(userId, USERAVATAEBADGE);
            for (QuantitySummaryInfo quantitySummaryInfo : quantitySummaryInfos) {
                String dataType = quantitySummaryInfo.getDataType();
                if (!"tohandle".equals(dataType) && !"msg".equals(dataType)) continue;
                count += (long)quantitySummaryInfo.getQuantitysum();
            }
            if (count < 0L || userQsImmapping != null && count > 100L) {
                this.logger.debug(String.format("user of [%s] count is [%s], stop push", userId, count));
                continue;
            }
            this.pushUserAvatarBadge(userId, count, isUseNewPortal);
        }
    }

    @Override
    public void updateUserAvatarBadge(Set<Long> userIds) {
        this.updateUserAvatarBadge(userIds, null);
    }

    private void pushUserAvatarBadge(Long userId, long count, boolean isUseNewPortal) {
        int rightSize = -5;
        int bellRightSize = -3;
        if (count >= 10L && count < 100L) {
            rightSize = -12;
            bellRightSize = -9;
        } else if (count >= 100L) {
            rightSize = -16;
            bellRightSize = -16;
        }
        HashMap<String, Object> p2 = new HashMap<String, Object>();
        p2.put("dot", false);
        p2.put("offset", new Integer[]{-6, -12});
        p2.put("overflowCount", 99);
        p2.put("showZero", false);
        ArrayList<HashMap<String, Object>> l = new ArrayList<HashMap<String, Object>>();
        l.add(p2);
        HashMap<String, Object> p1 = new HashMap<String, Object>();
        p1.put("args", l);
        String sign = isUseNewPortal ? "taskandmsg" : "usericon";
        p1.put(KEY, sign);
        p1.put("methodname", "setBadgeInfo");
        ArrayList<HashMap<String, Object>> param = new ArrayList<HashMap<String, Object>>();
        param.add(p1);
        Map pp2 = (Map)((List)((Map)param.get(0)).get("args")).get(0);
        pp2.put("count", count);
        Integer[] offset = isUseNewPortal ? new Integer[]{0, bellRightSize} : new Integer[]{-6, rightSize};
        pp2.put("offset", offset);
        ArrayList<String> userArray = new ArrayList<String>();
        userArray.add(String.valueOf(userId));
        PushServiceHelper.sendWebSocketAction((String)"InvokeControlMethod", param, userArray);
    }

    private Set<Long> filterUserAvtarBadge(Set<Long> userIds) {
        Set<Long> userIdsAfterFilter = userIds;
        try {
            String value;
            this.logger.debug(String.format("disableUserAvatarBadge userId original [%s]", userIds.toString()));
            QFilter qs = new QFilter(KEY, "=", (Object)"msg.disableUserAvatarBadge");
            DynamicObject ret = BusinessDataServiceHelper.loadSingleFromCache((String)"wf_confcenter", (String)VALUE, (QFilter[])new QFilter[]{qs});
            if (ret != null && WfUtils.isNotEmpty(value = ret.getString(VALUE))) {
                if ("true".equalsIgnoreCase(value)) {
                    userIdsAfterFilter = new HashSet<Long>();
                } else if ("false".equalsIgnoreCase(value)) {
                    userIdsAfterFilter = userIds;
                } else {
                    userIdsAfterFilter = new HashSet<Long>();
                    ArrayList<Long> uids = new ArrayList<Long>(value.split(",").length);
                    for (String uid : value.split(",")) {
                        uids.add(Long.valueOf(uid));
                    }
                    for (Long userId : userIds) {
                        if (uids.contains(userId)) continue;
                        userIdsAfterFilter.add(userId);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.info("disableUserAvatarBadge function has exception:" + WfUtils.getExceptionStacktrace(e));
        }
        return userIdsAfterFilter;
    }

    private List<Long> getQuantitySummaryTraceUserIds() {
        ArrayList<Long> traceUserIds = new ArrayList<Long>();
        try {
            String uIds;
            QFilter qs = new QFilter(KEY, "=", (Object)"msg.quantitySummaryTraceUserIds");
            DynamicObject ret = BusinessDataServiceHelper.loadSingleFromCache((String)"wf_confcenter", (String)VALUE, (QFilter[])new QFilter[]{qs});
            if (ret != null && WfUtils.isNotEmpty(uIds = ret.getString(VALUE))) {
                for (String s : uIds.split(",")) {
                    traceUserIds.add(Long.valueOf(s.trim()));
                }
            }
        }
        catch (Exception e) {
            this.logger.info("update qsInfos function has exception:" + WfUtils.getExceptionStacktrace(e));
        }
        return traceUserIds;
    }

    @Override
    public void gatherQuantitySummaryInfosFromIdentityLink(IdentityLinkEntity identityLinkEntity, ActivitiEventType eventType) {
        if (WfUtils.isEmpty(identityLinkEntity.getTaskId())) {
            return;
        }
        TaskEntity taskEntity = identityLinkEntity.getTask();
        if ("mobile".equalsIgnoreCase(taskEntity.getEndType())) {
            return;
        }
        Object taskComplate = taskEntity.getTransientVariable("syncTaskComplete");
        if (taskComplate == null && !taskEntity.isDisplay()) {
            boolean yunzhijiaCoordinate;
            boolean bl = yunzhijiaCoordinate = "YunzhijiaTask".equals(taskEntity.getCategory()) && "coordinate".equals(identityLinkEntity.getType());
            if (!yunzhijiaCoordinate) {
                return;
            }
        }
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
        if (ActivitiEventType.ENTITY_UPDATED == eventType) {
            Map records = identityLinkEntity.getAttributesModifyRecords();
            this.gatherInfosByUserId(identityLinkEntity, taskEntity, records, quantitySummaryInfos);
            this.gatherInfosByOwnerId(identityLinkEntity, taskEntity, records, quantitySummaryInfos);
            HashMap<Long, Integer> immapping = new HashMap<Long, Integer>();
            for (QuantitySummaryInfo quantitySummaryInfo : quantitySummaryInfos) {
                if (!"tohandle".equals(quantitySummaryInfo.getDataType())) continue;
                immapping.put(quantitySummaryInfo.getUserId(), quantitySummaryInfo.getQuantitysum());
            }
            if (!immapping.isEmpty()) {
                this.gatherInfosOfCustomFile(quantitySummaryInfos, taskEntity.getId(), immapping);
            }
        } else {
            Long ownerId;
            QuantitySummary quantitySummary;
            QuantitySummary quantitySummary2 = quantitySummary = ActivitiEventType.ENTITY_CREATED == eventType ? QuantitySummary.PLUS : QuantitySummary.MINUS;
            if (identityLinkEntity.isDisplay().booleanValue() && identityLinkEntity.getCompositeTaskId() == 0L) {
                Long userId = identityLinkEntity.getUserId();
                quantitySummaryInfos.add(this.wrapTaskQuantitySummary(userId, "tohandle", taskEntity.getBillType(), quantitySummary, taskEntity, identityLinkEntity));
            }
            if (identityLinkEntity.getCompositeTaskId() == 0L && WfUtils.isNotEmpty(ownerId = identityLinkEntity.getOwnerId())) {
                if (WfUtils.isNotEmpty(identityLinkEntity.getDelegateId())) {
                    quantitySummaryInfos.add(this.wrapQuantitySummary(ownerId, "delegate", "delegate", quantitySummary));
                } else if ("participant".equals(identityLinkEntity.getType())) {
                    quantitySummaryInfos.add(this.wrapQuantitySummary(ownerId, "transfer", "transfer", quantitySummary));
                    if (ActivitiEventType.ENTITY_DELETED == eventType) {
                        this.gatherInfosOfTransfer(quantitySummaryInfos, taskEntity, ownerId, quantitySummary);
                    }
                } else if ("coordinate".equals(identityLinkEntity.getType())) {
                    this.gatherInfosOfTransfer(quantitySummaryInfos, taskEntity, ownerId, quantitySummary);
                }
            }
            if (identityLinkEntity.isDisplay().booleanValue() && identityLinkEntity.getCompositeTaskId() == 0L) {
                HashMap<Long, Integer> immapping = new HashMap<Long, Integer>();
                immapping.put(identityLinkEntity.getUserId(), quantitySummary.getValue());
                this.gatherInfosOfCustomFile(quantitySummaryInfos, taskEntity.getId(), immapping);
            }
        }
        this.storeCommandContextQuantitySummaryInfos(quantitySummaryInfos);
    }

    private void gatherInfosOfTransfer(List<QuantitySummaryInfo> quantitySummaryInfos, TaskEntity taskEntity, Long ownerId, QuantitySummary quantitySummary) {
        QFilter f4;
        QFilter f3;
        QFilter f1;
        TaskHandleLogEntityManager taskHandleLogEntityManager = Context.getCommandContext().getTaskHandleLogEntityManager();
        List userTaskTransferLogs = taskHandleLogEntityManager.findByQueryFilters(new QFilter[]{f1 = new QFilter("taskid", "=", (Object)taskEntity.getId()), f3 = new QFilter("type", "=", (Object)"transfer"), f4 = new QFilter("isadminforward", "=", (Object)"0")});
        if (userTaskTransferLogs != null && !userTaskTransferLogs.isEmpty()) {
            for (TaskHandleLogEntity taskHandleLogEntity : userTaskTransferLogs) {
                if (taskHandleLogEntity.getOwnerId().equals(ownerId)) continue;
                quantitySummaryInfos.add(this.wrapQuantitySummary(taskHandleLogEntity.getOwnerId(), "transfer", "transfer", quantitySummary));
            }
        }
    }

    private void gatherInfosOfCustomFile(List<QuantitySummaryInfo> quantitySummaryInfos, Long taskId, Map<Long, Integer> immapping) {
        List rtRelationEntities;
        Set<Long> userIds = immapping.keySet();
        RuleTaskRelationEntityManager ruleTaskRelationEntityManager = Context.getCommandContext().getRuleTaskRelationEntityManager();
        QFilter f1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter f2 = new QFilter("ruletype", "=", (Object)"folder");
        QFilter f3 = new QFilter("userid", "in", userIds);
        if (userIds.size() == 1) {
            f3 = new QFilter("userid", "=", (Object)userIds.iterator().next());
        }
        if ((rtRelationEntities = ruleTaskRelationEntityManager.findByQueryFilters(new QFilter[]{f1, f2, f3})) != null && !rtRelationEntities.isEmpty()) {
            for (RuleTaskRelationEntity rtRelationEntity : rtRelationEntities) {
                Long ruleid = rtRelationEntity.getRuleid();
                Long userId = rtRelationEntity.getUserid();
                QuantitySummary quantitySummary = immapping.get(userId).intValue() == QuantitySummary.PLUS.getValue() ? QuantitySummary.PLUS : QuantitySummary.MINUS;
                quantitySummaryInfos.add(this.wrapQuantitySummary(userId, "custom", String.valueOf(ruleid), quantitySummary));
            }
        }
    }

    @Override
    public void gatherQuantitySummaryInfosFromHiComment(CommentEntity commentEntity, ActivitiEventType eventType) {
        if ("suggestion".equalsIgnoreCase(commentEntity.getType())) {
            return;
        }
        QuantitySummary quantitySummary = ActivitiEventType.ENTITY_CREATED == eventType ? QuantitySummary.PLUS : QuantitySummary.MINUS;
        boolean hitaskDisplay = commentEntity.isDisplay();
        String hitaskExecutionType = commentEntity.getExecutionType();
        String hitaskEndType = commentEntity.getEndType();
        if (!hitaskDisplay || "byAuto".equalsIgnoreCase(hitaskExecutionType) || "mobile".equalsIgnoreCase(hitaskEndType)) {
            return;
        }
        Long userId = commentEntity.getUserId();
        String billType = commentEntity.getBillType();
        if (WfUtils.isNotEmpty(userId) && WfUtils.isNotEmpty(billType)) {
            QuantitySummaryInfo quantitySummaryInfo = this.wrapQuantitySummary(userId, "handled", billType, quantitySummary);
            this.storeCommandContextQuantitySummaryInfos(quantitySummaryInfo);
        }
    }

    @Override
    public void gatherQuantitySummaryInfosFromRuleTaskRelation(RuleTaskRelationEntity ruleTaskRelationEntity, ActivitiEventType eventType) {
        if (!"folder".equalsIgnoreCase(ruleTaskRelationEntity.getRuletype())) {
            return;
        }
        QuantitySummary quantitySummary = ActivitiEventType.ENTITY_CREATED == eventType ? QuantitySummary.PLUS : QuantitySummary.MINUS;
        TaskEntityManager taskEntityManager = Context.getCommandContext().getTaskEntityManager();
        TaskEntity taskEntity = (TaskEntity)taskEntityManager.findById(ruleTaskRelationEntity.getTaskid());
        if (taskEntity == null) {
            this.logger.debug(String.format("EntityCreateListener_rtrealtion[%s] exist and taskentity gone when event[%s]", ruleTaskRelationEntity.getId(), eventType.getName()));
            return;
        }
        if ("mobile".equalsIgnoreCase(taskEntity.getEndType())) {
            return;
        }
        Object updateQsDone = taskEntity.getTransientVariable("updateQuantitySummaryDone");
        if (!taskEntity.isDisplay() && updateQsDone == null) {
            return;
        }
        boolean isIdentityLinkExist = Boolean.FALSE;
        Long userId = ruleTaskRelationEntity.getUserid();
        List<IdentityLinkEntity> identityLinks = taskEntity.getIdentityLinks();
        for (IdentityLinkEntity identityLinkEntity : identityLinks) {
            if (!userId.equals(identityLinkEntity.getUserId()) || !identityLinkEntity.isDisplay().booleanValue() || identityLinkEntity.getCompositeTaskId() != 0L) continue;
            isIdentityLinkExist = Boolean.TRUE;
            break;
        }
        if (isIdentityLinkExist) {
            Long ruleId = ruleTaskRelationEntity.getRuleid();
            QuantitySummaryInfo quantitySummaryInfo = this.wrapQuantitySummary(userId, "custom", String.valueOf(ruleId), quantitySummary);
            this.storeCommandContextQuantitySummaryInfos(quantitySummaryInfo);
        }
    }

    @Override
    public void gatherQuantitySummaryInfosFromTaskHandleLog(TaskHandleLogEntity taskHandleLogEntity, ActivitiEventType eventType) {
        QuantitySummary quantitySummary;
        if (taskHandleLogEntity.getIsadminforward().booleanValue() || !"transfer".equals(taskHandleLogEntity.getType())) {
            return;
        }
        if (!"coordinateTask".equals(taskHandleLogEntity.getScenes())) {
            if (LocalVariables.get() != null) {
                if (WfUtils.isEmpty(LocalVariables.get().getParams().get("isMultiLevelTransfer"))) {
                    return;
                }
            } else {
                return;
            }
        }
        Long taskId = taskHandleLogEntity.getTaskId();
        CommandContext commandContext = Context.getCommandContext();
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        if (!taskEntity.isDisplay() || "mobile".equalsIgnoreCase(taskEntity.getEndType())) {
            return;
        }
        QuantitySummaryInfo quantitySummaryInfo = null;
        Long ownerId = taskHandleLogEntity.getOwnerId();
        Long assigneeid = taskHandleLogEntity.getAssigneeid();
        QuantitySummary quantitySummary2 = quantitySummary = ActivitiEventType.ENTITY_CREATED == eventType ? QuantitySummary.PLUS : QuantitySummary.MINUS;
        if (ActivitiEventType.ENTITY_CREATED == eventType) {
            if ("task".equals(taskHandleLogEntity.getScenes())) {
                quantitySummaryInfo = this.wrapQuantitySummary(ownerId, "transfer", "transfer", quantitySummary);
            } else {
                QFilter f1 = new QFilter("taskid", "=", (Object)taskId);
                QFilter f2 = new QFilter("userid", "=", (Object)ownerId);
                QFilter f3 = new QFilter("type", "=", (Object)"coordinate");
                List identityLinkEntities = commandContext.getIdentityLinkEntityManager().findByQueryFilters(new QFilter[]{f1, f2, f3}, true);
                if (identityLinkEntities != null && !identityLinkEntities.isEmpty()) {
                    for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                        if (!identityLinkEntity.isDeleted() || identityLinkEntity.getCompositeTaskId() != 0L) continue;
                        quantitySummaryInfo = this.wrapQuantitySummary(ownerId, "transfer", "transfer", quantitySummary);
                    }
                }
            }
        } else {
            QFilter f1 = new QFilter("taskid", "=", (Object)taskId);
            QFilter f2 = new QFilter("userid", "=", (Object)assigneeid);
            QFilter f3 = new QFilter("type", "=", (Object)"coordinate");
            List identityLinkEntities = commandContext.getIdentityLinkEntityManager().findByQueryFilters(new QFilter[]{f1, f2, f3});
            if (identityLinkEntities != null && !identityLinkEntities.isEmpty()) {
                for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                    if (identityLinkEntity.getCompositeTaskId() != 0L) continue;
                    quantitySummaryInfo = this.wrapQuantitySummary(ownerId, "transfer", "transfer", quantitySummary);
                }
            }
        }
        if (quantitySummaryInfo != null) {
            this.storeCommandContextQuantitySummaryInfos(quantitySummaryInfo);
        }
    }

    private void gatherInfosByUserId(IdentityLinkEntity identityLinkEntity, TaskEntity taskEntity, Map<String, AttributeModifyRecord> records, List<QuantitySummaryInfo> quantitySummaryInfos) {
        boolean newIsDisplay = identityLinkEntity.isDisplay();
        boolean oldIsDisplay = records.get("display") == null ? identityLinkEntity.isDisplay().booleanValue() : ((Boolean)records.get("display").getOldValue()).booleanValue();
        Long newCompositeTaskId = identityLinkEntity.getCompositeTaskId();
        Long oldCompositeTaskId = records.get("compositetaskid") == null ? identityLinkEntity.getCompositeTaskId() : (Long)records.get("compositetaskid").getOldValue();
        if (records.get("userid") == null) {
            Long userId = identityLinkEntity.getUserId();
            if (oldIsDisplay && oldCompositeTaskId == 0L && (!newIsDisplay || newCompositeTaskId != 0L)) {
                quantitySummaryInfos.add(this.wrapTaskQuantitySummary(userId, "tohandle", taskEntity.getBillType(), QuantitySummary.MINUS, taskEntity, identityLinkEntity));
            } else if ((!oldIsDisplay || oldCompositeTaskId != 0L) && newIsDisplay && newCompositeTaskId == 0L) {
                quantitySummaryInfos.add(this.wrapTaskQuantitySummary(userId, "tohandle", taskEntity.getBillType(), QuantitySummary.PLUS, taskEntity, identityLinkEntity));
            }
        } else {
            AttributeModifyRecord userIdModifyRecord = records.get("userid");
            Long oldUserId = (Long)userIdModifyRecord.getOldValue();
            if (oldIsDisplay && oldCompositeTaskId == 0L) {
                quantitySummaryInfos.add(this.wrapTaskQuantitySummary(oldUserId, "tohandle", taskEntity.getBillType(), QuantitySummary.MINUS, taskEntity, identityLinkEntity));
            }
            Long userId = identityLinkEntity.getUserId();
            if (newIsDisplay && newCompositeTaskId == 0L) {
                quantitySummaryInfos.add(this.wrapTaskQuantitySummary(userId, "tohandle", taskEntity.getBillType(), QuantitySummary.PLUS, taskEntity, identityLinkEntity));
            }
        }
    }

    private void gatherInfosByOwnerId(IdentityLinkEntity identityLinkEntity, TaskEntity taskEntity, Map<String, AttributeModifyRecord> records, List<QuantitySummaryInfo> quantitySummaryInfos) {
        Long newCompositeTaskId = identityLinkEntity.getCompositeTaskId();
        Long oldCompositeTaskId = records.get("compositetaskid") == null ? identityLinkEntity.getCompositeTaskId() : (Long)records.get("compositetaskid").getOldValue();
        Long newDelegateId = identityLinkEntity.getDelegateId();
        Long oldDeletateId = records.get("delegateid") == null ? identityLinkEntity.getDelegateId() : (Long)records.get("delegateid").getOldValue();
        if (records.get("ownerid") == null) {
            Long ownerId = identityLinkEntity.getOwnerId();
            if (WfUtils.isEmpty(ownerId)) {
                return;
            }
            if (oldCompositeTaskId == 0L) {
                if (oldDeletateId == 0L) {
                    if (newCompositeTaskId == 0L) {
                        if (newDelegateId != 0L) {
                            quantitySummaryInfos.add(this.wrapQuantitySummary(ownerId, "transfer", "transfer", QuantitySummary.MINUS));
                            quantitySummaryInfos.add(this.wrapQuantitySummary(ownerId, "delegate", "delegate", QuantitySummary.PLUS));
                        }
                    } else {
                        quantitySummaryInfos.add(this.wrapQuantitySummary(ownerId, "transfer", "transfer", QuantitySummary.MINUS));
                    }
                } else if (newCompositeTaskId == 0L) {
                    if (newDelegateId == 0L) {
                        quantitySummaryInfos.add(this.wrapQuantitySummary(ownerId, "transfer", "transfer", QuantitySummary.PLUS));
                        quantitySummaryInfos.add(this.wrapQuantitySummary(ownerId, "delegate", "delegate", QuantitySummary.MINUS));
                    }
                } else {
                    quantitySummaryInfos.add(this.wrapQuantitySummary(ownerId, "delegate", "delegate", QuantitySummary.MINUS));
                }
            } else if (newCompositeTaskId == 0L) {
                if (newDelegateId == 0L) {
                    quantitySummaryInfos.add(this.wrapQuantitySummary(ownerId, "transfer", "transfer", QuantitySummary.PLUS));
                } else {
                    quantitySummaryInfos.add(this.wrapQuantitySummary(ownerId, "delegate", "delegate", QuantitySummary.PLUS));
                }
            }
        } else {
            Long userId;
            AttributeModifyRecord ownerIdModifyRecord = records.get("ownerid");
            Long oldOwnerId = (Long)ownerIdModifyRecord.getOldValue();
            if (WfUtils.isNotEmpty(oldOwnerId) && oldCompositeTaskId == 0L) {
                if (oldDeletateId == 0L) {
                    quantitySummaryInfos.add(this.wrapQuantitySummary(oldOwnerId, "transfer", "transfer", QuantitySummary.MINUS));
                } else {
                    quantitySummaryInfos.add(this.wrapQuantitySummary(oldOwnerId, "delegate", "delegate", QuantitySummary.MINUS));
                }
            }
            if (WfUtils.isNotEmpty(userId = identityLinkEntity.getOwnerId()) && newCompositeTaskId == 0L) {
                if (newDelegateId == 0L) {
                    quantitySummaryInfos.add(this.wrapQuantitySummary(userId, "transfer", "transfer", QuantitySummary.PLUS));
                } else {
                    quantitySummaryInfos.add(this.wrapQuantitySummary(userId, "delegate", "delegate", QuantitySummary.PLUS));
                }
            }
        }
    }

    @Override
    public void storeCommandContextQuantitySummaryInfos(List<QuantitySummaryInfo> quantitySummaryInfos) {
        if (quantitySummaryInfos.isEmpty()) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext.getAttribute("isClose") == null) {
            List<QuantitySummaryInfo> infos = commandContext.getQuantitySummaryInfos();
            if (infos.isEmpty()) {
                commandContext.addCloseListener(new DefaultCommandContextCloseListener("message-pushQuantitySummary"){

                    @Override
                    public void closed(CommandContext commandContext) {
                        MessageQuantitySummaryServcie messageQuantitySummaryService = MessageServiceUtil.getMessageQuantitySummaryService();
                        List<QuantitySummaryInfo> qsInfos = commandContext.getQuantitySummaryInfos();
                        messageQuantitySummaryService.updateQuantitySummary(qsInfos);
                    }
                });
            }
            infos.addAll(quantitySummaryInfos);
        } else {
            MessageQuantitySummaryServcie messageQuantitySummaryService = MessageServiceUtil.getMessageQuantitySummaryService();
            messageQuantitySummaryService.updateQuantitySummary(quantitySummaryInfos);
        }
    }

    private void storeCommandContextQuantitySummaryInfos(QuantitySummaryInfo quantitySummaryInfo) {
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
        quantitySummaryInfos.add(quantitySummaryInfo);
        this.storeCommandContextQuantitySummaryInfos(quantitySummaryInfos);
    }

    private boolean isCompensationEnable() {
        boolean useQS = !WfConfigurationUtil.diableUseQuantitySummary();
        boolean canCompensation = WfConfigurationUtil.canAsyncCompensationEnable();
        return canCompensation && useQS;
    }

    private boolean isCompensationOfDelegateAndFile() {
        return WfConfigurationUtil.canCompensationOfDelegateAndFile();
    }

    @Override
    public void gatherDiffData(String userId, List<TaskEntity> taskEntities, QuantitySummary summary) {
        if (!this.isCompensationEnable()) {
            return;
        }
        try {
            LocalVariables localVariables = LocalVariables.get();
            if (localVariables == null || !localVariables.isViewOperate()) {
                return;
            }
            HashMap immapping = new HashMap();
            HashMap values = new HashMap();
            taskEntities.forEach(item -> {
                String value = MsgServiceCacheHelper.wrapAsyncCompensationValue((String)CompensationType.TASK.getType(), (String)item.getBillType(), (Long)item.getId(), (int)summary.getValue());
                values.put(value, localVariables.getCompensationDataTypes());
                immapping.put(String.valueOf(item.getId()), value);
            });
            ArrayList<Long> taskIds = new ArrayList<Long>(taskEntities.size());
            for (TaskEntity taskEntity : taskEntities) {
                taskIds.add(taskEntity.getId());
            }
            if (QuantitySummary.MINUS == summary && this.isCompensationOfDelegateAndFile()) {
                QFilter f3;
                QFilter f2;
                QFilter f1;
                DynamicObject[] customFiles;
                QFilter f = new QFilter("taskid", "in", taskIds);
                QFilter f0 = new QFilter("display", "=", (Object)Character.valueOf('1'));
                DynamicObject[] participants = BusinessDataServiceHelper.load((String)"wf_participant", (String)"taskid,ownerid,delegateid,userid", (QFilter[])new QFilter[]{f, f0});
                if (participants != null && participants.length > 0) {
                    boolean toHandleDisplay = false;
                    for (DynamicObject participant : participants) {
                        if (userId.equals(participant.getString("ownerid")) && participant.getLong("delegateid") > 0L) {
                            String taskId = participant.getString("taskid");
                            List dataTypes = (List)values.get(immapping.get(taskId));
                            dataTypes.add("delegate");
                        }
                        if (!userId.equals(participant.getString("userid"))) continue;
                        toHandleDisplay = true;
                    }
                    if (taskIds.size() == 1 && !toHandleDisplay) {
                        String taskId = String.valueOf(taskIds.get(0));
                        List dataTypes = (List)values.get(immapping.get(taskId));
                        dataTypes.remove("tohandle");
                    }
                }
                if ((customFiles = BusinessDataServiceHelper.load((String)"wf_ruletaskrelation", (String)"taskid,ruleid", (QFilter[])new QFilter[]{f1 = new QFilter("userid", "=", (Object)Long.parseLong(userId)), f2 = new QFilter("taskid", "in", taskIds), f3 = new QFilter("ruletype", "=", (Object)"folder")})) != null && customFiles.length > 0) {
                    for (DynamicObject customFile : customFiles) {
                        String taskId = customFile.getString("taskid");
                        List dataTypes = (List)values.get(immapping.get(taskId));
                        dataTypes.add(customFile.getString("ruleid"));
                    }
                }
            }
            MsgServiceCacheHelper.putMCAsyncOperateCompensation((String)userId, values);
        }
        catch (Exception e) {
            this.logger.error(String.format("gatherDiffData has error : %s", WfUtils.getExceptionStacktrace(e)));
        }
    }

    @Override
    public void gatherDiffData(List<QuantitySummaryInfo> quantitySummaryInfos) {
        if (!this.isCompensationEnable()) {
            return;
        }
        try {
            LocalVariables localVariables = LocalVariables.get();
            if (localVariables == null || !localVariables.isViewOperate()) {
                return;
            }
            String currentUserId = RequestContext.get().getUserId();
            HashMap values = new HashMap();
            for (QuantitySummaryInfo quantitySummaryInfo : quantitySummaryInfos) {
                String dataType;
                if (!currentUserId.equals(String.valueOf(quantitySummaryInfo.getUserId())) || this.isIdModifyRecordBeyondMaxLevel(quantitySummaryInfo) || !"msg".equals(dataType = quantitySummaryInfo.getDataType())) continue;
                List<IdModifyRecord> idModifyRecords = quantitySummaryInfo.getIdModifyRecords();
                idModifyRecords.forEach(item -> {
                    String value = MsgServiceCacheHelper.wrapAsyncCompensationValue((String)CompensationType.MSG.getType(), (String)quantitySummaryInfo.getBillType(), (Long)item.getId(), (int)item.getQs().getValue());
                    values.put(value, localVariables.getCompensationDataTypes());
                });
            }
            if (!values.isEmpty()) {
                MsgServiceCacheHelper.putMCAsyncOperateCompensation((String)currentUserId, values);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("gatherDiffData has error : %s", WfUtils.getExceptionStacktrace(e)));
        }
    }

    private void clearDiffData(List<QuantitySummaryInfo> quantitySummaryInfos) {
        if (!this.isCompensationEnable()) {
            return;
        }
        if (quantitySummaryInfos == null || quantitySummaryInfos.isEmpty()) {
            return;
        }
        try {
            ArrayList<Long> taskIds = new ArrayList<Long>();
            HashMap immapping = new HashMap();
            for (QuantitySummaryInfo quantitySummaryInfo : quantitySummaryInfos) {
                Long userId2 = quantitySummaryInfo.getUserId();
                String dataType = quantitySummaryInfo.getDataType();
                if (!"msg".equals(dataType) && !"tohandle".equals(dataType) || this.isIdModifyRecordBeyondMaxLevel(quantitySummaryInfo)) continue;
                List<IdModifyRecord> idModifyRecords = quantitySummaryInfo.getIdModifyRecords();
                ArrayList<String> values = (ArrayList<String>)immapping.get(String.valueOf(userId2));
                if (values == null) {
                    values = new ArrayList<String>(idModifyRecords.size());
                }
                CompensationType compensationType = "msg".equals(dataType) ? CompensationType.MSG : CompensationType.TASK;
                for (IdModifyRecord idModifyRecord : idModifyRecords) {
                    taskIds.add(idModifyRecord.getId());
                    String value = MsgServiceCacheHelper.wrapAsyncCompensationValue((String)compensationType.getType(), (String)quantitySummaryInfo.getBillType(), (Long)idModifyRecord.getId(), (int)idModifyRecord.getQs().getValue());
                    values.add(value);
                    Map<String, String> params = idModifyRecord.getParams();
                    String taskType = params.get(TASKTYPE);
                    if (QuantitySummary.MINUS != idModifyRecord.getQs() || !"delegate".equals(taskType)) continue;
                    String ownerId = params.get("ownerId");
                    ArrayList<String> ownerValues = (ArrayList<String>)immapping.get(ownerId);
                    if (ownerValues == null) {
                        ownerValues = new ArrayList<String>(idModifyRecords.size());
                        ownerValues.add(value);
                        immapping.put(ownerId, ownerValues);
                        continue;
                    }
                    ownerValues.add(value);
                }
                immapping.put(String.valueOf(userId2), values);
            }
            if (!immapping.isEmpty()) {
                Set userIds = immapping.keySet();
                userIds.forEach(userId -> {
                    List values = (List)immapping.get(userId);
                    if (!values.isEmpty()) {
                        MsgServiceCacheHelper.removeMCAsyncOperateCompensation((String)userId, (List)values);
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("clearDiffData has error : %s", WfUtils.getExceptionStacktrace(e)));
        }
    }

    @Override
    public List<QuantitySummaryInfo> calculateCompensationData(Long userId) {
        if (!this.isCompensationEnable()) {
            return new ArrayList<QuantitySummaryInfo>();
        }
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
        try {
            JSONObject compensationDatas = MsgServiceCacheHelper.getMCAsyncOperateCompensation((String)String.valueOf(userId));
            if (compensationDatas == null) {
                return quantitySummaryInfos;
            }
            Set values = compensationDatas.keySet();
            for (String value : values) {
                String dataTypes = compensationDatas.getString(value);
                String[] data = value.split("&");
                String billType = data[1];
                int count = Integer.parseInt(data[3]);
                if (value.startsWith(CompensationType.MSG.getType())) {
                    quantitySummaryInfos.add(new QuantitySummaryInfo(userId, "msg", billType, count));
                    continue;
                }
                if (!value.startsWith(CompensationType.TASK.getType())) continue;
                JSONArray dataTypeArray = JSONArray.parseArray((String)dataTypes);
                for (int i = 0; i < dataTypeArray.size(); ++i) {
                    String dataType = dataTypeArray.getString(i);
                    if (dataType.equals("tohandle")) {
                        quantitySummaryInfos.add(new QuantitySummaryInfo(userId, "tohandle", billType, count));
                        continue;
                    }
                    if (dataType.equals("handled")) {
                        quantitySummaryInfos.add(new QuantitySummaryInfo(userId, "handled", billType, -count));
                        continue;
                    }
                    if (dataType.equals("transfer")) {
                        quantitySummaryInfos.add(new QuantitySummaryInfo(userId, "transfer", "transfer", -count));
                        continue;
                    }
                    if (dataType.equals("delegate")) {
                        quantitySummaryInfos.add(new QuantitySummaryInfo(userId, "delegate", "delegate", count));
                        continue;
                    }
                    quantitySummaryInfos.add(new QuantitySummaryInfo(userId, "custom", dataType, count));
                }
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("calcateCompensationData has error : %s", WfUtils.getExceptionStacktrace(e)));
        }
        return quantitySummaryInfos;
    }

    @Override
    public Map<Long, Map<String, Object>> getMsgQuantitySummaryByUserIds(List<Long> userIds, boolean canCorrectQSInfos) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>();
        if (WfConfigurationUtil.diableUseQuantitySummary()) {
            Map<Long, List<QuantitySummaryInfo>> correctQSInfos = this.getQSInfosFromBizDataByUserIds(userIds);
            Set<Map.Entry<Long, List<QuantitySummaryInfo>>> correctEntries = correctQSInfos.entrySet();
            for (Map.Entry<Long, List<QuantitySummaryInfo>> correctEntry : correctEntries) {
                HashMap<String, Object> userResult = new HashMap<String, Object>();
                userResult.put(ISCORRECTFROMBIZDB, true);
                userResult.put(QUANTITYSUMMARYINFOS, correctEntry.getValue());
                result.put(correctEntry.getKey(), userResult);
            }
        } else {
            QFilter[] filters;
            List<Object> quantitySummaryInfos;
            HashMap<String, Object> userResult;
            this.logger.debug(String.format("begine get user qsinfos[%s]", RequestContext.get().getTraceId()));
            ArrayList<Long> notHitUserIds = new ArrayList<Long>();
            for (Long userId : userIds) {
                JSONObject qsCacheData = MessageQuantitySummaryCacheUtils.getQuantitySummaryCacheData((Long)userId);
                if (qsCacheData != null) {
                    JSONArray qsCacheDatas = new JSONArray();
                    qsCacheDatas.add((Object)qsCacheData);
                    List<QuantitySummaryInfo> list = this.cache2DBConverter(qsCacheDatas);
                    userResult = new HashMap<String, Object>();
                    userResult.put(ISCORRECTFROMBIZDB, false);
                    userResult.put(QUANTITYSUMMARYINFOS, list);
                    result.put(userId, userResult);
                    continue;
                }
                notHitUserIds.add(userId);
            }
            if (!notHitUserIds.isEmpty() && !(quantitySummaryInfos = this.getQuantitySummaryDataFromQst(filters = new QFilter[]{new QFilter("userid", "in", notHitUserIds)})).isEmpty()) {
                JSONArray qsCacheDatas = this.db2CacheConverter(quantitySummaryInfos);
                MessageQuantitySummaryCacheUtils.pushQuantitySummaryCache((JSONArray)qsCacheDatas);
                for (QuantitySummaryInfo quantitySummaryInfo : quantitySummaryInfos) {
                    Long userId = quantitySummaryInfo.getUserId();
                    notHitUserIds.remove(userId);
                    if (result.containsKey(userId)) {
                        Map userResult2 = (Map)result.get(userId);
                        List qsInfos = (List)userResult2.get(QUANTITYSUMMARYINFOS);
                        qsInfos.add(quantitySummaryInfo);
                        continue;
                    }
                    ArrayList<QuantitySummaryInfo> qsInfos = new ArrayList<QuantitySummaryInfo>();
                    qsInfos.add(quantitySummaryInfo);
                    HashMap<String, Serializable> userResult3 = new HashMap<String, Serializable>();
                    userResult3.put(ISCORRECTFROMBIZDB, Boolean.valueOf(false));
                    userResult3.put(QUANTITYSUMMARYINFOS, qsInfos);
                    result.put(userId, userResult3);
                }
            }
            if (canCorrectQSInfos && !notHitUserIds.isEmpty()) {
                Map<Long, List<QuantitySummaryInfo>> correctQSInfos = this.getQSInfosFromBizDataByUserIds(notHitUserIds);
                quantitySummaryInfos = new ArrayList();
                Set<Map.Entry<Long, List<QuantitySummaryInfo>>> entries = correctQSInfos.entrySet();
                for (Map.Entry entry : entries) {
                    userResult = new HashMap();
                    userResult.put(ISCORRECTFROMBIZDB, true);
                    userResult.put(QUANTITYSUMMARYINFOS, entry.getValue());
                    result.put((Long)entry.getKey(), (Map<String, Object>)userResult);
                    quantitySummaryInfos.addAll((Collection)entry.getValue());
                }
                this.updateQuantitySummaryDB(quantitySummaryInfos, Boolean.FALSE);
                JSONArray quantitySummaryCacheDatas = this.db2CacheConverter(quantitySummaryInfos);
                MessageQuantitySummaryCacheUtils.pushQuantitySummaryCache((JSONArray)quantitySummaryCacheDatas);
            }
        }
        this.logger.debug(String.format("end get user qsinfos[%s]", RequestContext.get().getTraceId()));
        return result;
    }

    @Override
    public void correctQuantitySummaryFromBizData(Long userId) {
        this.correctQuantitySummaryFromBizData(userId, true);
    }

    @Override
    public void correctQuantitySummaryFromBizDataNoRecoredResult(List<Long> userIds) {
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
        MessageQuantitySummaryCorrectUtils.getMessageQuantitySummary(userIds, quantitySummaryInfos);
        this.updateQuantitySummaryDB(quantitySummaryInfos, Boolean.FALSE);
        JSONArray quantitySummaryCacheDatas = this.db2CacheConverter(quantitySummaryInfos);
        MessageQuantitySummaryCacheUtils.pushQuantitySummaryCache((JSONArray)quantitySummaryCacheDatas);
        this.logger.debug(String.format("correct users qsInfos ok[%s]", RequestContext.get().getTraceId()));
    }

    @Override
    public Map<Long, Map<String, Object>> correctQuantitySummaryFromBizData(List<Long> userIds) {
        if (userIds == null || userIds.isEmpty()) {
            return null;
        }
        HashMap<Long, Map<String, Object>> correctResult = new HashMap<Long, Map<String, Object>>();
        List<Long> uIds = userIds.stream().distinct().collect(Collectors.toList());
        try {
            Map<Long, Map<String, Object>> userQSInfos = this.getMsgQuantitySummaryByUserIds(uIds, false);
            Set<Map.Entry<Long, Map<String, Object>>> entries = userQSInfos.entrySet();
            for (Map.Entry<Long, Map<String, Object>> entry : entries) {
                List beforeCorrectQSInfos = (List)entry.getValue().get(QUANTITYSUMMARYINFOS);
                if (beforeCorrectQSInfos == null || beforeCorrectQSInfos.isEmpty()) continue;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("beforeCorrectQSInfos", beforeCorrectQSInfos);
                correctResult.put(entry.getKey(), hashMap);
            }
            Map<Long, List<QuantitySummaryInfo>> correctQSInfos = this.getQSInfosFromBizDataByUserIds(uIds);
            Set<Map.Entry<Long, List<QuantitySummaryInfo>>> correctEntries = correctQSInfos.entrySet();
            for (Map.Entry entry : correctEntries) {
                Long userId = (Long)entry.getKey();
                List list = (List)entry.getValue();
                Map<String, List> qsInfoData = null;
                if (correctResult.containsKey(userId)) {
                    qsInfoData = (Map)correctResult.get(userId);
                    qsInfoData.put("afterCorrectQSInfos", list);
                    continue;
                }
                qsInfoData = new HashMap();
                qsInfoData.put("beforeCorrectQSInfos", list);
                qsInfoData.put("afterCorrectQSInfos", list);
                correctResult.put(userId, qsInfoData);
            }
            ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
            Set set = correctResult.entrySet();
            for (Map.Entry entry : set) {
                List afterCorrectQSInfos;
                Map v = (Map)entry.getValue();
                List beforeCorrectQSInfos = (List)v.get("beforeCorrectQSInfos");
                Map<String, String> compare = this.compareCorrectQSInfos(beforeCorrectQSInfos, afterCorrectQSInfos = (List)v.get("afterCorrectQSInfos"));
                if (compare != null && !compare.isEmpty()) {
                    quantitySummaryInfos.addAll(afterCorrectQSInfos);
                    v.put("correctCompareResult", compare.toString());
                    continue;
                }
                uIds.remove(entry.getKey());
                v.put("correctCompareResult", "qsInfoSame");
            }
            this.logger.debug(String.format("calculate compare users qsInfos ok[%s]", RequestContext.get().getTraceId()));
            this.updateQuantitySummaryDB(quantitySummaryInfos, Boolean.FALSE);
            JSONArray quantitySummaryCacheDatas = this.db2CacheConverter(quantitySummaryInfos);
            MessageQuantitySummaryCacheUtils.pushQuantitySummaryCache((JSONArray)quantitySummaryCacheDatas);
            this.logger.debug(String.format("correct users qsInfos ok[%s]", RequestContext.get().getTraceId()));
        }
        catch (Exception e) {
            this.logger.error(String.format("correctQuantitySummaryFromBizData has exception: %s", WfUtils.getExceptionStacktrace(e)));
        }
        if (!uIds.isEmpty()) {
            this.updateUserAvatarBadge(new HashSet<Long>(uIds));
        }
        return correctResult;
    }

    private Map<Long, List<QuantitySummaryInfo>> getQSInfosFromBizDataByUserIds(List<Long> userIds) {
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
        MessageQuantitySummaryCorrectUtils.getMessageQuantitySummary(userIds, quantitySummaryInfos);
        this.logger.debug(String.format("calculate users qsInfos from db over![%s]", RequestContext.get().getTraceId()));
        HashMap<Long, List<QuantitySummaryInfo>> userQSInfos = new HashMap<Long, List<QuantitySummaryInfo>>();
        if (quantitySummaryInfos.isEmpty()) {
            return userQSInfos;
        }
        for (QuantitySummaryInfo quantitySummaryInfo : quantitySummaryInfos) {
            List<QuantitySummaryInfo> qsInfos;
            Long userId = quantitySummaryInfo.getUserId();
            if (userQSInfos.containsKey(userId)) {
                qsInfos = (List)userQSInfos.get(userId);
                qsInfos.add(quantitySummaryInfo);
                continue;
            }
            qsInfos = new ArrayList();
            qsInfos.add(quantitySummaryInfo);
            userQSInfos.put(userId, qsInfos);
        }
        return userQSInfos;
    }

    private Map<String, String> compareCorrectQSInfos(List<QuantitySummaryInfo> beforeCorrectQSInfos, List<QuantitySummaryInfo> afterCorrectQSInfos) {
        HashMap<String, String> compareResult = new HashMap<String, String>();
        if (beforeCorrectQSInfos == null || afterCorrectQSInfos == null || beforeCorrectQSInfos == afterCorrectQSInfos) {
            compareResult.put("noCacheAndDB", "true");
            return compareResult;
        }
        ArrayList<QuantitySummaryInfo> beforeQSInfos = new ArrayList<QuantitySummaryInfo>(beforeCorrectQSInfos);
        ArrayList<QuantitySummaryInfo> afterQSInfos = new ArrayList<QuantitySummaryInfo>(afterCorrectQSInfos);
        try {
            for (QuantitySummaryInfo afterQSInfo : afterQSInfos) {
                String dataType = afterQSInfo.getDataType();
                String billType = afterQSInfo.getBillType();
                int quantitysum = afterQSInfo.getQuantitysum();
                boolean isfindCompareData = false;
                Iterator iterator = beforeQSInfos.iterator();
                while (iterator.hasNext()) {
                    QuantitySummaryInfo beforeQSInfo = (QuantitySummaryInfo)iterator.next();
                    if (!dataType.equals(beforeQSInfo.getDataType()) || !billType.equals(beforeQSInfo.getBillType())) continue;
                    int beforeSum = beforeQSInfo.getQuantitysum();
                    if (quantitysum != beforeSum) {
                        compareResult.put(dataType + "-" + billType, "before[" + beforeSum + "]-after[" + quantitysum + "]");
                    }
                    iterator.remove();
                    isfindCompareData = true;
                    break;
                }
                if (isfindCompareData) continue;
                compareResult.put(dataType + "-" + billType, "after[" + quantitysum + "]");
            }
            if (!beforeQSInfos.isEmpty()) {
                for (QuantitySummaryInfo beforeQSInfo : beforeQSInfos) {
                    String v = "before[" + beforeQSInfo.getQuantitysum() + "]";
                    compareResult.put(beforeQSInfo.getDataType() + "-" + beforeQSInfo.getBillType(), v);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("compareCorrectQSInfos has Exception: %s", WfUtils.getExceptionStacktrace(e)));
            compareResult.put("errorInfo", RequestContext.get().getTraceId());
        }
        return compareResult;
    }

    @Override
    public List<QuantitySummaryInfo> getMsgQuantitySummaryByItemKey(Long userId, String scene, List<String> itemKey) {
        Map<String, Object> qsMapInfos = this.getMsgQuantitySummaryByItemKey(userId, Boolean.TRUE, scene, itemKey);
        List qsInfos = (List)qsMapInfos.get(QUANTITYSUMMARYINFOS);
        return qsInfos;
    }

    private Map<String, Object> getMsgQuantitySummaryByItemKey(Long userId, Boolean updateCache, String scene, List<String> itemKey) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean isCorrectFormBizDB = Boolean.FALSE;
        List<Object> quantitySummaryInfos = null;
        if (WfConfigurationUtil.diableUseQuantitySummary()) {
            if (WfUtils.isNotEmpty(scene)) {
                quantitySummaryInfos = new ArrayList();
                MessageQuantitySummaryCorrectUtils.getMessageQuantitySummaryByItemKey(userId, scene, quantitySummaryInfos, itemKey);
            } else {
                quantitySummaryInfos = MessageQuantitySummaryCorrectUtils.getQTYSummaryFromBizDataByItemKey(userId, itemKey);
            }
            isCorrectFormBizDB = Boolean.TRUE;
            this.logger.debug(String.format("MessageQuantitySummaryServcieImpl_getqs_%s", userId));
        } else {
            JSONObject qsCacheData = MessageQuantitySummaryCacheUtils.getQuantitySummaryCacheData((Long)userId);
            if (qsCacheData != null) {
                JSONArray qsCacheDatas = new JSONArray();
                qsCacheDatas.add((Object)qsCacheData);
                quantitySummaryInfos = this.cache2DBConverter(qsCacheDatas);
            } else {
                QFilter[] filters = new QFilter[]{new QFilter("userid", "=", (Object)userId)};
                quantitySummaryInfos = this.getQuantitySummaryDataFromQst(filters);
                if (!quantitySummaryInfos.isEmpty()) {
                    if (updateCache.booleanValue()) {
                        JSONArray qsCacheDatas = this.db2CacheConverter(quantitySummaryInfos);
                        MessageQuantitySummaryCacheUtils.pushQuantitySummaryCache((JSONArray)qsCacheDatas);
                    }
                } else {
                    quantitySummaryInfos = this.correctQuantitySummaryFromBizData(userId, updateCache);
                    isCorrectFormBizDB = Boolean.TRUE;
                }
            }
            String traceId = RequestContext.get().getTraceId();
            this.logger.debug(String.format("msgqs_traceLog_%s, traceId: %s, qsValue: %s, isCorrectFormBizDB: %s", userId, traceId, "", isCorrectFormBizDB));
        }
        result.put(ISCORRECTFROMBIZDB, isCorrectFormBizDB);
        result.put(QUANTITYSUMMARYINFOS, quantitySummaryInfos);
        return result;
    }
}

