/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;

public class MessageUtils {
    private static Log logger = LogFactory.getLog(MessageUtils.class);
    private static final String DEFAULTSMSCODE = "10725";
    private static final String EMAILCONTENT = "emailContent";
    private static final String EMAILTITLE = "emailTitle";
    private static final String CONTENT = "content";
    private static final String TITLE = "title";
    private static final String CHANNELMAPPINGTOAPPTYPE = "{'weixinqy' : 'wxqyh','dingding' : 'dd','welink' : 'wl'}";

    public static Map<String, Object> wrapResult(String description, Object data) {
        HashMap<String, Object> sendResult = new HashMap<String, Object>();
        if ("success".equals(description)) {
            sendResult.put("result", Boolean.TRUE);
            sendResult.put("code", "0");
            sendResult.put("description", String.format(ResManager.loadKDString((String)"\u63a8\u9001\u6210\u529f %s", (String)"MessageUtils_0", (String)"bos-wf-engine", (Object[])new Object[0]), description));
            sendResult.put("data", data);
        } else {
            sendResult.put("result", Boolean.FALSE);
            sendResult.put("code", "400");
            sendResult.put("description", String.format(ResManager.loadKDString((String)"\u63a8\u9001\u5931\u8d25 %s", (String)"MessageUtils_1", (String)"bos-wf-engine", (Object[])new Object[0]), description));
            sendResult.put("data", data);
        }
        logger.debug("MessageUtils--result: " + description);
        return sendResult;
    }

    public static List<String> getPhonesEmailAddressByParams(ToDoInfo todoInfo, MessageInfo messageInfo, String type) {
        List userIds;
        List<String> resultInfo = new ArrayList();
        List list = userIds = todoInfo != null ? todoInfo.getUserIds() : messageInfo.getUserIds();
        if (userIds != null && userIds.size() != 0) {
            QFilter f1 = new QFilter("enable", "=", (Object)Character.valueOf('1'));
            QFilter f2 = new QFilter("id", "in", (Object)userIds);
            DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)"id, phone, email", (QFilter[])new QFilter[]{f1, f2});
            for (DynamicObject user : users) {
                Object email;
                if ("sms".equals(type)) {
                    Object phone = user.get("phone");
                    if (!StringUtils.isNotBlank((Object)phone)) continue;
                    resultInfo.add(phone.toString());
                    continue;
                }
                if (!"email".equals(type) || !StringUtils.isNotBlank((Object)(email = user.get("email")))) continue;
                resultInfo.add(email.toString());
            }
        } else {
            Map param;
            Map map = param = todoInfo != null ? todoInfo.getParams() : messageInfo.getParams();
            if ("sms".equals(type)) {
                resultInfo = (List)param.get("phone");
            } else if ("email".equals(type)) {
                resultInfo = (List)param.get("email");
            }
        }
        return resultInfo;
    }

    public static Map<String, Object> getPhonesByParamsForSms(ToDoInfo todoInfo, MessageInfo messageInfo) {
        List userIds;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Object> useridAndPhone = new HashMap<String, Object>();
        List<String> resultInfo = new ArrayList();
        List list = userIds = todoInfo != null ? todoInfo.getUserIds() : messageInfo.getUserIds();
        if (userIds != null && userIds.size() != 0) {
            QFilter f1 = new QFilter("enable", "=", (Object)Character.valueOf('1'));
            QFilter f2 = new QFilter("id", "in", (Object)userIds);
            DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)"id, phone, email", (QFilter[])new QFilter[]{f1, f2});
            for (DynamicObject user : users) {
                Object phone = user.get("phone");
                if (!StringUtils.isNotBlank((Object)phone)) continue;
                resultInfo.add(phone.toString());
                useridAndPhone.put(phone.toString(), user.get("id"));
            }
            resultMap.put("useridAndPhone", useridAndPhone);
        } else {
            Map param = todoInfo != null ? todoInfo.getParams() : messageInfo.getParams();
            resultInfo = (List)param.get("phone");
        }
        resultMap.put("phones", resultInfo);
        return resultMap;
    }

    public static void wrapMessageContent(MessageInfo message, String type) {
        Object showUrlInSms = message.getParams().get("showurlinwfsms");
        if (type.equalsIgnoreCase(MessageChannels.SMS.getNumber()) && showUrlInSms != null && !((Boolean)showUrlInSms).booleanValue()) {
            return;
        }
        String mobContentUrl = message.getMobContentUrl();
        String content = message.getContent();
        if (StringUtils.isNotBlank((CharSequence)mobContentUrl) && StringUtils.isNotBlank((CharSequence)content) && !content.contains("http://") && !content.contains("https://")) {
            ILocaleString tips = WfUtils.getPromptWordLocaleString("\u4e1a\u52a1\u94fe\u63a5", "MessageUtils_2", "bos-wf-engine");
            ILocaleString messageContent = message.getMessageContent();
            if (WfUtils.isNotEmpty(messageContent)) {
                for (Map.Entry entry : messageContent.entrySet()) {
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                    String k = (String)entry.getKey();
                    String tipStr = WfMultiLangUtils.getValueFromLocalString(tips, k);
                    StringBuilder mc = new StringBuilder((String)entry.getValue());
                    mc.append(type.equalsIgnoreCase("email") ? "<br/>" : "\r\n");
                    mc.append(type.equalsIgnoreCase("email") ? "" : tipStr + ":");
                    mc.append(type.equalsIgnoreCase("email") ? "<a href=\"" + message.getMobContentUrl() + "\">" + tipStr + "</a>" : message.getMobContentUrl());
                    messageContent.setItem(k, (Object)mc.toString());
                }
                message.setMessageContent(messageContent);
            }
        }
    }

    public static final boolean isBlankMessage(List<MessageInfo> messages) {
        if (messages == null || messages.isEmpty()) {
            return true;
        }
        for (int i = 0; i < messages.size(); ++i) {
            MessageInfo message = messages.get(i);
            if (!StringUtils.isBlank((CharSequence)message.getContent())) continue;
            return true;
        }
        return false;
    }

    public static String getSingture(String lang) {
        MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)"sms");
        String singture = "";
        if (DEFAULTSMSCODE.equalsIgnoreCase(msgChannelInfo.getSmscode()) && StringUtils.isNotBlank((CharSequence)msgChannelInfo.getMobileappconfig())) {
            JSONObject mobilAppConfig = JSONObject.parseObject((String)msgChannelInfo.getMobileappconfig());
            Map signatureMap = (Map)SerializationUtils.fromJsonString((String)mobilAppConfig.getString("signature"), Map.class);
            Object singtureStr = signatureMap.get(lang);
            singture = StringUtils.isNotBlank(singtureStr) ? singtureStr.toString() : "";
        }
        return singture;
    }

    public static String handleData(JSONObject obj) {
        String lang = Lang.get().toString();
        LocaleString value = new LocaleString();
        if (null != obj && obj.size() > 0) {
            for (Map.Entry entry : obj.entrySet()) {
                if (!((String)entry.getKey()).equals(lang)) continue;
                value.setItem((String)entry.getKey(), (Object)((String)entry.getValue()));
                break;
            }
        }
        return String.valueOf(value);
    }

    public static String spliceData(JSONObject obj) {
        String content = "";
        String title = "";
        Object contentObj = null;
        Object titleObj = null;
        boolean isEmail = false;
        if (obj.containsKey((Object)EMAILTITLE) || obj.containsKey((Object)EMAILCONTENT)) {
            isEmail = true;
            contentObj = obj.get((Object)EMAILCONTENT);
            titleObj = obj.get((Object)EMAILTITLE);
        } else {
            isEmail = false;
            contentObj = obj.get((Object)CONTENT);
            titleObj = obj.get((Object)TITLE);
        }
        content = contentObj instanceof JSONObject ? MessageUtils.handleData((JSONObject)contentObj) : String.valueOf(contentObj);
        title = titleObj instanceof JSONObject ? MessageUtils.handleData((JSONObject)titleObj) : String.valueOf(titleObj);
        JSONObject object = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)title)) {
            object.put(isEmail ? EMAILTITLE : TITLE, (Object)title);
        }
        if (StringUtils.isNotBlank((CharSequence)content)) {
            object.put(isEmail ? EMAILCONTENT : CONTENT, (Object)content);
        }
        if (object == null || object.size() == 0) {
            return null;
        }
        return String.valueOf(object);
    }

    public static String getApptypeOrChannelNumber(String channel, String apptype) {
        JSONObject mappingObject = JSONObject.parseObject((String)CHANNELMAPPINGTOAPPTYPE);
        if (StringUtils.isNotBlank((CharSequence)channel)) {
            if (mappingObject.getString(channel) != null) {
                return mappingObject.getString(channel);
            }
            return channel;
        }
        if (StringUtils.isNotBlank((CharSequence)apptype)) {
            if (mappingObject.containsValue((Object)apptype) && MessageChannelUtils.getChannelConfig((String)channel) == null) {
                for (Map.Entry entry : mappingObject.entrySet()) {
                    if (!entry.getValue().equals(apptype)) continue;
                    return (String)entry.getKey();
                }
            }
            return apptype;
        }
        return null;
    }
}

