/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.util.dingding;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.DingdingTodoInfo;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.utils.DingdingTemplateUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.exception.WFErrorCode;

public class DingdingCommonUtil {
    private static Log logger = LogFactory.getLog(DingdingCommonUtil.class);
    private static final String DINGDIGNTODO = "wf_msg_dingtodo";
    private static final String DINDDINGTPL = "wf_msg_dingtpl";
    private static final String TPLID = "tplid";
    private static final String TPLNAME = "tplname";
    private static final String TPLDESCRIPTION = "tpldescription";
    private static final String PROCINSTID = "procinstid";
    private static final String TASKID = "taskid";
    private static final String DPROCINSTID = "dprocinstid";
    private static final String DTODOID = "dtodoid";
    private static final String TODOSTATE = "todostate";
    private static final String INSTSTATE = "inststate";
    private static final String TODOOKSTATE = "handled";
    private static final String INSTOKSTATE = "complete";

    public static JSONObject getDingTpl(String entityNumber, String entityName) {
        MsgChannelInfo msgChannel = MsgServiceCache.getMsgChannel((String)"dingding");
        if (StringUtils.isBlank((CharSequence)msgChannel.getAgentid())) {
            return null;
        }
        JSONObject map = new JSONObject();
        QFilter filter1 = new QFilter("entitynumber", "=", (Object)entityNumber);
        QFilter filter2 = new QFilter("agentid", "=", (Object)Long.valueOf(msgChannel.getAgentid()));
        QFilter filter3 = new QFilter("corpid", "=", (Object)msgChannel.getCorpid());
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        DynamicObject dingTplObject = BusinessDataServiceHelper.loadSingle((String)DINDDINGTPL, (String)"id, entitynumber, entityname, tplid, tplname, tpldescription, agentid, corpid", (QFilter[])filters);
        if (dingTplObject == null) {
            String tplCode = DingdingCommonUtil.getDingTplCode(entityName);
            logger.debug("getDingTpl--TPLID:" + tplCode);
            if (tplCode != null) {
                map.put("tplcode", (Object)tplCode);
            }
            map.put("ishastpl", (Object)false);
        } else {
            map.put("ishastpl", (Object)true);
            map.put(TPLID, (Object)dingTplObject.getString(TPLID));
            map.put(TPLNAME, (Object)dingTplObject.getString(TPLNAME));
            map.put(TPLDESCRIPTION, (Object)dingTplObject.getString(TPLDESCRIPTION));
        }
        return map;
    }

    private static String getDingTplCode(String entityName) {
        String errcode;
        Map resultObj = DingdingTemplateUtils.getDingTplCode((String)entityName);
        if (null != resultObj && null != resultObj.get("code") && "0".equals(errcode = String.valueOf(resultObj.get("code")))) {
            JSONObject tplCode = JSONObject.parseObject((String)String.valueOf(resultObj.get("tplCode")));
            logger.debug("getDingTplCode-- tplCode result is :" + tplCode.toString());
            Object processCode = tplCode.get((Object)"process_code");
            logger.debug("getDingTplCode-- tplCode is :" + processCode);
            if (StringUtils.isNotBlank((Object)processCode)) {
                return String.valueOf(processCode);
            }
        }
        return null;
    }

    public static void saveDingTpl(MessageContext ctx, DingdingTodoInfo todoInfo, Map<String, Object> todoResult) {
        if (todoResult != null && todoResult.get("code").equals("0")) {
            MsgChannelInfo msgChannel = MsgServiceCache.getMsgChannel((String)"dingding");
            DynamicObject dingTpl = ORM.create().newDynamicObject(DINDDINGTPL);
            dingTpl.set("entitynumber", (Object)ctx.getEntityNumber());
            dingTpl.set("entityname", (Object)ctx.getEntityName());
            dingTpl.set(TPLID, todoResult.get(TPLID));
            dingTpl.set(TPLNAME, (Object)todoInfo.getTplName());
            dingTpl.set(TPLDESCRIPTION, (Object)todoInfo.getTplDescription());
            dingTpl.set("corpid", (Object)msgChannel.getCorpid());
            dingTpl.set("agentid", (Object)msgChannel.getAgentid());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dingTpl});
            logger.debug("saveDingTpl---\u4fdd\u5b58\u9489\u9489\u6a21\u677f\u4fe1\u606f\u6210\u529f tplid=" + todoResult.get(TPLID));
        } else {
            Object s = null;
            s = todoResult != null ? todoResult.get("description") : "todoResult is null";
            logger.warn("saveDingTpl---\u521b\u5efa\u9489\u5f85\u529e\u5931\u8d25\uff0c\u4fe1\u606f" + s);
        }
    }

    public static void saveDingTodo(Long processInstanceId, Long taskId, Long userId, DingdingTodoInfo todoInfo, Map<String, Object> todoResult) {
        if (todoResult != null && todoResult.get("code").equals("0")) {
            DynamicObject dingTodo = ORM.create().newDynamicObject(DINGDIGNTODO);
            dingTodo.set(PROCINSTID, (Object)processInstanceId);
            dingTodo.set(TASKID, (Object)taskId);
            dingTodo.set("userid", (Object)userId);
            dingTodo.set("dtplid", todoResult.get(TPLID));
            dingTodo.set(DPROCINSTID, todoResult.get("processinstanceid"));
            dingTodo.set(DTODOID, todoResult.get(TASKID));
            dingTodo.set("createdate", (Object)System.currentTimeMillis());
            dingTodo.set("modifydate", (Object)System.currentTimeMillis());
            dingTodo.set(TODOSTATE, (Object)"tohandle");
            dingTodo.set(INSTSTATE, (Object)"uncomplete");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dingTodo});
            logger.debug("saveDingTodo--\u9489\u5f85\u529e\u521b\u5efa\u6210\u529f\uff0cdingtodoid=" + todoResult.get(TASKID));
        } else {
            logger.warn("saveDingTodo--\u9489\u5f85\u529e\u521b\u5efa\u5931\u8d25\uff0c\u672a\u4fdd\u5b58\u6570\u636e\u5e93");
        }
    }

    public static void updateDingTodo(List<String> taskIds) {
        if (taskIds != null && !taskIds.isEmpty()) {
            QFilter[] filters = new QFilter[]{new QFilter(DTODOID, "in", taskIds)};
            DynamicObject[] dingTodo = BusinessDataServiceHelper.load((String)DINGDIGNTODO, (String)"procinstid, dtplid, dprocinstid, todostate", (QFilter[])filters);
            for (int i = 0; i < dingTodo.length; ++i) {
                dingTodo[i].set(TODOSTATE, (Object)TODOOKSTATE);
            }
            SaveServiceHelper.update((DynamicObject[])dingTodo);
        }
    }

    public static void updateDingProcess(Long processInstanceId) {
        QFilter[] filters = new QFilter[]{new QFilter(PROCINSTID, "=", (Object)processInstanceId)};
        DynamicObject[] dingTodoList = BusinessDataServiceHelper.load((String)DINGDIGNTODO, (String)INSTSTATE, (QFilter[])filters);
        for (int i = 0; i < dingTodoList.length; ++i) {
            dingTodoList[i].set(INSTSTATE, (Object)INSTOKSTATE);
        }
        SaveServiceHelper.update((DynamicObject[])dingTodoList);
    }

    public static String getDingProcessInstance(Long processInstanceId) {
        String dingProcessInsatnceId = "";
        QFilter[] filters = new QFilter[]{new QFilter(PROCINSTID, "=", (Object)processInstanceId)};
        DynamicObject[] dingTodoList = BusinessDataServiceHelper.load((String)DINGDIGNTODO, (String)"procinstid, dtplid, dprocinstid", (QFilter[])filters);
        if (dingTodoList != null && dingTodoList.length != 0) {
            dingProcessInsatnceId = dingTodoList[0].getString(DPROCINSTID);
        }
        return dingProcessInsatnceId;
    }

    public static JSONArray getdingTodoInfo(ToDoInfo info) {
        QFilter[] filters = new QFilter[]{new QFilter(TASKID, "=", (Object)info.getTaskId()), new QFilter("userid", "in", (Object)info.getUserIds())};
        DynamicObject[] objist = BusinessDataServiceHelper.load((String)DINGDIGNTODO, (String)"procinstid, taskid, dtplid, dprocinstid, dtodoid", (QFilter[])filters);
        JSONArray array = new JSONArray();
        if (objist != null && objist.length != 0) {
            for (int i = 0; i < objist.length; ++i) {
                JSONObject map = new JSONObject();
                map.put(TASKID, (Object)objist[i].getString(DTODOID));
                map.put("processinstanceid", (Object)objist[i].getString(DPROCINSTID));
                array.add((Object)map);
            }
        }
        return array;
    }

    public static void deleteTodoInfo(List<Long> dingTodoIDs) {
        QFilter todoFilter = new QFilter(TODOSTATE, "=", (Object)TODOOKSTATE);
        QFilter instFilter = new QFilter(INSTSTATE, "=", (Object)INSTOKSTATE);
        QFilter[] filters = new QFilter[]{new QFilter(DTODOID, "in", (Object)dingTodoIDs.toArray()), todoFilter, instFilter};
        DeleteServiceHelper.delete((String)DINGDIGNTODO, (QFilter[])filters);
    }

    public static void deleteTodoInfoByProcessInstanceId(Long processInstanceId) {
        QFilter todoFilter = new QFilter(TODOSTATE, "=", (Object)TODOOKSTATE);
        QFilter instFilter = new QFilter(INSTSTATE, "=", (Object)INSTOKSTATE);
        QFilter[] filters = new QFilter[]{new QFilter(PROCINSTID, "=", (Object)processInstanceId), todoFilter, instFilter};
        DeleteServiceHelper.delete((String)DINGDIGNTODO, (QFilter[])filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MessageUser> getOpenIds(List<Long> userIdList, int type) {
        ArrayList<MessageUser> users = new ArrayList<MessageUser>();
        if (userIdList.isEmpty()) {
            return users;
        }
        ArrayList<Long> params = new ArrayList<Long>(userIdList.size());
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT FIMTypeID, FUserID, FOpenID, fencryopenid FROM t_bas_immapping WHERE FIMTypeID = ");
        sb.append(type);
        sb.append(" AND FUserID in (");
        for (int i = 0; i < userIdList.size(); ++i) {
            if (i == userIdList.size() - 1) {
                sb.append("?);");
            } else {
                sb.append("?,");
            }
            params.add(userIdList.get(i));
        }
        DynamicObjectCollection ObjectCollection = null;
        try (DataSet ds = DB.queryDataSet((String)"DingdingCommonUtil.getOpenIds.queryDingOpenId", (DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params.toArray());){
            ObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
        }
        if (ObjectCollection != null && !ObjectCollection.isEmpty()) {
            for (DynamicObject im : ObjectCollection) {
                users.add(new MessageUser(im.getLong("FUserID"), im.getString("FOpenID"), null, null, im.getString("fencryopenid")));
            }
        }
        return users;
    }

    public static ILocaleString wrapContent(ILocaleString content) {
        ILocaleString contentPrefix = WfUtils.getPromptWordLocaleString("\u8bf7\u5904\u7406\uff1a", "DingdingServiceHandler_2", "bos-wf-engine");
        ILocaleString titlePrefix = WfUtils.getPromptWordLocaleString("\u8bf7\u5904\u7406", "DingdingServiceHandler_3", "bos-wf-engine");
        LocaleString newContent = new LocaleString();
        for (Map.Entry entry : content.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!WfUtils.isNotEmpty(value)) continue;
            if (WfUtils.isNotEmpty((String)contentPrefix.get((Object)key)) && value.contains((CharSequence)contentPrefix.get((Object)key))) {
                value = value.replace((CharSequence)contentPrefix.get((Object)key), "");
            }
            if (WfUtils.isNotEmpty((String)titlePrefix.get((Object)key)) && value.contains((CharSequence)titlePrefix.get((Object)key))) {
                value = value.replace((CharSequence)titlePrefix.get((Object)key), "");
            }
            newContent.setItem(key, (Object)value);
        }
        return newContent;
    }

    public static String wrapContent(String lang, String value) {
        ILocaleString contentPrefix = WfUtils.getPromptWordLocaleString("\u8bf7\u5904\u7406:", "DingdingServiceHandler_2", "bos-wf-engine");
        ILocaleString titlePrefix = WfUtils.getPromptWordLocaleString("\u8bf7\u5904\u7406", "DingdingServiceHandler_3", "bos-wf-engine");
        if (WfUtils.isNotEmpty(value)) {
            if (WfUtils.isNotEmpty((String)contentPrefix.get((Object)lang)) && value.contains((CharSequence)contentPrefix.get((Object)lang))) {
                value = value.replace((CharSequence)contentPrefix.get((Object)lang), "");
            }
            if (WfUtils.isNotEmpty((String)titlePrefix.get((Object)lang)) && value.contains((CharSequence)titlePrefix.get((Object)lang))) {
                value = value.replace((CharSequence)titlePrefix.get((Object)lang), "");
            }
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void updateProcessInstanceState(MessageContext ctx, Long proceInstanceId) {
        logger.info("DingdingServiceHandler-- completeProcessInstance proceInstanceId:" + proceInstanceId);
        Map map = ctx.getParams();
        if (map == null) return;
        if (map.isEmpty()) {
            return;
        }
        String state = (String)map.get("processInstState");
        if (proceInstanceId != null && StringUtils.isNotBlank((CharSequence)state)) {
            String dingProcessInstanceId = DingdingCommonUtil.getDingProcessInstance(proceInstanceId);
            if (!StringUtils.isNotBlank((CharSequence)dingProcessInstanceId)) {
                String message = "DingdingServiceHandler-- completeProcessInstance updateDingProcessInstanceState--no dingProcessInstanceId : " + proceInstanceId;
                logger.info(message);
                throw new KDException(WFErrorCode.dingdingMsgError(), new Object[]{message});
            }
            Map result = MessageServiceHelper.dingdingUpdateProcessInstanceState((String)state, (String)dingProcessInstanceId);
            if (result != null && result.get("code").equals("0")) {
                DingdingCommonUtil.updateDingProcess(proceInstanceId);
                DingdingCommonUtil.deleteTodoInfoByProcessInstanceId(proceInstanceId);
                logger.info("DingdingServiceHandler-- completeProcessInstance sucess");
                return;
            }
            String description = result == null ? "" : (String)result.get("description");
            String faileMessage = "DingdingServiceHandler-- completeProcessInstance updateDingProcessInstanceState is error,description :" + description;
            logger.info(faileMessage);
            throw new KDException(WFErrorCode.dingdingMsgError(), new Object[]{faileMessage});
        }
        logger.info("DingdingServiceHandler-- completeProcessInstance updateDingProcessInstanceState-- param is error");
    }
}

