/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.util.welink;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.AccessTokenUtils;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.welink.WeLinkTodoInfo;
import kd.bos.workflow.engine.msg.model.welink.WeLinkTodoType;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.util.dingding.DingdingCommonUtil;
import kd.bos.workflow.engine.msg.util.welink.WeLinkHandleUtil;

public class WeLinkCommonUtil {
    private static Log logger = LogFactory.getLog(WeLinkCommonUtil.class);
    private static final String MSGWELINKTODO = "msg_welinktodo";
    private static final int STANDARDRETRY = 5;
    private static final String TASKID = "taskid";
    private static final String USERID = "userid";
    private static final String STATE = "state";
    private static final String RESULT = "result";
    private static final String FALSE = "false";
    private static final String RETRIES = "retries";
    private static final String OPENID = "openid";
    private static final String APPID = "appid";
    private static final String APPSECRET = "appsecret";
    private static final String CORPID = "corpid";
    private static final String WLCORPID = "wlcorpid";
    private static final String WLAPPID = "wlappid";
    private static final String WLAPPSECRET = "wlappsecret";
    private static final String APPNAME = "appname";
    private static final String WLAPPNAME = "wlappname";
    private static final String PROCINSTID = "procinstid";
    private static final String SELECTFIELDS = "id, userid, openid, state, result, retries, modifydate";
    private static final String MODIFYDATE = "modifydate";

    public static List<WeLinkTodoInfo> transformTodo(MessageContext ctx, ToDoInfo todoInfo, WeLinkTodoType todoType) {
        List<Object> weLinkTodoList;
        block11: {
            block12: {
                QFilter f4;
                QFilter f3;
                QFilter f2;
                block10: {
                    QFilter f42;
                    QFilter f32;
                    QFilter f22;
                    weLinkTodoList = new ArrayList();
                    if (todoType != WeLinkTodoType.CREATE) break block10;
                    QFilter f1 = new QFilter(TASKID, "=", (Object)todoInfo.getTaskId());
                    DynamicObject[] todoStates = BusinessDataServiceHelper.load((String)MSGWELINKTODO, (String)"id, userid, openid, result, retries", (QFilter[])new QFilter[]{f1, f22 = new QFilter(USERID, "in", (Object)todoInfo.getUserIds()), f32 = new QFilter(STATE, "=", (Object)todoType.getNumber()), f42 = new QFilter(RESULT, "=", (Object)FALSE).and(RETRIES, "<", (Object)5)});
                    if (todoStates != null && todoStates.length != 0) {
                        List userIdsNotInTable = todoInfo.getUserIds();
                        ArrayList<DynamicObject> canRetryTodoState = new ArrayList<DynamicObject>();
                        for (DynamicObject todoState : todoStates) {
                            userIdsNotInTable.remove(todoState.getLong(USERID));
                            if (todoState.getBoolean(RESULT) || todoState.getInt(RETRIES) > 5) continue;
                            canRetryTodoState.add(todoState);
                        }
                        weLinkTodoList = WeLinkCommonUtil.wrapWeLinkTodo(ctx, todoInfo, userIdsNotInTable, canRetryTodoState, todoType);
                    } else {
                        weLinkTodoList = WeLinkCommonUtil.wrapWeLinkTodo(ctx, todoInfo, todoInfo.getUserIds(), null, todoType);
                    }
                    break block11;
                }
                if (todoType != WeLinkTodoType.DEAL) break block12;
                QFilter f1 = new QFilter(TASKID, "=", (Object)todoInfo.getTaskId());
                DynamicObject[] weLinkTodoStates = BusinessDataServiceHelper.load((String)MSGWELINKTODO, (String)"id, userid, openid, corpid, appid, appsecret, appname", (QFilter[])new QFilter[]{f1, f2 = new QFilter(USERID, "in", (Object)todoInfo.getUserIds()), (f3 = new QFilter(STATE, "=", (Object)WeLinkTodoType.CREATE.getNumber()).and(RESULT, "=", (Object)"true")).or(f4 = new QFilter(STATE, "=", (Object)todoType.getNumber()).and(RETRIES, "<=", (Object)5))});
                if (weLinkTodoStates == null || weLinkTodoStates.length == 0) break block11;
                JSONObject configData = new JSONObject();
                for (DynamicObject todoState : weLinkTodoStates) {
                    WeLinkTodoInfo weLinkTodo = new WeLinkTodoInfo();
                    weLinkTodo.setTodoType(todoType.getNumber());
                    weLinkTodo.setTaskId(todoState.getString("id"));
                    weLinkTodo.setUserId(todoState.getString(OPENID));
                    weLinkTodo.setApplicantUserId(todoState.getString(USERID));
                    if (StringUtils.isEmpty((CharSequence)todoState.getString(APPID)) && StringUtils.isEmpty((CharSequence)todoState.getString(APPSECRET))) {
                        weLinkTodo.setTaskDesc("");
                    } else {
                        configData.put(WLCORPID, (Object)todoState.getString(CORPID));
                        configData.put(WLAPPID, (Object)todoState.getString(APPID));
                        configData.put(WLAPPSECRET, (Object)todoState.getString(APPSECRET));
                        configData.put(WLAPPNAME, (Object)todoState.getString(APPNAME));
                        weLinkTodo.setTaskDesc(configData.toJSONString());
                        configData.clear();
                    }
                    weLinkTodoList.add(weLinkTodo);
                }
                break block11;
            }
            QFilter f1 = new QFilter(TASKID, "=", (Object)todoInfo.getTaskId());
            QFilter f2 = new QFilter(USERID, "in", (Object)todoInfo.getUserIds());
            QFilter f3 = new QFilter(STATE, "=", (Object)WeLinkTodoType.CREATE.getNumber()).and(RESULT, "=", (Object)"true");
            QFilter f5 = new QFilter(STATE, "=", (Object)WeLinkTodoType.DEAL.getNumber());
            QFilter f4 = new QFilter(STATE, "=", (Object)todoType.getNumber()).and(RETRIES, "<=", (Object)5);
            DynamicObject[] weLinkTodoStates = BusinessDataServiceHelper.load((String)MSGWELINKTODO, (String)"id, userid, openid, corpid, appid, appsecret, appname", (QFilter[])new QFilter[]{f1, f2, f3.or(f5).or(f4)});
            if (weLinkTodoStates != null && weLinkTodoStates.length != 0) {
                JSONObject configData = new JSONObject();
                for (DynamicObject todoState : weLinkTodoStates) {
                    WeLinkTodoInfo weLinkTodo = new WeLinkTodoInfo();
                    weLinkTodo.setTodoType(todoType.getNumber());
                    weLinkTodo.setTaskId(todoState.getString("id"));
                    weLinkTodo.setUserId(todoState.getString(OPENID));
                    weLinkTodo.setApplicantUserId(todoState.getString(USERID));
                    if (StringUtils.isEmpty((CharSequence)todoState.getString(APPID)) && StringUtils.isEmpty((CharSequence)todoState.getString(APPSECRET))) {
                        weLinkTodo.setTaskDesc("");
                    } else {
                        configData.put(WLCORPID, (Object)todoState.getString(CORPID));
                        configData.put(WLAPPID, (Object)todoState.getString(APPID));
                        configData.put(WLAPPSECRET, (Object)todoState.getString(APPSECRET));
                        configData.put(WLAPPNAME, (Object)todoState.getString(APPNAME));
                        weLinkTodo.setTaskDesc(configData.toJSONString());
                        configData.clear();
                    }
                    weLinkTodoList.add(weLinkTodo);
                }
            }
        }
        return weLinkTodoList;
    }

    private static List<WeLinkTodoInfo> wrapWeLinkTodo(MessageContext ctx, ToDoInfo todoInfo, List<Long> userIds, List<DynamicObject> canRetryTodoStateList, WeLinkTodoType todoType) {
        ArrayList<WeLinkTodoInfo> weLinkTodoList = new ArrayList<WeLinkTodoInfo>();
        List<MessageUser> messageUserList = DingdingCommonUtil.getOpenIds(userIds, 4);
        ILocaleString userName = WfUtils.findUserName(ctx.getStartUserId());
        String startUserName = null;
        if (userName != null) {
            startUserName = userName.getLocaleValue();
        }
        if (messageUserList != null && messageUserList.size() != 0) {
            for (int i = 0; i < messageUserList.size(); ++i) {
                MessageUser userIm = messageUserList.get(i);
                weLinkTodoList.add(WeLinkCommonUtil.buildWeLinkeTodo(ctx, todoInfo, todoType, userIm.getUserId(), userIm.getOpenId(), startUserName));
            }
        }
        if (canRetryTodoStateList != null && canRetryTodoStateList.size() != 0) {
            for (DynamicObject canRetryTodoState : canRetryTodoStateList) {
                WeLinkTodoInfo weLinkTodo = WeLinkCommonUtil.buildWeLinkeTodo(ctx, todoInfo, todoType, canRetryTodoState.getLong(USERID), canRetryTodoState.getString(OPENID), startUserName);
                weLinkTodo.setTaskId(canRetryTodoState.getString("id"));
                weLinkTodoList.add(weLinkTodo);
            }
        }
        return weLinkTodoList;
    }

    private static WeLinkTodoInfo buildWeLinkeTodo(MessageContext ctx, ToDoInfo todoInfo, WeLinkTodoType todoType, Long userId, String openId, String startUserName) {
        WeLinkTodoInfo weLinkTodo = new WeLinkTodoInfo();
        weLinkTodo.setTodoType(todoType.getNumber());
        weLinkTodo.setTaskId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        weLinkTodo.setTitle(todoInfo.getTitle());
        weLinkTodo.setTaskDesc(todoInfo.getContent());
        weLinkTodo.setTaskUrl(todoInfo.getUrl());
        weLinkTodo.setAppName(ctx.getEntityName());
        weLinkTodo.setApplicantUserId(String.valueOf(userId));
        weLinkTodo.setUserId(openId);
        if (startUserName != null) {
            if (Lang.en_US == RequestContext.get().getLang()) {
                weLinkTodo.setApplicantUserNameCn("");
                weLinkTodo.setApplicantUserNameEn(startUserName);
            } else {
                weLinkTodo.setApplicantUserNameCn(startUserName);
                weLinkTodo.setApplicantUserNameEn("");
            }
        }
        return weLinkTodo;
    }

    public static void updateWelinkTodoState(Long processInstanceId, ToDoInfo todoInfo, List<WeLinkTodoInfo> successWeLinkTodoList, List<WeLinkTodoInfo> errorWeLinkTodoList, WeLinkTodoType todoType) {
        if (successWeLinkTodoList.size() == 0 && errorWeLinkTodoList.size() == 0) {
            return;
        }
        if (todoType == WeLinkTodoType.CREATE) {
            QFilter f5;
            QFilter f4;
            QFilter f3;
            QFilter f2;
            String selectFields = SELECTFIELDS;
            QFilter f1 = new QFilter(TASKID, "=", (Object)todoInfo.getTaskId());
            DynamicObject[] todoStates = BusinessDataServiceHelper.load((String)MSGWELINKTODO, (String)selectFields, (QFilter[])new QFilter[]{f1, f2 = new QFilter(PROCINSTID, "=", (Object)processInstanceId), f3 = new QFilter(STATE, "=", (Object)todoType.getNumber()), f4 = new QFilter(RESULT, "=", (Object)FALSE), f5 = new QFilter(RETRIES, "<=", (Object)5)});
            if (todoStates != null && todoStates.length != 0) {
                for (DynamicObject todoState : todoStates) {
                    todoState.set(STATE, (Object)todoType.getNumber());
                    if (WeLinkCommonUtil.isExist(todoState.getString(USERID), successWeLinkTodoList)) {
                        todoState.set(RESULT, (Object)Boolean.TRUE);
                        todoState.set(MODIFYDATE, (Object)new Date());
                        continue;
                    }
                    if (!WeLinkCommonUtil.isExist(todoState.getString(USERID), errorWeLinkTodoList)) continue;
                    todoState.set(RESULT, (Object)Boolean.FALSE);
                    todoState.set(RETRIES, (Object)(todoState.getInt(RETRIES) + 1));
                    todoState.set(MODIFYDATE, (Object)new Date());
                }
                SaveServiceHelper.save((DynamicObject[])todoStates);
                if (successWeLinkTodoList.size() != 0 || errorWeLinkTodoList.size() != 0) {
                    WeLinkCommonUtil.saveWeLinkTodoState(processInstanceId, todoInfo.getTaskId(), successWeLinkTodoList, errorWeLinkTodoList, todoType);
                }
            } else {
                WeLinkCommonUtil.saveWeLinkTodoState(processInstanceId, todoInfo.getTaskId(), successWeLinkTodoList, errorWeLinkTodoList, todoType);
            }
            logger.debug("save welink create todo state is ok");
        } else if (todoType == WeLinkTodoType.DEAL) {
            QFilter f4;
            QFilter f3;
            QFilter f2;
            QFilter f1 = new QFilter(TASKID, "=", (Object)todoInfo.getTaskId());
            DynamicObject[] weLinkTodoStates = BusinessDataServiceHelper.load((String)MSGWELINKTODO, (String)SELECTFIELDS, (QFilter[])new QFilter[]{f1, f2 = new QFilter(USERID, "in", (Object)todoInfo.getUserIds()), (f3 = new QFilter(STATE, "=", (Object)WeLinkTodoType.CREATE.getNumber()).and(RESULT, "=", (Object)"true")).or(f4 = new QFilter(STATE, "=", (Object)todoType.getNumber()).and(RETRIES, "<=", (Object)5))});
            if (weLinkTodoStates != null && weLinkTodoStates.length != 0) {
                for (DynamicObject todoState : weLinkTodoStates) {
                    todoState.set(STATE, (Object)todoType.getNumber());
                    if (WeLinkCommonUtil.isExist(todoState.getString(USERID), successWeLinkTodoList)) {
                        todoState.set(RESULT, (Object)Boolean.TRUE);
                        todoState.set(MODIFYDATE, (Object)new Date());
                        continue;
                    }
                    if (!WeLinkCommonUtil.isExist(todoState.getString(USERID), errorWeLinkTodoList)) continue;
                    todoState.set(RESULT, (Object)Boolean.FALSE);
                    todoState.set(RETRIES, (Object)(todoState.getInt(RETRIES) + 1));
                    todoState.set(MODIFYDATE, (Object)new Date());
                }
                SaveServiceHelper.save((DynamicObject[])weLinkTodoStates);
                logger.debug("deal welink todo state is ok");
            }
        } else if (todoType == WeLinkTodoType.DELETE) {
            QFilter f1 = new QFilter(TASKID, "=", (Object)todoInfo.getTaskId());
            QFilter f2 = new QFilter(USERID, "in", (Object)todoInfo.getUserIds());
            QFilter f3 = new QFilter(STATE, "=", (Object)WeLinkTodoType.CREATE.getNumber()).and(RESULT, "=", (Object)"true");
            QFilter f5 = new QFilter(STATE, "=", (Object)WeLinkTodoType.DEAL.getNumber());
            QFilter f4 = new QFilter(STATE, "=", (Object)todoType.getNumber()).and(RETRIES, "<=", (Object)5);
            DynamicObject[] weLinkTodoStates = BusinessDataServiceHelper.load((String)MSGWELINKTODO, (String)SELECTFIELDS, (QFilter[])new QFilter[]{f1, f2, f3.or(f5).or(f4)});
            if (weLinkTodoStates != null && weLinkTodoStates.length != 0) {
                ArrayList<Long> deleteSuccessIds = new ArrayList<Long>();
                StringBuilder deleteUserIds = new StringBuilder();
                ArrayList<DynamicObject> failDeleteTodo = new ArrayList<DynamicObject>();
                for (DynamicObject todoState : weLinkTodoStates) {
                    if (WeLinkCommonUtil.isExist(todoState.getString(USERID), successWeLinkTodoList)) {
                        deleteSuccessIds.add(todoState.getLong("id"));
                        deleteUserIds.append(todoState.getString(USERID));
                        continue;
                    }
                    if (!WeLinkCommonUtil.isExist(todoState.getString(USERID), errorWeLinkTodoList)) continue;
                    todoState.set(RESULT, (Object)Boolean.FALSE);
                    todoState.set(STATE, (Object)todoType.getNumber());
                    todoState.set(RETRIES, (Object)(todoState.getInt(RETRIES) + 1));
                    todoState.set(MODIFYDATE, (Object)new Date());
                    failDeleteTodo.add(todoState);
                }
                if (deleteSuccessIds.size() != 0) {
                    DeleteServiceHelper.delete((String)MSGWELINKTODO, (QFilter[])new QFilter[]{new QFilter("id", "in", deleteSuccessIds)});
                    logger.debug("delete welinke todo state is ok");
                }
                if (failDeleteTodo.size() != 0) {
                    SaveServiceHelper.save((DynamicObject[])failDeleteTodo.toArray(new DynamicObject[0]));
                    logger.debug("delete is fail and update todoState");
                }
            }
        }
    }

    private static void saveWeLinkTodoState(Long processInstanceId, Long taskId, List<WeLinkTodoInfo> successWeLinkTodoList, List<WeLinkTodoInfo> errorWeLinkTodoList, WeLinkTodoType todoType) {
        int size = successWeLinkTodoList.size() + errorWeLinkTodoList.size();
        ArrayList<DynamicObject> dynamicList = new ArrayList<DynamicObject>(size);
        for (int i = 0; i < successWeLinkTodoList.size(); ++i) {
            WeLinkTodoInfo successTodo = successWeLinkTodoList.get(i);
            dynamicList.add(WeLinkCommonUtil.buildWeLinkTodoState(processInstanceId, taskId, todoType, successTodo, true));
        }
        for (int j = 0; j < errorWeLinkTodoList.size(); ++j) {
            WeLinkTodoInfo errorTodo = errorWeLinkTodoList.get(j);
            dynamicList.add(WeLinkCommonUtil.buildWeLinkTodoState(processInstanceId, taskId, todoType, errorTodo, false));
        }
        SaveServiceHelper.save((DynamicObject[])dynamicList.toArray(new DynamicObject[0]));
    }

    private static boolean isExist(String userId, List<WeLinkTodoInfo> weLinkTodoList) {
        boolean isExist = false;
        for (int i = 0; i < weLinkTodoList.size(); ++i) {
            WeLinkTodoInfo weLinkTodoInfo = weLinkTodoList.get(i);
            if (!weLinkTodoInfo.getApplicantUserId().equalsIgnoreCase(userId)) continue;
            isExist = true;
            weLinkTodoList.remove(weLinkTodoInfo);
            break;
        }
        return isExist;
    }

    private static DynamicObject buildWeLinkTodoState(Long pId, Long tId, WeLinkTodoType todoType, WeLinkTodoInfo todo, boolean isSuccess) {
        MsgChannelInfo welinkCacheInfo = MsgServiceCache.getMsgChannel((String)"welink");
        JSONObject config = new JSONObject();
        if (welinkCacheInfo == null) {
            logger.debug("when save welink todostate, the welinkcache is empty");
        } else {
            String configData = welinkCacheInfo.getMobileappconfig();
            config = JSONObject.parseObject((String)configData);
        }
        DynamicObject weLinkTodoState = ORM.create().newDynamicObject(MSGWELINKTODO);
        weLinkTodoState.set("id", (Object)todo.getTaskId());
        weLinkTodoState.set(TASKID, (Object)tId);
        weLinkTodoState.set(USERID, (Object)todo.getApplicantUserId());
        weLinkTodoState.set(OPENID, (Object)todo.getUserId());
        weLinkTodoState.set(PROCINSTID, (Object)pId);
        weLinkTodoState.set(CORPID, (Object)config.getString(WLCORPID));
        weLinkTodoState.set(APPID, (Object)config.getString(WLAPPID));
        weLinkTodoState.set(APPSECRET, (Object)config.getString(WLAPPSECRET));
        weLinkTodoState.set(APPNAME, (Object)config.getString(WLAPPNAME));
        weLinkTodoState.set(STATE, (Object)todoType.getNumber());
        weLinkTodoState.set(RESULT, (Object)isSuccess);
        weLinkTodoState.set(RETRIES, (Object)0);
        weLinkTodoState.set("createdate", (Object)new Date());
        weLinkTodoState.set(MODIFYDATE, (Object)new Date());
        return weLinkTodoState;
    }

    public static void deleteWeLinkTodoStateByProcessInstanceId(Long processInstanceId) {
        WeLinkCommonUtil.deleteWelinkTodoWhenProcessEnd(processInstanceId);
        QFilter f1 = new QFilter(PROCINSTID, "=", (Object)processInstanceId);
        QFilter f2 = new QFilter(RESULT, "=", (Object)"true");
        QFilter f3 = new QFilter(STATE, "=", (Object)WeLinkTodoType.CREATE.getNumber()).and(RESULT, "=", (Object)FALSE);
        DeleteServiceHelper.delete((String)MSGWELINKTODO, (QFilter[])new QFilter[]{f1, f2.or(f3)});
    }

    private static void deleteWelinkTodoWhenProcessEnd(Long processInstanceId) {
        QFilter f1 = new QFilter(PROCINSTID, "=", (Object)processInstanceId);
        QFilter f2 = new QFilter(RESULT, "=", (Object)"true").and(STATE, "=", (Object)WeLinkTodoType.CREATE.getNumber());
        DynamicObject[] weLinkTodoStates = BusinessDataServiceHelper.load((String)MSGWELINKTODO, (String)"id, taskid, appid, appsecret, state, result, retries, modifydate", (QFilter[])new QFilter[]{f1, f2});
        if (weLinkTodoStates != null && weLinkTodoStates.length != 0) {
            ArrayList<DynamicObject> failTodoStates = new ArrayList<DynamicObject>(weLinkTodoStates.length);
            ArrayList<String> kdTaskIds = new ArrayList<String>();
            try {
                for (DynamicObject todoState : weLinkTodoStates) {
                    JSONObject resJson;
                    WeLinkTodoInfo weLinkTodo = new WeLinkTodoInfo();
                    weLinkTodo.setTaskId(todoState.getString("id"));
                    String accessToken = AccessTokenUtils.getAccessToken((String)"welink", (String)todoState.getString(APPID), (String)todoState.getString(APPSECRET), null);
                    if (StringUtils.isNotBlank((CharSequence)accessToken) && (resJson = WeLinkHandleUtil.transmitOneHttp(accessToken, weLinkTodo, null, null, WeLinkTodoType.DELETE.getNumber())) != null && resJson.getIntValue("code") == 0) {
                        kdTaskIds.add(todoState.getString(TASKID));
                        continue;
                    }
                    todoState.set(RESULT, (Object)Boolean.FALSE);
                    todoState.set(STATE, (Object)WeLinkTodoType.DELETE.getNumber());
                    todoState.set(RETRIES, (Object)(todoState.getInt(RETRIES) + 1));
                    todoState.set(MODIFYDATE, (Object)new Date());
                    failTodoStates.add(todoState);
                }
                logger.debug("when process end, have delete welink todo list:" + ((Object)kdTaskIds).toString());
            }
            catch (Exception e) {
                logger.debug("when process end, have exception is:" + e.getMessage());
            }
            if (failTodoStates.size() != 0) {
                SaveServiceHelper.save((DynamicObject[])failTodoStates.toArray(new DynamicObject[0]));
            }
        }
    }
}

