/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.util.welink;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.AccessTokenUtils;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.util.HttpClientUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.model.welink.WeLinkMessageInfo;
import kd.bos.workflow.engine.msg.model.welink.WeLinkTodoInfo;
import kd.bos.workflow.engine.msg.model.welink.WeLinkTodoType;
import kd.bos.workflow.engine.msg.util.MessageUtils;
import kd.bos.workflow.exception.WFException;

public class WeLinkHandleUtil {
    private static Log logger = LogFactory.getLog(WeLinkHandleUtil.class);
    public static final String WELINK = "welink";
    private static final String SUCCESS = "success";
    private static final String MSGTITLE = "msgTitle";
    private static final String LOGDESCRIPTION = "welink-body-";

    public static Map<String, Object> sendTodo(WeLinkTodoInfo todoInfo, String configData) {
        logger.debug("send welinktodo info is:" + todoInfo);
        if (WeLinkTodoType.CREATE.getNumber().equalsIgnoreCase(todoInfo.getTodoType()) || StringUtils.isEmpty((CharSequence)configData)) {
            MsgChannelInfo welinkCacheInfo = MsgServiceCache.getMsgChannel((String)WELINK);
            if (welinkCacheInfo == null) {
                return MessageUtils.wrapResult(ResManager.loadKDString((String)"\u672a\u914d\u7f6eWeLink\u53c2\u6570\uff0c\u8bf7\u5728\u201c\u516c\u5171\u8bbe\u7f6e>\u6d88\u606f\u8bbe\u7f6e>\u6d88\u606f\u6e20\u9053\u201d\u4e2d\u68c0\u67e5\u3002", (String)"WeLinkHandler_0", (String)"bos-wf-engine", (Object[])new Object[0]), null);
            }
            configData = welinkCacheInfo.getMobileappconfig();
        }
        JSONObject cfgInfo = JSONObject.parseObject((String)configData);
        Map<Object, Object> rs = new HashMap();
        try {
            JSONObject resJson;
            String accessToken = AccessTokenUtils.getAccessToken((String)WELINK, (String)cfgInfo.getString("wlappid"), (String)cfgInfo.getString("wlappsecret"), null);
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                return MessageUtils.wrapResult("accessToken is null, send todo is terminated", null);
            }
            if (!StringUtils.isBlank((CharSequence)cfgInfo.getString("wlappname"))) {
                todoInfo.setAppName(cfgInfo.getString("wlappname"));
            }
            if ((resJson = WeLinkHandleUtil.transmitOneHttp(accessToken, todoInfo, null, null, todoInfo.getTodoType())).getIntValue("code") != 0) {
                return MessageUtils.wrapResult(String.format(ResManager.loadKDString((String)"WeLink\u5f85\u529e\u63a8\u9001\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WeLinkHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]), resJson.getString("message")), null);
            }
            logger.debug("sendMessage--\u63a8\u9001welnk\u5f85\u529esuccess");
            rs = MessageUtils.wrapResult(SUCCESS, configData == null ? configData : null);
        }
        catch (Exception e) {
            rs = MessageUtils.wrapResult(e.getMessage(), null);
        }
        return rs;
    }

    public static Map<String, Object> sendMessage(WeLinkMessageInfo messageInfo) {
        logger.info("send welnk msg and messageinfo is" + messageInfo);
        MsgChannelInfo welinkCacheInfo = MsgServiceCache.getMsgChannel((String)WELINK);
        if (welinkCacheInfo == null) {
            return MessageUtils.wrapResult(ResManager.loadKDString((String)"\u672a\u914d\u7f6eWeLink\u53c2\u6570\uff0c\u8bf7\u5728\u201c\u516c\u5171\u8bbe\u7f6e>\u6d88\u606f\u8bbe\u7f6e>\u6d88\u606f\u6e20\u9053\u201d\u4e2d\u68c0\u67e5\u3002", (String)"WeLinkHandler_0", (String)"bos-wf-engine", (Object[])new Object[0]), null);
        }
        String configInfo = welinkCacheInfo.getMobileappconfig();
        JSONObject cfgInfo = JSONObject.parseObject((String)configInfo);
        Map<Object, Object> rs = new HashMap();
        try {
            String accessToken = AccessTokenUtils.getAccessToken((String)WELINK, (String)cfgInfo.getString("wlappid"), (String)cfgInfo.getString("wlappsecret"), null);
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                return MessageUtils.wrapResult("accessToken is null, send msg is terminated", null);
            }
            JSONObject resJson = WeLinkHandleUtil.transmitOneHttp(accessToken, null, messageInfo, cfgInfo, "sendmsg");
            if (resJson.getIntValue("code") != 0) {
                return MessageUtils.wrapResult(String.format(ResManager.loadKDString((String)"WeLink\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WeLinkHandler_2", (String)"bos-wf-engine", (Object[])new Object[0]), resJson.getString("message")), null);
            }
            logger.info("sendMessage--\u63a8\u9001welnk\u6d88\u606fsuccess");
            rs = MessageUtils.wrapResult(SUCCESS, null);
        }
        catch (Exception e) {
            rs = MessageUtils.wrapResult(WfUtils.getExceptionStacktrace(e), null);
        }
        return rs;
    }

    private static String wrapUrl(String url) {
        logger.info("url orginal---" + url);
        if (!StringUtils.isEmpty((CharSequence)url)) {
            String[] urlParts;
            StringBuilder sb = new StringBuilder();
            for (String p : urlParts = url.split("&")) {
                if (p.contains("appId") || p.contains("pCaption") || p.contains("mCaption")) continue;
                sb.append(p).append('&');
            }
            sb.append("apptype=wl&device=mob");
            logger.info(sb.toString());
            return sb.toString();
        }
        return url;
    }

    protected static JSONObject transmitOneHttp(String accessToken, WeLinkTodoInfo todoInfo, WeLinkMessageInfo messageInfo, JSONObject cfgCacheInfo, String type) {
        String result = null;
        String url = null;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("x-wlk-Authorization", accessToken);
        headerMap.put("Content-Type", "application/json");
        try {
            if (WeLinkTodoType.CREATE.getNumber().equalsIgnoreCase(type)) {
                url = "https://open.welink.huaweicloud.com/api/todo/v1/addtask";
                JSONObject bodyJson = new JSONObject();
                bodyJson.put("taskId", (Object)todoInfo.getTaskId());
                bodyJson.put("taskTitle", (Object)todoInfo.getTitle());
                bodyJson.put("taskDesc", (Object)(todoInfo.getTaskDesc() != null && todoInfo.getTaskDesc().length() > 300 ? todoInfo.getTaskDesc().substring(0, 300) : todoInfo.getTaskDesc()));
                bodyJson.put("detailsUrl", (Object)WeLinkHandleUtil.wrapUrl(todoInfo.getTaskUrl()));
                bodyJson.put("userId", (Object)todoInfo.getUserId());
                bodyJson.put("appName", (Object)todoInfo.getAppName());
                bodyJson.put("applicantUserId", (Object)todoInfo.getApplicantUserId());
                bodyJson.put("applicantUserNameEn", (Object)todoInfo.getApplicantUserNameEn());
                bodyJson.put("applicantUserNameCn", (Object)todoInfo.getApplicantUserNameCn());
                logger.info(LOGDESCRIPTION + bodyJson.toJSONString());
                result = HttpClientUtils.postjson((String)url, headerMap, (String)bodyJson.toJSONString());
            } else if (WeLinkTodoType.DELETE.getNumber().equalsIgnoreCase(type) || WeLinkTodoType.DEAL.getNumber().equalsIgnoreCase(type)) {
                url = "https://open.welink.huaweicloud.com/api/todo/v1/deltask";
                HashMap<String, String> body = new HashMap<String, String>();
                body.put("taskId", todoInfo.getTaskId());
                logger.info(LOGDESCRIPTION + body);
                result = HttpClientUtils.get((String)url, headerMap, body);
            } else if ("sendmsg".equalsIgnoreCase(type)) {
                url = "https://open.welink.huaweicloud.com/api/messages/v2/send";
                JSONObject bodyJson = new JSONObject();
                bodyJson.put("msgRange", (Object)messageInfo.getMsgRange());
                bodyJson.put("publicAccID", (Object)cfgCacheInfo.getString("wlpubaccid"));
                bodyJson.put("toUserList", messageInfo.getToUserIds());
                bodyJson.put("msgOwner", (Object)messageInfo.getOwnerName());
                if (StringUtils.isBlank((CharSequence)messageInfo.getTitle())) {
                    bodyJson.put(MSGTITLE, (Object)messageInfo.getContent());
                } else if (messageInfo.getTitle().equalsIgnoreCase(messageInfo.getContent())) {
                    bodyJson.put(MSGTITLE, (Object)messageInfo.getTitle());
                } else {
                    bodyJson.put(MSGTITLE, (Object)messageInfo.getTitle());
                    bodyJson.put("msgContent", (Object)messageInfo.getContent());
                }
                if (!StringUtils.isEmpty((CharSequence)messageInfo.getUrl())) {
                    bodyJson.put("urlType", (Object)messageInfo.getUrlType());
                    bodyJson.put("urlPath", (Object)WeLinkHandleUtil.wrapUrl(messageInfo.getUrl()));
                }
                logger.info(LOGDESCRIPTION + bodyJson.toJSONString());
                result = HttpClientUtils.postjson((String)url, headerMap, (String)bodyJson.toJSONString());
            }
        }
        catch (Exception e) {
            logger.info("transmitOneHttp fail : " + e.getMessage());
            throw new WFException(e.getMessage(), e);
        }
        return JSONObject.parseObject(result);
    }
}

