/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.util.yzj;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.model.yzj.YzjToDoProperty;
import kd.bos.workflow.engine.msg.model.yzj.YzjToDoState;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaToDoUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.exception.WFMessageServiceException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public final class YunzhijiaCommonUtil {
    private static Log logger = LogFactory.getLog(YunzhijiaCommonUtil.class);
    public static final String FLOWASSIST = "flowassist";
    public static final String YUNZHIJIA = "yunzhijia";
    public static final String YUNZHIJIAECO = "yunzhijiaeco";
    public static final String YUNZHIJIANEW = "yunzhijiaup";
    public static final String OPENDEVICEPROPCANCHANGE = "msg.yzj.OpenDevicePropCanChange";
    public static final String YZJAPPIDCHANGEINFO = "msg.channel.yzjappidchange";
    public static final String CONFCENTER = "wf_confcenter";
    public static final String YUNZHIJIANEWTPL = "msg_yzjtpl";
    private static final String ERRORINFO = "errorInfo";
    private static final String UNDEALCOUNT = "undelCount";
    private static final String APPID = "appId";
    private static final String CHARSETTYPE = "application/json; charset=utf-8";
    private static final String CONTENTTYPE = "Content-Type";
    private static final String APPLICATIONJSON = "application/json";
    private static final String ACCEPT = "Accept";
    private static final String SUCCESS = "success";
    private static final String VALUE = "value";
    private static final String RESULTISNULL = "result is null!";
    private static final String DOPOSTRESULTISNULL = "doPostWithAuth result is null!";
    private static final String YUNZHIJIACOMMONUTIL7 = "YunzhijiaCommonUtil_7";
    private static final String APPIDPART = "&appId=";
    private static final String FLOWID = "flowId";
    private static final String BODYDATAIS = "body data is :";
    private static final String TODOTITLE = "toDoTitle";
    private static final String ISTEMPLATE = "isTemplate";
    private static final String ENTITYNAME = "entityname";
    private static final String SUBJECT = "subject";
    private static final String STR_SENDMESSAGETONOTIFYCENTER = "sendmessagetonotifycenter";
    public static final String YUNZHIJIAUPCREATURL = "/gateway/flowcenter/native/todo/send";
    public static final String YUNZHIJIAUPDEALURL = "/gateway/flowcenter/native/todo/done";
    public static final String YUNZHIJIAUPDELATEURL = "/gateway/flowcenter/native/todo/delete";
    public static final String YUNZHIJIAUPINITURL = "/gateway/flowcenter/native/init";
    public static final String YUNZHIJIAUPDELETEPROCESSURL = "/gateway/flowcenter/native/instance/delete";
    public static final String YUNZHIJIAUPFINISHURL = "/gateway/flowcenter/native/instance/finish";
    public static final String YUNZHIJIAUPRESETURL = "/gateway/flowcenter/native/instance/reset";
    public static final String YUNZHIJIAUPCOPYSENDURL = "/gateway/flowcenter/native/carboncopy/send";
    public static final String YUNZHIJIAUPCOPYSENDFINISHURL = "/gateway/flowcenter/native/carboncopy/read";
    public static final String AUTHURL = "/gateway/oauth2/token/getAccessToken";
    public static final String SENDMSGTONOTIFYCENTERURL = "/gateway/newtodo/open/generatetodo.json";
    public static final String DEALMESSAGE = "/gateway/newtodo/open/action.json";

    public static void createUserToDo(MessageContext ctx, ToDoInfo info, YzjToDoState todoState, String type) {
        List<YzjToDoProperty> yzjToDoProperties = new ArrayList<YzjToDoProperty>();
        boolean success = true;
        try {
            YunzhijiaCommonUtil.embellishTodoUrl(info, null, type);
            yzjToDoProperties = YunzhijiaToDoUtil.transformToDo(ctx, info, todoState, type);
            ArrayList<String> userOpenIdList = new ArrayList<String>();
            ArrayList<String> userNameList = new ArrayList<String>();
            List<Long> userIds = YunzhijiaToDoUtil.cloneUserList(info.getUserIds());
            if (yzjToDoProperties != null && yzjToDoProperties.size() > 0) {
                JSONObject yzjBodyData;
                for (YzjToDoProperty todoProperty : yzjToDoProperties) {
                    userOpenIdList.add(todoProperty.getOpenId());
                    userNameList.add(todoProperty.getUserName());
                    userIds.remove(Long.valueOf(todoProperty.getUserid()));
                }
                YzjToDoProperty todoProperty = yzjToDoProperties.get(0);
                JSONObject result = YunzhijiaCommonUtil.sendHttpRequest(todoProperty, yzjBodyData = YunzhijiaToDoUtil.buildYzjBodyData(info, todoProperty, userOpenIdList, todoState, type), todoState, type);
                if (YunzhijiaCommonUtil.fail(result)) {
                    throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{result != null ? result.toJSONString() : RESULTISNULL});
                }
                if (userIds.size() != 0) {
                    logger.info(String.format("\u7528\u6237[%s]\u6570\u636e\u5e93\u4e2d\u7f3a\u5c11openid", userIds.toString()));
                }
            }
            logger.debug("\u4e91\u4e4b\u5bb6createToDo is ok , url is:" + info.getUrl());
            YunzhijiaCommonUtil.addCreateTODOLog(ctx.getTaskId(), userNameList);
        }
        catch (Exception e) {
            success = false;
            throw new WFMessageServiceException(e, WFErrorCode.yzjSendTodoError(), e.getMessage());
        }
        finally {
            if (success) {
                YunzhijiaToDoUtil.updateYzjTodoState(ctx.getProcessInstanceId(), info, yzjToDoProperties, null, todoState, type);
            } else {
                YunzhijiaToDoUtil.updateYzjTodoState(ctx.getProcessInstanceId(), info, null, yzjToDoProperties, todoState, type);
            }
        }
    }

    public static void updateUserToDo(MessageContext ctx, ToDoInfo info, YzjToDoState todoState, String type) {
        List<Object> yzjToDoProperties = new ArrayList();
        boolean success = true;
        try {
            yzjToDoProperties = YunzhijiaToDoUtil.transformToDo(ctx, info, todoState, type);
            List<Long> userIds = YunzhijiaToDoUtil.cloneUserList(info.getUserIds());
            if (yzjToDoProperties.size() > 0) {
                for (YzjToDoProperty yzjToDoProperty : yzjToDoProperties) {
                    JSONObject result;
                    JSONObject yzjBodyData;
                    if (YUNZHIJIANEW.equals(yzjToDoProperty.getType())) {
                        yzjBodyData = YunzhijiaToDoUtil.buildYzjNewBodyData(info, yzjToDoProperty, null, todoState);
                        result = YunzhijiaCommonUtil.sendHttpRequest(yzjBodyData, todoState.getNumber());
                    } else {
                        yzjBodyData = YunzhijiaToDoUtil.buildYzjBodyData(info, yzjToDoProperty, null, todoState, yzjToDoProperty.getType());
                        result = YunzhijiaCommonUtil.sendHttpRequest(yzjToDoProperty, yzjBodyData, todoState, yzjToDoProperty.getType());
                    }
                    if (YunzhijiaCommonUtil.failNew(result, todoState)) {
                        throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{result == null ? DOPOSTRESULTISNULL : result.toJSONString()});
                    }
                    userIds.remove(Long.valueOf(yzjToDoProperty.getUserid()));
                    YunzhijiaCommonUtil.updateToDoStateOfSwitchApp(info, ctx.getCreateDate(), yzjToDoProperty, todoState, type);
                }
                logger.info(String.format("[%s-%s]\u66f4\u65b0\u4e91\u4e4b\u5bb6\u5f85\u529e\u72b6\u6001\u6210\u529f", info.getTaskId(), RequestContext.get().getTraceId()));
                if (userIds.size() != 0) {
                    if (YzjToDoState.DEAL == todoState) {
                        throw new WFMessageServiceException(new KDBizException(ResManager.loadKDString((String)"\u5f85\u529e\u53d8\u5df2\u529e\u5931\u8d25\uff0c\u7528\u6237\u6ca1\u6709openID\u3002", (String)YUNZHIJIACOMMONUTIL7, (String)"bos-wf-engine", (Object[])new Object[0])), WFErrorCode.yzjCheckUserOpenIdError(), String.format(ResManager.loadKDString((String)"\u5f85\u529e\u53d8\u5df2\u529e\u5931\u8d25\uff0c\u7528\u6237%s\u7f3a\u5c11openId\u3002", (String)"YunzhijiaCommonUtil_8", (String)"bos-wf-engine", (Object[])new Object[0]), userIds.toString()));
                    }
                    throw new WFMessageServiceException(new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u5f85\u529e\u5931\u8d25\uff0c\u7528\u6237\u6ca1\u6709openID\u3002", (String)"YunzhijiaCommonUtil_10", (String)"bos-wf-engine", (Object[])new Object[0])), WFErrorCode.yzjCheckUserOpenIdError(), String.format(ResManager.loadKDString((String)"\u7528\u6237%s\u7f3a\u5c11openID\uff0c\u5220\u9664\u5f85\u529e\u5931\u8d25\u3002", (String)"YunzhijiaCommonUtil_11", (String)"bos-wf-engine", (Object[])new Object[0]), userIds.toString()));
                }
            }
        }
        catch (Exception e) {
            success = false;
            throw new WFMessageServiceException(e, WFErrorCode.yzjdealTodoError(), e.getMessage());
        }
        finally {
            if (success) {
                YunzhijiaToDoUtil.updateYzjTodoState(ctx.getProcessInstanceId(), info, yzjToDoProperties, null, todoState, type);
            } else {
                YunzhijiaToDoUtil.updateYzjTodoState(ctx.getProcessInstanceId(), info, null, yzjToDoProperties, todoState, type);
            }
        }
    }

    public static void checkUserToDo(MessageContext ctx, ToDoInfo info, YzjToDoState todoState, String type) {
        List<Object> yzjToDoProperties = new ArrayList();
        boolean success = true;
        try {
            yzjToDoProperties = YunzhijiaToDoUtil.transformToDo(ctx, info, todoState, type);
            List<Long> userIds = YunzhijiaToDoUtil.cloneUserList(info.getUserIds());
            for (YzjToDoProperty yzjToDoProperty : yzjToDoProperties) {
                JSONObject bodyData = YunzhijiaToDoUtil.buildYzjBodyData(info, yzjToDoProperty, null, todoState, type);
                JSONObject result = YunzhijiaCommonUtil.sendHttpRequest(yzjToDoProperty, bodyData, todoState, type);
                JSONObject checkResult = YunzhijiaCommonUtil.checkToDoResult(result, Long.valueOf(yzjToDoProperty.getTaskId()));
                userIds.remove(Long.valueOf(yzjToDoProperty.getUserid()));
                if (!StringUtils.isNotBlank((CharSequence)checkResult.getString(ERRORINFO))) continue;
                if (StringUtils.isNotBlank((CharSequence)checkResult.getString(UNDEALCOUNT)) && checkResult.getInteger(UNDEALCOUNT) > 0) {
                    JSONObject dealData = YunzhijiaToDoUtil.buildYzjBodyData(info, yzjToDoProperty, null, YzjToDoState.DEAL, type);
                    YunzhijiaCommonUtil.sendHttpRequest(yzjToDoProperty, dealData, YzjToDoState.DEAL, type);
                }
                String appId = yzjToDoProperty.getAppId();
                String appSecret = yzjToDoProperty.getAppSecret();
                if (YunzhijiaCommonUtil.checkUserToDoByOldAppInfo(info, ctx.getCreateDate(), yzjToDoProperty, todoState, type)) {
                    yzjToDoProperty.setAppId(appId);
                    yzjToDoProperty.setAppSecret(appSecret);
                    continue;
                }
                throw new WFMessageServiceException(null, WFErrorCode.yzjcheckTodoError(), new Object[]{checkResult.getString(ERRORINFO)});
            }
            if (userIds.size() != 0) {
                logger.info(String.format(ResManager.loadKDString((String)"\u5f85\u529e\u53d8\u5df2\u529e\u5931\u8d25\uff0c\u7528\u6237%s\u7f3a\u5c11openId\u3002", (String)"YunzhijiaCommonUtil_8", (String)"bos-wf-engine", (Object[])new Object[0]), userIds.toString()));
            }
        }
        catch (Exception e) {
            success = false;
            throw new WFMessageServiceException(e, WFErrorCode.yzjcheckTodoError(), e.getMessage());
        }
        finally {
            if (success) {
                YunzhijiaToDoUtil.updateYzjTodoState(ctx.getProcessInstanceId(), info, yzjToDoProperties, null, todoState, type);
            } else {
                YunzhijiaToDoUtil.updateYzjTodoState(ctx.getProcessInstanceId(), info, null, yzjToDoProperties, todoState, type);
            }
        }
    }

    private static boolean checkUserToDoByOldAppInfo(ToDoInfo todoInfo, Date taskDate, YzjToDoProperty yzjToDoProperty, YzjToDoState todoState, String type) {
        boolean checkDealIsOk = false;
        JSONArray appInfos = YunzhijiaCommonUtil.getChannelAppInfo();
        if (appInfos != null) {
            for (int i = 0; i < appInfos.size(); ++i) {
                JSONObject appInfo = appInfos.getJSONObject(i);
                if (!taskDate.before(appInfo.getDate("switchDate"))) continue;
                yzjToDoProperty.setAppId(appInfo.getString(APPID));
                yzjToDoProperty.setAppSecret(appInfo.getString("appSecret"));
                JSONObject bodyData = YunzhijiaToDoUtil.buildYzjBodyData(todoInfo, yzjToDoProperty, null, todoState, type);
                JSONObject result = YunzhijiaCommonUtil.sendHttpRequest(yzjToDoProperty, bodyData, todoState, type);
                logger.info(String.format("\u4f7f\u7528\u65e7\u7684APPID: %s Check\u5f85\u529e\u72b6\u6001] SourceId: %s, UserId: %s", appInfo.getString(APPID), yzjToDoProperty.getTaskId(), yzjToDoProperty.getUserid()));
                JSONObject checkResult = YunzhijiaCommonUtil.checkToDoResult(result, Long.valueOf(yzjToDoProperty.getTaskId()));
                if (!StringUtils.isBlank((CharSequence)checkResult.getString(ERRORINFO))) continue;
                checkDealIsOk = true;
                break;
            }
        }
        return checkDealIsOk;
    }

    private static void updateToDoStateOfSwitchApp(ToDoInfo todoInfo, Date taskDate, YzjToDoProperty yzjToDoProperty, YzjToDoState todoState, String type) {
        try {
            JSONArray appInfos;
            if (taskDate != null && YUNZHIJIA.equalsIgnoreCase(type) && (appInfos = YunzhijiaCommonUtil.getChannelAppInfo()) != null) {
                for (int i = 0; i < appInfos.size(); ++i) {
                    JSONObject appInfo = appInfos.getJSONObject(i);
                    if (!taskDate.before(appInfo.getDate("switchDate"))) continue;
                    yzjToDoProperty.setAppId(appInfo.getString(APPID));
                    yzjToDoProperty.setAppSecret(appInfo.getString("appSecret"));
                    JSONObject bodyData = YunzhijiaToDoUtil.buildYzjBodyData(todoInfo, yzjToDoProperty, null, todoState, type);
                    YunzhijiaCommonUtil.sendHttpRequest(yzjToDoProperty, bodyData, todoState, type);
                }
            }
        }
        catch (Exception e) {
            logger.info(String.format("\u4f7f\u7528\u65e7\u7684\u8f7b\u5e94\u7528\u66f4\u65b0\u5f85\u529e\u629b\u51fa\u5f02\u5e38:[%s]", e.getMessage()));
        }
    }

    private static JSONObject checkToDoResult(JSONObject result, Long TaskId) {
        JSONObject checkResult = new JSONObject();
        JSONObject data = (JSONObject)result.get((Object)"data");
        if (data != null) {
            boolean check = data.getBoolean("check");
            if (check) {
                int dealCount = data.getIntValue("dealCount");
                int undelCount = data.getIntValue(UNDEALCOUNT);
                if (dealCount < 1 || undelCount != 0) {
                    if (dealCount == 0 && undelCount == 0) {
                        checkResult.put(ERRORINFO, null);
                    } else {
                        checkResult.put("dealCount", (Object)dealCount);
                        checkResult.put(UNDEALCOUNT, (Object)undelCount);
                        checkResult.put(ERRORINFO, (Object)String.format(ResManager.loadKDString((String)"\u5f85\u529e\u5904\u7406\u5931\u8d25\u3002\u5904\u7406\u6570\u91cf\uff1a%1$s\uff1b\u672a\u5904\u7406\u6570\u91cf\uff1a%2$s\u3002", (String)"YunzhijiaCommonUtil_3", (String)"bos-wf-engine", (Object[])new Object[0]), dealCount, undelCount));
                    }
                }
            } else {
                checkResult.put(ERRORINFO, (Object)String.format(ResManager.loadKDString((String)"\u72b6\u6001\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"YunzhijiaCommonUtil_4", (String)"bos-wf-engine", (Object[])new Object[0]), data.getString("errormsg")));
            }
        } else {
            checkResult.put(ERRORINFO, (Object)ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u201c\u68c0\u67e5\u5f85\u529e\u63a5\u53e3\u201d\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\u3002", (String)"YunzhijiaCommonUtil_5", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        return checkResult;
    }

    public static JSONObject sendHttpRequest(YzjToDoProperty todoProperty, JSONObject bodyData, YzjToDoState todoState, String type) {
        JSONObject result = new JSONObject();
        String todoUrl = null;
        todoUrl = YzjToDoState.CREATE == todoState ? todoProperty.getCreateUrl() : (YzjToDoState.DEAL == todoState || YzjToDoState.DELETE == todoState ? todoProperty.getHandleUrl() : todoProperty.getCheckUrl());
        String authUrl = todoProperty.getAuthUrl();
        String appId = todoProperty.getAppId();
        String mainEid = todoProperty.getEid();
        String appSecret = todoProperty.getAppSecret();
        String ecologySecret = todoProperty.getEcoSecret();
        String authorization = YunzhijiaCommonUtil.getYzjAccessToken(authUrl, appId, appSecret, mainEid, ecologySecret, type);
        result = YunzhijiaCommonUtil.doPsotWithToDoAuth(todoUrl, authorization, bodyData);
        return result;
    }

    private static JSONObject doPsotWithToDoAuth(String todoUrl, String authorization, JSONObject bodyData) {
        JSONObject result = new JSONObject();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENTTYPE, CHARSETTYPE);
        headers.put(ACCEPT, APPLICATIONJSON);
        String newUrl = todoUrl + "?accessToken=" + authorization;
        result = YunzhijiaCommonUtil.doPost(newUrl, bodyData, headers);
        return result;
    }

    protected static JSONObject doPost(String url, JSONObject data, Map<String, String> headers) {
        JSONObject result = new JSONObject();
        try {
            logger.debug("begin post api");
            String responseEntify = HttpClientUtils.postjson((String)url, headers, (String)data.toJSONString());
            result = (JSONObject)JSONObject.parse((String)responseEntify);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, WFErrorCode.httpRequestException(), new Object[]{e.getMessage()});
        }
        return result;
    }

    private static String getYzjAccessToken(String authUrl, String appId, String appSecret, String mainEid, String ecologySecret, String type) {
        String yzjAccessToken = null;
        if (yzjAccessToken == null || StringUtils.isBlank(yzjAccessToken)) {
            JSONObject tokenJson = null;
            tokenJson = YUNZHIJIA.equalsIgnoreCase(type) ? YunzhijiaCommonUtil.auth(authUrl, appId, null, appSecret, type, null) : YunzhijiaCommonUtil.auth(authUrl, null, mainEid, ecologySecret, type, null);
            if (tokenJson == null || YunzhijiaCommonUtil.fail(tokenJson)) {
                throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{tokenJson != null ? tokenJson.toJSONString() : ""});
            }
            JSONObject data = tokenJson.getJSONObject("data");
            yzjAccessToken = data.getString("accessToken");
        }
        return yzjAccessToken;
    }

    private static String getYzjAccessToken(String authUrl, String appId, String appSecret, String mainEid, String ecologySecret, String type, String eid) {
        if (YUNZHIJIANEW.equals(type)) {
            JSONObject tokenJson = YunzhijiaCommonUtil.auth(authUrl, appId, null, appSecret, type, eid);
            if (tokenJson == null || YunzhijiaCommonUtil.fail(tokenJson)) {
                throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{tokenJson != null ? tokenJson.toJSONString() : ""});
            }
            JSONObject data = tokenJson.getJSONObject("data");
            String yzjAccessToken = data.getString("accessToken");
            return yzjAccessToken;
        }
        return YunzhijiaCommonUtil.getYzjAccessToken(authUrl, appId, appSecret, mainEid, ecologySecret, type);
    }

    private static JSONObject auth(String authUrl, String appId, String mainEid, String secret, String type, String eid) {
        JSONObject result = null;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(CONTENTTYPE, CHARSETTYPE);
            headers.put(ACCEPT, APPLICATIONJSON);
            JSONObject data = new JSONObject();
            if (YUNZHIJIAECO.equalsIgnoreCase(type)) {
                data.put("eid", (Object)(WfUtils.isEmpty(mainEid) ? "" : mainEid));
                data.put("scope", (Object)"resGroupSecret");
            } else if (YUNZHIJIANEW.equalsIgnoreCase(type)) {
                data.put(APPID, (Object)(WfUtils.isEmpty(appId) ? "" : appId));
                data.put("eid", (Object)eid);
                data.put("scope", (Object)"team");
            } else {
                data.put(APPID, (Object)(WfUtils.isEmpty(appId) ? "" : appId));
                data.put("scope", (Object)"app");
            }
            data.put("secret", (Object)secret);
            data.put("timestamp", (Object)System.currentTimeMillis());
            result = YunzhijiaCommonUtil.doPost(authUrl, data, headers);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, WFErrorCode.yzjAuthError(), new Object[]{e.getMessage()});
        }
        return result;
    }

    private static String getWholeKey(String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(RequestContext.get().getAccountId()).append(".msg.");
        return YunzhijiaCommonUtil.strAppend(sb.toString(), ".", args);
    }

    private static String strAppend(String pref, String split, String[] args) {
        StringBuilder sb = new StringBuilder(pref);
        if (args != null && args.length > 0) {
            for (String arg : args) {
                sb.append(arg).append(split);
            }
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static List<Long> getUserIds(List<MessageUser> users) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (MessageUser user : users) {
            if (!WfUtils.isNotEmpty(user.getUserId())) continue;
            userIds.add(user.getUserId());
        }
        return userIds;
    }

    private static void addCreateTODOLog(Long taskId, List<String> usernames) {
        if (usernames == null || usernames.isEmpty()) {
            return;
        }
        StringBuilder names = new StringBuilder(" ");
        for (String name : usernames) {
            names.append(name).append(" ");
        }
    }

    private static boolean fail(JSONObject result) {
        if (result == null) {
            return true;
        }
        return !"true".equals(result.get((Object)SUCCESS)) && !result.getBooleanValue(SUCCESS);
    }

    private static boolean failNew(JSONObject result, YzjToDoState todoState) {
        if (result == null) {
            return true;
        }
        if (todoState == YzjToDoState.DELETE) {
            return !"true".equals(result.get((Object)SUCCESS)) && !result.getBooleanValue(SUCCESS) && !"502".equals(result.getString("errorCode")) && !"1301001".equals(result.getString("errorCode"));
        }
        return !"true".equals(result.get((Object)SUCCESS)) && !result.getBooleanValue(SUCCESS);
    }

    public static void checkTaskId(Long taskId) {
        if (WfUtils.isEmpty(taskId)) {
            throw new KDException(WFErrorCode.illegAlargumentException(), new Object[]{ResManager.loadKDString((String)"\u5f85\u529e\u6279\u6b21\u201c\u4efb\u52a1ID\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002 ", (String)"YunzhijiaCommonUtil_2", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
    }

    public static String decode(String stringToDecode) {
        try {
            return URLDecoder.decode(stringToDecode, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new KDException((Throwable)e, WFErrorCode.encodingException(), new Object[]{e.getMessage()});
        }
    }

    public static String encode(String stringToEncode) {
        try {
            return URLEncoder.encode(stringToEncode, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new KDException((Throwable)e, WFErrorCode.encodingException(), new Object[]{e.getMessage()});
        }
    }

    private static boolean checkTaskDate(Long taskId) {
        boolean isLess30Day = false;
        HistoricTaskInstanceEntity hisTask = (HistoricTaskInstanceEntity)Context.getCommandContext().getHistoricTaskInstanceEntityManager().findById(taskId);
        if (hisTask != null) {
            Date currentDate = new Date();
            Long diffTime = currentDate.getTime() - hisTask.getCreateDate().getTime();
            Long targetTime = 2592000000L;
            if (diffTime < targetTime) {
                isLess30Day = true;
            }
        }
        return isLess30Day;
    }

    public static Map<String, List<String>> getUserOpenIdsGroupByEid(List<Long> userIdList) {
        DynamicObject[] userDo;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (userIdList.isEmpty()) {
            return map;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", userIdList)};
        for (DynamicObject user : userDo = BusinessDataServiceHelper.load((String)"bos_user", (String)"useropenid, eid", (QFilter[])filters)) {
            String openid = user.getString("useropenid");
            String eid = user.getString("eid");
            if (!WfUtils.isNotEmpty(eid)) continue;
            ArrayList<String> temp = (ArrayList<String>)map.get(eid);
            if (temp == null) {
                temp = new ArrayList<String>();
            }
            if (WfUtils.isNotEmpty(openid)) {
                temp.add(openid);
            }
            map.put(eid, temp);
        }
        return map;
    }

    public static Map<String, List<MessageUser>> getMessageUserGroupByEid(List<Long> userIdList) {
        DynamicObject[] userDo;
        HashMap<String, List<MessageUser>> map = new HashMap<String, List<MessageUser>>();
        if (userIdList.isEmpty()) {
            return map;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", userIdList)};
        for (DynamicObject user : userDo = BusinessDataServiceHelper.load((String)"bos_user", (String)"id, useropenid, eid, name", (QFilter[])filters)) {
            MessageUser messageUser = new MessageUser(user.getLong("id"), user.getString("useropenid"), user.getLocaleString("name").getLocaleValue(), user.getString("eid"));
            String eid = user.getString("eid");
            if (!WfUtils.isNotEmpty(eid)) continue;
            ArrayList<MessageUser> temp = (ArrayList<MessageUser>)map.get(eid);
            if (temp == null) {
                temp = new ArrayList<MessageUser>();
            }
            if (messageUser != null) {
                temp.add(messageUser);
            }
            map.put(eid, temp);
        }
        return map;
    }

    public static void embellishTodoUrl(ToDoInfo todo, MessageInfo message, String type) {
        StringBuilder urlPart = new StringBuilder();
        String lightAppId = WfConfigurationUtil.getLightAppId(type, FLOWASSIST, null);
        urlPart.append(APPIDPART).append(YunzhijiaCommonUtil.encode(lightAppId));
        Boolean isOnlyMobile = message != null && message.getParams() != null && "true".equals(message.getParams().get("isOnlyMobile"));
        if ((YunzhijiaToDoUtil.isYzjOpenDevicePropCanChange() || YUNZHIJIANEW.equals(type)) && !isOnlyMobile.booleanValue()) {
            urlPart.append("&opentype=100");
        } else {
            urlPart.append("&device=mob");
        }
        if (!YUNZHIJIANEW.equals(type)) {
            urlPart.append("&fromyzj=true");
        }
        if (todo != null) {
            urlPart.insert(0, todo.getUrl());
            todo.setUrl(urlPart.toString());
            String wrapUrl = MessageServiceUtil.wrapSystemDomain(todo.getUrl(), type);
            todo.setUrl(wrapUrl);
        } else if (message != null && StringUtils.isNotBlank((CharSequence)message.getMobContentUrl())) {
            urlPart.insert(0, message.getMobContentUrl());
            message.setMobContentUrl(urlPart.toString());
            String wrapUrl = MessageServiceUtil.wrapSystemDomain(message.getMobContentUrl(), type);
            message.setMobContentUrl(wrapUrl);
        }
    }

    private static JSONArray getChannelAppInfo() {
        JSONArray appInfos = null;
        QFilter filter = new QFilter("key", "=", (Object)YZJAPPIDCHANGEINFO);
        DynamicObject channelAppInfo = BusinessDataServiceHelper.loadSingleFromCache((String)CONFCENTER, (String)VALUE, (QFilter[])new QFilter[]{filter});
        if (channelAppInfo != null && !channelAppInfo.getString(VALUE).isEmpty()) {
            appInfos = JSONArray.parseArray((String)channelAppInfo.getString(VALUE));
        }
        return appInfos;
    }

    public static JSONObject updateToDoState(String appId, String appSecret, String sourceId, String openid, YzjToDoState todoState, String type) {
        JSONArray openids = new JSONArray();
        openids.add((Object)openid);
        JSONObject stateData = new JSONObject();
        stateData.put("sourcetype", (Object)appId);
        stateData.put("sourceitemid", (Object)sourceId);
        stateData.put("openids", (Object)openids);
        JSONObject actiontype = new JSONObject();
        if (YzjToDoState.DEAL == todoState) {
            actiontype.put("read", (Object)1);
            actiontype.put("deal", (Object)1);
            actiontype.put("delete", (Object)0);
        } else if (YzjToDoState.DELETE == todoState) {
            actiontype.put("delete", (Object)1);
        }
        stateData.put("actiontype", (Object)actiontype);
        String handleUrl = WfConfigurationUtil.getHandleTodoUrl(type, FLOWASSIST, null);
        JSONObject result = YunzhijiaCommonUtil.doPostWithToDoAuth(handleUrl, stateData, appId, appSecret, type);
        if (YunzhijiaCommonUtil.fail(result)) {
            throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{result == null ? DOPOSTRESULTISNULL : result.toJSONString()});
        }
        return result;
    }

    public static JSONObject updateYzjUpToDoState(String appId, String sourceId, String openid, YzjToDoState todoState) {
        JSONObject bodyData = new JSONObject();
        bodyData.put(APPID, (Object)appId);
        ArrayList<String> bizIds = new ArrayList<String>(1);
        bizIds.add(sourceId + openid);
        bodyData.put("bizId", (Object)bizIds.toArray());
        String authUrl = YunzhijiaToDoUtil.editYzjupUrlWithDomain(AUTHURL);
        String eid = WfConfigurationUtil.getLightAppEid(YUNZHIJIANEW, FLOWASSIST, null);
        String approveAppId = WfConfigurationUtil.getLightApprovalAppId(YUNZHIJIANEW, FLOWASSIST, null);
        String approveAppKey = WfConfigurationUtil.getLightApprovalAppKey(YUNZHIJIANEW, FLOWASSIST, null);
        String authorization = YunzhijiaCommonUtil.getYzjAccessToken(authUrl, approveAppId, approveAppKey, null, null, YUNZHIJIANEW, eid);
        String handleUrl = "";
        if (YzjToDoState.DEAL == todoState) {
            handleUrl = YunzhijiaToDoUtil.editYzjupUrlWithDomain(YUNZHIJIAUPDEALURL);
        } else if (YzjToDoState.DELETE == todoState) {
            handleUrl = YunzhijiaToDoUtil.editYzjupUrlWithDomain(YUNZHIJIAUPDELATEURL);
        }
        JSONObject result = YunzhijiaCommonUtil.doPsotWithToDoAuth(handleUrl, authorization, bodyData);
        if (YunzhijiaCommonUtil.failNew(result, todoState)) {
            throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{result == null ? DOPOSTRESULTISNULL : result.toJSONString()});
        }
        return result;
    }

    public static JSONObject getCheckTodoResult(String sourceId, String openId, String appId, String appSecret, String type) {
        JSONObject stateData = new JSONObject();
        stateData.put("sourcetype", (Object)appId);
        stateData.put("sourceitemid", (Object)sourceId);
        stateData.put("openId", (Object)openId);
        String handleUrl = WfConfigurationUtil.getCheckTodoUrl(type, FLOWASSIST, null);
        JSONObject result = YunzhijiaCommonUtil.doPostWithToDoAuth(handleUrl, stateData, appId, appSecret, type);
        logger.info(String.format("checkTodo result:%s-%s-%s", sourceId, result, openId));
        if (YunzhijiaCommonUtil.fail(result)) {
            throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{result != null ? result.toJSONString() : RESULTISNULL});
        }
        return result;
    }

    private static JSONObject doPostWithToDoAuth(String url, JSONObject data, String appId, String appSecret, String type) {
        JSONObject result = new JSONObject();
        String authUrl = WfConfigurationUtil.getAuthURL(type, FLOWASSIST, null);
        String mainEid = WfConfigurationUtil.getEcoMainEid(type, FLOWASSIST, null);
        String ecologySecret = WfConfigurationUtil.getEcoSecret(type, FLOWASSIST, null);
        String authorization = YunzhijiaCommonUtil.getYzjAccessToken(authUrl, appId, appSecret, mainEid, ecologySecret, type);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENTTYPE, CHARSETTYPE);
        headers.put(ACCEPT, APPLICATIONJSON);
        String newUrl = url + "?accessToken=" + authorization;
        result = YunzhijiaCommonUtil.doPost(newUrl, data, headers);
        return result;
    }

    public static void initNewYzjTemplate(MessageContext ctx, ToDoInfo info) {
        try {
            String appId = WfConfigurationUtil.getLightAppId(YUNZHIJIANEW, FLOWASSIST, null);
            QFilter f1 = new QFilter("appid", "=", (Object)appId);
            QFilter f2 = new QFilter("entitynumber", "=", (Object)ctx.getEntityNumber());
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)YUNZHIJIANEWTPL, (String)"id", (QFilter[])new QFilter[]{f1, f2});
            if (objs.length <= 0) {
                JSONObject yzjBodyData = YunzhijiaToDoUtil.buildYzjNewBodyData(info, null, null, YzjToDoState.INIT);
                if (yzjBodyData != null) {
                    JSONObject result = YunzhijiaCommonUtil.sendHttpRequest(yzjBodyData, YzjToDoState.INIT.getNumber());
                    if (YunzhijiaCommonUtil.fail(result)) {
                        throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{result != null ? result.toJSONString() : RESULTISNULL});
                    }
                } else {
                    throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{"buildYzjNewBody is fail"});
                }
                TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(info.getTaskId());
                YunzhijiaCommonUtil.saveYzjTpl(appId, task.getEntityNumber(), task.getEntityName());
                logger.info("\u4e91\u4e4b\u5bb6\u6a21\u677f\u521d\u59cb\u5316 is ok");
            }
        }
        catch (Exception e) {
            throw new WFMessageServiceException(e, WFErrorCode.yzjSendTodoError(), e.getMessage());
        }
    }

    private static void saveYzjTpl(String appId, String entityNumber, ILocaleString entityName) {
        DynamicObject yzjtpl = ORM.create().newDynamicObject(YUNZHIJIANEWTPL);
        yzjtpl.set(APPID, (Object)appId);
        yzjtpl.set("entitynumber", (Object)entityNumber);
        yzjtpl.set("name", (Object)entityName);
        yzjtpl.set("createdate", (Object)new Date());
        yzjtpl.set("modifydate", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yzjtpl});
    }

    public static JSONObject sendHttpRequest(JSONObject bodyData, String todoState) {
        JSONObject result = new JSONObject();
        String todoUrl = null;
        String approveAppId = WfConfigurationUtil.getLightApprovalAppId(YUNZHIJIANEW, FLOWASSIST, null);
        String approveAppKey = WfConfigurationUtil.getLightApprovalAppKey(YUNZHIJIANEW, FLOWASSIST, null);
        String eid = WfConfigurationUtil.getLightAppEid(YUNZHIJIANEW, FLOWASSIST, null);
        String authUrl = YunzhijiaToDoUtil.editYzjupUrlWithDomain(AUTHURL);
        String appId = WfConfigurationUtil.getLightAppId(YUNZHIJIANEW, FLOWASSIST, null);
        String appSecret = WfConfigurationUtil.getLightAppSecret(YUNZHIJIANEW, FLOWASSIST, null);
        String authorization = null;
        if (YzjToDoState.INIT.getNumber().equals(todoState)) {
            todoUrl = YUNZHIJIAUPINITURL;
        } else if (YzjToDoState.CREATE.getNumber().equals(todoState)) {
            todoUrl = YUNZHIJIAUPCREATURL;
        } else if (YzjToDoState.DEAL.getNumber().equals(todoState)) {
            todoUrl = YUNZHIJIAUPDEALURL;
        } else if (YzjToDoState.DELETE.getNumber().equals(todoState)) {
            todoUrl = YUNZHIJIAUPDELATEURL;
        } else if ("deleteprocess".equals(todoState)) {
            todoUrl = YUNZHIJIAUPDELETEPROCESSURL;
        } else if ("completeprocess".equals(todoState)) {
            todoUrl = YUNZHIJIAUPFINISHURL;
        } else if ("reset".equals(todoState)) {
            todoUrl = YUNZHIJIAUPRESETURL;
        } else if ("copysend".equals(todoState)) {
            todoUrl = YUNZHIJIAUPCOPYSENDURL;
        } else if ("copysendfinish".equals(todoState)) {
            todoUrl = YUNZHIJIAUPCOPYSENDFINISHURL;
        } else if (STR_SENDMESSAGETONOTIFYCENTER.equals(todoState)) {
            todoUrl = SENDMSGTONOTIFYCENTERURL;
            authorization = YunzhijiaCommonUtil.getYzjAccessToken(authUrl, appId, appSecret, null, null, YUNZHIJIA, eid);
        } else if ("dealMessage".equals(todoState)) {
            todoUrl = DEALMESSAGE;
            authorization = YunzhijiaCommonUtil.getYzjAccessToken(authUrl, appId, appSecret, null, null, YUNZHIJIA, eid);
        }
        if (StringUtils.isBlank(authorization)) {
            authorization = YunzhijiaCommonUtil.getYzjAccessToken(authUrl, approveAppId, approveAppKey, null, null, YUNZHIJIANEW, eid);
        }
        result = YunzhijiaCommonUtil.doPsotWithToDoAuth(YunzhijiaToDoUtil.editYzjupUrlWithDomain(todoUrl), authorization, bodyData);
        return result;
    }

    public static void createNewYzjToDo(MessageContext ctx, ToDoInfo info) {
        List<YzjToDoProperty> yzjToDoProperties = new ArrayList<YzjToDoProperty>();
        boolean success = true;
        try {
            YunzhijiaCommonUtil.embellishTodoUrl(info, null, YUNZHIJIANEW);
            yzjToDoProperties = YunzhijiaToDoUtil.transformToDo(ctx, info, YzjToDoState.CREATE, YUNZHIJIANEW);
            ArrayList<String> userOpenIdList = new ArrayList<String>(yzjToDoProperties.size());
            ArrayList<String> userNameList = new ArrayList<String>(yzjToDoProperties.size());
            List<Long> userIds = YunzhijiaToDoUtil.cloneUserList(info.getUserIds());
            if (!yzjToDoProperties.isEmpty()) {
                for (YzjToDoProperty todoProperty : yzjToDoProperties) {
                    userOpenIdList.add(todoProperty.getOpenId());
                    userNameList.add(todoProperty.getUserName());
                    userIds.remove(Long.valueOf(todoProperty.getUserid()));
                }
                YzjToDoProperty todoProperty = yzjToDoProperties.get(0);
                info.getParams().put("businessKey", ctx.getBusinessKey());
                JSONObject yzjBodyData = YunzhijiaToDoUtil.buildYzjNewBodyData(info, todoProperty, userOpenIdList, YzjToDoState.CREATE);
                JSONObject result = YunzhijiaCommonUtil.sendHttpRequest(yzjBodyData, YzjToDoState.CREATE.getNumber());
                if (YunzhijiaCommonUtil.fail(result)) {
                    throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{result != null ? result.toJSONString() : RESULTISNULL});
                }
                if (!userIds.isEmpty()) {
                    logger.info(String.format("\u7528\u6237[%s]\u6570\u636e\u5e93\u4e2d\u7f3a\u5c11openid", userIds.toString()));
                }
            }
            logger.info("\u4e91\u4e4b\u5bb6createToDo is ok , url is:" + info.getUrl());
            YunzhijiaCommonUtil.addCreateTODOLog(ctx.getTaskId(), userNameList);
        }
        catch (Exception e) {
            success = false;
            throw new WFMessageServiceException(e, WFErrorCode.yzjSendTodoError(), e.getMessage());
        }
        finally {
            if (success) {
                YunzhijiaToDoUtil.updateYzjTodoState(ctx.getProcessInstanceId(), info, yzjToDoProperties, null, YzjToDoState.CREATE, YUNZHIJIANEW);
            } else {
                YunzhijiaToDoUtil.updateYzjTodoState(ctx.getProcessInstanceId(), info, null, yzjToDoProperties, YzjToDoState.CREATE, YUNZHIJIANEW);
            }
        }
    }

    public static void updateNewYzjToDo(MessageContext ctx, ToDoInfo info, YzjToDoState todoState) {
        List<Object> yzjToDoProperties = new ArrayList();
        boolean success = true;
        try {
            yzjToDoProperties = YunzhijiaToDoUtil.transformToDo(ctx, info, todoState, YUNZHIJIANEW);
            List<Long> userIds = YunzhijiaToDoUtil.cloneUserList(info.getUserIds());
            if (!yzjToDoProperties.isEmpty()) {
                for (YzjToDoProperty yzjToDoProperty : yzjToDoProperties) {
                    JSONObject result;
                    JSONObject yzjBodyData;
                    if (YUNZHIJIANEW.equals(yzjToDoProperty.getType())) {
                        yzjBodyData = YunzhijiaToDoUtil.buildYzjNewBodyData(info, yzjToDoProperty, null, todoState);
                        result = YunzhijiaCommonUtil.sendHttpRequest(yzjBodyData, todoState.getNumber());
                    } else {
                        yzjBodyData = YunzhijiaToDoUtil.buildYzjBodyData(info, yzjToDoProperty, null, todoState, yzjToDoProperty.getType());
                        result = YunzhijiaCommonUtil.sendHttpRequest(yzjToDoProperty, yzjBodyData, todoState, yzjToDoProperty.getType());
                    }
                    if (YunzhijiaCommonUtil.failNew(result, todoState)) {
                        throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{result == null ? DOPOSTRESULTISNULL : result.toJSONString()});
                    }
                    userIds.remove(Long.valueOf(yzjToDoProperty.getUserid()));
                }
                logger.info(String.format("[%s-%s]\u66f4\u65b0\u4e91\u4e4b\u5bb6\u5f85\u529e\u72b6\u6001\u6210\u529f", info.getTaskId(), RequestContext.get().getTraceId()));
                if (!userIds.isEmpty()) {
                    if (YzjToDoState.DEAL == todoState) {
                        throw new WFMessageServiceException(new KDBizException(ResManager.loadKDString((String)"\u5f85\u529e\u53d8\u5df2\u529e\u5931\u8d25\uff0c\u7528\u6237\u6ca1\u6709openID\u3002", (String)YUNZHIJIACOMMONUTIL7, (String)"bos-wf-engine", (Object[])new Object[0])), WFErrorCode.yzjdealTodoError(), String.format(ResManager.loadKDString((String)"\u5f85\u529e\u53d8\u5df2\u529e\u5931\u8d25\uff0c\u7528\u6237%s\u7f3a\u5c11openId\u3002", (String)"YunzhijiaCommonUtil_8", (String)"bos-wf-engine", (Object[])new Object[0]), userIds.toString()));
                    }
                    throw new WFMessageServiceException(new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u5f85\u529e\u5931\u8d25\uff0c\u7528\u6237\u6ca1\u6709openID\u3002", (String)"YunzhijiaCommonUtil_10", (String)"bos-wf-engine", (Object[])new Object[0])), WFErrorCode.yzjdeleteTodoError(), String.format(ResManager.loadKDString((String)"\u7528\u6237%s\u7f3a\u5c11openID\uff0c\u5220\u9664\u5f85\u529e\u5931\u8d25\u3002", (String)"YunzhijiaCommonUtil_11", (String)"bos-wf-engine", (Object[])new Object[0]), userIds.toString()));
                }
            }
        }
        catch (Exception e) {
            success = false;
            throw new WFMessageServiceException(e, WFErrorCode.yzjdealTodoError(), e.getMessage());
        }
        finally {
            if (success) {
                YunzhijiaToDoUtil.updateYzjTodoState(ctx.getProcessInstanceId(), info, yzjToDoProperties, null, todoState, YUNZHIJIANEW);
            } else {
                YunzhijiaToDoUtil.updateYzjTodoState(ctx.getProcessInstanceId(), info, null, yzjToDoProperties, todoState, YUNZHIJIANEW);
            }
        }
    }

    public static void deleteProcess(Long processInstanceId, String type, String entityNumber) {
        if (!WfConfigurationUtil.isEnabled(YUNZHIJIANEW)) {
            return;
        }
        if (YUNZHIJIANEW.equals(type)) {
            try {
                YunzhijiaToDoUtil.deleteYzjTodoStateByProcessInstanceId(processInstanceId);
                JSONObject bodyData = new JSONObject();
                bodyData.put(APPID, (Object)WfConfigurationUtil.getLightAppId(YUNZHIJIANEW, FLOWASSIST, null));
                bodyData.put(FLOWID, (Object)new String[]{entityNumber});
                logger.info(BODYDATAIS + bodyData.toString());
                JSONObject result = YunzhijiaCommonUtil.sendHttpRequest(bodyData, "deleteprocess");
                if (YunzhijiaCommonUtil.fail(result)) {
                    throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{result != null ? result.toJSONString() : RESULTISNULL});
                }
            }
            catch (Exception e) {
                throw new WFMessageServiceException(e, WFErrorCode.yzjSendTodoError(), e.getMessage());
            }
        }
    }

    public static void completeProcess(Long processInstanceId, String type, String entityNumber) {
        if (!WfConfigurationUtil.isEnabled(YUNZHIJIANEW)) {
            return;
        }
        if (YUNZHIJIANEW.equals(type)) {
            try {
                YunzhijiaToDoUtil.deleteYzjTodoStateByProcessInstanceId(processInstanceId);
                JSONObject bodyData = new JSONObject();
                bodyData.put(APPID, (Object)WfConfigurationUtil.getLightAppId(YUNZHIJIANEW, FLOWASSIST, null));
                bodyData.put(FLOWID, (Object)new String[]{entityNumber});
                logger.info(BODYDATAIS + bodyData.toString());
                JSONObject result = YunzhijiaCommonUtil.sendHttpRequest(bodyData, "completeprocess");
                if (YunzhijiaCommonUtil.fail(result)) {
                    throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{result != null ? result.toJSONString() : RESULTISNULL});
                }
            }
            catch (Exception e) {
                throw new WFMessageServiceException(e, WFErrorCode.yzjSendTodoError(), e.getMessage());
            }
        }
    }

    @Deprecated
    public static boolean isNeeedReeset(Long taskId) {
        TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(taskId);
        FlowElement currentElement = task.getProcessInstance().getCurrentFlowElement();
        if (currentElement instanceof UserTask) {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(task.getProcessDefinitionId(), task.getProcessInstanceId());
            UserTask userTask = (UserTask)bpmnModel.getFlowElement(task.getTaskDefinitionKey());
            return BpmnModelUtil.isFirstNodeByModel(userTask);
        }
        return false;
    }

    public static void resetNewYzj(String processInstanceId) {
        try {
            JSONObject bodyData = new JSONObject();
            bodyData.put(APPID, (Object)WfConfigurationUtil.getLightAppId(YUNZHIJIANEW, FLOWASSIST, null));
            bodyData.put(FLOWID, (Object)new String[]{processInstanceId});
            logger.info(BODYDATAIS + bodyData.toString());
            JSONObject result = YunzhijiaCommonUtil.sendHttpRequest(bodyData, "reset");
            if (YunzhijiaCommonUtil.fail(result)) {
                throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{result != null ? result.toJSONString() : RESULTISNULL});
            }
        }
        catch (Exception e) {
            throw new WFException(e.getMessage(), e);
        }
    }

    @Deprecated
    public static void copySendYunzhijiaUp(MessageInfo messageInfo, MessageContext ctx) {
        ArrayList<String> openIds = new ArrayList<String>();
        List<MessageUser> messageUsers = YunzhijiaToDoUtil.getMessageUsers(messageInfo.getUserIds());
        for (MessageUser messageUser : messageUsers) {
            if (!WfUtils.isNotEmpty(messageUser.getOpenId())) continue;
            openIds.add(messageUser.getOpenId());
        }
        int len = messageUsers.size();
        for (int i = 0; i < len; ++i) {
            MessageUser messageUser = messageUsers.get(i);
        }
        YunzhijiaCommonUtil.copySendYunzhijiaUp(messageInfo, openIds);
    }

    public static void copySendYunzhijiaUp(MessageInfo messageInfo, List<String> openIds) {
        try {
            MessageContext ctx = (MessageContext)SerializationUtils.fromJsonString((String)((String)messageInfo.getParams().get("messageContext")), MessageContext.class);
            DynamicObject taskDynobj = YunzhijiaCommonUtil.getTask(ctx.getTaskId());
            JSONObject bodyData = new JSONObject();
            String appId = WfConfigurationUtil.getLightAppId(YUNZHIJIANEW, FLOWASSIST, null);
            bodyData.put("webLink", (Object)MessageServiceUtil.getReplacedUrl(messageInfo.getContentUrl(), YUNZHIJIANEW));
            bodyData.put("mobileLink", (Object)messageInfo.getMobContentUrl());
            String flowLink = YunzhijiaToDoUtil.getMyInitiatedUrl(taskDynobj.getLong("processinstanceid"), appId);
            String replacedUrl = MessageServiceUtil.getReplacedUrl(flowLink, YUNZHIJIANEW);
            bodyData.put("webFlowLink", (Object)replacedUrl);
            bodyData.put("mobileFlowLink", (Object)replacedUrl);
            bodyData.put(APPID, (Object)appId);
            JSONArray copyArray = new JSONArray();
            for (String openId : openIds) {
                JSONObject json = new JSONObject();
                json.put("bizId", (Object)(messageInfo.getId() + openId));
                json.put("copyTo", (Object)openId);
                copyArray.add((Object)json);
            }
            bodyData.put("copy", (Object)copyArray);
            bodyData.put("typeId", (Object)ctx.getEntityNumber());
            bodyData.put("urgency", (Object)YunzhijiaToDoUtil.getTransformUrgency(taskDynobj.getInt("priority")));
            bodyData.put(FLOWID, (Object)String.valueOf(ctx.getBusinessKey()));
            bodyData.put("title", (Object)messageInfo.getTitle());
            bodyData.put("serialNo", taskDynobj.get("billno"));
            bodyData.put("field", (Object)YunzhijiaToDoUtil.getMainFieldValue(ctx.getEntityNumber(), ctx.getBusinessKey(), (String)messageInfo.getParams().get("lang")));
            ArrayList<Long> list = new ArrayList<Long>(1);
            Long creatorId = taskDynobj.getLong("starterid");
            list.add(creatorId);
            List<MessageUser> createUser = YunzhijiaToDoUtil.getMessageUsers(list);
            if (createUser.isEmpty() || StringUtils.isBlank((CharSequence)createUser.get(0).getOpenId())) {
                logger.info(String.format("\u7528\u6237[%s]\u6570\u636e\u5e93\u4e2d\u7f3a\u5c11openid", creatorId));
                return;
            }
            String creatorOpenId = createUser.get(0).getOpenId();
            bodyData.put("creator", (Object)creatorOpenId);
            bodyData.put("creatorOrgId", YunzhijiaToDoUtil.getYzjOrgIdByUserId(creatorId));
            double expireTime = YunzhijiaToDoUtil.getTaskExpireTime(taskDynobj.getDate("createdate"), taskDynobj.getDate("duedate"));
            if (expireTime > 0.0) {
                bodyData.put("ttlType", (Object)"standard");
                bodyData.put("ttl", (Object)((int)Math.ceil(expireTime / 60000.0)));
            }
            bodyData.put("activityId", taskDynobj.get("taskdefinitionkey"));
            bodyData.put("activityName", messageInfo.getParams().get("activityName"));
            JSONObject result = YunzhijiaCommonUtil.sendHttpRequest(bodyData, "copysend");
            if (YunzhijiaCommonUtil.fail(result)) {
                throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{result != null ? result.toJSONString() : RESULTISNULL});
            }
        }
        catch (Exception e) {
            throw new WFMessageServiceException(e, WFErrorCode.yzjsendMsgError(), e.getMessage());
        }
    }

    private static DynamicObject getTask(Long taskId) {
        WorkflowService service = (WorkflowService)ServiceFactory.getService((String)"WorkflowService");
        TaskEntity task = (TaskEntity)service.getTaskService().getTask(taskId);
        DynamicObject taskDynobj = null;
        if (task == null) {
            HistoricTaskInstanceEntityImpl hisTask = (HistoricTaskInstanceEntityImpl)service.getTaskService().getHistoricTask(taskId);
            if (hisTask == null) {
                throw new WFMessageServiceException(null, WFErrorCode.emptyErrorCode(), new Object[]{"task is null"});
            }
            taskDynobj = hisTask.getDynamicObject();
        } else {
            taskDynobj = task.getDynamicObject();
        }
        return taskDynobj;
    }

    public static void setCopyMsgRead(Object[] msgIds) {
        if (WfConfigurationUtil.isEnabled(YUNZHIJIANEW)) {
            logger.info("\u4e91\u4e4b\u5bb6\u6807\u8bb0\u6284\u9001\u5df2\u8bfb copysend : " + Arrays.toString(msgIds));
            try {
                JSONObject bodyData = new JSONObject();
                bodyData.put(APPID, (Object)WfConfigurationUtil.getLightAppId(YUNZHIJIANEW, FLOWASSIST, null));
                bodyData.put("bizId", (Object)msgIds);
                logger.info(BODYDATAIS + bodyData.toString());
                JSONObject result = YunzhijiaCommonUtil.sendHttpRequest(bodyData, "copysendfinish");
                if (YunzhijiaCommonUtil.fail(result) && (result == null || !String.valueOf(result.get((Object)"errorCode")).equals("1301002"))) {
                    throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{result != null ? result.toJSONString() : RESULTISNULL});
                }
            }
            catch (Exception e) {
                logger.info("\u4e91\u4e4b\u5bb6\u6807\u8bb0\u6284\u9001\u5df2\u8bfb\u5931\u8d25 \uff1a " + e.getMessage());
            }
        }
    }

    public static void sendMessageToNoticeCenter(String eid, List<String> userOpenIds, MessageInfo message, String type) {
        try {
            logger.info("\u4e91\u4e4b\u5bb6\u53d1\u9001\u6d88\u606f\u5230\u901a\u77e5\u4e2d\u5fc3\u7684\u79fb\u52a8\u7aef\u94fe\u63a5\u662f\uff1a" + message.getMobContentUrl());
            JSONObject bodyData = new JSONObject();
            String appId = WfConfigurationUtil.getLightAppId(type, FLOWASSIST, null);
            bodyData.put(APPID, (Object)appId);
            bodyData.put("sourceId", (Object)message.getId());
            bodyData.put("title", (Object)YunzhijiaCommonUtil.getPubaccName(message.getParams().get("lang"), type));
            if (StringUtils.isNotBlank((CharSequence)message.getMobContentUrl())) {
                bodyData.put("url", (Object)message.getMobContentUrl());
            }
            bodyData.put("headImg", (Object)WfConfigurationUtil.getPubAppIcon(type, FLOWASSIST, null));
            bodyData.put("content", (Object)message.getContent());
            bodyData.put("itemtitle", (Object)message.getTitle());
            JSONArray params = new JSONArray();
            for (String openId : userOpenIds) {
                JSONObject someOneAndTheStatus = new JSONObject();
                someOneAndTheStatus.put("openId", (Object)openId);
                params.add((Object)someOneAndTheStatus);
            }
            bodyData.put("params", (Object)params);
            bodyData.put("sync", (Object)true);
            String tagId = "alarm".equals(message.getType()) || "warning".equals(message.getType()) ? "alarm" : "notify";
            bodyData.put("tagId", (Object)tagId);
            bodyData.put("todoType", (Object)0);
            JSONObject result = YUNZHIJIANEW.equals(type) ? YunzhijiaCommonUtil.sendHttpRequest(bodyData, STR_SENDMESSAGETONOTIFYCENTER) : new JSONObject();
            if (YunzhijiaCommonUtil.fail(result)) {
                throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{result != null ? result.toJSONString() : RESULTISNULL});
            }
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{WfUtils.getExceptionStacktrace(e)});
        }
    }

    public static void dealMessage(String userOpenId, MessageInfo message, String type) {
        try {
            JSONObject bodyData = new JSONObject();
            String appId = WfConfigurationUtil.getLightAppId(type, FLOWASSIST, null);
            bodyData.put("sourcetype", (Object)appId);
            bodyData.put("sourceitemid", (Object)message.getId());
            JSONArray userOpenIdArray = new JSONArray();
            userOpenIdArray.add((Object)userOpenId);
            bodyData.put("openids", (Object)userOpenIdArray);
            JSONObject actiontype = new JSONObject();
            actiontype.put("read", (Object)1);
            actiontype.put("deal", (Object)1);
            actiontype.put("delete", (Object)0);
            bodyData.put("actiontype", (Object)actiontype);
            bodyData.put("sync", (Object)true);
            JSONObject result = YUNZHIJIANEW.equals(type) ? YunzhijiaCommonUtil.sendHttpRequest(bodyData, STR_SENDMESSAGETONOTIFYCENTER) : new JSONObject();
            result = YunzhijiaCommonUtil.sendHttpRequest(bodyData, "dealMessage");
            if (YunzhijiaCommonUtil.fail(result)) {
                throw new KDException(WFErrorCode.httpRequestWrongResponse(), new Object[]{result != null ? result.toJSONString() : RESULTISNULL});
            }
        }
        catch (Exception e) {
            throw new WFMessageServiceException(e, WFErrorCode.emptyErrorCode(), e.getMessage());
        }
    }

    public static void wrapContent(ToDoInfo info, Map<String, Object> map, String type, Map<String, Object> param) {
        if (!map.isEmpty()) {
            boolean isTemplate = (Boolean)map.get(ISTEMPLATE);
            if (isTemplate) {
                String flowassist;
                LocaleString toDoTitle = new LocaleString();
                if (map.get(TODOTITLE) == null && WfUtils.isNotEmpty(flowassist = YunzhijiaCommonUtil.getPubaccName(info.getParams().get("lang"), type))) {
                    toDoTitle = (LocaleString)WfUtils.getMultiLangValue(flowassist);
                    info.setToDoTitle(toDoTitle);
                }
            } else if (!param.isEmpty()) {
                Object subject;
                LocaleString title;
                Object entityName = param.get(ENTITYNAME);
                if (entityName != null && WfUtils.isNotEmpty((ILocaleString)(title = YunzhijiaCommonUtil.rebuildTitle((LocaleString)SerializationUtils.fromJsonString((String)((String)entityName), LocaleString.class))))) {
                    info.setToDoTitle(title);
                }
                if ((subject = param.get(SUBJECT)) != null) {
                    info.setToDoContent((LocaleString)SerializationUtils.fromJsonString((String)((String)subject), LocaleString.class));
                }
            }
        }
    }

    private static String getPubaccName(Object lang, String type) {
        String pubAppName = "";
        String pan = WfConfigurationUtil.getPubAppName(type, FLOWASSIST, null);
        if (WfUtils.isNotEmpty(pan)) {
            if (WfUtils.isJSONFormat(pan)) {
                JSONObject name = JSONObject.parseObject((String)pan);
                if (lang != null && WfUtils.isNotEmpty((String)lang) && WfUtils.isNotEmpty(name.getString((String)lang))) {
                    pubAppName = name.getString((String)lang);
                }
                if (WfUtils.isEmpty(pubAppName)) {
                    pubAppName = name.getString("GLang");
                }
            } else {
                pubAppName = pan;
            }
        }
        return pubAppName;
    }

    public static LocaleString rebuildTitle(LocaleString entityName) {
        LocaleString title = new LocaleString();
        if (WfUtils.isNotEmpty((ILocaleString)entityName)) {
            ILocaleString titlePrefix = WfUtils.getPromptWordLocaleString("\u8bf7\u5904\u7406:", "YunzhijiaServiceHandler_13", "bos-wf-engine");
            for (String key : entityName.keySet()) {
                title.setItem(key, (Object)(WfUtils.getEmptyStringValue(titlePrefix, key) + (String)entityName.get((Object)key)));
            }
        }
        return title;
    }
}

