/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.util.yzj;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaCommonUtil;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class YunzhijiaPubUtil {
    private static Log logger = LogFactory.getLog(YunzhijiaPubUtil.class);
    private static final String SUCCESS = "success";

    public static boolean isEidSame(List<MessageUser> messageUsers) {
        boolean isEidSame = true;
        String eid = messageUsers.get(0).getEid();
        for (MessageUser messageUser : messageUsers) {
            if (eid.equals(messageUser.getEid())) continue;
            isEidSame = false;
            break;
        }
        return isEidSame;
    }

    public static void sendMessage(String eid, List<String> userOpenIds, MessageInfo message, String type) {
        try {
            JSONObject js = new JSONObject();
            JSONObject msg = new JSONObject();
            int msgType = 2;
            String pubaccNumber = message.getPubaccNumber();
            String entityNumer = message.getEntityNumber();
            if (StringUtils.isNotEmpty((String)message.getMobContentUrl())) {
                msgType = 5;
                String appId = WfConfigurationUtil.getLightAppId(type, pubaccNumber, entityNumer);
                logger.info("YunzhijiaPubUtil sendMessage appId = " + appId);
                if (WfUtils.isEmpty(appId)) {
                    appId = WfConfigurationUtil.getLightAppId(type, "flowassist", entityNumer);
                    logger.info("YunzhijiaPubUtil sendMessage flowassist appId = " + appId);
                }
                msg.put("text", (Object)(message.getTitle() + "\n" + message.getContent()));
                msg.put("url", (Object)message.getMobContentUrl());
                msg.put("appid", (Object)appId);
                msg.put("todo", (Object)0);
            } else {
                msgType = 2;
                msg.put("text", (Object)message.getContent());
            }
            js.put("from", (Object)YunzhijiaPubUtil.buildFrom(type, message));
            js.put("to", (Object)YunzhijiaPubUtil.buildTo(eid, userOpenIds));
            js.put("msg", (Object)msg);
            js.put("type", (Object)msgType);
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("Content-Type", "application/json; charset=utf-8");
            headMap.put("Accept", "application/json");
            String pubaccUrl = WfConfigurationUtil.getPubMessageUrl(type, pubaccNumber, entityNumer);
            JSONObject result = YunzhijiaCommonUtil.doPost(pubaccUrl, js, headMap);
            if (result == null) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u7ed3\u679c\u4e3a\u7a7a", (String)"YunzhijiaPubUtil_1", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            if (pubaccUrl.contains("pubsendV2") ? result.getBoolean(SUCCESS) == false : !result.containsKey((Object)"pubId")) {
                throw new RuntimeException(result.toJSONString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static JSONObject buildFrom(String type, MessageInfo message) {
        JSONObject from = new JSONObject();
        SecureRandom random = new SecureRandom();
        String nonce = String.valueOf(random.nextInt());
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        String no = WfConfigurationUtil.getEid();
        String pub = WfConfigurationUtil.getPub(type, message.getPubaccNumber(), message.getEntityNumber());
        String pubsercet = WfConfigurationUtil.getPubSercet(type, message.getPubaccNumber(), message.getEntityNumber());
        from.put("no", (Object)no);
        from.put("pub", (Object)pub);
        from.put("nonce", (Object)nonce);
        from.put("time", (Object)time);
        String pubtoken = YunzhijiaPubUtil.sha(no, pub, pubsercet, nonce, time);
        from.put("pubtoken", (Object)pubtoken);
        return from;
    }

    private static JSONArray buildTo(String eid, List<String> userOpenIds) {
        JSONArray to = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("no", (Object)eid);
        JSONArray openIdArray = new JSONArray();
        for (String openId : userOpenIds) {
            openIdArray.add((Object)openId);
        }
        item.put("user", (Object)openIdArray);
        to.add((Object)item);
        return to;
    }

    private static String sha(String ... data) {
        Arrays.sort(data);
        return DigestUtils.shaHex((String)StringUtils.join((Object[])data));
    }
}

