/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.util.yzj;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.model.yzj.YzjToDoProperty;
import kd.bos.workflow.engine.msg.model.yzj.YzjToDoResult;
import kd.bos.workflow.engine.msg.model.yzj.YzjToDoState;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class YunzhijiaToDoUtil {
    private static Log logger = LogFactory.getLog(YunzhijiaToDoUtil.class);
    private static final String MSGYZJTODO = "msg_yzjtodo";
    private static final String TASKID = "taskid";
    private static final String USERID = "userid";
    private static final String MSGSTATE = "msgstate";
    private static final String MODIFYDATE = "modifydate";
    private static final String MSGRESULT = "msgresult";
    private static final String TITLE = "title";
    private static final String ACTIVITYNAME = "activityName";
    private static final String ACCOUNTIDPART = "&accountId=";
    private static final String APPIDPART = "&appId=";
    private static final String ISQUICKAGREE = "isquickagree";
    private static final String VALUE = "value";

    public static List<YzjToDoProperty> transformToDo(MessageContext ctx, ToDoInfo todoInfo, YzjToDoState state, String type) {
        List<YzjToDoProperty> otherYzjToDoProperties;
        QFilter f2;
        ArrayList<YzjToDoProperty> yzjToDoProperties = new ArrayList<YzjToDoProperty>();
        String selectFields = "id, userid, username, openid, type, eid, ecosecret, appid, appsecret, authurl, createurl, checkurl, dealurl";
        DynamicObject[] yzjTodoStates = null;
        List<Long> userIds = YunzhijiaToDoUtil.cloneUserList(todoInfo.getUserIds());
        QFilter f1 = new QFilter(TASKID, "=", (Object)todoInfo.getTaskId());
        yzjTodoStates = BusinessDataServiceHelper.load((String)MSGYZJTODO, (String)selectFields, (QFilter[])new QFilter[]{f1, f2 = new QFilter(USERID, "in", (Object)todoInfo.getUserIds())});
        if (yzjTodoStates != null && yzjTodoStates.length != 0) {
            for (DynamicObject yzjtodoState : yzjTodoStates) {
                YzjToDoProperty yzjTodoProperty = YunzhijiaToDoUtil.buildYzjToDoProperty(ctx, todoInfo, null, yzjtodoState.getString("type"), state, yzjtodoState);
                yzjToDoProperties.add(yzjTodoProperty);
                userIds.remove(Long.valueOf(yzjtodoState.getString(USERID)));
            }
        }
        if (userIds.size() != 0 && (otherYzjToDoProperties = YunzhijiaToDoUtil.wrapYzjToDo(ctx, todoInfo, userIds, null, state, type)).size() != 0) {
            yzjToDoProperties.addAll(otherYzjToDoProperties);
        }
        return yzjToDoProperties;
    }

    private static List<YzjToDoProperty> wrapYzjToDo(MessageContext ctx, ToDoInfo todoInfo, List<Long> userNotTable, List<DynamicObject> canRetryTodoList, YzjToDoState state, String type) {
        ArrayList<YzjToDoProperty> yzjTodoProperties = new ArrayList<YzjToDoProperty>();
        if (userNotTable != null && userNotTable.size() != 0) {
            List<MessageUser> messageUsers = YunzhijiaToDoUtil.getMessageUsers(userNotTable);
            for (int i = 0; i < messageUsers.size(); ++i) {
                yzjTodoProperties.add(YunzhijiaToDoUtil.buildYzjToDoProperty(ctx, todoInfo, messageUsers.get(i), type, state, null));
            }
        }
        if (canRetryTodoList != null && canRetryTodoList.size() != 0) {
            for (DynamicObject retryTodoState : canRetryTodoList) {
                yzjTodoProperties.add(YunzhijiaToDoUtil.buildYzjToDoProperty(ctx, todoInfo, null, type, state, retryTodoState));
            }
        }
        return yzjTodoProperties;
    }

    private static YzjToDoProperty buildYzjToDoProperty(MessageContext ctx, ToDoInfo todoInfo, MessageUser messageUser, String type, YzjToDoState todoState, DynamicObject retryTodoState) {
        YzjToDoProperty yzjTodo = new YzjToDoProperty();
        if (messageUser != null) {
            yzjTodo.setUserid(String.valueOf(messageUser.getUserId()));
            yzjTodo.setUserName(messageUser.getUserName());
            yzjTodo.setOpenId(messageUser.getOpenId());
            yzjTodo.setTaskId(String.valueOf(todoInfo.getTaskId()));
            yzjTodo.setProcinstid(String.valueOf(ctx.getProcessInstanceId()));
            yzjTodo.setType(type);
            if ("yunzhijia".equals(type)) {
                yzjTodo.setEid("");
                yzjTodo.setEcoSecret("");
            } else {
                yzjTodo.setEid(WfConfigurationUtil.getEcoMainEid(type, "flowassist", null));
                yzjTodo.setEcoSecret(WfConfigurationUtil.getEcoSecret(type, "flowassist", null));
            }
            yzjTodo.setAuthUrl(WfConfigurationUtil.getAuthURL(type, "flowassist", null));
            yzjTodo.setAppId(WfConfigurationUtil.getLightAppId(type, "flowassist", null));
            yzjTodo.setCheckUrl(WfConfigurationUtil.getCheckTodoUrl(type, "flowassist", null));
            yzjTodo.setHandleUrl(WfConfigurationUtil.getHandleTodoUrl(type, "flowassist", null));
            yzjTodo.setAppSecret(WfConfigurationUtil.getLightAppSecret(type, "flowassist", null));
            yzjTodo.setCreateUrl(WfConfigurationUtil.getGenerateTodoUrl(type, "flowassist", null));
        } else {
            yzjTodo.setId(retryTodoState.getLong("id"));
            yzjTodo.setUserid(retryTodoState.getString(USERID));
            yzjTodo.setUserName(retryTodoState.getLocaleString("username").getLocaleValue());
            yzjTodo.setOpenId(retryTodoState.getString("openid"));
            yzjTodo.setTaskId(String.valueOf(todoInfo.getTaskId()));
            yzjTodo.setProcinstid(String.valueOf(ctx.getProcessInstanceId()));
            yzjTodo.setType(retryTodoState.getString("type"));
            yzjTodo.setEcoSecret(retryTodoState.getString("ecosecret"));
            yzjTodo.setEid(retryTodoState.getString("eid"));
            yzjTodo.setAppId(retryTodoState.getString("appid"));
            yzjTodo.setAppSecret(retryTodoState.getString("appsecret"));
            yzjTodo.setAuthUrl(retryTodoState.getString("authurl"));
            yzjTodo.setCreateUrl(retryTodoState.getString("createurl"));
            yzjTodo.setCheckUrl(retryTodoState.getString("checkurl"));
            yzjTodo.setHandleUrl(retryTodoState.getString("dealurl"));
        }
        return yzjTodo;
    }

    private static String getPubaccName(ToDoInfo todoInfo, String type) {
        String pubAppName = "";
        String pan = WfConfigurationUtil.getPubAppName(type, "flowassist", null);
        if (WfUtils.isNotEmpty(pan)) {
            if (WfUtils.isJSONFormat(pan)) {
                String lang;
                JSONObject name = JSONObject.parseObject((String)pan);
                if (todoInfo.getParams().containsKey("lang") && WfUtils.isNotEmpty(name.getString(lang = (String)todoInfo.getParams().get("lang")))) {
                    pubAppName = name.getString(lang);
                }
                if (WfUtils.isEmpty(pubAppName)) {
                    pubAppName = name.getString("GLang");
                }
            } else {
                pubAppName = pan;
            }
        }
        return pubAppName;
    }

    public static JSONObject buildYzjBodyData(ToDoInfo todoInfo, YzjToDoProperty yzjToDoProperty, List<String> opendIds, YzjToDoState state, String type) {
        JSONObject bodyData = new JSONObject();
        if (YzjToDoState.CREATE == state) {
            boolean isBizTask;
            bodyData.put("appId", (Object)yzjToDoProperty.getAppId());
            bodyData.put("sourceId", (Object)yzjToDoProperty.getTaskId());
            bodyData.put(TITLE, (Object)YunzhijiaToDoUtil.getPubaccName(todoInfo, type));
            bodyData.put("url", (Object)todoInfo.getUrl());
            bodyData.put("headImg", (Object)WfConfigurationUtil.getPubAppIcon(type, "flowassist", null));
            Map todoInfoParams = todoInfo.getParams();
            boolean bl = isBizTask = todoInfoParams.get("isBizTask") == null ? false : (Boolean)todoInfoParams.get("isBizTask");
            if (!isBizTask && YunzhijiaToDoUtil.isQuickApprove(todoInfo, type) && YunzhijiaToDoUtil.isNeedPassUrl(todoInfo)) {
                String domain = UrlService.getDomainContextUrl();
                StringBuilder purl = new StringBuilder(domain);
                if (!domain.trim().endsWith("/")) {
                    purl.append("/");
                }
                purl.append("kapi/app/wf/batchAgreeTask?accountId=");
                purl.append(RequestContext.get().getAccountId());
                String url = MessageServiceUtil.wrapSystemDomain(purl.toString(), type);
                logger.debug("taskId=" + todoInfo.getTaskId() + " yunzhijia fast deal todo passUrl=" + url);
                bodyData.put("passUrl", (Object)url);
            }
            bodyData.put("senderId", null);
            bodyData.put("itemtitle", (Object)todoInfo.getTitle());
            bodyData.put("content", (Object)todoInfo.getContent());
            JSONObject status = new JSONObject();
            status.put("READ", (Object)0);
            status.put("DO", (Object)0);
            JSONArray params = new JSONArray();
            for (String openId : opendIds) {
                JSONObject someOneAndTheStatus = new JSONObject();
                someOneAndTheStatus.put("openId", (Object)openId);
                someOneAndTheStatus.put("status", (Object)status);
                params.add((Object)someOneAndTheStatus);
            }
            bodyData.put("params", (Object)params);
            bodyData.put("sync", (Object)true);
        } else if (YzjToDoState.DEAL == state || YzjToDoState.DELETE == state) {
            bodyData.put("sourcetype", (Object)yzjToDoProperty.getAppId());
            bodyData.put("sourceitemid", (Object)yzjToDoProperty.getTaskId());
            bodyData.put("openids", (Object)YunzhijiaToDoUtil.turnToJSONArray(yzjToDoProperty.getOpenId()));
            JSONObject actiontype = new JSONObject();
            if (YzjToDoState.DEAL == state) {
                actiontype.put("read", (Object)1);
                actiontype.put("deal", (Object)1);
                actiontype.put("delete", (Object)0);
            } else {
                actiontype.put("delete", (Object)2);
            }
            bodyData.put("actiontype", (Object)actiontype);
            bodyData.put("sync", (Object)true);
        } else if (YzjToDoState.CHECK == state) {
            bodyData.put("sourcetype", (Object)yzjToDoProperty.getAppId());
            bodyData.put("sourceitemid", (Object)yzjToDoProperty.getTaskId());
            bodyData.put("openId", (Object)yzjToDoProperty.getOpenId());
        }
        return bodyData;
    }

    public static boolean isNeedPassUrl(ToDoInfo info) {
        boolean needPassUrl = true;
        if (WfUtils.isNotEmpty(info.getTodoType()) && info.getTodoType().equals(MessageTypeEnum.COORDINATE.getNumber())) {
            needPassUrl = false;
        }
        if (WfUtils.isNotEmpty(info.getCategory()) && info.getCategory().equals("UserTask")) {
            needPassUrl = false;
        }
        return needPassUrl;
    }

    private static JSONArray turnToJSONArray(String userOpenId) {
        JSONArray array = new JSONArray();
        array.add((Object)userOpenId);
        return array;
    }

    public static void updateYzjTodoState(Long pId, ToDoInfo todoInfo, List<YzjToDoProperty> successTodoProperties, List<YzjToDoProperty> failTodoProperties, YzjToDoState state, String type) {
        boolean success;
        boolean bl = success = successTodoProperties != null && !successTodoProperties.isEmpty();
        if (YzjToDoState.CREATE == state) {
            if (success) {
                YunzhijiaToDoUtil.saveYzjTodoState(pId, todoInfo.getTaskId(), successTodoProperties, failTodoProperties, state, type);
            }
        } else if (YzjToDoState.DEAL == state || YzjToDoState.CHECK == state) {
            QFilter f2;
            String selectFields = "id, userid, msgstate, msgresult, retries, modifydate";
            QFilter f1 = new QFilter(TASKID, "=", (Object)todoInfo.getTaskId());
            DynamicObject[] todoStates = BusinessDataServiceHelper.load((String)MSGYZJTODO, (String)selectFields, (QFilter[])new QFilter[]{f1, f2 = new QFilter(USERID, "in", (Object)todoInfo.getUserIds())});
            if (todoStates != null && todoStates.length != 0) {
                for (DynamicObject todoState : todoStates) {
                    todoState.set(MSGSTATE, (Object)state.getNumber());
                    todoState.set(MODIFYDATE, (Object)new Date());
                    if (success) {
                        todoState.set(MSGRESULT, (Object)YzjToDoResult.SUCCESS.getNumber());
                        continue;
                    }
                    todoState.set(MSGRESULT, (Object)YzjToDoResult.FAIL.getNumber());
                }
                SaveServiceHelper.save((DynamicObject[])todoStates);
            } else {
                YunzhijiaToDoUtil.saveYzjTodoState(pId, todoInfo.getTaskId(), successTodoProperties, failTodoProperties, state, type);
            }
            logger.debug("save yunzhijia create todo state is ok");
        } else if (YzjToDoState.DELETE == state) {
            QFilter f1 = new QFilter(TASKID, "=", (Object)todoInfo.getTaskId());
            QFilter f2 = new QFilter(USERID, "in", (Object)todoInfo.getUserIds());
            String selectFields = "id, userid, msgstate, msgresult, retries, modifydate";
            DynamicObject[] yzjTodoStates = BusinessDataServiceHelper.load((String)MSGYZJTODO, (String)selectFields, (QFilter[])new QFilter[]{f1, f2});
            ArrayList<Long> deleteSuccessIds = new ArrayList<Long>();
            ArrayList<DynamicObject> failDeleteTodo = new ArrayList<DynamicObject>();
            if (yzjTodoStates != null && yzjTodoStates.length != 0) {
                for (DynamicObject todoState : yzjTodoStates) {
                    if (success) {
                        deleteSuccessIds.add(todoState.getLong("id"));
                        continue;
                    }
                    todoState.set(MSGSTATE, (Object)state.getNumber());
                    todoState.set(MSGRESULT, (Object)YzjToDoResult.FAIL.getNumber());
                    todoState.set(MODIFYDATE, (Object)new Date());
                    failDeleteTodo.add(todoState);
                }
            } else if (!success) {
                YunzhijiaToDoUtil.saveYzjTodoState(pId, todoInfo.getTaskId(), null, failTodoProperties, state, type);
            }
            if (deleteSuccessIds.size() > 0) {
                DeleteServiceHelper.delete((String)MSGYZJTODO, (QFilter[])new QFilter[]{new QFilter("id", "in", deleteSuccessIds)});
                logger.debug("delete yzj todo state is success");
            }
            if (failDeleteTodo.size() != 0) {
                SaveServiceHelper.save((DynamicObject[])failDeleteTodo.toArray(new DynamicObject[0]));
                logger.debug("update yzj delete todo state is success");
            }
        }
    }

    private static void saveYzjTodoState(Long pId, Long taskId, List<YzjToDoProperty> successTodoProperties, List<YzjToDoProperty> failTodoProperties, YzjToDoState todoState, String type) {
        ArrayList<DynamicObject> dynamicList = new ArrayList<DynamicObject>();
        if (successTodoProperties != null && successTodoProperties.size() > 0) {
            for (int i = 0; i < successTodoProperties.size(); ++i) {
                YzjToDoProperty successTodo = successTodoProperties.get(i);
                dynamicList.add(YunzhijiaToDoUtil.buildYzjTodoState(pId, taskId, successTodo, todoState, type, YzjToDoResult.SUCCESS));
            }
        }
        if (failTodoProperties != null && failTodoProperties.size() > 0) {
            for (int j = 0; j < failTodoProperties.size(); ++j) {
                YzjToDoProperty errorTodo = failTodoProperties.get(j);
                dynamicList.add(YunzhijiaToDoUtil.buildYzjTodoState(pId, taskId, errorTodo, todoState, type, YzjToDoResult.FAIL));
            }
        }
        SaveServiceHelper.save((DynamicObject[])dynamicList.toArray(new DynamicObject[0]));
    }

    private static DynamicObject buildYzjTodoState(Long pId, Long tId, YzjToDoProperty todo, YzjToDoState todoState, String type, YzjToDoResult result) {
        DynamicObject yzjtodoState = ORM.create().newDynamicObject(MSGYZJTODO);
        yzjtodoState.set("id", (Object)todo.getId());
        yzjtodoState.set(USERID, (Object)todo.getUserid());
        LocaleString username = new LocaleString();
        username.setLocaleValue(todo.getUserName());
        yzjtodoState.set("username", (Object)username);
        yzjtodoState.set("openid", (Object)todo.getOpenId());
        yzjtodoState.set("type", (Object)type);
        yzjtodoState.set("ecosecret", (Object)(StringUtils.isBlank((CharSequence)todo.getEcoSecret()) ? " " : todo.getEcoSecret()));
        yzjtodoState.set("eid", (Object)(StringUtils.isBlank((CharSequence)todo.getEid()) ? "0" : todo.getEid()));
        yzjtodoState.set("appid", (Object)todo.getAppId());
        yzjtodoState.set("appsecret", (Object)todo.getAppSecret());
        yzjtodoState.set("authurl", (Object)todo.getAuthUrl());
        yzjtodoState.set("createurl", (Object)todo.getCreateUrl());
        yzjtodoState.set("checkurl", (Object)todo.getCheckUrl());
        yzjtodoState.set("dealurl", (Object)todo.getHandleUrl());
        yzjtodoState.set(TASKID, (Object)todo.getTaskId());
        yzjtodoState.set("procinstid", (Object)todo.getProcinstid());
        yzjtodoState.set(MSGSTATE, (Object)todoState.getNumber());
        yzjtodoState.set(MSGRESULT, (Object)result.getNumber());
        yzjtodoState.set("retries", (Object)0);
        yzjtodoState.set("createdate", (Object)new Date());
        yzjtodoState.set(MODIFYDATE, (Object)new Date());
        return yzjtodoState;
    }

    public static List<MessageUser> getMessageUsers(List<Long> userIdList) {
        ArrayList<MessageUser> users = new ArrayList<MessageUser>();
        if (userIdList.isEmpty()) {
            return users;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", userIdList)};
        DynamicObject[] UserObjects = BusinessDataServiceHelper.load((String)"bos_user", (String)"id, useropenid, eid, name", (QFilter[])filters);
        if (UserObjects != null && UserObjects.length != 0) {
            for (DynamicObject userObj : UserObjects) {
                if (!StringUtils.isNotBlank((CharSequence)userObj.getString("useropenid"))) continue;
                MessageUser mu = new MessageUser(userObj.getLong("id"), userObj.getString("useropenid"), userObj.getLocaleString("name").getLocaleValue(), userObj.getString("eid"));
                users.add(mu);
            }
        }
        return users;
    }

    public static void deleteYzjTodoStateByProcessInstanceId(Long processInstanceId) {
        QFilter f1 = new QFilter("procinstid", "=", (Object)processInstanceId);
        QFilter f2 = new QFilter(MSGSTATE, "=", (Object)YzjToDoState.CHECK.getNumber()).and(MSGRESULT, "=", (Object)YzjToDoResult.SUCCESS.getNumber());
        DeleteServiceHelper.delete((String)MSGYZJTODO, (QFilter[])new QFilter[]{f1, f2});
    }

    protected static List<Long> cloneUserList(List<Long> uIds) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        if (uIds != null && uIds.size() != 0) {
            for (Long u : uIds) {
                userIds.add(u);
            }
        }
        return userIds;
    }

    public static List<MessageInfo> rebuildMessage(MessageInfo message) {
        ArrayList<MessageInfo> messages = new ArrayList<MessageInfo>();
        List userIds = message.getUserIds();
        if (userIds != null && userIds.size() != 0) {
            Map<String, List<Long>> userLangs = YunzhijiaToDoUtil.getUserLangs(userIds);
            for (Map.Entry<String, List<Long>> entry : userLangs.entrySet()) {
                String key = entry.getKey();
                List<Long> values = entry.getValue();
                if (values == null || values.isEmpty()) continue;
                MessageInfo messageInfo = message.copy();
                ILocaleString title = message.getMessageTitle();
                messageInfo.setTitle(YunzhijiaToDoUtil.getData(title, key));
                ILocaleString content = message.getMessageContent();
                messageInfo.setContent(YunzhijiaToDoUtil.getData(content, key));
                logger.info(String.format("rebuildMessage_content:[%s], lang:[%s], userIds:[%s]", WfUtils.mapToString(content), key, values));
                messageInfo.setUserIds(values);
                messageInfo.getParams().put("lang", key);
                messages.add(messageInfo);
            }
        } else {
            messages.add(message);
            if (WfUtils.isEmpty(message.getContent())) {
                ILocaleString messageContent = message.getMessageContent();
                message.setContent(YunzhijiaToDoUtil.getData(messageContent, Lang.get().toString()));
            }
        }
        return messages;
    }

    public static Map<String, List<Long>> getUserLangs(List<Long> userIds) {
        HashMap<String, List<Long>> userLangs = new HashMap<String, List<Long>>();
        for (Long userId : userIds) {
            List<Long> langUserIds;
            String lang = "";
            try {
                EnabledLang enabledLang = InteServiceHelper.getUserLang((Long)userId);
                lang = enabledLang.getNumber();
                if (WfUtils.isEmpty(lang)) {
                    lang = Lang.defaultLang().toString();
                }
            }
            catch (Exception e) {
                lang = Lang.defaultLang().toString();
            }
            if (userLangs.containsKey(lang)) {
                langUserIds = (List)userLangs.get(lang);
                langUserIds.add(userId);
                continue;
            }
            langUserIds = new ArrayList();
            langUserIds.add(userId);
            userLangs.put(lang, langUserIds);
        }
        return userLangs;
    }

    public static List<ToDoInfo> rebuildToDoInfo(ToDoInfo model) {
        Map<String, List<Long>> userLangs = YunzhijiaToDoUtil.getUserLangs(model.getUserIds());
        ArrayList<ToDoInfo> toDoInfos = new ArrayList<ToDoInfo>();
        for (Map.Entry<String, List<Long>> entry : userLangs.entrySet()) {
            String key = entry.getKey();
            List<Long> values = entry.getValue();
            if (values == null || values.isEmpty()) continue;
            ToDoInfo toDoInfo = model.copy();
            LocaleString title = toDoInfo.getToDoTitle();
            toDoInfo.setTitle(YunzhijiaToDoUtil.getData((ILocaleString)title, key));
            LocaleString content = toDoInfo.getToDoContent();
            toDoInfo.setContent(YunzhijiaToDoUtil.getData((ILocaleString)content, key));
            toDoInfo.setUserIds(values);
            toDoInfo.getParams().put("lang", key);
            toDoInfos.add(toDoInfo);
        }
        return toDoInfos;
    }

    public static List<ToDoInfo> rebuildNewYzjToDoInfo(ToDoInfo model) {
        Map<String, List<Long>> userLangs = YunzhijiaToDoUtil.getUserLangs(model.getUserIds());
        Long taskId = model.getTaskId();
        TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(taskId);
        ArrayList<ToDoInfo> toDoInfos = new ArrayList<ToDoInfo>();
        for (Map.Entry<String, List<Long>> entry : userLangs.entrySet()) {
            String key = entry.getKey();
            List<Long> values = entry.getValue();
            if (values == null || values.isEmpty()) continue;
            ToDoInfo toDoInfo = model.copy();
            ILocaleString procTitle = task.getSubject();
            toDoInfo.setTitle(YunzhijiaToDoUtil.getYzjData(procTitle, key));
            ILocaleString name = task.getName();
            toDoInfo.getParams().put(ACTIVITYNAME, YunzhijiaToDoUtil.getYzjData(name, key));
            toDoInfo.setUserIds(values);
            toDoInfo.getParams().put("lang", key);
            toDoInfos.add(toDoInfo);
        }
        return toDoInfos;
    }

    public static JSONObject buildYzjNewBodyData(ToDoInfo todoInfo, YzjToDoProperty todoProperty, List<String> userOpenIdList, YzjToDoState state) {
        JSONObject bodyData = new JSONObject();
        Long taskId = todoInfo.getTaskId();
        TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(taskId);
        String appId = WfConfigurationUtil.getLightAppId("yunzhijiaup", "flowassist", null);
        String appName = WfConfigurationUtil.getLightAppName("yunzhijiaup", "flowassist", null);
        if (YzjToDoState.INIT == state) {
            MessageUser yzjTplCreator = YunzhijiaToDoUtil.getYzjTplCreator(task);
            if (yzjTplCreator == null) {
                logger.info(String.format("\u7528\u6237[%s]\u6570\u636e\u5e93\u4e2d\u7f3a\u5c11openid", task.getProcessInstance().getCreatorId()));
                return null;
            }
            StringBuilder webUrl = new StringBuilder();
            webUrl.append(UrlService.getDomainContextUrl()).append("/index.html?formId=").append(task.getEntityNumber()).append(APPIDPART).append(appId).append(ACCOUNTIDPART).append(RequestContext.get().getAccountId());
            StringBuilder mobileUrl = new StringBuilder();
            mobileUrl.append(UrlService.getDomainContextUrl()).append("/mobile.html?form=").append(YunzhijiaToDoUtil.getMobEntityNumber(task.getEntityNumber())).append(APPIDPART).append(appId).append(ACCOUNTIDPART).append(RequestContext.get().getAccountId());
            String lang = WfMultiLangUtils.getUserDefaultLang(yzjTplCreator.getUserId());
            bodyData.put("buid", (Object)"");
            bodyData.put("creator", (Object)yzjTplCreator.getOpenId());
            bodyData.put("typeId", (Object)task.getEntityNumber());
            bodyData.put("typeName", (Object)YunzhijiaToDoUtil.getCurrentLangValue(task.getEntityName(), lang));
            bodyData.put("appId", (Object)appId);
            bodyData.put("appName", (Object)appName);
            bodyData.put("webUrl", (Object)MessageServiceUtil.getReplacedUrl(webUrl.toString(), "yunzhijiaup"));
            bodyData.put("mobileUrl", (Object)MessageServiceUtil.getReplacedUrl(mobileUrl.toString(), "yunzhijiaup"));
            bodyData.put("field", (Object)YunzhijiaToDoUtil.getMainField(task.getEntityNumber(), lang));
            if (!task.isBizTask() && WfUtils.isNotEmpty(task.getProcessInstance().getDescription())) {
                bodyData.put("description", (Object)YunzhijiaToDoUtil.getCurrentLangValue(task.getProcessInstance().getDescription(), lang));
            }
        } else if (YzjToDoState.CREATE == state) {
            double expireTime;
            Long creatorId;
            String webFlowLink = YunzhijiaToDoUtil.getMyInitiatedUrl(task.getProcessInstanceId(), appId);
            String mobileFlowLink = YunzhijiaToDoUtil.getMyInitiatedUrl(task.getProcessInstanceId(), appId);
            bodyData.put("webLink", (Object)todoInfo.getUrl());
            bodyData.put("mobileLink", (Object)todoInfo.getUrl());
            bodyData.put("webFlowLink", (Object)MessageServiceUtil.getReplacedUrl(webFlowLink, "yunzhijiaup"));
            bodyData.put("mobileFlowLink", (Object)MessageServiceUtil.getReplacedUrl(mobileFlowLink, "yunzhijiaup"));
            bodyData.put("appId", (Object)appId);
            JSONArray todoArray = new JSONArray();
            for (String openId : userOpenIdList) {
                JSONObject someOneAndTheStatus = new JSONObject();
                someOneAndTheStatus.put("approver", (Object)openId);
                someOneAndTheStatus.put("bizId", (Object)(taskId + openId));
                someOneAndTheStatus.put("messageMode", (Object)"MODE_MESSAGE");
                someOneAndTheStatus.put("messageContent", (Object)todoInfo.getTitle());
                todoArray.add((Object)someOneAndTheStatus);
            }
            bodyData.put("todo", (Object)todoArray);
            bodyData.put("typeId", (Object)task.getEntityNumber());
            bodyData.put("urgency", (Object)YunzhijiaToDoUtil.getTransformUrgency(task.getPriority()));
            if (YunzhijiaToDoUtil.isNeedPassUrl(todoInfo) && YunzhijiaToDoUtil.isQuickApprove(todoInfo, "yunzhijiaup")) {
                String domain = UrlService.getDomainContextUrl();
                StringBuilder purl = new StringBuilder(domain);
                if (!domain.trim().endsWith("/")) {
                    purl.append("/");
                }
                purl.append("kapi/app/wf/batchAgreeTask?accountId=");
                purl.append(RequestContext.get().getAccountId());
                String replacedUrl = MessageServiceUtil.getReplacedUrl(purl.toString(), "yunzhijiaup");
                logger.info("taskId=" + todoInfo.getTaskId() + " yunzhijia fast deal todo passUrl=" + replacedUrl);
                bodyData.put("processUrl", (Object)replacedUrl);
            }
            bodyData.put("flowId", (Object)String.valueOf(task.getBusinessKey()));
            bodyData.put(TITLE, (Object)todoInfo.getTitle());
            bodyData.put("serialNo", (Object)task.getBillNo());
            bodyData.put("field", (Object)YunzhijiaToDoUtil.getMainFieldValue(task.getEntityNumber(), (String)todoInfo.getParams().get("businessKey"), (String)todoInfo.getParams().get("lang")));
            Long l = creatorId = task.isBizTask() ? task.getStarterId() : task.getProcessInstance().getCreatorId();
            if (WfUtils.isNotEmpty(creatorId)) {
                Object yzjOrgIdByUserId;
                ArrayList<Long> list = new ArrayList<Long>(1);
                list.add(creatorId);
                List<MessageUser> messageUsers = YunzhijiaToDoUtil.getMessageUsers(list);
                if (!messageUsers.isEmpty()) {
                    String creatorOpenId = messageUsers.get(0).getOpenId();
                    bodyData.put("creator", (Object)creatorOpenId);
                }
                if (StringUtils.isNotBlank((Object)(yzjOrgIdByUserId = YunzhijiaToDoUtil.getYzjOrgIdByUserId(creatorId)))) {
                    bodyData.put("creatorOrgId", yzjOrgIdByUserId);
                }
            }
            if ((expireTime = (double)YunzhijiaToDoUtil.getTaskExpireTime(task.getCreateDate(), task.getDueDate())) > 0.0) {
                bodyData.put("ttlType", (Object)"standard");
                bodyData.put("ttl", (Object)((int)Math.ceil(expireTime / 60000.0)));
            }
            bodyData.put("activityId", (Object)task.getTaskDefinitionKey());
            bodyData.put(ACTIVITYNAME, todoInfo.getParams().get(ACTIVITYNAME));
        } else if (YzjToDoState.DEAL == state || YzjToDoState.DELETE == state) {
            bodyData.put("appId", (Object)todoProperty.getAppId());
            ArrayList<String> bizIds = new ArrayList<String>(1);
            bizIds.add(taskId + todoProperty.getOpenId());
            bodyData.put("bizId", (Object)bizIds.toArray());
        }
        logger.debug("body data is :" + bodyData.toString());
        return bodyData;
    }

    public static long getTaskExpireTime(Date createDate, Date dueDate) {
        if (dueDate == null) {
            return 0L;
        }
        return dueDate.getTime() - createDate.getTime();
    }

    public static JSONArray getMainFieldValue(String entityNumber, String businessKey, String lang) {
        String mainField = null;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            BillSubjectModelEntity billSubject = commandContext.getBillSubjectModelEntityManager().findBillSubjectByEntityNumber(entityNumber);
            if (billSubject != null) {
                mainField = billSubject.getMainField();
            }
        } else {
            DynamicObject dyObj = QueryServiceHelper.queryOne((String)"wf_billsubjectmodel", (String)"mainfield", (QFilter[])new QFilter[]{new QFilter("entitynumber", "=", (Object)entityNumber)});
            if (dyObj != null) {
                try {
                    mainField = dyObj.getString("mainfield");
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                }
            }
        }
        JSONArray fieldsArr = new JSONArray();
        if (mainField != null && WfUtils.isNotEmpty(mainField)) {
            if (mainField.startsWith(",")) {
                mainField = mainField.substring(1, mainField.length() - 1);
            }
            String[] mainfield = mainField.split(",");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            Map fields = entityType.getAllFields();
            QFilter f1 = new QFilter("id", "=", (Object)Long.valueOf(businessKey));
            DynamicObject[] dyobj = BusinessDataServiceHelper.load((String)entityNumber, (String)mainField, (QFilter[])new QFilter[]{f1});
            int len = mainfield.length;
            for (int i = 0; i < len; ++i) {
                if (fields.get(mainfield[i]) == null || ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f", (String)"YunzhijiaToDoUtil_0", (String)"bos-wf-engine", (Object[])new Object[0]).equals(YunzhijiaToDoUtil.getCurrentLangValue((ILocaleString)((IDataEntityProperty)fields.get(mainfield[i])).getDisplayName(), lang)) || !StringUtils.isNotBlank((Object)dyobj[0].get(mainfield[i]))) continue;
                JSONObject fieldObj = new JSONObject();
                fieldObj.put("name", (Object)YunzhijiaToDoUtil.getCurrentLangValue((ILocaleString)((IDataEntityProperty)fields.get(mainfield[i])).getDisplayName(), lang));
                String value = String.valueOf(YunzhijiaToDoUtil.getFieldValue((IDataEntityProperty)fields.get(mainfield[i]), dyobj[0].get(mainfield[i])));
                fieldObj.put(VALUE, (Object)(value.length() > 180 ? value.substring(0, 180) : value));
                fieldsArr.add((Object)fieldObj);
            }
        }
        return fieldsArr;
    }

    private static Object getFieldValue(IDataEntityProperty property, Object value) {
        if (property instanceof DateTimeProp) {
            try {
                DateTimeProp p = (DateTimeProp)property;
                SimpleDateFormat shortDate = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat longDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                value = p.getRegionType() == 1 ? shortDate.format(value) : longDate.format(value);
            }
            catch (Exception e) {
                logger.info("yunzhijiaup getFieldValue() format date error");
            }
        }
        return value;
    }

    public static Object getYzjOrgIdByUserId(Long userId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select c.fid fid, c.fyzjorgid fyzjorgid from t_sec_userposition a inner join t_org_org c on a.fdptid = c.fid where a.fid = ? and a.fispartjob = '0';");
        try (DataSet ds = DB.queryDataSet((String)"YunzhijiaToDoUtil.getYzjOrgIdByUserId", (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])new Object[]{userId});){
            DynamicObjectCollection collection = ORM.create().toPlainDynamicObjectCollection(ds);
            if (!collection.isEmpty()) {
                String string = ((DynamicObject)collection.get(0)).getString("fyzjorgid");
                return string;
            }
        }
        return null;
    }

    public static int getTransformUrgency(int priority) {
        int urgencyLevel;
        switch (priority) {
            case 100: {
                urgencyLevel = 5;
                break;
            }
            case 60: {
                urgencyLevel = 3;
                break;
            }
            case 0: {
                urgencyLevel = 1;
                break;
            }
            default: {
                urgencyLevel = 1;
            }
        }
        return urgencyLevel;
    }

    private static JSONArray getMainField(String entityNumber, String lang) {
        String mainField;
        BillSubjectModelEntity billSubject = Context.getCommandContext().getBillSubjectModelEntityManager().findBillSubjectByEntityNumber(entityNumber);
        JSONArray fieldsArr = new JSONArray();
        if (StringUtils.isNotBlank((Object)billSubject) && WfUtils.isNotEmpty(mainField = billSubject.getMainField())) {
            String[] mainfield = mainField.split(",");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            Map fields = entityType.getAllFields();
            int len = mainfield.length;
            for (int i = 0; i < len; ++i) {
                if (fields.get(mainfield[i]) == null) continue;
                JSONObject fieldObj = new JSONObject();
                fieldObj.put(TITLE, (Object)YunzhijiaToDoUtil.getCurrentLangValue((ILocaleString)((IDataEntityProperty)fields.get(mainfield[i])).getDisplayName(), lang));
                fieldsArr.add((Object)fieldObj);
            }
        }
        return fieldsArr;
    }

    private static MessageUser getYzjTplCreator(TaskEntity taskEntity) {
        ArrayList<Long> userIdList = new ArrayList<Long>(2);
        if (!taskEntity.isBizTask()) {
            userIdList.add(taskEntity.getProcessInstance().getCreatorId());
        }
        userIdList.add(taskEntity.getStarterId());
        List<MessageUser> messageUsers = YunzhijiaToDoUtil.getMessageUsers(userIdList);
        int len = messageUsers.size();
        for (int i = 0; i < len; ++i) {
            if (messageUsers.get(i).getOpenId() == null) continue;
            return messageUsers.get(i);
        }
        return null;
    }

    private static String getCurrentLangValue(ILocaleString value, String lang) {
        if (WfUtils.isEmpty((String)value.getItem(lang))) {
            return (String)value.getDefaultItem();
        }
        return (String)value.getItem(lang);
    }

    public static String editYzjupUrlWithDomain(String url) {
        String domainName = WfConfigurationUtil.getDomainName("yunzhijiaup", "flowassist", null);
        if (StringUtils.isBlank((CharSequence)domainName)) {
            logger.info("YunzhijiaToDoUtil\uff1athe domainname of yunzhijiaup is null");
            return url;
        }
        StringBuilder sb = new StringBuilder();
        if (!domainName.startsWith("https://")) {
            sb.append("https://");
        }
        sb.append(domainName);
        sb.append(url);
        return sb.toString();
    }

    public static List<MessageInfo> rebuildNewYzjMessage(MessageInfo message, DynamicObject taskDynobj) {
        ArrayList<MessageInfo> messages = new ArrayList<MessageInfo>();
        List userIds = message.getUserIds();
        if (userIds != null && !userIds.isEmpty()) {
            Map<String, List<Long>> userLangs = YunzhijiaToDoUtil.getUserLangs(userIds);
            for (Map.Entry<String, List<Long>> entry : userLangs.entrySet()) {
                ILocaleString name;
                String key = entry.getKey();
                List<Long> values = entry.getValue();
                if (values == null || values.isEmpty()) continue;
                MessageInfo messageInfo = message.copy();
                ILocaleString procTitle = taskDynobj.getLocaleString("subject");
                if (WfUtils.isNotEmpty(procTitle)) {
                    message.setMessageTitle(procTitle);
                    if (WfUtils.isNotEmpty((String)procTitle.get((Object)key))) {
                        messageInfo.setTitle((String)procTitle.get((Object)key));
                    } else {
                        messageInfo.setTitle((String)procTitle.getDefaultItem());
                    }
                }
                if (!WfUtils.isEmpty(name = taskDynobj.getLocaleString("name"))) {
                    if (!WfUtils.isEmpty((String)name.get((Object)key))) {
                        messageInfo.putParam(ACTIVITYNAME, (String)name.get((Object)key));
                    } else {
                        messageInfo.putParam(ACTIVITYNAME, (String)name.getDefaultItem());
                    }
                }
                messageInfo.getParams().put("lang", key);
                messageInfo.setUserIds(values);
                messages.add(messageInfo);
            }
        } else {
            messages.add(message);
        }
        return messages;
    }

    private static final boolean isQuickApprove(ToDoInfo todoInfo, String type) {
        MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)type);
        if (msgChannelInfo == null) {
            logger.info("it's impossiable!");
            return false;
        }
        boolean isQuickApprove = true;
        String config = msgChannelInfo.getConfig();
        if (StringUtils.isNotBlank((CharSequence)config) && config.contains("quicklyagreeconfig")) {
            Object billDisabled;
            JSONObject configJson = JSONObject.parseObject((String)config.trim());
            JSONObject quickAgreeJson = configJson.getJSONObject("quicklyagreeconfig");
            String quickRule = quickAgreeJson.getString("quickrule");
            if ("alldisable".equals(quickRule)) {
                isQuickApprove = false;
            } else if ("partdisable".equals(quickRule) && StringUtils.isNotBlank((Object)(billDisabled = quickAgreeJson.get((Object)"billdisable")))) {
                Long taskId = todoInfo.getTaskId();
                TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(taskId);
                isQuickApprove = YunzhijiaToDoUtil.isBillDisabled(billDisabled, task.getEntityNumber());
            }
        } else {
            Object quicklyAgree = MessageServiceUtil.getConfigCenterProperty("message", "msg.yzj.quicklyAgree");
            if (StringUtils.isNotBlank((Object)quicklyAgree)) {
                isQuickApprove = Boolean.parseBoolean((String)quicklyAgree);
            }
        }
        if (isQuickApprove && todoInfo.getParams() != null) {
            Map params = todoInfo.getParams();
            isQuickApprove = params.get(ISQUICKAGREE) == null || params.get(ISQUICKAGREE) != null && (Boolean)params.get(ISQUICKAGREE) != false;
        }
        return isQuickApprove;
    }

    private static boolean isBillDisabled(Object billDisabled, String entityNumber) {
        String[] billArr = billDisabled.toString().split(",");
        int len = billArr.length;
        for (int i = 0; i < len; ++i) {
            if (!entityNumber.equals(billArr[i])) continue;
            return false;
        }
        return true;
    }

    public static final String getMobEntityNumber(String entityNumber) {
        DesignFormMeta designMeta = (DesignFormMeta)BusinessDataReader.read((Object)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity), (IDataEntityType)OrmUtils.getDataEntityType(DesignFormMeta.class), (Boolean)false);
        String content = designMeta.getDataXml();
        SAXReader reader = SAXReader.createDefault();
        StringReader strReader = new StringReader(content);
        try {
            Document doc = reader.read((Reader)strReader);
            Node selectSingleNode = doc.selectSingleNode("/FormMetadata/Items/BillFormAp/MobMeta/FormMetadata/Key");
            if (selectSingleNode != null) {
                return selectSingleNode.getStringValue();
            }
        }
        catch (Exception e) {
            logger.info("get mobil's entityNumber is error, errorinfo is :" + e.getMessage());
        }
        return entityNumber + "_mob";
    }

    protected static String getMyInitiatedUrl(Long processInstanceId, String appId) {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageServiceUtil.buildWebPageUrlForMyApplyed(processInstanceId));
        sb.append(APPIDPART).append(appId);
        sb.append("&opentype=100");
        return sb.toString().replace("type=dynApply", "type=dynnApply");
    }

    public static boolean isYzjOpenDevicePropCanChange() {
        boolean yzjDevicePropCanChange = false;
        try {
            QFilter qs = new QFilter("key", "=", (Object)"msg.yzj.OpenDevicePropCanChange");
            Map ret = BusinessDataServiceHelper.loadFromCache((String)"wf_confcenter", (String)VALUE, (QFilter[])new QFilter[]{qs});
            if (ret != null && ret.size() > 0) {
                Set entrySet = ret.entrySet();
                for (Map.Entry entry : entrySet) {
                    DynamicObject t = (DynamicObject)entry.getValue();
                    yzjDevicePropCanChange = t.getBoolean(VALUE);
                }
            }
        }
        catch (Exception e) {
            logger.info("IsYzjOpenDevicePropCanChange function has exception:" + e.getMessage());
        }
        return yzjDevicePropCanChange;
    }

    public static String getData(ILocaleString value, String key) {
        String returnData = "";
        if (!WfUtils.isEmpty(value) && WfUtils.isEmpty(returnData = (String)value.get((Object)key)) && WfUtils.isEmpty(returnData = (String)value.get((Object)"commonlang"))) {
            if (value instanceof LocaleString) {
                returnData = ((LocaleString)value).toString();
            } else if (value instanceof OrmLocaleValue) {
                returnData = ((OrmLocaleValue)value).toString();
            }
            if (WfUtils.isEmpty(returnData)) {
                Collection vs = value.values();
                for (String v : vs) {
                    if (!WfUtils.isNotEmpty(v)) continue;
                    returnData = v;
                    break;
                }
            }
        }
        return returnData;
    }

    public static String getYzjData(ILocaleString value, String key) {
        String returnData = "";
        if (!WfUtils.isEmpty(value) && WfUtils.isEmpty(returnData = (String)value.get((Object)key)) && WfUtils.isEmpty(returnData = (String)value.get((Object)"commonlang"))) {
            returnData = (String)value.getDefaultItem();
        }
        return returnData;
    }
}

